/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import medicine.Entity;
import medicine.EntityData;
import medicine.gui.MultiChoiceLogic;

public class MultiChoiceDialog
extends JDialog {
    MultiChoiceLogic logic = new MultiChoiceLogic();
    JTextArea infoText = new JTextArea();
    JPanel qpanel = new JPanel();
    JRadioButton[] stemButt = new JRadioButton[5];
    ButtonGroup bg = new ButtonGroup();
    JButton nextButton = new JButton("OK");
    JTextArea questionText = new JTextArea();
    JPanel optionPanel = new JPanel();
    JComboBox typecombo;
    JCheckBox randcheck;
    JCheckBox restrRtCheck;
    JCheckBox restrChCheck;
    int correctIndex;

    public MultiChoiceDialog(EntityData entityData, Entity entity) {
        this.typecombo = new JComboBox<String>(this.logic.MODE_NAMES);
        this.randcheck = new JCheckBox("Random root");
        this.restrRtCheck = new JCheckBox("Restrict root");
        this.restrChCheck = new JCheckBox("Restrict stems");
        this.logic.ed = entityData;
        this.logic.seed = entity;
        this.initComponents();
        this.setSize(400, 700);
        this.newQuestion();
    }

    void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.infoText, "South");
        this.infoText.setLineWrap(true);
        this.infoText.setWrapStyleWord(true);
        this.add((Component)this.qpanel, "Center");
        this.qpanel.setLayout(new GridLayout(7, 1));
        this.qpanel.add(this.questionText);
        this.questionText.setLineWrap(true);
        this.questionText.setWrapStyleWord(true);
        int i = 0;
        while (i < this.stemButt.length) {
            this.stemButt[i] = new JRadioButton();
            this.bg.add(this.stemButt[i]);
            this.qpanel.add(this.stemButt[i]);
            this.stemButt[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MultiChoiceDialog.this.infoText.setText(e.getActionCommand());
                }
            });
            ++i;
        }
        this.qpanel.add(this.nextButton);
        this.add((Component)this.optionPanel, "North");
        this.setTitle("Multiple Choice");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiChoiceDialog.this.newQuestion();
            }
        });
        this.optionPanel.add(this.typecombo);
        this.typecombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MultiChoiceDialog.this.logic.mode = MultiChoiceDialog.this.typecombo.getSelectedIndex();
            }
        });
        this.optionPanel.add(this.randcheck);
        this.randcheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MultiChoiceDialog.this.logic.randomroot = MultiChoiceDialog.this.randcheck.isSelected();
                MultiChoiceDialog.this.restrRtCheck.setEnabled(MultiChoiceDialog.this.logic.randomroot);
            }
        });
        this.optionPanel.add(this.restrRtCheck);
        this.randcheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MultiChoiceDialog.this.logic.restrRoot = MultiChoiceDialog.this.randcheck.isSelected();
            }
        });
        this.restrRtCheck.setEnabled(false);
    }

    void newQuestion() {
        boolean success = false;
        do {
            try {
                this.logic.newQuestion();
                success = true;
            }
            catch (IllegalStateException x) {
                JOptionPane.showMessageDialog(null, x.toString());
                x.printStackTrace();
            }
            catch (MultiChoiceLogic.TryAgain x) {
                // empty catch block
            }
        } while (!success);
        int cix = (int)Math.floor(Math.random() * 5.0);
        int i = 0;
        while (i < this.stemButt.length) {
            if (i == cix) {
                this.stemButt[i].setText(this.logic.correct.toString());
                this.stemButt[i].setSelected(true);
                this.stemButt[i].setActionCommand("Correct!\n" + this.logic.infoCorrect);
            } else {
                int inci = i - (i > cix ? 1 : 0);
                this.stemButt[i].setText(this.logic.incorrect[inci].toString());
                this.stemButt[i].setActionCommand("Wrong!\n" + this.logic.infoIncor[inci]);
            }
            ++i;
        }
        this.questionText.setText(this.logic.question);
        this.infoText.setText(this.logic.infoText);
        this.correctIndex = cix;
    }
}

