/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import medicine.DataIntegrityException;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.gui.AboutBox;
import medicine.gui.AdvancedFindDialog;
import medicine.gui.CauseListDialog;
import medicine.gui.CauseTreeDialog;
import medicine.gui.DiagnosisDialog;
import medicine.gui.DictionaryDialog;
import medicine.gui.EntityEditorPanel;
import medicine.gui.EntityTable;
import medicine.gui.EssayDialog;
import medicine.gui.FindExplanationDialog;
import medicine.gui.FindFilterDialog;
import medicine.gui.SList;
import medicine.gui.ServerAction;
import medicine.gui.StatisticsDialog;
import medicine.mcq.EditMCQDialog;
import medicine.visual.VisualiserFrame;

public class MainFrame
extends JFrame
implements ActionListener {
    public static final String serverRoot = "http://www.homphysiology.org";
    public static final String serverPath = "http://www.homphysiology.org/cgi-bin/medicine.pl";
    public static final String serverPathUpload = "http://www.homphysiology.org/cgi-bin/medicine_upload.pl";
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem savemenuitem = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenuItem jMenuItem5 = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem6 = new JMenuItem();
    public EntityEditorPanel editor = new EntityEditorPanel();
    JMenu jMenu3 = new JMenu();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem7 = new JMenuItem();
    JMenuItem jMenuItem8 = new JMenuItem();
    JMenuItem jMenuItem9 = new JMenuItem();
    JMenuItem jMenuItem10 = new JMenuItem();
    JMenuItem jMenuItem11 = new JMenuItem();
    JMenu jMenu4 = new JMenu();
    JMenuItem jMenuItem4 = new JMenuItem();
    JMenuItem jMenuItem12 = new JMenuItem();
    JMenuItem jMenuItem13 = new JMenuItem();
    JMenuItem jMenuItem14 = new JMenuItem();
    private JMenuItem jMenuItem15 = new JMenuItem();
    JMenuItem effectlistmenu = new JMenuItem();
    private JMenu jMenu5 = new JMenu();
    private JMenuItem causetree_menu = new JMenuItem();
    private JMenuItem effect_tree_menu = new JMenuItem();
    private JMenuItem diagnoseMenu = new JMenuItem();
    String defaultDirectory = "c:\\";
    String appTitle = "Medical Browser";
    public JFileChooser filer;
    boolean filingEnabled = true;
    Entity rootEntity = new Entity(null, 0);
    String currentFilename = null;
    EntityData entityData;
    JFrame thisFrame = this;
    FileFilter databaseFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".med");
        }

        public String getDescription() {
            return "Medical database (*.med)";
        }
    };
    FileFilter zipFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".zip");
        }

        public String getDescription() {
            return "Zipped text database (*.zip)";
        }
    };
    FileFilter textFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".txt");
        }

        public String getDescription() {
            return "Text file database (*.txt)";
        }
    };
    FileFilter currentFileFormat = this.zipFilter;
    Action findExplanation = new AbstractAction("Find explanation"){

        public void actionPerformed(ActionEvent e) {
            FindExplanationDialog fed = new FindExplanationDialog(MainFrame.this.editor.navigator, MainFrame.this.entityData);
            fed.show();
        }
    };
    Action entityTableAction = new AbstractAction("Table of effects"){

        public void actionPerformed(ActionEvent e) {
            EntityTable et = new EntityTable(MainFrame.this.entityData);
            et.setupFrom(MainFrame.this.editor.navigator.entity);
            et.setVisible(true);
        }
    };
    Action uploadServer = new ServerAction(true, this);
    public Action downloadServer = new ServerAction(false, this);
    boolean dirty = true;
    JMenuItem essaymenu = new JMenuItem();
    JMenuItem jMenuItem16 = new JMenuItem();
    JMenuItem jMenuItem17 = new JMenuItem();
    JMenuItem filterfilndmenu = new JMenuItem();
    JMenuItem findExplanationMenu = new JMenuItem();
    EditMCQDialog mcqd;
    Action multichoiceAction = new AbstractAction("Multiple choice"){

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.mcqd != null && MainFrame.this.mcqd.isVisible()) {
                MainFrame.this.mcqd.requestFocus();
                return;
            }
            MainFrame.this.mcqd = new EditMCQDialog(MainFrame.this.entityData, MainFrame.this.editor.navigator.entity);
            MainFrame.this.mcqd.setNavigator(MainFrame.this.editor.navigator);
            MainFrame.this.mcqd.setVisible(true);
        }
    };
    JMenuItem multichoice = new JMenuItem(this.multichoiceAction);

    public EntityData getData() {
        return this.entityData;
    }

    public MainFrame(boolean enableFiling) {
        this.filingEnabled = enableFiling;
        this.initialise();
    }

    public MainFrame() {
        this.initialise();
    }

    protected void initialise() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(800, 600);
        this.editor.navigator.setEntity(this.rootEntity);
        this.editor.navigator.clearHistory();
        if (this.filingEnabled) {
            this.filer = new JFileChooser(this.defaultDirectory);
            this.filer.addChoosableFileFilter(this.textFilter);
            this.filer.addChoosableFileFilter(this.databaseFilter);
            this.filer.addChoosableFileFilter(this.zipFilter);
            this.filer.setCurrentDirectory(new File(this.defaultDirectory));
        }
        this.editor.registerKeyboardAction(this, "Save", KeyStroke.getKeyStroke(83, 2), 1);
        this.editor.registerKeyboardAction(this, "Open", KeyStroke.getKeyStroke(79, 2), 1);
        this.editor.registerKeyboardAction(this, "New", KeyStroke.getKeyStroke(78, 2), 1);
        this.editor.registerKeyboardAction(this, "AFind", KeyStroke.getKeyStroke(70, 3), 1);
        this.editor.registerKeyboardAction(this, "Find", KeyStroke.getKeyStroke(70, 2), 1);
    }

    private void jbInit() throws Exception {
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Open...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.fileopen(e);
            }
        });
        this.savemenuitem.setEnabled(false);
        this.savemenuitem.setText("Save");
        this.savemenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.filesave(e, false);
            }
        });
        this.jMenuItem3.setText("Save as...");
        if (!this.filingEnabled) {
            this.jMenuItem3.setEnabled(false);
        }
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.fileSaveas(e);
            }
        });
        this.jMenuItem5.setText("Exit");
        this.jMenu2.setText("Edit");
        this.jMenuItem6.setText("New");
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.filenew(e);
            }
        });
        this.jMenuItem5.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle(this.appTitle);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.this_windowClosing(e);
            }
        });
        this.jMenu3.setText("Help");
        this.jMenuItem2.setText("Return to first node");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.returntoFirstNode(e);
            }
        });
        this.jMenuItem7.setText("About...");
        this.jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.jMenuItem7_actionPerformed(e);
            }
        });
        this.jMenuItem8.setText("Copy");
        this.jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editcommand(e);
            }
        });
        this.jMenuItem9.setText("Paste");
        this.jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editcommand(e);
            }
        });
        this.jMenuItem10.setText("Delete");
        this.jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editcommand(e);
            }
        });
        this.jMenuItem11.setText("Bookmark");
        this.jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editcommand(e);
            }
        });
        this.jMenu4.setText("Tools");
        this.jMenuItem4.setText("Visualiser");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.toolsvisualiser(e);
            }
        });
        this.jMenuItem12.setText("Statistics");
        this.jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.toolsstats(e);
            }
        });
        this.jMenuItem13.setText("Find...");
        this.jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editfind(e);
            }
        });
        this.jMenuItem14.setText("Advanced find...");
        this.jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.editadvancedfind(e);
            }
        });
        this.jMenuItem15.setEnabled(true);
        this.jMenuItem15.setText("Cause list");
        this.jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.causelist(e);
            }
        });
        this.effectlistmenu.setText("Effect list");
        this.effectlistmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.effectlist(e);
            }
        });
        this.jMenu5.setText("Lists");
        this.causetree_menu.setText("Cause tree");
        this.causetree_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.causetree_menu_actionPerformed(e);
            }
        });
        this.effect_tree_menu.setText("Effect tree");
        this.effect_tree_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.effect_tree_menu_actionPerformed(e);
            }
        });
        this.diagnoseMenu.setText("Diagnose");
        this.diagnoseMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.diagnoseMenu_actionPerformed(e);
            }
        });
        this.essaymenu.setText("Essay...");
        this.essaymenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.essaymenu_actionPerformed(e);
            }
        });
        this.jMenuItem16.setActionCommand("Dictionary...");
        this.jMenuItem16.setText("Dictionary...");
        this.jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dictionary_actionPerformed(e);
            }
        });
        this.jMenuItem17.setText("Merge files...");
        this.jMenuItem17.addActionListener(this);
        this.filterfilndmenu.setText("Filter find...");
        this.filterfilndmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.filterFind(e);
            }
        });
        this.findExplanationMenu.setText("Find explanation...");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu1.add(this.jMenuItem6);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.savemenuitem);
        this.jMenu1.add(this.downloadServer);
        this.jMenu1.add(this.uploadServer);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jMenuItem17);
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jMenuItem5);
        this.getContentPane().add((Component)this.editor, "Center");
        this.jMenu3.add(this.jMenuItem2);
        this.jMenu3.addSeparator();
        this.jMenu3.add(this.jMenuItem7);
        this.jMenu2.add(this.jMenuItem8);
        this.jMenu2.add(this.jMenuItem9);
        this.jMenu2.add(this.jMenuItem10);
        this.jMenu2.addSeparator();
        this.jMenu2.add(this.jMenuItem11);
        this.jMenu2.add(this.jMenuItem13);
        this.jMenu2.add(this.filterfilndmenu);
        this.jMenu2.add(this.jMenuItem16);
        this.jMenu2.add(this.findExplanationMenu);
        this.jMenu4.add(this.jMenuItem4);
        this.jMenu4.add(this.jMenuItem12);
        this.jMenu4.add(this.jMenu5);
        this.jMenu4.add(this.diagnoseMenu);
        this.jMenu4.add(this.essaymenu);
        this.jMenu5.add(this.jMenuItem15);
        this.jMenu5.add(this.effectlistmenu);
        this.jMenu4.add(this.entityTableAction);
        this.jMenu5.add(this.causetree_menu);
        this.jMenu5.add(this.effect_tree_menu);
        this.jMenu4.add(this.multichoice);
        this.findExplanationMenu.addActionListener(this.findExplanation);
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Open")) {
            this.fileopen(e);
        }
        if (s.equals("Save")) {
            this.filesave(e, false);
        }
        if (s.equals("New")) {
            this.filenew(e);
        }
        if (s.equals("AFind")) {
            this.editadvancedfind(e);
        }
        if (s.equals("Find")) {
            this.editor.navigator.find(this.entityData);
        }
        if (s.equals("Exit")) {
            this.shutdown();
        }
        if (s.equals("Merge files...")) {
            this.mergeFiles();
        }
    }

    void filenew(ActionEvent e) {
        if (this.discardcurrent()) {
            this.entityData = new EntityData();
            this.rootEntity = this.entityData.addNewEntity(null, 0);
            this.editor.navigator.setEntity(this.rootEntity);
            this.editor.navigator.clearHistory();
            this.setFilename(null);
        }
    }

    boolean filesave(ActionEvent e, boolean wait) {
        if (this.currentFilename != null && this.currentFilename != "") {
            return this.writeCurrentFile(null, wait);
        }
        return this.fileSaveas(e);
    }

    boolean fileSaveas(ActionEvent e) {
        int res = this.filer.showSaveDialog(this);
        if (res == 0) {
            String fname = this.filer.getSelectedFile().getAbsolutePath();
            this.currentFileFormat = this.filer.getFileFilter();
            if (this.currentFileFormat == this.textFilter && !fname.endsWith(".txt")) {
                fname = String.valueOf(fname) + ".txt";
            }
            if (this.currentFileFormat == this.zipFilter && !fname.endsWith(".zip")) {
                fname = String.valueOf(fname) + ".zip";
            }
            return this.writeCurrentFile(fname, false);
        }
        return false;
    }

    private boolean writeCurrentFile(String optionalFileName, boolean wait) {
        File file = this.filer.getSelectedFile();
        if (optionalFileName != null) {
            file = new File(optionalFileName);
            this.filer.setSelectedFile(file);
        }
        boolean success = true;
        try {
            FileOutputStream os = new FileOutputStream(file);
            if (this.currentFileFormat == this.databaseFilter) {
                success = this.writeDatabaseStream(os);
            } else {
                Entities saveEntities = new Entities();
                saveEntities.setData(this.entityData);
                if (this.currentFileFormat == this.zipFilter) {
                    ZipOutputStream zos = new ZipOutputStream(os);
                    zos.putNextEntry(new ZipEntry("Medical.txt"));
                    saveEntities.writeTextForm(zos);
                    zos.closeEntry();
                    zos.close();
                    success = true;
                } else if (this.currentFileFormat == this.textFilter) {
                    saveEntities.writeTextForm(os);
                }
            }
            if (success) {
                this.setFilename(file.getAbsolutePath());
            }
            return success;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.thisFrame, ex.getMessage(), "Save error", 0);
            ex.printStackTrace();
            return false;
        }
    }

    protected void writeZipFile(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        zos.putNextEntry(new ZipEntry("Medical.txt"));
        Entities saveEntities = new Entities();
        saveEntities.setData(this.entityData);
        saveEntities.writeTextForm(zos);
        zos.closeEntry();
        zos.close();
    }

    void fileopen(ActionEvent e) {
        int res = this.filer.showOpenDialog(this);
        try {
            if (res == 0) {
                FileInputStream stream = new FileInputStream(this.filer.getSelectedFile());
                String fname = this.filer.getSelectedFile().getAbsolutePath();
                if (this.filer.getFileFilter() == this.databaseFilter) {
                    this.readDatabaseFrom(stream, fname);
                } else if (this.filer.getFileFilter() == this.zipFilter) {
                    this.readTextFromZip(stream, fname);
                } else {
                    this.readTextFromStream(stream, fname);
                }
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.thisFrame, ex.getMessage(), "Open error", 0);
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this.thisFrame, ex.getMessage(), "Incorrect file format", 0);
        }
        catch (DataIntegrityException ex) {
            JOptionPane.showMessageDialog(this.thisFrame, ex.getMessage(), "Data integrity check failed", 0);
        }
    }

    public void readTextFromZip(InputStream file, String name) throws IOException, DataIntegrityException {
        ZipInputStream s = new ZipInputStream(file);
        s.getNextEntry();
        this.readTextFromStream(s, name);
    }

    public void readTextFromStream(InputStream s, String name) throws IOException, DataIntegrityException {
        Cursor oldcursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            EntityData entityData = Entities.readTextForm(s);
            if (entityData == null) {
                throw new IOException("Stream " + name + " contains no data");
            }
            entityData.checkIntegrity();
            this.entityData = entityData;
            Entity first = entityData.getFirstEntity();
            this.editor.navigator.setEntity(first);
            this.editor.navigator.clearHistory();
            this.rootEntity = first;
            this.setFilename(name);
        }
        finally {
            this.setCursor(oldcursor);
        }
    }

    public boolean writeDatabaseStream(OutputStream fos) throws IOException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.rootEntity);
            fos.close();
            return true;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Save error", 0);
            ex.printStackTrace();
            return false;
        }
    }

    public void readDatabaseFrom(InputStream is, String name) throws ClassNotFoundException, IOException {
        Cursor oldcursor = this.getCursor();
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.rootEntity = (Entity)ois.readObject();
            is.close();
            this.editor.navigator.setEntity(this.rootEntity);
            this.editor.navigator.clearHistory();
            this.setFilename(name);
        }
        finally {
            this.setCursor(oldcursor);
        }
    }

    void mergeFiles() {
        block9: {
            File currFile = this.filer.getSelectedFile();
            FileFilter currFilter = this.filer.getFileFilter();
            if (this.currentFileFormat == this.databaseFilter) {
                this.requireTextFilterMessage();
                return;
            }
            try {
                int res = this.filer.showOpenDialog(this);
                if (res != 0) break block9;
                InputStream s2 = new FileInputStream(this.filer.getSelectedFile());
                if (this.filer.getFileFilter() == this.databaseFilter) {
                    this.requireTextFilterMessage();
                    return;
                }
                try {
                    if (this.filer.getFileFilter() == this.zipFilter) {
                        ZipInputStream s = new ZipInputStream(s2);
                        s.getNextEntry();
                        s2 = s;
                        Entities.mergeTextFromStream(this.entityData, s2);
                        break block9;
                    }
                    Entities.mergeTextFromStream(this.entityData, s2);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.thisFrame, ex.getMessage(), "Open error", 0);
                }
            }
            finally {
                this.filer.setSelectedFile(currFile);
                this.filer.setFileFilter(currFilter);
            }
        }
    }

    private void requireTextFilterMessage() throws HeadlessException {
        JOptionPane.showMessageDialog(this.thisFrame, "You must select a text file for merging.", "Error", 0);
    }

    boolean discardcurrent() {
        int r = JOptionPane.showConfirmDialog(this, "This will clear the current data.", "Discard current document", 2, 2);
        return r == 0;
    }

    void setFilename(String s) {
        this.currentFilename = s;
        if (s != null && s != "") {
            if (this.filingEnabled) {
                this.savemenuitem.setEnabled(true);
            }
            this.setTitle(String.valueOf(this.appTitle) + " - " + s);
            if (this.filer != null) {
                this.filer.setSelectedFile(new File(s));
            }
        } else {
            this.savemenuitem.setEnabled(false);
            this.setTitle(String.valueOf(this.appTitle) + " - [None]");
        }
    }

    void returntoFirstNode(ActionEvent e) {
        this.editor.navigator.setEntity(this.rootEntity);
    }

    void jMenuItem7_actionPerformed(ActionEvent e) {
        new AboutBox().show();
    }

    void editcommand(ActionEvent e) {
        SList l = this.editor.navigator.getFocusedList();
        if (l != null) {
            e = new ActionEvent(l, e.getID(), e.getActionCommand(), e.getModifiers());
        }
        this.editor.actionPerformed(e);
    }

    void toolsvisualiser(ActionEvent e) {
        VisualiserFrame v = new VisualiserFrame();
        v.visualiserPane1.setEntity(this.editor.navigator.entity);
        v.setVisible(true);
    }

    void toolsstats(ActionEvent e) {
        new StatisticsDialog(this.entityData).setVisible(true);
    }

    void editfind(ActionEvent e) {
        this.editor.navigator.find(this.entityData);
    }

    void editadvancedfind(ActionEvent e) {
        AdvancedFindDialog fd = new AdvancedFindDialog(this.entityData, this.editor.navigator.entity);
        fd.setModal(true);
        fd.show();
        if (fd.entity != null) {
            this.editor.navigator.setEntity(fd.entity);
        }
    }

    void causelist(ActionEvent e) {
        CauseListDialog cld = new CauseListDialog();
        cld.setData(this.entityData);
        cld.setEntity(this.editor.navigator.entity);
        cld.setVisible(true);
        if (cld.selection != null) {
            this.editor.navigator.setEntity(cld.selection);
        }
    }

    void effectlist(ActionEvent e) {
        CauseListDialog cld = new CauseListDialog();
        cld.setDirection(8, "Effects");
        cld.setData(this.entityData);
        cld.setEntity(this.editor.navigator.entity);
        cld.setVisible(true);
        if (cld.selection != null) {
            this.editor.navigator.setEntity(cld.selection);
        }
    }

    void effect_tree_menu_actionPerformed(ActionEvent e) {
        CauseTreeDialog d = new CauseTreeDialog();
        d.relations = 11;
        d.setEntity(this.editor.navigator.entity);
        d.show();
    }

    void causetree_menu_actionPerformed(ActionEvent e) {
        CauseTreeDialog d = new CauseTreeDialog();
        d.relations = 7;
        d.setEntity(this.editor.navigator.entity);
        d.show();
    }

    void diagnoseMenu_actionPerformed(ActionEvent e) {
        DiagnosisDialog dd = new DiagnosisDialog(this.editor.navigator, this.entityData);
        dd.show();
    }

    void this_windowClosing(WindowEvent e) {
        this.shutdown();
    }

    void shutdown() {
        if (this.mcqd != null && this.mcqd.isVisible()) {
            JOptionPane.showMessageDialog(this, "Please close the MCQ generator before exiting.");
            return;
        }
        if (this.allowCloseDocument()) {
            this.hide();
            this.dispose();
            System.exit(0);
        }
    }

    boolean allowCloseDocument() {
        if (this.mcqd != null && this.mcqd.isVisible()) {
            return false;
        }
        if (!this.dirty) {
            return true;
        }
        int r = JOptionPane.showConfirmDialog(this, "Save these data?", "Closing", 1);
        if (r == 0) {
            return this.filesave(new ActionEvent(this, 0, "Closing"), true);
        }
        return r == 1;
    }

    void essaymenu_actionPerformed(ActionEvent e) {
        EssayDialog ed = new EssayDialog();
        ed.setEntity(this.editor.navigator.entity);
        ed.show();
    }

    void dictionary_actionPerformed(ActionEvent e) {
        DictionaryDialog dd = new DictionaryDialog(this.entityData);
        dd.show();
        if (dd.returnValue != null) {
            this.editor.navigator.setEntity(dd.returnValue);
        }
    }

    void filterFind(ActionEvent e) {
        FindFilterDialog d = new FindFilterDialog(this.entityData, this.editor.navigator.entity);
        d.setVisible(true);
        if (d.entity != null) {
            this.editor.navigator.setEntity(d.entity);
        }
    }
}

