/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import medicine.Entity;
import medicine.EntityData;
import medicine.MainApplication;
import medicine.gui.FindDialog;
import medicine.gui.FindFilter;
import medicine.gui.FindFilterDialog_addFilterButton_actionAdapter;
import medicine.gui.FindFilterDialog_searchButton_actionAdapter;

public class FindFilterDialog
extends FindDialog {
    EntityData data;
    Entity entity;
    Cursor oldCursor;
    Thread currentSearch = null;
    JPanel jPanel1 = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JButton addFilterButton = new JButton();
    JButton removeFilterButton = new JButton();
    JButton searchButton = new JButton();
    Vector filterListModel = new Vector();
    JSplitPane splitter = new JSplitPane();
    MyList filterListPanel = new MyList();
    GridLayout filterListGridLayout = new GridLayout();
    int filterSelection = -1;
    FocusListener focusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof FindFilter) {
                FindFilterDialog.this.setSelection(FindFilterDialog.this.filterListModel.indexOf(e.getSource()));
            }
        }

        public void focusLost(FocusEvent e) {
            int i = FindFilterDialog.this.filterListModel.indexOf(e.getSource());
            if (i >= 0) {
                FindFilterDialog.this.setSelection(-1);
            }
        }
    };
    MouseListener ml = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                FindFilterDialog.this.entity = (Entity)FindFilterDialog.this.foundlist.getSelectedValue();
                MainApplication.frame.editor.navigator.setEntity(FindFilterDialog.this.entity);
            }
        }
    };

    public FindFilterDialog(EntityData data, Entity entity) throws HeadlessException {
        this.data = data;
        this.entity = entity;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(475, 500);
        MainApplication.centreWindow(this);
        this.setTitle("Find item");
    }

    public void executeFilters() {
        if (this.currentSearch != null) {
            this.currentSearch.interrupt();
            this.currentSearch = null;
        } else {
            this.oldCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.currentSearch = new Thread(new Runnable(){

            public void run() {
                FindFilterDialog.this.processFindAction();
                FindFilterDialog.this.setCursor(FindFilterDialog.this.oldCursor);
            }
        });
        this.currentSearch.start();
    }

    public void processFindAction() {
        Vector items;
        Vector prevItems = items = new Vector(this.data.getAllEntities());
        int i = 0;
        while (i < this.filterListModel.size()) {
            FindFilter filter = (FindFilter)this.filterListModel.get(i);
            try {
                items = filter.isOrFilter() ? this.mergeLists(items, filter.getFilteredItems(prevItems)) : filter.getFilteredItems(items);
            }
            catch (ParseException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.toString(), "Could not parse filter expression", 0);
            }
            ++i;
        }
        this.showSearchResults(items);
    }

    void showSearchResults(Vector v) {
        this.found = v;
        this.foundlist.setListData(this.found);
    }

    Vector mergeLists(Vector dest, Vector source) {
        int i = 0;
        while (i < source.size()) {
            Object o = source.get(i);
            if (!dest.contains(o)) {
                dest.add(o);
            }
            ++i;
        }
        return dest;
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.addFilterButton.setText("Add");
        this.addFilterButton.addActionListener(new FindFilterDialog_addFilterButton_actionAdapter(this));
        this.removeFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindFilterDialog.this.removeFilter();
            }
        });
        this.removeFilterButton.setText("Remove Filter");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.splitter.setOrientation(0);
        this.splitter.setTopComponent(this.jPanel1);
        this.getContentPane().remove(this.toppanel);
        this.splitter.setBottomComponent(this.mainPanel);
        this.filterListPanel.setLayout(this.filterListGridLayout);
        this.filterListGridLayout.setColumns(1);
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new FindFilterDialog_searchButton_actionAdapter(this));
        this.jPanel1.add((Component)this.scrollPane, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.addFilterButton, null);
        this.jPanel3.add((Component)this.removeFilterButton, null);
        this.scrollPane.getViewport().add(this.filterListPanel);
        this.getContentPane().add((Component)this.splitter, "Center");
        this.buttonpanel.add((Component)this.searchButton, "North");
        this.splitter.setDividerLocation(250);
    }

    void addFilterButton_actionPerformed(ActionEvent e) {
        FindFilter f = new FindFilter(this.data, this.entity);
        f.addFocusListener(this.focusListener);
        int i = this.filterSelection;
        if (i >= 0) {
            this.filterListModel.insertElementAt(f, i);
            this.filterListPanel.add((Component)f, i);
        } else {
            this.filterListModel.addElement(f);
            this.filterListPanel.add(f);
        }
        this.filterListGridLayout.setRows(this.filterListModel.size());
        this.scrollPane.validate();
    }

    void removeFilter() {
        if (this.filterSelection < 0) {
            this.filterSelection = this.filterListModel.size() - 1;
        }
        FindFilter ff = (FindFilter)this.filterListModel.get(this.filterSelection);
        this.filterListModel.remove(this.filterSelection);
        this.filterListPanel.removeListItem(ff);
        this.setSelection(-1);
        this.filterListPanel.invalidate();
        this.scrollPane.invalidate();
    }

    public void setSelection(int i) {
        if (this.filterSelection >= 0 && this.filterSelection < this.filterListModel.size()) {
            ((FindFilter)this.filterListModel.get(this.filterSelection)).setSelected(false);
        }
        this.filterSelection = i;
        if (this.filterSelection >= 0) {
            ((FindFilter)this.filterListModel.get(this.filterSelection)).setSelected(true);
        }
    }

    void searchAction(ActionEvent e) {
        this.executeFilters();
    }

    class MyList
    extends JPanel
    implements Scrollable {
        GridLayout grid = new GridLayout(1, 1);
        int count = 0;

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        MyList() {
            this.setLayout(this.grid);
            this.addMouseListener(FindFilterDialog.this.ml);
        }

        public void addListItem(JComponent c) {
            this.grid.setRows(++this.count);
            this.add(c);
            this.validate();
        }

        public void removeListItem(JComponent c) {
            this.remove(c);
            this.grid.setRows(--this.count);
            this.validate();
        }
    }
}

