/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.gui.EntityChooserComboBox;
import medicine.gui.NavigatorPanel;

public class FindExplanationDialog
extends JDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton okbutton = new JButton();
    JPanel jPanel3 = new JPanel();
    EntityChooserComboBox entityToCombo;
    JSpinner stepsSpinner = new JSpinner();
    SpinnerNumberModel stepsModel = new SpinnerNumberModel(5, 1, 12, 1);
    EntityChooserComboBox entityFromCombo;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JButton jButton1 = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JList explanationList = new JList();
    NavigatorPanel navigator;
    EntityData data;
    Action close = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent e) {
            FindExplanationDialog.this.setVisible(false);
        }
    };
    Action findAction = new AbstractAction("Find explanataion"){

        public void actionPerformed(ActionEvent e) {
            Entity from = FindExplanationDialog.this.entityFromCombo.getSelectedValue();
            Entity to = FindExplanationDialog.this.entityToCombo.getSelectedValue();
            if (!(from instanceof Entity) || !(to instanceof Entity)) {
                JOptionPane.showMessageDialog(null, "Please select two entities in the boxes above.", "Error - no entity selected", 0);
                return;
            }
            Cursor oldCursor = FindExplanationDialog.this.getCursor();
            FindExplanationDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            Vector solution = Entities.findRelationChains(from, to, 11, FindExplanationDialog.this.stepsModel.getNumber().intValue(), null, null, null, 0);
            Vector<Explanation> solutionExplanations = new Vector<Explanation>();
            int i = 0;
            while (i < solution.size()) {
                solutionExplanations.add(new Explanation((Vector)solution.get(i)));
                ++i;
            }
            FindExplanationDialog.this.explanationList.setListData(solutionExplanations);
            FindExplanationDialog.this.setCursor(oldCursor);
        }
    };

    public FindExplanationDialog(NavigatorPanel n, EntityData d) throws HeadlessException {
        this.navigator = n;
        this.data = d;
        this.entityToCombo = new EntityChooserComboBox(this.data);
        this.entityFromCombo = new EntityChooserComboBox(this.data);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.entityToCombo.setAllowCreateNewEntity(false);
        this.entityFromCombo.setAllowCreateNewEntity(false);
        this.entityFromCombo.setEntity(this.navigator.entity);
        this.entityToCombo.setEntity(this.navigator.entity);
        this.entityFromCombo.setSelectedItem(this.navigator.entity);
        this.setSize(600, 250);
        this.setTitle("Find explanation");
    }

    private void jbInit() throws Exception {
        this.okbutton.setText("OK");
        this.stepsSpinner.setModel(this.stepsModel);
        this.jLabel1.setText("causes");
        this.jLabel2.setText("steps");
        this.jLabel3.setText("in");
        this.jButton1.setText("Find explanation");
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.okbutton, null);
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.entityFromCombo, null);
        this.jPanel3.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.entityToCombo, null);
        this.jPanel3.add((Component)this.jLabel3, null);
        this.jPanel3.add((Component)this.stepsSpinner, null);
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.explanationList, null);
        this.jButton1.addActionListener(this.findAction);
        this.okbutton.addActionListener(this.close);
    }

    static class Explanation {
        Vector chain;

        public Explanation(Vector chain) {
            this.chain = chain;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.chain.size()) {
                sb.append(this.chain.get(i));
                if (i < this.chain.size() - 1) {
                    sb.append(" - ");
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

