/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import medicine.Entity;
import medicine.EntityComparator;
import medicine.EntityCrawler;
import medicine.EntityData;
import medicine.MainApplication;
import medicine.gui.EntityPanel;

public class FindDialog
extends JDialog
implements ActionListener {
    public boolean caseSensitive = false;
    public boolean exactMatch = false;
    EntityData data;
    JTextField findtext = new JTextField();
    JPanel toppanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane leftlistpane = new JScrollPane();
    JList foundlist = new JList();
    JPanel buttonpanel = new JPanel();
    JButton OK = new JButton();
    JButton jButton2 = new JButton();
    EntityPanel entitypanel = new EntityPanel();
    Action sortAction = new AbstractAction("Sort"){

        public void actionPerformed(ActionEvent e) {
            FindDialog.this.sortFoundList();
        }
    };
    JButton sortButton = new JButton(this.sortAction);
    Vector found = new Vector();
    String searchstring;
    Entity anyNode;
    EntityComparator sortMode = EntityComparator.ASCENDING_ALPHABETICAL;
    Entity entity;
    JSplitPane jSplitPane1 = new JSplitPane();

    public FindDialog(EntityData data) {
        this();
        this.data = data;
    }

    public FindDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(475, 430);
        MainApplication.centreWindow(this);
        this.setTitle("Find item");
    }

    private void jbInit() throws Exception {
        this.jLabel1.setText("Find");
        this.findtext.setPreferredSize(new Dimension(200, 21));
        this.findtext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findtext_actionPerformed(e);
            }
        });
        this.mainPanel.setLayout(this.borderLayout1);
        this.leftlistpane.setPreferredSize(new Dimension(100, 132));
        this.foundlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FindDialog.this.foundlist_valueChanged(e);
            }
        });
        this.OK.setText("OK");
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.OKclick(e);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.cancelClick(e);
            }
        });
        this.foundlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                FindDialog.this.foundlist_mouseClicked(e);
            }
        });
        this.jSplitPane1.setLeftComponent(this.leftlistpane);
        this.jSplitPane1.setRightComponent(this.entitypanel);
        this.getContentPane().add((Component)this.toppanel, "North");
        this.toppanel.add((Component)this.jLabel1, null);
        this.toppanel.add((Component)this.findtext, null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.buttonpanel, "South");
        this.buttonpanel.add((Component)this.sortButton, null);
        this.buttonpanel.add((Component)this.OK, null);
        this.buttonpanel.add((Component)this.jButton2, null);
        this.leftlistpane.getViewport().setView(this.foundlist);
        this.jSplitPane1.setDividerLocation(170);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findtext_actionPerformed(ActionEvent e) {
        Vector vector = this.found;
        synchronized (vector) {
            this.searchstring = this.findtext.getText();
            this.found.removeAllElements();
            this.foundlist.setListData(this.found);
        }
        EntityCrawler es = new EntityCrawler(this.data, this);
        es.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != null && e.getActionCommand() != null) {
            Entity node = (Entity)e.getSource();
            boolean f = this.caseSensitive ? (this.exactMatch ? node.equals(this.searchstring) : node.contains(this.searchstring)) : (this.exactMatch ? node.equalsIgnoreCase(this.searchstring) : node.containsIgnoreCase(this.searchstring));
            if (f) {
                this.found.add(e.getSource());
            }
            this.redisplay();
        } else if (e.getID() == -1) {
            this.sortFoundList();
            if (this.found.size() == 1) {
                this.foundlist.setSelectedIndex(0);
                this.OK.requestFocus();
            }
        }
    }

    void sortFoundList() {
        Collections.sort(this.found, this.sortMode);
        this.redisplay();
    }

    void redisplay() {
        this.foundlist.setListData(this.found);
    }

    void foundlist_valueChanged(ListSelectionEvent e) {
        this.entitypanel.setEntity((Entity)this.foundlist.getSelectedValue());
    }

    void cancelClick(ActionEvent e) {
        this.entity = null;
        this.hide();
    }

    void OKclick(ActionEvent e) {
        this.entity = (Entity)this.foundlist.getSelectedValue();
        this.hide();
    }

    void foundlist_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.entity = (Entity)this.foundlist.getSelectedValue();
            if (this.entity != null) {
                MainApplication.frame.editor.navigator.setEntity(this.entity);
            }
            this.entityDoubleClicked();
        }
    }

    public void entityDoubleClicked() {
        this.hide();
    }
}

