/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;

public class EntityTable
extends JDialog {
    int DEPTH = 2;
    int NC = 10;
    int NR = 10;
    EntityData data;
    JScrollPane scroll = new JScrollPane();
    JTable table = new JTable();
    BorderLayout borderlayout1 = new BorderLayout();
    JPanel lower = new JPanel();
    JButton ok = new JButton();
    EntityTableModel m = new EntityTableModel();
    DefaultTableColumnModel tcm = new DefaultTableColumnModel();
    Action okaction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            EntityTable.this.setVisible(false);
        }
    };
    Vector rowEntities = new Vector();
    Vector colEntities = new Vector();
    int relation = 8;

    public EntityTable(EntityData e) {
        this.data = e;
        this.init();
    }

    void init() {
        this.setLayout(this.borderlayout1);
        this.add((Component)this.scroll, "Center");
        this.scroll.getViewport().setView(this.table);
        this.add((Component)this.lower, "South");
        this.lower.add(this.ok);
        this.ok.setAction(this.okaction);
        this.table.setModel(this.m);
        this.table.setColumnModel(this.tcm);
        this.table.setDefaultRenderer(TableItem.class, TableItem.YES);
        this.scroll.setPreferredSize(new Dimension(1000, 300));
        this.pack();
    }

    void setupFrom(Entity e) {
        Vector columns = new Vector();
        columns.addAll(Entities.getExtensiveListOf(this.relation, e, this.DEPTH));
        Vector<Entity> rows = new Vector<Entity>();
        int[] rowscores = new int[65535];
        rows.add(e);
        for (Entity c : columns) {
            Vector orel = c.listOf(Entity.inverseOf(this.relation));
            for (Entity or : orel) {
                if (!rows.contains(or)) {
                    rows.add(or);
                }
                int n = rows.indexOf(or);
                rowscores[n] = rowscores[n] + 1;
            }
        }
        if (rows.size() > this.NR) {
            int[] topridx = new int[this.NR];
            int[] toprsco = new int[this.NR];
            int i = 0;
            while (i < this.NR) {
                topridx[i] = i;
                toprsco[i] = rowscores[i];
                ++i;
            }
            i = this.NR;
            while (i < rows.size()) {
                int[] diff = new int[this.NR];
                int lowestj = 0;
                int lowestd = Integer.MAX_VALUE;
                int j = 0;
                while (j < this.NR) {
                    diff[j] = toprsco[j] - rowscores[i];
                    if (diff[j] < lowestd) {
                        lowestd = diff[j];
                        lowestj = j;
                    }
                    ++j;
                }
                if (lowestd < 0) {
                    topridx[lowestj] = i;
                    toprsco[lowestj] = rowscores[i];
                }
                ++i;
            }
            Vector newrows = new Vector();
            int i2 = 0;
            while (i2 < this.NR) {
                newrows.add(rows.get(topridx[i2]));
                ++i2;
            }
            rows = newrows;
        }
        this.m.setColumns(columns);
        this.m.setRows(rows);
        this.chooseBestColumns();
        this.pack();
    }

    void chooseBestColumns() {
        Vector columns = new Vector();
        int[] colscore = new int[65535];
        for (Entity r : this.m.rows) {
            Vector nc = r.listOf(this.relation);
            int j = 0;
            while (j < nc.size()) {
                if (!columns.contains(nc.get(j))) {
                    columns.add(nc.get(j));
                }
                int n = columns.indexOf(nc.get(j));
                colscore[n] = colscore[n] + 1;
                ++j;
            }
        }
        if (columns.size() > this.NC) {
            int[] topcidx = new int[this.NC];
            int[] topcsco = new int[this.NC];
            int i = 0;
            while (i < this.NC) {
                topcidx[i] = i;
                topcsco[i] = colscore[i];
                ++i;
            }
            i = this.NC;
            while (i < columns.size()) {
                int[] diff = new int[this.NC];
                int lowestj = 0;
                int lowestd = Integer.MAX_VALUE;
                int j = 0;
                while (j < this.NC) {
                    diff[j] = topcsco[j] - colscore[i];
                    if (diff[j] < lowestd) {
                        lowestd = diff[j];
                        lowestj = j;
                    }
                    ++j;
                }
                if (lowestd < 0) {
                    topcidx[lowestj] = i;
                    topcsco[lowestj] = colscore[i];
                }
                ++i;
            }
            Vector newcols = new Vector();
            int i2 = 0;
            while (i2 < this.NC) {
                newcols.add(columns.get(topcidx[i2]));
                ++i2;
            }
            columns = newcols;
        }
        this.m.setColumns(columns);
    }

    public void addRow(Entity e) {
        Vector<Entity> r = new Vector<Entity>();
        r.add(e);
        for (Entity e2 : this.rowEntities) {
            if (!e2.equals(e)) continue;
            return;
        }
        this.m.rows.add(r);
        this.m.fireTableStructureChanged();
    }

    class EntityTableModel
    extends AbstractTableModel {
        private Vector columns = new Vector();
        private Vector rows = new Vector();
        TableColumn firstCol = new TableColumn();
        int relation = 8;
        String[] pHigh = new String[]{"Hyper", "Increased ", "High ", "Higher ", "Raised "};
        String[] pLow = new String[]{"Hypo", "Decreased ", "Low ", "Lower ", "Lowered"};

        EntityTableModel() {
        }

        public void addColumn(Entity e) {
            if (!this.columns.contains(e)) {
                this.columns.add(e);
                TableColumn col = new TableColumn();
                col.setHeaderValue(e);
                EntityTable.this.tcm.addColumn(col);
            }
            this.fireTableStructureChanged();
        }

        public void setColumns(Vector v) {
            this.columns = v;
            EntityTable.this.tcm = new DefaultTableColumnModel();
            EntityTable.this.tcm.addColumn(this.firstCol);
            int i = 0;
            while (i < v.size()) {
                this.addColumn((Entity)v.get(i));
                ++i;
            }
            this.fireTableStructureChanged();
        }

        public void setRows(Vector v) {
            this.rows = v;
            this.fireTableStructureChanged();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return TableItem.class;
        }

        public int getColumnCount() {
            return this.columns.size() + 1;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Name";
            }
            return ((Entity)this.columns.get((int)(columnIndex - 1))).name;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((Entity)this.rows.get((int)rowIndex)).name;
            }
            return this.getTableItemFor((Entity)this.rows.get(rowIndex), (Entity)this.columns.get(columnIndex - 1));
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        TableItem getTableItemFor(Entity r, Entity c) {
            Set v = Entities.getExtensiveListOf(this.relation, r, EntityTable.this.DEPTH);
            for (Entity e : v) {
                String strippedr;
                if (e.equals(c)) {
                    return TableItem.YES;
                }
                String strippedc = this.strip(c.name);
                if (!strippedc.equals(strippedr = this.strip(e.name))) continue;
                if (this.startsWithOneOf(e.name, this.pHigh)) {
                    return TableItem.UP;
                }
                return TableItem.DOWN;
            }
            return TableItem.NO;
        }

        boolean startsWithOneOf(String a, String[] x) {
            int i = 0;
            while (i < x.length) {
                if (a.startsWith(x[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        String strip(String s) {
            int i = 0;
            while (i < this.pHigh.length) {
                if (s.startsWith(this.pHigh[i])) {
                    return s.substring(this.pHigh[i].length());
                }
                ++i;
            }
            i = 0;
            while (i < this.pLow.length) {
                if (s.startsWith(this.pLow[i])) {
                    return s.substring(this.pLow[i].length());
                }
                ++i;
            }
            return s;
        }
    }

    static class TableItem
    extends DefaultTableCellRenderer {
        int type;
        String[] t = new String[]{"?", "U", "D", "Y", "N"};
        static TableItem UP = new TableItem(1);
        static TableItem DOWN = new TableItem(2);
        static TableItem YES = new TableItem(3);
        static TableItem NO = new TableItem(4);
        static TableItem NONE = new TableItem(0);
        int tcrt;
        int sw = 2;
        int aw = 5;

        TableItem(int a) {
            this.type = a;
        }

        public String toString() {
            return this.t[this.type];
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.tcrt = value instanceof TableItem ? ((TableItem)value).type : -1;
            return this;
        }

        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int x0 = (w - Math.min(h, w)) / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(3.0f));
            if (this.tcrt >= 0) {
                if (this.tcrt == 1) {
                    g.setColor(Color.magenta);
                    g.fillRect(w / 2 - this.sw, this.aw, this.sw * 2, this.getHeight() - this.aw);
                    int[] nArray = new int[3];
                    nArray[0] = this.aw;
                    nArray[2] = this.aw;
                    g.fillPolygon(new int[]{x0, w / 2, w - x0}, nArray, 3);
                } else if (this.tcrt == 2) {
                    g.setColor(Color.blue);
                    g.fillRect(w / 2 - this.sw, 0, this.sw * 2, this.getHeight() - this.aw);
                    g.fillPolygon(new int[]{x0, w / 2, w - x0}, new int[]{h - this.aw, h, h - this.aw}, 3);
                } else if (this.tcrt == 3) {
                    g.setColor(Color.red);
                    g.drawLine(x0, h / 2, w / 2, h);
                    g.drawLine(w / 2, h, w - x0, 0);
                } else if (this.tcrt == 4) {
                    g.setColor(Color.black);
                    g.drawLine(x0, 0, w - x0, h);
                    g.drawLine(x0, h, w - x0, 0);
                }
            } else {
                super.paint(g);
            }
        }
    }
}

