/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import medicine.DataIntegrityException;
import medicine.Entity;
import medicine.EntityData;
import medicine.gui.MainFrame;
import medicine.gui.NavigatorPanel;
import medicine.gui.SynonymInputDialog;

public class EntityPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    Entity entity;
    Border border1;
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane descriptionScroll = new JScrollPane();
    static final boolean HTML = false;
    JEditorPane descriptiontxt = new JEditorPane("text/plain", "");
    JScrollPane synonympanel = new JScrollPane();
    JList synonymlist = new JList();
    JTextField namepanel = new JTextField();
    JPopupMenu popupmenu = new JPopupMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem removesynon = new JMenuItem();
    MainFrame frame;
    JComponent thisComp = this;
    int nreplaces;
    String lastTestedName = "";
    boolean isEditable;
    JPanel treatpanel = new JPanel();
    JScrollPane treatscroll = new JScrollPane();
    JScrollPane treatmentscroll = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    GridLayout gridLayout1 = new GridLayout();

    public EntityPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntity(Entity e) {
        this.entity = e;
        this.init();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void init() {
        if (this.entity != null) {
            this.namepanel.setText(this.entity.name);
            this.synonymlist.setListData(this.entity.synonyms);
            this.descriptiontxt.setText(this.entity.description);
        } else {
            this.namepanel.setText("");
            this.synonymlist.setListData(new Vector());
            this.descriptiontxt.setText("");
        }
    }

    String escapehtml(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\n", "\n<br>\n");
        return s;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(248, 240, 255), new Color(121, 117, 151)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(this.borderLayout1);
        this.setBorder(this.border1);
        this.descriptiontxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EntityPanel.this.descriptionChanged(e);
            }
        });
        this.namepanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.nameChanged();
            }
        });
        this.jMenuItem1.setText("Add...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.addsynonym(e);
            }
        });
        this.removesynon.setText("Remove");
        this.removesynon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.removesynonym(e);
            }
        });
        this.synonymlist.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                EntityPanel.this.synonymlist_mouseReleased(e);
            }
        });
        this.namepanel.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                EntityPanel.this.nameChanged();
            }
        });
        this.namepanel.setFont(new Font("SansSerif", 1, 12));
        this.namepanel.setToolTipText("Name of entity");
        this.descriptionScroll.setHorizontalScrollBarPolicy(31);
        this.treatpanel.setLayout(this.gridLayout1);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel1.setLayout(this.borderLayout4);
        this.jLabel1.setText("Treatments");
        this.jLabel2.setText("Treats");
        this.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.descriptionScroll, "Description");
        this.jTabbedPane1.add((Component)this.synonympanel, "Synonyms");
        this.jTabbedPane1.add((Component)this.treatpanel, "Rx");
        this.add((Component)this.namepanel, "North");
        this.synonympanel.getViewport().add((Component)this.synonymlist, null);
        this.descriptionScroll.getViewport().add((Component)this.descriptiontxt, null);
        this.popupmenu.add(this.jMenuItem1);
        this.popupmenu.add(this.removesynon);
        this.jPanel1.add((Component)this.treatmentscroll, "Center");
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.treatpanel.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.treatscroll, "Center");
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.treatpanel.add((Component)this.jPanel1, null);
        this.namepanel.setEditable(false);
        JPopupMenu p = new JPopupMenu();
        p.add(new JMenuItem(new AbstractAction("Edit"){

            public void actionPerformed(ActionEvent e) {
                EntityPanel.this.namepanel.setEditable(true);
            }
        }));
        this.namepanel.setComponentPopupMenu(p);
    }

    void namepanel_inputMethodTextChanged(InputMethodEvent e) {
        if (this.entity != null) {
            this.entity.name = this.namepanel.getText();
        }
    }

    void addsynonym(ActionEvent e) {
        SynonymInputDialog sid = new SynonymInputDialog(this.entity);
        sid.setModal(true);
        sid.show();
        if (sid.synonym != null && sid.synonym != "") {
            this.entity.synonyms.add(sid.synonym);
            this.redisplay();
        }
    }

    void removesynonym(ActionEvent e) {
        Object o = this.synonymlist.getSelectedValue();
        this.entity.synonyms.remove(o);
        this.redisplay();
    }

    void redisplay() {
        this.setEntity(this.entity);
    }

    EntityData getFrameData() {
        if (this.frame == null) {
            Container p = this;
            if (p == null) {
                return null;
            }
            while (!((p = p.getParent()) instanceof MainFrame) || p == null) {
            }
            if (p instanceof MainFrame) {
                this.frame = (MainFrame)p;
            }
        }
        if (this.frame != null) {
            return this.frame.entityData;
        }
        return null;
    }

    void synonymlist_mouseReleased(MouseEvent e) {
        if (this.isEditable && e.getModifiers() == 4) {
            this.popupmenu.show(this.synonympanel, e.getX(), e.getY());
        }
    }

    void descriptionChanged(FocusEvent e) {
        if (this.entity != null) {
            this.entity.description = this.descriptiontxt.getText();
        }
    }

    void nameChanged() {
        if (this.entity == null) {
            return;
        }
        this.entity.name = this.namepanel.getText();
        if (this.lastTestedName.equals(this.entity.name)) {
            return;
        }
        this.lastTestedName = this.entity.name;
        EntityData data = this.getFrameData();
        Vector v = data.findEntities(this.entity.name, false, true);
        if (v.size() > 1) {
            throw new DataIntegrityException("Duplicates of " + this.entity.name + " found.");
        }
        if (v.size() > 1) {
            Entity duplicate = (Entity)v.get(1);
            String dstr = String.valueOf(duplicate.name) + " (" + duplicate.description + ")";
            if (this.entity.isBlank()) {
                int res = JOptionPane.showConfirmDialog(this.thisComp, "An entity called " + dstr + " already exists. Would you like to replace the" + "current entity with it?", "Duplicate entity", 0);
                if (res == 0) {
                    ++this.nreplaces;
                    this.entity.replaceAllWith(duplicate);
                    this.setEntity(duplicate);
                    if (this.getParent() instanceof NavigatorPanel) {
                        ((NavigatorPanel)this.getParent()).setEntity(this.entity);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.thisComp, "Warning: an entity called " + dstr + " already exists.", "Duplicate entity name", 2);
            }
        }
        this.namepanel.setEditable(false);
    }

    public void setEditable(boolean t) {
        this.isEditable = t;
        this.descriptiontxt.setEditable(t);
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

