/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import medicine.Entity;
import medicine.EntityData;
import medicine.MainApplication;
import medicine.gui.DictionaryDialog_jList1_mouseAdapter;

public class DictionaryDialog
extends JDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JPanel toppanel = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jList1 = new JList();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    AbstractButton[] buttons = new AbstractButton[27];
    ButtonGroup bg = new ButtonGroup();
    EntityData data;
    ActionListener bgal = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DictionaryDialog.this.currentLetter = e.getActionCommand();
            DictionaryDialog.this.updateData();
        }
    };
    String currentLetter;
    Vector items = new Vector();
    Comparator comparator = new Comparator(){

        public int compare(Object o, Object o2) {
            return o.toString().compareTo(o2.toString());
        }
    };
    public Entity returnValue;
    ActionListener bl = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Cancel")) {
                DictionaryDialog.this.returnValue = null;
                DictionaryDialog.this.hide();
            } else {
                DictionaryDialog.this.returnValue = ((Item)DictionaryDialog.this.jList1.getSelectedValue()).entity;
                DictionaryDialog.this.hide();
            }
        }
    };
    GridLayout gridLayout1 = new GridLayout();

    public DictionaryDialog(EntityData data) throws HeadlessException {
        this.data = data;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = new JToggleButton(i < this.buttons.length - 1 ? String.valueOf((char)(65 + i)) : "#");
            this.bg.add(this.buttons[i]);
            this.toppanel.add(this.buttons[i]);
            this.buttons[i].addActionListener(this.bgal);
            this.buttons[i].setMargin(new Insets(2, 2, 2, 2));
            ++i;
        }
        this.setSize(250, 400);
        MainApplication.centreWindow(this);
        this.buttons[0].setSelected(false);
    }

    void updateData() {
        Collection c = this.data.getAllEntities();
        this.items.removeAllElements();
        for (Entity e3 : c) {
            if (DictionaryDialog.satisfies(e3.name, this.currentLetter)) {
                this.items.add(new Item(e3, e3.name));
            }
            int j = 0;
            while (j < e3.synonyms.size()) {
                String s = e3.synonyms.elementAt(j).toString();
                if (DictionaryDialog.satisfies(s, this.currentLetter)) {
                    this.items.add(new Item(e3, s));
                }
                ++j;
            }
        }
        this.updateListItems();
    }

    static final boolean satisfies(String name, String let) {
        if (let != "#") {
            return name.startsWith(let);
        }
        return Character.isDigit(name.charAt(0));
    }

    void updateListItems() {
        Object[] o = this.items.toArray();
        Arrays.sort(o, this.comparator);
        this.jList1.setListData(o);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(109, 109, 110), new Color(156, 156, 158)), BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jButton1.setText("Go");
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(this.bl);
        this.jButton1.addActionListener(this.bl);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel1.setBorder(this.border1);
        this.toppanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(9);
        this.gridLayout1.setRows(3);
        this.jList1.addMouseListener(new DictionaryDialog_jList1_mouseAdapter(this));
        this.setModal(true);
        this.setTitle("Dictionary");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jButton2, null);
        this.jPanel2.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.toppanel, "North");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
    }

    void jList1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.returnValue = ((Item)this.jList1.getSelectedValue()).entity;
            this.hide();
        }
    }

    class Item {
        Entity entity;
        String name;

        Item(Entity e, String s) {
            this.entity = e;
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

