/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.MainApplication;

public class CauseListDialog
extends JDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButton1 = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTree tree = new JTree();
    JSpinner spindepth = new JSpinner(new SpinnerNumberModel(2, 1, 7, 1));
    Entity entity;
    public Entity selection;
    int relations = 7;
    String dirname = "Causes";
    EntityData entityData;

    public CauseListDialog() {
        this.initComponents();
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        this.initTree();
    }

    void initComponents() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(300, 300);
        MainApplication.centreWindow(this);
    }

    private void jbInit() throws Exception {
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CauseListDialog.this.ok_action(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.tree, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add(this.spindepth);
        this.spindepth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CauseListDialog.this.initTree();
            }
        });
        this.jPanel2.add((Component)this.jButton1, null);
    }

    void ok_action(ActionEvent e) {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            Object o = tp.getLastPathComponent();
            if (o instanceof Entity) {
                this.selection = (Entity)o;
            } else if (this.entityData != null) {
                this.selection = this.entityData.findEntityExact(o.toString());
            }
        }
        this.hide();
    }

    void initTree() {
        this.setTitle("List of " + this.dirname);
        int depth = (Integer)this.spindepth.getValue();
        Set c = Entities.getDirectionalListOf(this.relations, this.entity, depth);
        Cloneable nodes = this.entityData != null ? Entities.groupedVectors(c, Entities.E_DISEASE | Entities.E_PATHOLOGY | Entities.E_INVESTIGATION | Entities.E_SIGN | Entities.E_SYMPTOM | Entities.E_SUBSTANCE | Entities.E_TREATMENT | Entities.E_LIFESTYLE) : new Vector(c);
        JTree.DynamicUtilTreeNode root = new JTree.DynamicUtilTreeNode((Object)(String.valueOf(this.dirname) + " of " + this.entity.name), nodes);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.tree.setModel(model);
        int i = 0;
        while (i < this.tree.getRowCount()) {
            this.tree.expandRow(i);
            ++i;
        }
    }

    public void setData(EntityData d) {
        this.entityData = d;
    }

    public void setDirection(int dir, String dirname) {
        this.relations = dir | 1 | 2;
        this.dirname = dirname;
    }
}

