/*
 * Decompiled with CFR 0.152.
 */
package medicine.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import medicine.Entity;
import medicine.EntityCrawler;
import medicine.EntityData;
import medicine.gui.AdvancedFindControls;
import medicine.gui.FindDialog;

public class AdvancedFindDialog
extends FindDialog {
    AdvancedFindControls afc = new AdvancedFindControls();
    JButton searchbutton = new JButton();
    int relation;
    int nrelations;
    int search;
    static final int NRELATIONS = 1;
    static final int TEXT = 2;
    static final int RELATEDTO = 3;
    boolean caseSensitive;
    boolean exactMatch;
    boolean superclass;

    public AdvancedFindDialog(EntityData d, Entity e) {
        super(d);
        this.init();
        this.afc.currententity.setText(e.name);
    }

    public AdvancedFindDialog() {
        this.init();
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.searchbutton.setText("Search");
        this.searchbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedFindDialog.this.searchbutton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.afc, "North");
        this.buttonpanel.add((Component)this.searchbutton, "South");
    }

    public void findtext_actionPerformed(ActionEvent e) {
        this.afc.textcheck.setSelected(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchbutton_actionPerformed(ActionEvent e) {
        Vector vector = this.found;
        synchronized (vector) {
            this.found = new Vector();
            this.foundlist.setListData(this.found);
        }
        this.initialiseSearch();
    }

    void initialiseSearch() {
        if (this.afc.numcheck.isSelected()) {
            this.search = 1;
            try {
                this.relation = this.afc.getSelectedRelation();
                if (this.relation < 0) {
                    throw new Exception("No relationship selected");
                }
                this.nrelations = Integer.valueOf(this.afc.numentitiestext.getText());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Not a number", "Please type a number", 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Please select a relationship", "No relationship selected", 0);
            }
        }
        if (this.afc.textcheck.isSelected()) {
            this.search = 2;
            this.exactMatch = !this.afc.contains.isSelected();
            this.caseSensitive = this.afc.casesensitive.isSelected();
            this.searchstring = this.afc.findtext.getText();
        }
        EntityCrawler es = new EntityCrawler(this.data, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedFindDialog.this.test(e);
            }
        });
        if (this.afc.relatedcheck.isSelected()) {
            this.search = 3;
            int i = this.afc.getSelectedRelation();
            if (i == -1) {
                i = 63;
            }
            if (this.afc.includesupercheck.isSelected()) {
                i |= 1;
            }
            es.setBranchMask(i);
        }
        es.start();
    }

    void test(ActionEvent e) {
        if (e.getActionCommand() == null) {
            this.actionPerformed(e);
            return;
        }
        Entity r = (Entity)e.getSource();
        boolean found = false;
        if (this.search == 1) {
            int n = r.listOf(this.relation).size();
            if (n == this.nrelations) {
                found = true;
            }
        } else if (this.search == 2) {
            found = this.caseSensitive ? (this.exactMatch ? r.equals(this.searchstring) : r.contains(this.searchstring)) : (this.exactMatch ? r.equalsIgnoreCase(this.searchstring) : r.containsIgnoreCase(this.searchstring));
        } else if (this.search == 3) {
            found = true;
        }
        if (found) {
            this.actionPerformed(e);
        }
    }
}

