/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import medicine.DataIntegrityException;
import medicine.gui.MainFrame;

public class MainApplication {
    public static MainFrame frame;

    public static void main(String[] params) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frame = new MainFrame();
        String filename = null;
        String server = null;
        if (params.length > 0) {
            filename = params[0];
            String string = server = params.length > 1 ? params[1] : null;
        }
        if (params.length == 0 || filename.startsWith("server")) {
            final String srv = server;
            Thread nt = new Thread(new Runnable(){

                public void run() {
                    String srvr = srv;
                    if (srvr == null) {
                        srvr = "http://www.homphysiology.org/cgi-bin/medicine.pl";
                    }
                    MainApplication.frame.downloadServer.actionPerformed(new ActionEvent(this, 0, srvr));
                }
            });
            nt.run();
        } else if (filename != null) {
            final String file = filename;
            Thread nt = new Thread(new Runnable(){

                public void run() {
                    try {
                        File f = new File(file);
                        FileInputStream stream = new FileInputStream(f);
                        if (file.endsWith("txt")) {
                            frame.readTextFromStream(stream, file);
                        } else if (file.endsWith("zip")) {
                            frame.readTextFromZip(stream, file);
                        } else {
                            frame.readDatabaseFrom(stream, file);
                        }
                        MainApplication.frame.filer.setSelectedFile(f);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Open error: " + file, 0);
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Incorrect format: " + file, 0);
                    }
                    catch (DataIntegrityException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Data integr " + file, 0);
                    }
                }
            });
            nt.start();
        }
        frame.setVisible(true);
    }

    public static Point getCentre() {
        if (frame == null) {
            return null;
        }
        return new Point(MainApplication.frame.getLocation().x + MainApplication.frame.getSize().width / 2, MainApplication.frame.getLocation().y + MainApplication.frame.getSize().height / 2);
    }

    public static void centreWindow(Window w) {
        if (frame == null) {
            return;
        }
        Point p = MainApplication.getCentre();
        p.x -= w.getWidth() / 2;
        p.y -= w.getHeight() / 2;
        w.setLocation(p);
    }
}

