/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import medicine.DataIntegrityException;
import medicine.Entity;

public class EntityData {
    private Hashtable namesToEntities = new Hashtable();
    public long saveTime;
    public long lastRead;

    public Collection getAllEntities() {
        return this.namesToEntities.values();
    }

    public Entity addNewEntity(String name) {
        Entity e = new Entity(null, 0);
        e.name = name;
        Entity o = this.namesToEntities.put(name, e);
        if (o != null) {
            throw new IllegalStateException("Two entites with key " + name);
        }
        return e;
    }

    public Entity addNewEntity(Entity from, int relation) {
        Entity e = new Entity(from, relation);
        Entity o = this.namesToEntities.put(e.name, e);
        if (o != null) {
            throw new IllegalStateException("Two entites with key " + e.name);
        }
        return e;
    }

    public void removeEntity(Entity r) {
        this.namesToEntities.remove(r.name);
    }

    public void removeAllOf(Collection e) {
        Iterator i = e.iterator();
        while (i.hasNext()) {
            this.removeEntity((Entity)i.next());
        }
    }

    void refreshNames() {
        Collection es = this.namesToEntities.values();
        Hashtable<String, Entity> nht = new Hashtable<String, Entity>();
        for (Entity e : es) {
            nht.put(e.name, e);
        }
        this.namesToEntities = nht;
    }

    public void checkIntegrity() throws DataIntegrityException {
        Collection c = this.namesToEntities.values();
        for (Entity e : c) {
            int i = 1;
            while (i < Entity.relationList.length) {
                Vector v = e.listOf(Entity.relationList[i]);
                for (Entity e2 : v) {
                    if (c.contains(e2)) continue;
                    throw new DataIntegrityException(String.valueOf(e2.name) + " not found in data.");
                }
                ++i;
            }
        }
    }

    public int size() {
        return this.namesToEntities.size();
    }

    public Entity findEntityExact(String name) {
        return (Entity)this.namesToEntities.get(name);
    }

    public Vector findEntities(String text, boolean contains, boolean csensitive) {
        Vector res = new Vector();
        Enumeration k = this.namesToEntities.elements();
        block0: while (k.hasMoreElements()) {
            Entity c = (Entity)k.nextElement();
            String s = c.name;
            String textlc = text.toLowerCase();
            if (contains) {
                if (csensitive) {
                    if (s.indexOf(text) >= 0) {
                        res.addElement(this.namesToEntities.get(s));
                        continue;
                    }
                } else if (s.toLowerCase().indexOf(textlc) >= 0) {
                    res.addElement(this.namesToEntities.get(s));
                    continue;
                }
                int i = 0;
                while (i < c.synonyms.size()) {
                    String syn = (String)c.synonyms.elementAt(i);
                    if (csensitive) {
                        if (syn.indexOf(text) >= 0) {
                            res.addElement(this.namesToEntities.get(s));
                            continue block0;
                        }
                    } else if (syn.toLowerCase().indexOf(textlc) >= 0) {
                        res.addElement(this.namesToEntities.get(s));
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (csensitive) {
                if (!s.equals(text)) continue;
                res.addElement(this.namesToEntities.get(s));
                continue;
            }
            if (!s.equalsIgnoreCase(text)) continue;
            res.addElement(this.namesToEntities.get(s));
        }
        return res;
    }

    @Deprecated
    public Entity getFirstEntity() {
        return (Entity)this.namesToEntities.values().iterator().next();
    }

    private Entity getItemAtIndex(int n) {
        int index = 0;
        for (Object o : this.namesToEntities.values()) {
            if (index == n) {
                return (Entity)o;
            }
            ++index;
        }
        throw new ArrayIndexOutOfBoundsException("can't get entity at index " + n);
    }

    public Entity getRandomEntity() {
        return this.getItemAtIndex((int)Math.floor(Math.random() * (double)this.getAllEntities().size()));
    }
}

