/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.io.Serializable;
import java.util.Vector;

public class Entity
implements Serializable {
    static int serial = 0;
    public static final int PARENT = 1;
    public static final int CHILD = 2;
    public static final int CAUSE = 4;
    public static final int EFFECT = 8;
    public static final int TREATS = 16;
    public static final int TREATMENTS = 32;
    public static int[] relationList = new int[]{4, 8, 1, 2, 16, 32};
    public static String[] relationNameList = new String[]{"Causes", "Effects", "Supertypes", "Subtypes", "Treats", "Treatments"};
    double[][] probs;
    public Vector children = new Vector();
    public Vector parents = new Vector();
    public Vector causes = new Vector();
    public Vector effects = new Vector();
    public Vector synonyms;
    public String name;
    public String description;
    public Vector treats = new Vector();
    public Vector treatments = new Vector();
    public Vector pChildren;
    public Vector pCauses;
    public Vector pEffects;

    public Entity(Entity from, int connection) {
        if (from != null) {
            this.connect(from, connection);
        }
        this.synonyms = new Vector();
        this.name = "Entity" + serial++;
        this.description = "";
    }

    public Vector listOf(int relation) {
        switch (relation) {
            case 1: {
                return this.parents;
            }
            case 2: {
                return this.children;
            }
            case 4: {
                return this.causes;
            }
            case 8: {
                return this.effects;
            }
            case 16: {
                return this.treats;
            }
            case 32: {
                return this.treatments;
            }
        }
        return null;
    }

    public double[] probsOf(int relation) {
        if (this.probs == null) {
            return null;
        }
        int i = 0;
        while (i < relationList.length) {
            double[] v;
            if ((relationList[i] & relation) > 0 && (v = this.probs[i]) != null) {
                if (v.length != this.listOf(relation).size()) {
                    this.ensureConnectionProbs(relation);
                }
                return v;
            }
            ++i;
        }
        return null;
    }

    private int probidxOfRel(int rel) {
        int i = 0;
        while (i < relationList.length) {
            if ((relationList[i] & rel) > 0) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(rel) + " is not a relation.");
    }

    private void removeProb(int rel, int idx) {
        double[] op;
        if (this.probs != null && (op = this.probs[this.probidxOfRel(rel)]) != null) {
            double[] np = new double[op.length - 1];
            System.arraycopy(op, 0, np, 0, idx - 1);
            System.arraycopy(op, idx + 1, np, idx, op.length - idx - 1);
            this.probs[this.probidxOfRel((int)rel)] = np;
        }
    }

    public void moveListItem(int rel, int idx1, int idx2) {
        Object o = this.listOf(rel).get(idx1);
        if (idx1 == idx2) {
            return;
        }
        int dest = idx2;
        if (idx1 < idx2) {
            --dest;
        }
        this.listOf(rel).remove(idx1);
        this.listOf(rel).insertElementAt(o, dest);
        double[] p = this.probsOf(rel);
        if (p != null) {
            double tmp = p[idx1];
            if (idx2 > idx1) {
                int i = idx1;
                while (i < dest) {
                    p[i] = p[i + 1];
                    ++i;
                }
            } else {
                int i = idx1;
                while (i > dest) {
                    p[i] = p[i - 1];
                    --i;
                }
            }
            p[dest] = tmp;
        }
    }

    public void checkIfProbsClear() {
        if (this.probs != null) {
            int i = 0;
            while (i < this.probs.length) {
                if (this.probs[i] != null) {
                    boolean empty = true;
                    int j = 0;
                    while (j < this.probs[i].length) {
                        if (!Double.isNaN(this.probs[i][j])) {
                            empty = false;
                        }
                        ++j;
                    }
                    if (empty) {
                        this.probs[i] = null;
                    }
                }
                ++i;
            }
        }
    }

    public void setProbOf(int relation, int idx, double x) {
        if (this.probs == null) {
            this.probs = new double[relationList.length][];
        }
        int i = 0;
        while (i < relationList.length) {
            if ((relationList[i] & relation) > 0) {
                int nrel;
                if (this.probs[i] == null) {
                    nrel = this.listOf(relation).size();
                    this.probs[i] = new double[nrel];
                    int j = 0;
                    while (j < nrel) {
                        this.probs[i][j] = Double.NaN;
                        ++j;
                    }
                } else if (this.probs[i].length <= idx) {
                    nrel = this.listOf(relation).size();
                    double[] npr = new double[nrel];
                    int j = 0;
                    while (j < this.probs[i].length) {
                        npr[j] = this.probs[i][j];
                        ++j;
                    }
                    j = this.probs[i].length;
                    while (j < nrel) {
                        npr[j] = Double.NaN;
                        ++j;
                    }
                    this.probs[i] = npr;
                }
                this.probs[i][idx] = x;
            }
            ++i;
        }
    }

    public static int inverseOf(int reciprocalRelation) {
        switch (reciprocalRelation) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 32;
            }
            case 32: {
                return 16;
            }
        }
        return 0;
    }

    public void connect(Entity to, int connectAs) {
        Vector mylist = this.listOf(connectAs);
        if (mylist.indexOf(to) >= 0) {
            return;
        }
        this.listOf(connectAs).add(to);
        this.ensureConnectionProbs(connectAs);
        to.listOf(Entity.inverseOf(connectAs)).add(this);
        to.ensureConnectionProbs(Entity.inverseOf(connectAs));
    }

    public void ensureConnectionProbs(int rel) {
        int r;
        boolean error = false;
        if (this.probs != null && this.probs[r = this.probidxOfRel(rel)] != null) {
            int nn = this.probs[r].length;
            int n = this.listOf(rel).size();
            if (nn == n) {
                return;
            }
            double[] np = new double[n];
            if (n < nn) {
                nn = n;
                error = true;
            }
            System.arraycopy(this.probs[r], 0, np, 0, nn);
            int j = this.probs[r].length;
            while (j < np.length) {
                np[j] = Double.NaN;
                ++j;
            }
            this.probs[r] = np;
        }
        if (error) {
            throw new IllegalStateException("The list " + this + "." + relationNameList[rel] + " has too many probabilities. I am truncating the list, possible losing data.");
        }
    }

    public void disconnect(Entity from, int relation) {
        if (this.numConnections() < 2) {
            System.out.println("Cannot delete last connection");
            return;
        }
        if (this.listOf(relation).contains(from)) {
            int idx = this.listOf(relation).indexOf(from);
            this.listOf(relation).remove(from);
            this.removeProb(relation, idx);
            int idx2 = from.listOf(Entity.inverseOf(relation)).indexOf(this);
            from.listOf(Entity.inverseOf(relation)).remove(this);
            from.removeProb(Entity.inverseOf(relation), idx2);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(String s) {
        if (this.name.equals(s)) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (s.equals((String)this.synonyms.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String s) {
        if (this.name.equalsIgnoreCase(s)) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (s.equalsIgnoreCase((String)this.synonyms.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(String s) {
        if (this.name.indexOf(s) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (((String)this.synonyms.get(i)).indexOf(s) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsIgnoreCase(String s) {
        if (this.indexOfIgnoreCase(this.name, s) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.synonyms.size()) {
            if (this.indexOfIgnoreCase((String)this.synonyms.get(i), s) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int indexOfIgnoreCase(String main, String sub) {
        int k = 0;
        while (k <= main.length() - sub.length()) {
            if (main.substring(k, k + sub.length()).equalsIgnoreCase(sub)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public boolean isBlank() {
        return this.synonyms.isEmpty() && this.numConnections() < 2 && this.description.equals("");
    }

    public void replaceAllWith(Entity replacement) {
        int i = 0;
        while (i < relationList.length) {
            int rel = relationList[i];
            Vector v = this.listOf(rel);
            int j = 0;
            while (j < v.size()) {
                Entity dest = (Entity)v.get(j);
                replacement.connect(dest, rel);
                dest.disconnect(this, Entity.inverseOf(rel));
                ++j;
            }
            ++i;
        }
    }

    int numConnections() {
        int n = this.causes.size() + this.effects.size() + this.parents.size() + this.children.size();
        return n += this.treatments.size() + this.treats.size();
    }
}

