/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import medicine.Entity;
import medicine.EntityData;
import medicine.EntityNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entities {
    EntityData entityData;
    public static final String[] standardStrings = new String[]{"Disease", "Pathology", "Investigation", "Sign", "Symptom", "Substance", "Treatment", "Lifestyle"};
    public static int E_DISEASE = 1;
    public static int E_PATHOLOGY = 2;
    public static int E_INVESTIGATION = 4;
    public static int E_SIGN = 8;
    public static int E_SYMPTOM = 16;
    public static int E_SUBSTANCE = 32;
    public static int E_TREATMENT = 64;
    public static int E_LIFESTYLE = 128;
    static final boolean ENSURE_VALIIDTY_AT_EXPENSE_OF_ORDER = false;
    public EntityData data;
    static int MAX_LIST_SIZE = 5;

    public static boolean isStandardUltimateParent(Entity e) {
        if (e == null) {
            return false;
        }
        int i = 0;
        while (i < standardStrings.length) {
            if (e.name.equals(standardStrings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasAStandardUltimateParent(Entity e) {
        Set l = Entities.getExtensiveListOf(1, e, 15);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            if (!Entities.isStandardUltimateParent((Entity)i.next())) continue;
            return true;
        }
        return false;
    }

    public void filterVectorForStandardParents(Vector v) {
        Vector rm = new Vector();
        int i = 0;
        while (i < v.size()) {
            if (Entities.isStandardUltimateParent(Entities.getUltimateParents((Entity)v.get(i)))) {
                rm.add(v.get(i));
            }
            ++i;
        }
        v.removeAll(rm);
    }

    public static void filterVectorForStandardParents(Vector v, int ultimateParent) {
        Vector rm = new Vector();
        int i = 0;
        while (i < v.size()) {
            Entity e = (Entity)v.get(i);
            Entity ultP = Entities.getUltimateParents(e);
            boolean ok = false;
            if (ultP != null) {
                int b = 0;
                while (b < 8) {
                    if ((ultimateParent & 1 << b) > 0 && ultP.name.equals(standardStrings[b])) {
                        ok = true;
                    }
                    ++b;
                }
            }
            if (!ok) {
                rm.add(v.get(i));
            }
            ++i;
        }
        v.removeAll(rm);
    }

    public void setData(EntityData e) {
        Vector<Entity> toremove = new Vector<Entity>();
        for (Entity en : e.getAllEntities()) {
            int nconn = 0;
            int j = 0;
            while (j < Entity.relationList.length) {
                Vector v = en.listOf(Entity.relationList[j]);
                nconn += v.size();
                ++j;
            }
            if (nconn == 0) {
                toremove.add(en);
            }
            int nsyn = en.synonyms.size();
            int j2 = 0;
            while (j2 < nsyn) {
                int k = j2 + 1;
                while (k < nsyn) {
                    if (en.synonyms.get(j2).equals(en.synonyms.get(k))) {
                        en.synonyms.set(k, "");
                    }
                    ++k;
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < en.synonyms.size()) {
                if (en.synonyms.get(j2).equals("")) {
                    en.synonyms.remove(j2--);
                }
                ++j2;
            }
        }
        e.removeAllOf(toremove);
        this.entityData = e;
    }

    public EntityData getData() {
        return this.entityData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextForm(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Entities entities = this;
        synchronized (entities) {
            for (Entity ent : this.entityData.getAllEntities()) {
                this.writeTextForm(out, ent);
            }
            this.writeTimeToStream(out, new Date().getTime());
        }
    }

    private void writeTimeToStream(PrintStream pw, long time) {
        pw.println("_SAVED_TIME " + time);
    }

    void writeTextForm(PrintStream out, Entity e) {
        out.println(String.valueOf(e.name) + " {");
        if (e.synonyms.size() > 0) {
            out.println("\tSynonyms {" + Entities.getDelimitedNames(e.synonyms, ", ") + "}");
        }
        if (e.causes.size() > 0) {
            out.println("\tCauses {" + Entities.getDelimitedEntities(e, 4, ", ") + "}");
        }
        if (e.effects.size() > 0) {
            out.println("\tEffects {" + Entities.getDelimitedEntities(e, 8, ", ") + "}");
        }
        if (e.parents.size() > 0) {
            out.println("\tParents {" + Entities.getDelimitedEntities(e, 1, ", ") + "}");
        }
        if (e.children.size() > 0) {
            out.println("\tChildren {" + Entities.getDelimitedEntities(e, 2, ", ") + "}");
        }
        if (e.treats.size() > 0) {
            out.println("\tTreats {" + Entities.getDelimitedEntities(e, 16, ", ") + "}");
        }
        if (e.treatments.size() > 0) {
            out.println("\tTreatments {" + Entities.getDelimitedEntities(e, 32, ", ") + "}");
        }
        if (!e.description.equals("")) {
            out.println("\tDescription {\"" + e.description.replace('{', '(').replace('}', ')') + "\"}");
        }
        out.println("}");
    }

    public static EntityData readTextForm(InputStream is) throws IOException {
        InputStreamReader fr = null;
        EntityData data = null;
        try {
            fr = new InputStreamReader(is);
            data = new EntityData();
            while (true) {
                Entities.readEntity(data, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                fr.close();
            }
            if (data == null) {
                return null;
            }
            if (data.size() == 0) {
                return null;
            }
            Entities.validateConnections(data);
            return data;
        }
    }

    @Deprecated
    public static Entity mergeTextFromStreams(InputStream is, InputStream is2) throws IOException {
        InputStreamReader fr = null;
        EntityData data = null;
        try {
            fr = new InputStreamReader(is);
            data = new EntityData();
            while (true) {
                Entities.readEntity(data, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                fr.close();
                fr = null;
            }
            if (data == null) {
                data = new EntityData();
            }
            try {
                fr = new InputStreamReader(is2);
                while (true) {
                    Entities.readEntity(data, fr);
                }
            }
            catch (EOF eOF2) {
                if (fr != null) {
                    fr.close();
                }
                if (data == null) {
                    return null;
                }
                if (data.size() == 0) {
                    return null;
                }
                return data.getFirstEntity();
            }
        }
    }

    public static EntityData mergeTextFromStream(EntityData d, InputStream is) throws IOException {
        InputStreamReader fr = null;
        try {
            fr = new InputStreamReader(is);
            while (true) {
                Entities.readEntity(d, fr);
            }
        }
        catch (EOF eOF) {
            if (fr != null) {
                ((Reader)fr).close();
            }
            Entities.validateConnections(d);
            return d;
        }
    }

    private static void readEntity(EntityData data, Reader r) throws IOException, EOF {
        int ch;
        StringBuffer nameb = new StringBuffer();
        while ((ch = r.read()) != 123 && ch != -1) {
            nameb.append((char)ch);
        }
        if (ch == -1) {
            throw new EOF();
        }
        String name = nameb.toString().trim();
        if (nameb.equals("_SAVED_TIME")) {
            data.saveTime = Entities.readTimeFromStream(r);
            return;
        }
        Entity e = data.findEntityExact(name);
        if (e == null) {
            e = data.addNewEntity(name);
        }
        try {
            while (true) {
                Entities.readSection(e, data, r);
            }
        }
        catch (EOE eOE) {
            return;
        }
    }

    private static long readTimeFromStream(Reader r) throws IOException, EOF {
        int ch;
        StringBuffer d = new StringBuffer();
        while (!Character.isWhitespace((char)(ch = r.read()))) {
            d.append(ch);
        }
        if (ch == -1) {
            throw new EOF();
        }
        return Long.parseLong(d.toString());
    }

    private static void readSection(Entity e, EntityData data, Reader r) throws EOE, IOException {
        int ch;
        StringBuffer nameb = new StringBuffer();
        while ((ch = r.read()) != 123 && ch != 125 && ch != -1) {
            nameb.append((char)ch);
        }
        if (ch == 125) {
            throw new EOE();
        }
        if (ch == -1) {
            throw new EOF();
        }
        String name = nameb.toString().trim();
        if (name.equals("Causes")) {
            Entities.readListTillCloseBracket(e, 4, data, r, true);
        }
        if (name.equals("Effects")) {
            Entities.readListTillCloseBracket(e, 8, data, r, true);
        }
        if (name.equals("Parents")) {
            Entities.readListTillCloseBracket(e, 1, data, r, true);
        }
        if (name.equals("Children")) {
            Entities.readListTillCloseBracket(e, 2, data, r, true);
        }
        if (name.equals("Synonyms")) {
            Entities.readStringListTillCloseBracket(e.synonyms, data, r);
        }
        if (name.equals("Treats")) {
            Entities.readListTillCloseBracket(e, 16, data, r, true);
        }
        if (name.equals("Treatments")) {
            Entities.readListTillCloseBracket(e, 32, data, r, true);
        }
        if (name.equals("Description")) {
            StringBuffer desc = new StringBuffer();
            while ((ch = r.read()) != 125 && ch != -1) {
                desc.append((char)ch);
            }
            if (ch == -1) {
                throw new EOF();
            }
            String d = desc.toString().trim();
            if (d.startsWith("\"")) {
                d = d.substring(1, d.length() - 1);
            }
            Entities.mergeDescriptions(e, d);
        }
    }

    private static void readListTillCloseBracket(Entity from, int relation, EntityData data, Reader r, boolean convertToEntity) throws IOException, EOF {
        int ch;
        StringBuffer s = new StringBuffer();
        while ((ch = r.read()) != 125) {
            if (ch == -1) {
                throw new EOF();
            }
            if (ch == 44) {
                Entities.storeEntity(from, s, relation, data, convertToEntity);
                continue;
            }
            if (ch == 96) {
                ch = 44;
            }
            s.append((char)ch);
        }
        Entities.storeEntity(from, s, relation, data, convertToEntity);
    }

    private static void readStringListTillCloseBracket(Vector v, EntityData d, Reader r) throws IOException, EOF {
        int ch;
        StringBuffer s = new StringBuffer();
        while ((ch = r.read()) != 125) {
            if (ch == -1) {
                throw new EOF();
            }
            if (ch == 44) {
                if (!v.contains(s.toString().intern())) {
                    v.addElement(s.toString().trim());
                }
                s.setLength(0);
                continue;
            }
            if (ch == 96) {
                ch = 44;
            }
            s.append((char)ch);
        }
        if (!v.contains(s.toString().intern())) {
            v.addElement(s.toString().trim());
        }
        s.setLength(0);
    }

    private static void storeEntity(Entity from, StringBuffer s, int relation, EntityData d, boolean convertToEntity) throws IOException {
        String n = s.toString().trim();
        Vector v = from.listOf(relation);
        if (convertToEntity) {
            Entity e;
            double p = Double.NaN;
            if (n.endsWith("%")) {
                int i = n.length() - 2;
                while (!Character.isWhitespace(n.charAt(i))) {
                    --i;
                }
                try {
                    p = Double.parseDouble(n.substring(i + 1, n.length() - 1));
                }
                catch (NumberFormatException e2) {
                    throw new IOException("Illegal percentage in " + from.name + ": " + n);
                }
                n = n.substring(0, i);
            }
            if ((e = d.findEntityExact(n)) == null) {
                e = d.addNewEntity(n);
                v.addElement(e);
            } else if (!v.contains(e)) {
                v.addElement(e);
            }
            if (!Double.isNaN(p)) {
                from.setProbOf(relation, v.indexOf(e), p);
            }
            s.setLength(0);
        } else {
            if (!v.contains(s.toString().intern())) {
                v.addElement(s.toString().trim());
            }
            s.setLength(0);
        }
    }

    private static void mergeDescriptions(Entity e, String d) {
        if (e.description.equals(d)) {
            return;
        }
        if (e.description.startsWith(d)) {
            return;
        }
        if (d.startsWith(e.description)) {
            e.description = d;
            return;
        }
        e.description = String.valueOf(e.description) + '\n' + d;
    }

    public static String getDelimitedNames(Vector v, String delimiter) {
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            Object o = v.get(i);
            String s = o.toString();
            s = s.replace('{', '(').replace('}', ')').replace(',', '`');
            list.append(s.toString());
            if (i < v.size() - 1) {
                list.append(delimiter);
            }
            ++i;
        }
        return list.toString();
    }

    public static String getDelimitedEntities(Entity e, int relation, String delimiter) {
        StringBuffer list = new StringBuffer();
        Vector v = e.listOf(relation);
        double[] p = e.probsOf(relation);
        int i = 0;
        while (i < v.size()) {
            Object o = v.get(i);
            String s = o.toString();
            s = s.replace('{', '(').replace('}', ')').replace(',', '`');
            list.append(s.toString());
            if (p != null && p.length > i && !Double.isNaN(p[i])) {
                list.append(' ');
                list.append(p[i]);
                list.append('%');
            }
            if (i < v.size() - 1) {
                list.append(delimiter);
            }
            ++i;
        }
        return list.toString();
    }

    String readUntil(StreamTokenizer st, String c) throws IOException {
        StringBuffer s = new StringBuffer();
        do {
            int tt;
            if ((tt = st.nextToken()) != -3) continue;
            s.append(st.sval);
        } while (!st.sval.equals(c));
        return s.toString().trim();
    }

    public static int validateConnections(EntityData d) {
        int errors = 0;
        for (Entity e : d.getAllEntities()) {
            int j = 1;
            while (j < Entity.relationList.length) {
                int r = Entity.relationList[j];
                int ri = Entity.inverseOf(r);
                for (Entity f : e.listOf(r)) {
                    if (f.listOf(ri).contains(e)) continue;
                    f.listOf(ri).add(e);
                    ++errors;
                }
                ++j;
            }
        }
        return errors;
    }

    public static Vector getAllCauses(Entity entity, Vector except) {
        if (except != null && except.contains(entity)) {
            return null;
        }
        if (except == null) {
            except = new Vector<Entity>();
        }
        Vector v = new Vector();
        except.add(entity);
        int i = 0;
        while (i < entity.causes.size()) {
            Vector ve;
            Entity e = (Entity)entity.causes.get(i);
            if (!(except != null && except.contains(e) || (ve = Entities.getAllCauses(e, v)) == null)) {
                if (ve.size() > 0) {
                    v.addAll(ve);
                } else {
                    ve.add(e);
                }
            }
            ++i;
        }
        return v;
    }

    public static String getRelationNamesFromBits(int b) {
        String s = "";
        int i = 0;
        while (i < Entity.relationList.length) {
            if ((b & Entity.relationList[i]) > 0) {
                s = String.valueOf(s) + Entity.relationNameList[i];
            }
            ++i;
        }
        if (s.endsWith("s")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.toLowerCase();
    }

    public static Set getExtensiveListOf(int relations, Entity entity, int depth) {
        return Entities.getExtensiveListOf(relations, entity, depth, null);
    }

    public static Set getExtensiveListOf(int relations, Entity entity, int depth, Set except) {
        HashSet<Entity> v = except;
        if (depth < 0) {
            return v;
        }
        if (v == null) {
            v = new HashSet<Entity>();
        }
        if (v.contains(entity)) {
            return v;
        }
        v.add(entity);
        int i = 0;
        while (i < Entity.relationList.length) {
            Vector ve;
            if ((relations & Entity.relationList[i]) > 0 && (ve = entity.listOf(Entity.relationList[i])) != null) {
                int j = 0;
                while (j < ve.size()) {
                    Entity e = (Entity)ve.get(j);
                    Set vf = Entities.getExtensiveListOf(relations, e, depth - 1, v);
                    v.addAll(vf);
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    public static Set getDirectionalListOf(int relations, Entity entity, int depth) {
        Set s = Entities.getDirectionalListOf(relations, entity, depth, null);
        HashSet<Entity> rm = new HashSet<Entity>();
        for (Entity e : s) {
            if (!Entities.isChildOf(e, entity) && !Entities.isChildOf(entity, e) && entity != e) continue;
            rm.add(e);
        }
        s.removeAll(rm);
        return s;
    }

    public static Set getDirectionalListOf(int relations, Entity entity, int depth, Set except) {
        boolean first;
        HashSet<Entity> v = except;
        if (depth < 0) {
            return v;
        }
        boolean bl = first = v == null;
        if (first) {
            v = new HashSet<Entity>();
        }
        if (v.contains(entity)) {
            return v;
        }
        v.add(entity);
        int i = 0;
        while (i < Entity.relationList.length) {
            Vector ve;
            if ((relations & Entity.relationList[i]) > 0 && (ve = entity.listOf(Entity.relationList[i])) != null) {
                int j = 0;
                while (j < ve.size()) {
                    Entity e = (Entity)ve.get(j);
                    int newrelations = relations & ~Entity.inverseOf(Entity.relationList[i]);
                    Set vf = Entities.getDirectionalListOf(newrelations, e, depth - 1, v);
                    v.addAll(vf);
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    public static Vector getCauseHierarchy(Entity entity, Vector complete) {
        if (complete != null && complete.contains(entity)) {
            return null;
        }
        if (complete == null) {
            complete = new Vector<Entity>();
        }
        Vector<Vector> v = new Vector<Vector>();
        complete.add(entity);
        int i = 0;
        while (i < entity.causes.size()) {
            Vector add;
            Entity e = (Entity)entity.causes.get(i);
            if (!(complete != null && complete.contains(e) || (add = Entities.getCauseHierarchy(e, complete)) == null)) {
                v.add(add);
            }
            ++i;
        }
        return v;
    }

    public static int numConnections(Entity e) {
        return e.causes.size() + e.effects.size() + e.parents.size() + e.children.size();
    }

    public static boolean isChildOf(Entity queryItem, Entity parent) {
        return Entities.isChildOfRecursive(queryItem, parent, new Vector());
    }

    public static boolean isChildOfRecursive(Entity queryItem, Entity parent, Vector avoid) {
        if (avoid.contains(queryItem)) {
            return false;
        }
        avoid.add(queryItem);
        Vector p = queryItem.parents;
        if (p.indexOf(parent) >= 0) {
            return true;
        }
        int i = 0;
        while (i < p.size()) {
            Entity nquery = (Entity)p.get(i);
            if (Entities.isChildOfRecursive(nquery, parent, avoid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Entity getSpecificNamedEntity(String name, EntityData data) throws EntityNotFoundException {
        Vector v = data.findEntities(name, false, true);
        if (v.size() == 1) {
            return (Entity)v.get(1);
        }
        throw new EntityNotFoundException("Can't find entity " + name);
    }

    public static Entity getUltimateParents(Entity e) {
        if (e.parents.size() == 0) {
            return null;
        }
        Entity p = (Entity)e.parents.elementAt(0);
        while (p.parents.size() > 0) {
            p = (Entity)p.parents.elementAt(0);
        }
        return p;
    }

    public static Vector<Entity> getChainOfFirstItem(Entity e, int direction) {
        Vector<Entity> v = new Vector<Entity>();
        v.add(e);
        while (!e.listOf(direction).isEmpty()) {
            e = (Entity)e.listOf(direction).get(0);
            v.add(e);
        }
        return v;
    }

    public static boolean isRelatedTo(Entity from, Entity to, int relations, int maxRecursionDepth, Vector excludeItems) {
        if (excludeItems == null) {
            excludeItems = new Vector();
        }
        if (excludeItems.contains(from)) {
            return false;
        }
        if (maxRecursionDepth <= 0) {
            return false;
        }
        if (from == to) {
            return true;
        }
        int i = 0;
        while (i < Entity.relationList.length) {
            if ((relations & Entity.relationList[i]) > 0) {
                Vector v = from.listOf(Entity.relationList[i]);
                int j = 0;
                while (j < v.size()) {
                    Entity e = (Entity)v.get(j);
                    if (e == to) {
                        return true;
                    }
                    Vector<Entity> newExcludeItems = new Vector<Entity>(excludeItems);
                    newExcludeItems.add(from);
                    if (Entities.isRelatedTo(e, to, relations, maxRecursionDepth - 1, newExcludeItems)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static Vector findRelationChains(Entity from, Entity to, int relations, int maxRecursionDepth, Vector excludeItems, Vector currentSolutions, Vector currentChain, int temporarilyAvoidDirections) {
        if (excludeItems == null) {
            excludeItems = new Vector();
        }
        if (currentChain == null) {
            currentChain = new Vector();
        }
        if (currentSolutions == null) {
            currentSolutions = new Vector<Vector>();
        }
        if (excludeItems.contains(from)) {
            return currentSolutions;
        }
        if (maxRecursionDepth <= 0) {
            return currentSolutions;
        }
        currentChain = (Vector)currentChain.clone();
        currentChain.add(from);
        if (from == to) {
            currentSolutions.add(currentChain);
            return currentSolutions;
        }
        int i = 0;
        while (i < Entity.relationList.length) {
            int currentRelation = Entity.relationList[i];
            if ((currentRelation & temporarilyAvoidDirections) <= 0 && (relations & currentRelation) > 0) {
                Vector v = from.listOf(currentRelation);
                int j = 0;
                while (j < v.size()) {
                    Entity e = (Entity)v.get(j);
                    Vector<Entity> newExcludeItems = new Vector<Entity>(excludeItems);
                    newExcludeItems.add(from);
                    Entities.findRelationChains(e, to, relations, maxRecursionDepth - 1, newExcludeItems, currentSolutions, currentChain, Entity.inverseOf(currentRelation));
                    ++j;
                }
            }
            ++i;
        }
        return currentSolutions;
    }

    public static Vector findRelationChainsSorted(Entity from, Entity to, int relations, int maxRecursionDepth, Vector excludeItems, Vector currentSolutions, Vector currentChain, int temporarilyAvoidDirections) {
        Vector solutions = Entities.findRelationChains(from, to, relations, maxRecursionDepth, excludeItems, currentSolutions, currentChain, temporarilyAvoidDirections);
        Comparator sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Vector)o1).size() - ((Vector)o2).size();
            }
        };
        Collections.sort(solutions, sorter);
        return solutions;
    }

    public static String toLowerCase(Entity e) {
        String n = e.name;
        boolean startword = true;
        int j = 0;
        while (j < n.length()) {
            if (startword && j < n.length() - 1 && Character.isUpperCase(n.charAt(j)) && Character.isLowerCase(n.charAt(j + 1))) {
                n = String.valueOf(n.substring(0, j)) + Character.toLowerCase(n.charAt(j)) + n.substring(j + 1);
            }
            startword = Character.isWhitespace(n.charAt(j));
            ++j;
        }
        return n;
    }

    public static String chainText(Vector ch) {
        Entity fr = (Entity)ch.get(0);
        String out = fr.name;
        int i = 1;
        while (i < ch.size()) {
            Entity to = (Entity)ch.get(i);
            boolean found = false;
            int j = 0;
            while (j < Entity.relationList.length) {
                if (fr.listOf(Entity.relationList[j]).contains(to)) {
                    String tmp = i == 1 ? " is a " : ", which is a ";
                    out = Entity.inverseOf(Entity.relationList[j]) != 2 ? String.valueOf(out) + tmp + Entities.getRelationNamesFromBits(Entity.inverseOf(Entity.relationList[j])) + " of " + to.name.toLowerCase() : String.valueOf(out) + tmp + " " + to.name.toLowerCase();
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                throw new IllegalArgumentException("Ill-formed chain, " + ch);
            }
            fr = to;
            ++i;
        }
        return String.valueOf(out) + ".";
    }

    public static String listToText(Vector v) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            Entity e = (Entity)v.get(i);
            String n = Entities.toLowerCase(e);
            sb.append(n);
            if (i == v.size() - 2) {
                sb.append(" and ");
            } else if (i < v.size() - 2) {
                sb.append(", ");
            }
            ++i;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static Hashtable<String, Object> groupedVectors(Collection<Entity> c, int i) {
        Hashtable<String, Vector<Entity>> r = new Hashtable<String, Vector<Entity>>();
        for (Entity e : c) {
            Entity pe = Entities.getUltimateParents(e);
            String pn = pe != null ? pe.name : "Other";
            Vector<Entity> v = (Vector<Entity>)r.get(pn);
            if (v == null) {
                v = new Vector<Entity>();
                r.put(pn, v);
            }
            v.add(e);
        }
        Hashtable modresult = (Hashtable)r.clone();
        for (String k : r.keySet()) {
            Vector l = (Vector)r.get(k);
            if (l.size() <= MAX_LIST_SIZE) continue;
            modresult.put(k, Entities.regroup(l));
        }
        return modresult;
    }

    static Hashtable regroup(Vector<Entity> v) {
        int highestlevel = 0;
        int maxgrp = v.size();
        Vector<Vector<Entity>> hier = new Vector<Vector<Entity>>();
        for (Entity e : v) {
            Vector<Entity> h = Entities.getChainOfFirstItem(e, 1);
            Collections.reverse(h);
            hier.add(h);
        }
        Vector<Entity> uniques = null;
        Vector grpitems = null;
        while (maxgrp > MAX_LIST_SIZE && highestlevel < 4) {
            ++highestlevel;
            uniques = new Vector<Entity>();
            Vector<Integer> grpsize = new Vector<Integer>();
            grpitems = new Vector();
            for (Vector vector : hier) {
                Entity top = (Entity)vector.get(Math.max(0, Math.min(highestlevel, vector.size() - 2)));
                if (!uniques.contains(top)) {
                    uniques.add(top);
                    Vector le = new Vector();
                    grpitems.add(le);
                    le.add(vector.lastElement());
                    grpsize.add(1);
                    continue;
                }
                int ix = uniques.indexOf(top);
                ((Vector)grpitems.get(ix)).add((Entity)vector.lastElement());
                grpsize.set(ix, (Integer)grpsize.get(ix) + 1);
            }
            maxgrp = 0;
            Iterator iterator = grpsize.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (maxgrp >= n) continue;
                maxgrp = n;
            }
        }
        Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
        if (uniques == null) {
            return null;
        }
        int n = 2;
        for (Entity u : uniques) {
            Vector vi = (Vector)grpitems.get(uniques.indexOf(u));
            if (vi.size() >= n) {
                result.put(u.name, vi);
                continue;
            }
            for (Entity ei : vi) {
                result.put(ei.name, ei);
            }
        }
        return result;
    }

    public static class AmbiguityException
    extends RuntimeException {
        public AmbiguityException(String s) {
            super(s);
        }

        public AmbiguityException() {
        }
    }

    public static class DynamicRelationNode
    extends DefaultMutableTreeNode {
        Entity entity;
        int relations;
        boolean loadedChildren = false;

        public DynamicRelationNode(Entity e, int relations) {
            super(e);
            this.entity = e;
            this.relations = relations;
            this.setAllowsChildren(true);
        }

        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        public TreeNode getChildAt(int index) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(index);
        }

        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicRelationNode.createChildren(this, this.entity, this.relations);
        }

        public static void createChildren(DefaultMutableTreeNode n, Entity entity, int relations) {
            boolean viaParent = (relations & 1) > 0;
            boolean viaChild = (relations & 2) > 0;
            int relation = -1;
            if ((relations & 4) > 0) {
                relation = 4;
            } else if ((relations & 8) > 0) {
                relation = 8;
            }
            if (relation == -1) {
                return;
            }
            Vector rels = entity.listOf(relation);
            DynamicRelationNode.fillWithVector(n, rels, relations);
            if (viaParent) {
                Vector p = entity.listOf(1);
                int i = 0;
                while (i < p.size()) {
                    DynamicRelationNode.fillWithVector(n, ((Entity)p.get(i)).listOf(relation), relations);
                    ++i;
                }
            }
            if (viaChild) {
                DynamicRelationNode.fillWithVector(n, entity.listOf(2), relations);
            }
            n.setAllowsChildren(n.getChildCount() > 0);
        }

        protected static void fillWithVector(DefaultMutableTreeNode n, Vector v, int r) {
            if (v == null || n == null) {
                return;
            }
            int i = 0;
            while (i < v.size()) {
                n.add(new DynamicRelationNode((Entity)v.get(i), r));
                ++i;
            }
        }
    }

    static class EOE
    extends IllegalStateException {
        EOE() {
        }
    }

    static class EOF
    extends IllegalStateException {
        EOF() {
        }
    }
}

