/*
 * Decompiled with CFR 0.152.
 */
package medicine;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.RepeatingEntityCrawler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diagnoser
implements Runnable,
ActionListener {
    String[] causativeClasses = new String[]{"Trauma", "Pathology", "Disease", "Drug", "Surgery"};
    String[] effectiveClasses = new String[]{"Sign", "Symptom"};
    Entity[] causativeEntities = new Entity[this.causativeClasses.length];
    Vector obs;
    ActionListener al;
    public Thread thread = new Thread(this);
    Vector<Possibility> poss = new Vector();
    public int differentialSize = 10;
    public int maxRelevantDistance = 10;
    public int maxTraverseCount = 10;
    public double proximityPower = 0.25;
    public boolean allowGenerics = false;
    public boolean allowEffectless = false;
    public boolean allowNonCausative = false;
    public boolean allowChildrenOfDiagnoses = true;
    public int branchMask = 7;
    int ended = 0;
    Hashtable<Entity, Possibility> hashposs = new Hashtable();

    public Diagnoser(Vector observations, EntityData data, ActionListener al) {
        this.obs = observations;
        this.al = al;
        int i = 0;
        while (i < this.causativeClasses.length) {
            this.causativeEntities[i] = data.findEntityExact(this.causativeClasses[i]);
            ++i;
        }
    }

    public void start() {
        this.thread.start();
    }

    public void waitForCompletion() throws InterruptedException {
        this.thread.join();
    }

    public Vector<Entity> getDifferential() {
        Object[] s = new Possibility[this.poss.size()];
        s = this.poss.toArray(s);
        Arrays.sort(s);
        Vector<Entity> best = new Vector<Entity>();
        int j = s.length - 1;
        int i = 0;
        while (i < this.differentialSize && j > 0) {
            Object p = s[j--];
            boolean isCausative = false;
            int k = 0;
            while (k < this.causativeEntities.length) {
                if (Entities.isChildOf(((Possibility)p).entity, this.causativeEntities[k])) {
                    isCausative = true;
                }
                ++k;
            }
            if (!this.allowNonCausative && !isCausative || !this.allowGenerics && ((Possibility)p).entity.children.size() != 0 || !this.allowEffectless && ((Possibility)p).entity.effects.size() <= 0) continue;
            if (!this.allowChildrenOfDiagnoses) {
                boolean itsOK = true;
                int k2 = 0;
                while (k2 < best.size()) {
                    Entity comp = best.get(k2);
                    if (Entities.isChildOf(((Possibility)p).entity, comp)) {
                        itsOK = false;
                    }
                    if (Entities.isChildOf(comp, ((Possibility)p).entity)) {
                        best.set(k2, ((Possibility)p).entity);
                        itsOK = false;
                    }
                    ++k2;
                }
                if (!itsOK) continue;
            }
            best.add(((Possibility)p).entity);
            ++i;
        }
        return best;
    }

    @Override
    public void run() {
        this.ended = 0;
        int i = 0;
        while (i < this.obs.size()) {
            Entity observation = (Entity)this.obs.get(i);
            RepeatingEntityCrawler ec = new RepeatingEntityCrawler(observation, this);
            ec.setBranchMask(this.branchMask);
            ec.setMaxTraverseCount(this.maxTraverseCount);
            ec.MAX_DISTANCE = this.maxRelevantDistance;
            ec.start();
            ++i;
        }
        while (this.ended < this.obs.size()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.al.actionPerformed(new ActionEvent(this, 0, "Finished"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int distance = e.getModifiers();
        Object o = e.getSource();
        if (!(o instanceof Entity)) {
            ++this.ended;
            return;
        }
        Entity f = (Entity)o;
        if (distance > 0) {
            Possibility p = this.findPossibility(f);
            p.score += Math.pow(this.proximityPower, distance);
        }
    }

    Possibility findPossibility(Entity e) {
        Possibility p = this.hashposs.get(e);
        if (p == null) {
            p = new Possibility();
            this.poss.add(p);
            this.hashposs.put(e, p);
            p.entity = e;
            p.score = 0.0;
        }
        return p;
    }

    class Possibility
    implements Comparable {
        Entity entity;
        double score;

        Possibility() {
        }

        public int compareTo(Object o) {
            Possibility p = (Possibility)o;
            double c = this.score - p.score;
            return c < 0.0 ? -1 : (c > 0.0 ? 1 : 0);
        }
    }
}

