/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.fluid;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.fluid.FluidComponent;
import com.neurolab.fluid.FluidPanel;
import java.awt.Graphics;
import java.awt.Point;

public class FluidPipe
extends FluidComponent {
    public int diameter = 16;
    public double level = 1.0;
    public boolean drawstart = false;
    public boolean drawend = false;
    public boolean drawEdges = true;

    public FluidPipe(FluidPanel p, Point p1, Point p2) {
        super(p, p1, p2);
    }

    public void paint(Graphics g_) {
        try {
            Graphics g = g_;
            NeurolabExhibit.setStrokeThickness(g, this.stroke);
            g.setColor(this.linecolor);
            Point a = this.perpendicular(this.p1, this.diameter / 2);
            Point b = this.perpendicular(this.p2, this.diameter / 2);
            if (this.drawEdges) {
                g.drawLine(a.x, a.y, b.x, b.y);
            }
            a = this.perpendicular(this.p1, -this.diameter / 2);
            b = this.perpendicular(this.p2, -this.diameter / 2);
            if (this.drawEdges) {
                g.drawLine(a.x, a.y, b.x, b.y);
            }
            Point corner = this.perpendicularLess(this.p1, this.diameter / 2 - 2);
            g.setColor(this.watercolor);
            g.fillRect(corner.x - (int)(2.0 * Math.abs(this.diry)), corner.y - (int)(2.0 * Math.abs(this.dirx)), (int)((this.magn + 4.0) * Math.abs(this.diry) + (double)(this.diameter - 4) * Math.abs(this.dirx)), (int)((this.magn + 4.0) * Math.abs(this.dirx) + (double)(this.diameter - 4) * Math.abs(this.diry)));
            g.setColor(this.linecolor);
            if (this.drawstart) {
                Point q1 = new Point(this.p1.x - (int)(2.0 * this.diry), this.p1.y + (int)(2.0 * this.dirx));
                a = this.perpendicular(q1, this.diameter / 2);
                b = this.perpendicular(q1, -this.diameter / 2);
                g.drawLine(a.x, a.y, b.x, b.y);
            }
            if (this.drawend) {
                Point q2 = new Point(this.p2.x + (int)(2.0 * this.diry), this.p2.y - (int)(2.0 * this.dirx));
                a = this.perpendicular(q2, this.diameter / 2);
                b = this.perpendicular(q2, -this.diameter / 2);
                g.drawLine(a.x, a.y, b.x, b.y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

