/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.SignalListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SignalGenerator
extends JPanel
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    public JPanel optionPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    public JRadioButton step = new JRadioButton();
    public JRadioButton ramp = new JRadioButton();
    public JRadioButton sinusoidal = new JRadioButton();
    public JPanel sliderPanel = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    public JPanel frequencyPanel = new JPanel();
    public JSlider frequency = new JSlider();
    public JLabel freqLabel = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    public JLabel amplLabel = new JLabel();
    public JSlider amplitude = new JSlider();
    BorderLayout borderLayout2 = new BorderLayout();
    public JRadioButton squareramp = new JRadioButton();
    public ButtonGroup bg = new ButtonGroup();
    final int tickspersecond = 20;
    public Timer timer = new Timer(50, this);
    public JPanel amplitudePanel = new JPanel();
    int t = 0;
    int maxfreq = 2;
    SignalListener listener = null;
    double os;
    double phase = 0.0;
    double oldf = 50.0;
    int nButtons = 4;

    public SignalGenerator() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        double freq = (double)(this.frequency.getValue() * this.maxfreq) / 100.0;
        this.phase += freq / 20.0;
        this.phase -= (double)((int)this.phase);
        double a = this.amplitude.getValue();
        double s = 0.0;
        if (this.sinusoidal.isSelected()) {
            s = a * Math.sin(Math.PI * 2 * this.phase);
        } else if (this.step.isSelected()) {
            s = a * (double)(this.phase < 0.5 ? 1 : -1);
        } else if (this.ramp.isSelected()) {
            s = this.phase < 0.5 ? 4.0 * a * (this.phase - 0.25) : 4.0 * a * (0.75 - this.phase);
        } else if (this.squareramp.isSelected()) {
            s = this.phase < 0.25 ? 8.0 * a * (this.phase - 0.125) : (this.phase < 0.5 ? a : (this.phase < 0.75 ? 8.0 * a * (0.625 - this.phase) : -a));
        }
        this.fireSignalEvent(s);
    }

    public void fireSignalEvent(double s) {
        if (this.listener != null) {
            this.listener.signalEvent(s);
        }
    }

    public void setSignalListener(SignalListener l) {
        this.listener = l;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.optionPanel.setBackground(Color.lightGray);
        this.optionPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(1);
        this.step.setText("Step");
        this.ramp.setText("Ramp");
        this.sinusoidal.setText("Sinusoidal");
        this.sliderPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setColumns(1);
        this.frequencyPanel.setLayout(this.borderLayout3);
        this.freqLabel.setHorizontalAlignment(0);
        this.freqLabel.setText("Frequency");
        this.amplLabel.setHorizontalAlignment(0);
        this.amplLabel.setText("Amplitude");
        this.amplitudePanel.setLayout(this.borderLayout2);
        this.frequency.setMinimum(1);
        this.frequency.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SignalGenerator.this.frequency_stateChanged(e);
            }
        });
        this.squareramp.setText("Square-ramp");
        this.add((Component)this.optionPanel, "Center");
        this.optionPanel.add((Component)this.step, null);
        this.optionPanel.add((Component)this.ramp, null);
        this.optionPanel.add((Component)this.sinusoidal, null);
        this.optionPanel.add((Component)this.squareramp, null);
        this.add((Component)this.sliderPanel, "South");
        this.sliderPanel.add((Component)this.frequencyPanel, null);
        this.frequencyPanel.add((Component)this.frequency, "Center");
        this.frequencyPanel.add((Component)this.freqLabel, "South");
        this.frequencyPanel.setBackground(Color.lightGray);
        this.sliderPanel.add((Component)this.amplitudePanel, null);
        this.sliderPanel.setBackground(Color.lightGray);
        this.amplitudePanel.add((Component)this.amplLabel, "South");
        this.amplitudePanel.add((Component)this.amplitude, "Center");
        this.amplitudePanel.setBackground(Color.lightGray);
        this.step.setBackground(Color.lightGray);
        this.ramp.setBackground(Color.lightGray);
        this.sinusoidal.setBackground(Color.lightGray);
        this.squareramp.setBackground(Color.lightGray);
        this.frequency.setBackground(Color.lightGray);
        this.amplitude.setBackground(Color.lightGray);
        this.bg.add(this.step);
        this.bg.add(this.ramp);
        this.bg.add(this.sinusoidal);
        this.bg.add(this.squareramp);
    }

    void frequency_stateChanged(ChangeEvent e) {
        double oticksperiod = 100.0 / (this.oldf * (double)this.maxfreq) * 20.0;
        this.oldf = this.frequency.getValue();
        double nticksperiod = 100.0 / (this.oldf * (double)this.maxfreq) * 20.0;
        this.t = (int)((double)this.t / oticksperiod * nticksperiod);
    }

    public void addOption(AbstractButton c) {
        this.optionPanel.add(c);
        this.bg.add(c);
        ++this.nButtons;
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(this.nButtons);
    }

    public void removeOption(AbstractButton c) {
        this.optionPanel.remove(c);
        --this.nButtons;
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(this.nButtons);
    }
}

