/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.Timer;

public class MidiImpl {
    MidiDevice md;
    Receiver rec;
    int currnote = -1;
    Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MidiImpl.this.stopNote();
        }
    });

    public MidiImpl() {
        this.timer.setRepeats(false);
        try {
            this.md = MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[0]);
            this.md.open();
            this.rec = this.md.getReceiver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playNote(int note) {
        if (this.rec == null) {
            return;
        }
        if (this.currnote != -1) {
            this.stopNote();
        }
        ShortMessage m = new ShortMessage();
        try {
            m.setMessage(144, 1, note, 127);
            this.rec.send(m, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.timer.start();
    }

    public void stopNote() {
        if (this.currnote != -1) {
            ShortMessage m = new ShortMessage();
            try {
                m.setMessage(128, 1, this.currnote, 0);
                this.rec.send(m, -1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.currnote = -1;
            this.timer.stop();
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.rec != null) {
            this.rec.close();
        }
        if (this.md != null) {
            this.md.close();
        }
    }
}

