/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.PaintableComponent;
import java.awt.Graphics;
import java.awt.Point;

public abstract class LinearComponent
implements PaintableComponent {
    public Point p1;
    public Point p2;
    public double dirx;
    public double diry;
    public double magn;

    public LinearComponent(Point a1, Point a2) {
        this.p1 = a1;
        this.p2 = a2;
        this.calculatePos();
    }

    public void calculatePos() {
        this.dirx = this.p1.y - this.p2.y;
        this.diry = this.p2.x - this.p1.x;
        this.magn = Math.sqrt(this.dirx * this.dirx + this.diry * this.diry);
        this.dirx /= this.magn;
        this.diry /= this.magn;
    }

    public void setPos(Point a, Point b) {
        this.p1 = a;
        this.p2 = b;
        this.calculatePos();
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    public Point perpendicular(Point p, double dist) {
        return new Point((int)((double)p.x + dist * this.dirx), (int)((double)p.y + dist * this.diry));
    }

    public Point perpendicularLess(Point p, double dist) {
        return new Point((int)((double)p.x - Math.abs(dist * this.dirx)), (int)((double)p.y - Math.abs(dist * this.diry)));
    }

    public double getLineAngle() {
        double p = this.p2.y - this.p1.y;
        double q = this.p2.x - this.p1.x;
        double t = Math.atan(p / q);
        if (q < 0.0) {
            t += Math.PI;
        }
        return t;
    }

    public Point pointBetween(Point a, Point b, double frac) {
        return new Point((int)((double)a.x + (double)(b.x - a.x) * frac), (int)((double)a.y + (double)(b.y - a.y) * frac));
    }

    public abstract void paint(Graphics var1);
}

