/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class IonicCell {
    double qk = 13916.0;
    double qn = 227.0;
    double qa = 8683.0;
    double qx = 5500.0;
    public int ki = 146;
    public int ni = 3;
    public int ai = 88;
    public int xi = 57;
    public int ko = 5;
    public int no = 145;
    public int ao = 150;
    public int c = 300;
    double fk = 82.84;
    double fn = 113.62;
    double fa = -30.78;
    double pk = 86.22;
    double pn = -130.64;
    double gk = 6.0;
    double gn = 5.0;
    double ga = 30.0;
    double pmax = 2000.0;
    public double vol = 89.23;
    double mv = -11.0;
    double e = 0.0;
    double zpot = 1.59;
    boolean initflag = false;
    boolean pumping = true;
    int oldno;
    int oldni;
    int oldko;
    int oldki;
    int oldvol;
    double X = 5391.0;
    double Y = 3485.0;
    double z = 130.6;
    public Timer Timer1 = new Timer(150, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            IonicCell.this.Timer1_Timer();
        }
    });
    ActionListener listener;
    public double[] Text1 = new double[13];
    public boolean RBC = true;
    double lqk = this.qk;
    double lqn = this.qn;
    double lqa = this.qa;
    double lqx = this.qx;
    double lrate = 0.4;

    public void Restart() {
        this.setup();
    }

    public IonicCell() {
        this.setup();
        this.initialise();
        this.Timer1.start();
    }

    public void PumpOn(boolean Value) {
        this.pumping = Value;
    }

    public void RBC_Click() {
        this.RBC = true;
        this.setup();
    }

    public void Squid_Click() {
        this.RBC = false;
        this.setup();
    }

    public void spinChange(int i) {
        this.qk = (double)this.ki * this.vol;
        this.qn = (double)this.ni * this.vol;
        this.qa = (double)this.ai * this.vol;
        this.updateout();
        this.updateperm();
    }

    public void fire(String s) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 1001, s));
        }
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void Burst() {
        this.fire("Burst");
        this.Timer1.stop();
    }

    public void CellDraw() {
        if (this.oldno != this.no || this.oldko != this.ko) {
            this.fire("RedrawCell");
        }
        if (this.oldni != this.no || this.oldki != this.ki || (double)this.oldvol != this.vol) {
            this.fire("RedrawCell");
        }
    }

    public void Concs() {
        this.lqk = (1.0 - this.lrate) * this.lqk + this.lrate * this.qk;
        this.lqn = (1.0 - this.lrate) * this.lqn + this.lrate * this.qn;
        this.lqa = (1.0 - this.lrate) * this.lqa + this.lrate * this.qa;
        this.lqx = (1.0 - this.lrate) * this.lqx + this.lrate * this.qx;
        this.ki = (int)(this.lqk / this.vol);
        this.ni = (int)(this.lqn / this.vol);
        this.ai = (int)(this.lqa / this.vol);
        this.xi = (int)(this.lqx / this.vol);
    }

    public void Fluxes() {
        this.fk = 0.1 * this.gk * ((double)this.ko * this.zpot - (double)this.ki);
        this.fn = 0.1 * this.gn * ((double)this.no * this.zpot - (double)this.ni);
        this.fa = 0.1 * this.ga * ((double)this.ai * this.zpot - (double)this.ao);
    }

    public void GCFE() {
        this.Y = this.gn * (double)this.no + this.gk * (double)this.ko + this.ga * (double)this.ai;
        this.X = this.gn * (double)this.ni + this.gk * (double)this.ki + this.ga * (double)this.ao;
        this.zpot = this.Y > 0.0 ? this.X / this.Y : 1000.0 * this.X;
        if (this.zpot != 0.0) {
            this.mv = -25.0 * Math.log(this.zpot);
        }
    }

    public void initialise() {
        if (this.RBC) {
            this.xi = 55;
            this.ki = 140;
            this.ni = 10;
            this.ai = 95;
            this.mv = -60.0;
        } else {
            this.xi = 145;
            this.ki = 140;
            this.ni = 10;
            this.ai = 5;
            this.mv = -70.0;
        }
        this.vol = 100.0;
        this.pmax = 2000.0;
        this.qk = (double)this.ki * this.vol;
        this.qn = (double)this.ni * this.vol;
        this.qa = (double)this.ai * this.vol;
        this.qx = (double)this.xi * this.vol;
        this.updateperm();
        this.updateout();
        this.Shower();
        this.Timer1.start();
    }

    public void iterate() {
        this.Pump();
        this.GCFE();
        this.Fluxes();
        this.Quants();
        this.Volume();
        this.Concs();
    }

    public void Pump() {
        if (this.pumping) {
            this.Y = 42.0 * (double)this.ni / (double)(42 * this.ni + 8 + this.ki);
            this.z = 180.0 * (double)this.ko / (double)(180 * this.ko + 18 + this.no);
        } else {
            this.Y = 0.0;
        }
        this.z = this.Y * this.Y * this.Y * this.z * this.z * this.pmax;
        this.pn = -this.z;
        this.pk = 0.66 * this.z;
    }

    public void Quants() {
        this.qk = this.fk + this.pk + this.qk;
        this.qn = this.fn + this.pn + this.qn;
        this.qa = this.qk + this.qn - this.qx;
        if (this.qk <= this.vol) {
            this.qk = this.vol;
        }
        if (this.qn <= this.vol) {
            this.qn = this.vol;
        }
        if (this.qa <= this.vol) {
            this.qa = this.vol;
        }
    }

    public void setup() {
        if (this.RBC) {
            this.Text1[2] = 6.0;
            this.Text1[5] = 5.0;
            this.Text1[8] = 30.0;
            this.Text1[1] = 5.0;
            this.Text1[4] = 145.0;
            this.Text1[7] = 150.0;
        } else {
            this.Text1[2] = 30.0;
            this.Text1[5] = 2.0;
            this.Text1[8] = 40.0;
            this.Text1[1] = 5.0;
            this.Text1[4] = 145.0;
            this.Text1[7] = 150.0;
        }
        this.initialise();
        this.fire("AllTextChange");
    }

    public void Shower() {
        this.fire("BarChange");
        this.Text1[11] = this.ki;
        this.Text1[10] = this.ni;
        this.Text1[9] = this.ai;
        this.Text1[12] = this.mv;
        this.fire("TextChange");
        if (this.vol > 130.0) {
            this.Burst();
        } else {
            this.CellDraw();
        }
    }

    public void Timer1_Timer() {
        if (!this.initflag) {
            this.setup();
            this.initflag = true;
        } else {
            this.iterate();
            this.Shower();
        }
    }

    public void updateout() {
        this.ko = (int)this.Text1[1];
        this.no = (int)this.Text1[4];
        this.ao = (int)this.Text1[7];
        this.c = this.ko + this.no + this.ao;
    }

    public void updateperm() {
        this.gk = this.Text1[2];
        this.gn = this.Text1[5];
        this.ga = this.Text1[8];
    }

    public void Volume() {
        this.vol = 0.5 * (this.vol + (this.lqk + this.lqn + this.lqa + this.lqx) / (double)this.c);
    }

    public double Val(String s) {
        return Double.valueOf(s);
    }
}

