/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.NeurolabGuiComponent;
import java.awt.Graphics;
import javax.swing.JComponent;

public class GraphicComponent
extends JComponent
implements NeurolabGuiComponent {
    public static final int TYPE_LINE = 0;
    public static final int TYPE_BOX = 1;
    public static final int TYPE_HORZLINE = 2;
    public static final int TYPE_VERTLINE = 3;
    public static final int TYPE_ELLIPSE = 4;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_FORWARDS = 1;
    public static final int ARROW_BACKWARDS = 2;
    private int type = 0;
    private int thickness = 5;
    private boolean direction = false;
    private int arrow = 0;
    private int arrowlen = 4;

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int t) {
        this.thickness = t;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setDirection(boolean d) {
        this.direction = d;
    }

    public void setArrow(int a) {
        this.arrow = a;
    }

    public int getArrow() {
        return this.arrow;
    }

    public GraphicComponent() {
        NeurolabExhibit.setBG(this);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getForeground());
        NeurolabExhibit.antiAlias(g);
        NeurolabExhibit.setStrokeThickness(g, this.thickness);
        switch (this.type) {
            case 0: {
                if (this.direction) {
                    g.drawLine(0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                g.drawLine(this.getWidth(), 0, 0, this.getHeight());
                break;
            }
            case 1: {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                break;
            }
            case 2: {
                g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                if (this.arrow == 1) {
                    g.drawLine(this.getWidth(), this.getHeight() / 2, this.getWidth() - this.arrowlen, this.getHeight() / 2 - this.arrowlen);
                    g.drawLine(this.getWidth(), this.getHeight() / 2, this.getWidth() - this.arrowlen, this.getHeight() / 2 + this.arrowlen);
                    break;
                }
                if (this.arrow != 2) break;
                g.drawLine(0, this.getHeight() / 2, this.arrowlen, this.getHeight() / 2 - this.arrowlen);
                g.drawLine(0, this.getHeight() / 2, this.arrowlen, this.getHeight() / 2 + this.arrowlen);
                break;
            }
            case 3: {
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
                if (this.arrow == 1) {
                    g.drawLine(this.getWidth() / 2, this.getHeight(), this.getWidth() / 2 - this.arrowlen, this.getHeight() - this.arrowlen);
                    g.drawLine(this.getWidth() / 2, this.getHeight(), this.getWidth() / 2 + this.arrowlen, this.getHeight() - this.arrowlen);
                    break;
                }
                if (this.arrow != 2) break;
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2 - this.arrowlen, this.arrowlen);
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2 + this.arrowlen, this.arrowlen);
                break;
            }
            case 4: {
                g.fillOval(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

