/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.HeldExhibit;
import com.neurolab.common.HoldsExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class ExhibitFrame
extends JFrame
implements HoldsExhibit {
    HeldExhibit content;
    String initialExhibit;
    static String[] params;

    public static void main(String[] p) {
        params = p;
        new ExhibitFrame();
    }

    public ExhibitFrame() {
        String[] preferredOrder = new String[]{"Nimbus", "Windows Classic", "Windows"};
        String plaf = UIManager.getSystemLookAndFeelClassName();
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        int selected = -1;
        int i = 0;
        while (i < preferredOrder.length) {
            int j = 0;
            while (j < lnfs.length) {
                if (lnfs[j].getName().equalsIgnoreCase(preferredOrder[i])) {
                    selected = j;
                    break;
                }
                ++j;
            }
            if (selected >= 0) break;
            ++i;
        }
        if (selected >= 0) {
            plaf = lnfs[selected].getClassName();
        }
        try {
            UIManager.setLookAndFeel(plaf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((Component)this).setSize(620, 440);
        this.getContentPane().setLayout(new BorderLayout());
        String exhname = null;
        if (params != null && params.length > 0) {
            exhname = params[0];
        }
        if (exhname == null) {
            exhname = "ExhibitChooser";
            ReturnButton.createOperational = true;
        }
        try {
            Class<?> newclass = Class.forName("com.neurolab." + exhname);
            this.content = (HeldExhibit)newclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.content.setHolder(this);
        this.getContentPane().add((Component)((Object)this.content));
        this.content.init();
        this.initialExhibit = exhname;
        this.setTitle("Neurolab");
        try {
            this.setDefaultCloseOperation(3);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.validateTree();
        this.show();
    }

    public void setExhibit(String ename) {
        HeldExhibit newex;
        ReturnButton.createOperational = !ename.endsWith(this.initialExhibit);
        try {
            Class<?> nclass = Class.forName(ename);
            newex = (HeldExhibit)nclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.getContentPane().remove((Component)((Object)this.content));
        this.content = newex;
        System.gc();
        this.content.setHolder(this);
        this.getContentPane().add((Component)((Object)this.content));
        this.content.init();
        this.validateTree();
    }

    public URL getURL(String filename) {
        URL url = null;
        try {
            url = this.getClass().getResource(String.valueOf('/') + filename);
        }
        catch (Exception e) {
            System.out.println("Couldn't create image: badly specified URL " + filename);
            return null;
        }
        return url;
    }

    public Image getImage(URL url) {
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public Image getImage(URL url, String s) {
        try {
            return Toolkit.getDefaultToolkit().createImage(new URL(url, s));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Image getImage(String s) {
        if (s.startsWith("resources")) {
            s = "/" + s;
        }
        return this.getImage(this.getClass().getResource(s));
    }
}

