/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.HeldExhibit;
import com.neurolab.common.HoldsExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.UIManager;

public class ExhibitContainer
extends JApplet
implements HoldsExhibit {
    HeldExhibit content;
    String initialExhibit;
    URL codeBase = null;

    public void init() {
        String[] preferredOrder = new String[]{"Nimbus", "Windows Classic", "Windows"};
        String plaf = UIManager.getCrossPlatformLookAndFeelClassName();
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        int selected = -1;
        int i = 0;
        while (i < preferredOrder.length) {
            int j = 0;
            while (j < lnfs.length) {
                if (lnfs[j].getName().equalsIgnoreCase(preferredOrder[i])) {
                    selected = j;
                    break;
                }
                ++j;
            }
            if (selected >= 0) break;
            ++i;
        }
        if (selected >= 0) {
            plaf = lnfs[selected].getClassName();
        }
        try {
            UIManager.setLookAndFeel(plaf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.init();
        String exhname = this.getParameter("Exhibit");
        if (exhname == null) {
            exhname = "ExhibitChooser";
            ReturnButton.createOperational = true;
        }
        try {
            Class<?> newclass = Class.forName("com.neurolab." + exhname);
            this.content = (HeldExhibit)newclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.content.setHolder(this);
        this.getContentPane().add((Component)((Object)this.content), "Center");
        this.content.init();
        this.initialExhibit = exhname;
    }

    public void start() {
        super.start();
        this.validateTree();
    }

    public void setExhibit(String ename) {
        HeldExhibit newex;
        ReturnButton.createOperational = !ename.endsWith(this.initialExhibit);
        try {
            Class<?> nclass = Class.forName(ename);
            newex = (HeldExhibit)nclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.content.close();
        this.getContentPane().remove((Component)((Object)this.content));
        this.content = newex;
        System.gc();
        this.content.setHolder(this);
        this.getContentPane().add((Component)((Object)this.content));
        this.content.init();
        this.validateTree();
    }

    public URL getURL(String filename) {
        URL url = null;
        if (this.codeBase == null) {
            this.codeBase = this.getCodeBase();
        }
        try {
            url = new URL(this.codeBase, filename);
        }
        catch (MalformedURLException e) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return url;
    }

    public Image getImage(String s) {
        if (!s.startsWith("/")) {
            s = String.valueOf('/') + s;
        }
        InputStream is = this.getClass().getResourceAsStream(s);
        return Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(s));
    }
}

