/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;

public class CustomSound16 {
    private byte[] pBuffer;
    private int length;
    private Clip clp;
    private Mixer mix = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
    private boolean silent = false;
    int loops = 1;

    public CustomSound16(double[] p) {
        this.open(p);
    }

    public void open(double[] p) {
        this.pBuffer = new byte[this.loops * p.length * 2];
        int i = 0;
        while (i < p.length) {
            int x = (int)(Math.max(-1.0, Math.min(1.0, p[i])) * 32767.0);
            byte lo = (byte)(x & 0xFF);
            byte hi = (byte)(x >> 8 & 0xFF);
            int j = 0;
            while (j < this.loops) {
                this.pBuffer[j * p.length * 2 + i * 2] = lo;
                this.pBuffer[j * p.length * 2 + i * 2 + 1] = hi;
                ++j;
            }
            ++i;
        }
        this.reopen();
    }

    void reopen() {
        this.length = this.pBuffer.length;
        try {
            if (this.clp == null || !this.clp.isOpen()) {
                this.clp = (Clip)this.mix.getLine(this.mix.getSourceLineInfo(new Line.Info(Class.forName("javax.sound.sampled.Clip")))[0]);
            }
            AudioFormat af = new AudioFormat(44100.0f, 16, 1, true, false);
            if (this.clp.isOpen()) {
                this.clp.close();
            }
            this.clp.open(af, this.pBuffer, 0, this.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.silent = true;
        }
    }

    public void close() {
        if (this.clp != null) {
            if (this.isActive()) {
                this.stop();
            }
            if (this.clp.isOpen()) {
                this.clp.close();
            }
        }
    }

    public void start() {
        if (!this.silent) {
            this.clp.loop(-1);
        }
    }

    public void playOnce() {
        if (this.clp.isActive()) {
            this.clp.stop();
        }
        if (!this.clp.isOpen()) {
            this.reopen();
        }
        if (!this.silent) {
            this.clp.loop(1);
        }
    }

    public void stop() {
        if (!this.silent) {
            this.clp.stop();
            this.clp.setFramePosition(0);
        }
    }

    public boolean isActive() {
        if (!this.silent) {
            return this.clp.isActive();
        }
        return false;
    }

    public void finalize() throws Throwable {
        if (!this.silent) {
            this.clp.close();
        }
        this.mix.close();
        super.finalize();
    }
}

