/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import java.lang.reflect.Array;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;

public class CustomSound {
    private byte[] pBuffer;
    private int length;
    private Clip clp;
    private Mixer mix = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
    private boolean silent = false;
    int loops = 1;

    public CustomSound(byte[] p) {
        this.open(p);
    }

    public void open(byte[] p) {
        this.pBuffer = new byte[this.loops * p.length];
        int i = 0;
        while (i < p.length) {
            byte value = p[i];
            int j = 0;
            while (j < this.loops) {
                this.pBuffer[j * p.length + i] = value;
                ++j;
            }
            ++i;
        }
        this.reopen();
    }

    void reopen() {
        this.length = Array.getLength(this.pBuffer);
        try {
            if (this.clp == null || !this.clp.isOpen()) {
                this.clp = (Clip)this.mix.getLine(this.mix.getSourceLineInfo(new Line.Info(Class.forName("javax.sound.sampled.Clip")))[0]);
            }
            AudioFormat af = new AudioFormat(44100.0f, 8, 1, false, false);
            if (this.clp.isOpen()) {
                this.clp.close();
            }
            this.clp.open(af, this.pBuffer, 0, this.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.silent = true;
        }
    }

    public void close() {
        if (this.clp != null) {
            if (this.isActive()) {
                this.stop();
            }
            if (this.clp.isOpen()) {
                this.clp.close();
            }
        }
    }

    public void start() {
        if (!this.silent) {
            this.clp.loop(-1);
        }
    }

    public void playOnce() {
        if (this.clp.isActive()) {
            this.clp.stop();
        }
        if (!this.clp.isOpen()) {
            this.reopen();
        }
        if (!this.silent) {
            this.clp.loop(1);
        }
    }

    public void stop() {
        if (!this.silent) {
            this.clp.stop();
            this.clp.setFramePosition(0);
        }
    }

    public boolean isActive() {
        if (!this.silent) {
            return this.clp.isActive();
        }
        return false;
    }

    public void finalize() throws Throwable {
        if (!this.silent) {
            this.clp.close();
        }
        this.mix.close();
        super.finalize();
    }
}

