/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.NeurolabExhibit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class AngleControl
extends JPanel {
    int value = 0;
    boolean directional;
    double f = 0.3;
    String prefix = "Angle=";
    protected int zero = 0;
    protected int maximum = 359;
    protected int minimum = 0;
    int oldx = 0;
    int oldy = 0;
    public boolean mouseHorizontalMode = false;

    public int getValue() {
        return this.value;
    }

    /*
     * Unable to fully structure code
     */
    public void setValue(int v) {
        block3: {
            block2: {
                if (this.maximum - this.minimum >= 359) ** GOTO lbl10
                if (v <= this.maximum) break block2;
                v = this.maximum;
                break block3;
            }
            if (v >= this.minimum) break block3;
            v = this.minimum;
            break block3;
lbl-1000:
            // 1 sources

            {
                v += 360;
lbl10:
                // 2 sources

                ** while (v < this.minimum)
            }
lbl11:
            // 2 sources

            while (v > this.maximum) {
                v -= 360;
            }
        }
        this.value = v;
        this.repaint();
    }

    public void setDirectional(boolean d) {
        this.directional = d;
    }

    public boolean getDirectional() {
        return this.directional;
    }

    public void setArrowSize(double a) {
        this.f = a;
    }

    public double getArrowSize() {
        return this.f;
    }

    public void setPrefix(String s) {
        this.prefix = s;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getZero() {
        return this.zero;
    }

    public void setZero(int z) {
        this.zero = z;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int m) {
        this.maximum = m;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int m) {
        this.minimum = m;
    }

    public AngleControl() {
        this.setBackground(NeurolabExhibit.systemGray);
        MouseInputAdapter m = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                AngleControl.this.oldx = e.getX();
                AngleControl.this.oldy = e.getY();
            }

            public void mouseDragged(MouseEvent e) {
                if (AngleControl.this.oldx != e.getX() || AngleControl.this.oldy != e.getY()) {
                    if (AngleControl.this.mouseHorizontalMode) {
                        AngleControl.this.setValue(AngleControl.this.value + e.getX() - AngleControl.this.oldx);
                    } else {
                        int cx = AngleControl.this.getWidth() / 2;
                        int cy = AngleControl.this.getHeight() / 2;
                        int x1 = AngleControl.this.oldx - cx;
                        int y1 = AngleControl.this.oldy - cy;
                        int x2 = e.getX() - cx;
                        int y2 = e.getY() - cy;
                        double dt = Math.acos((double)(x1 * x2 + y1 * y2) / Math.sqrt(x1 * x1 + y1 * y1) / Math.sqrt(x2 * x2 + y2 * y2));
                        int sign = (x2 - x1) * y1 - (y2 - y1) * x1;
                        if (sign != 0) {
                            sign = -sign / Math.abs(sign);
                        }
                        AngleControl.this.setValue(AngleControl.this.value + sign * (int)(180.0 * dt / Math.PI));
                    }
                    AngleControl.this.oldx = e.getX();
                    AngleControl.this.oldy = e.getY();
                }
            }
        };
        this.addMouseMotionListener(m);
        this.addMouseListener(m);
    }

    public void paint(Graphics g) {
        super.paint(g);
        NeurolabExhibit.antiAlias(g);
        int w = this.getWidth() - 4;
        g.setColor(SystemColor.controlLtHighlight);
        g.drawOval(0, 0, w, w);
        g.setColor(SystemColor.controlDkShadow);
        g.drawOval(2, 2, w, w);
        g.setColor(Color.lightGray);
        g.fillOval(1, 1, w, w);
        g.setColor(SystemColor.controlLtHighlight);
        g.fillOval(4, 4, w -= 10, w);
        g.setColor(SystemColor.controlShadow);
        g.fillOval(8, 8, w, w);
        this.redrawArrow(g);
    }

    public void redrawArrow(Graphics g) {
        NeurolabExhibit.antiAlias(g);
        int w = this.getWidth() - 14;
        g.setColor(Color.lightGray);
        g.fillOval(6, 6, w, w);
        g.setColor(SystemColor.controlShadow);
        g.drawOval(6, 6, w, w);
        int in = 7;
        int dx = (int)((double)(--w / 2) * Math.sin((double)(this.zero + this.value) * Math.PI / 180.0));
        int dy = (int)((double)(-w / 2) * Math.cos((double)(this.zero + this.value) * Math.PI / 180.0));
        Polygon arrow = new Polygon();
        arrow.addPoint(in + w / 2 + dx, in + w / 2 + dy);
        arrow.addPoint(in + w / 2 + dx - (int)(this.f * (double)(dx + dy)), in + w / 2 + dy - (int)(this.f * (double)(dy - dx)));
        arrow.addPoint(in + w / 2 + dx - (int)(this.f * (double)(dx - dy)), in + w / 2 + dy - (int)(this.f * (double)(dy + dx)));
        NeurolabExhibit.setStrokeThickness(g, 3.0f);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(in + w / 2 + dx, in + w / 2 + dy, in + w / 2 - dx, in + w / 2 - dy);
        if (this.directional) {
            g.fillPolygon(arrow);
        }
        g.setColor(SystemColor.controlShadow);
        g.drawLine(in + w / 2 + dx - 1, in + w / 2 + dy - 1, in + w / 2 - dx - 1, in + w / 2 - dy - 1);
        arrow.translate(-1, -1);
        if (this.directional) {
            g.fillPolygon(arrow);
        }
        g.setColor(this.getBackground());
        g.fillRect(0, this.getWidth() + 1, this.getWidth(), this.getHeight() - this.getWidth());
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        String text = String.valueOf(this.prefix) + String.valueOf(this.value);
        g.drawString(text, 0, this.getHeight() - 10);
    }
}

