/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab.common;

import com.neurolab.common.CustomSound16;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.Timer;

public class ActionPotentials
implements ActionListener {
    private CustomSound16 apsound;
    public Timer timer = new Timer(1000, this);
    private static byte[] buffer;
    private Random rand;
    private int newdelay;
    double frequency;
    long mstimer;
    int VAR = 50;

    static {
        byte[] byArray = new byte[8];
        byArray[2] = 127;
        byArray[3] = 127;
        byArray[4] = 127;
        byArray[5] = 127;
        byArray[6] = 127;
        byArray[7] = 127;
        buffer = byArray;
    }

    public ActionPotentials() {
        this.timer.setInitialDelay(0);
        this.timer.stop();
        double[] buf = new double[]{0.0, 1.0, 0.0};
        this.apsound = new CustomSound16(buf);
        this.apsound.loops = 1;
        this.apsound.open(buf);
        this.rand = new Random();
    }

    public void setRate(double newfreq) {
        this.frequency = newfreq;
        if (newfreq <= 0.0) {
            this.timer.stop();
        } else {
            this.newdelay = (int)(1000.0 / newfreq);
            if (this.newdelay > 10000 || this.newdelay < 0) {
                this.timer.stop();
                return;
            }
            this.timer.setDelay(this.newdelay);
            if (System.currentTimeMillis() - this.mstimer > (long)this.newdelay) {
                this.timer.setDelay(1);
                this.timer.restart();
            } else {
                this.timer.start();
            }
        }
    }

    public void doSingleAP() {
        if (!this.apsound.isActive()) {
            this.apsound.playOnce();
        }
    }

    public double getRate() {
        int delay = this.timer.getDelay();
        if (delay != 0) {
            return 1000.0 / (double)delay;
        }
        return 1000.0;
    }

    public void actionPerformed(ActionEvent e) {
        long ct = System.currentTimeMillis();
        long dt = ct - this.mstimer;
        this.mstimer = ct;
        if (this.frequency > 0.0) {
            this.doSingleAP();
        }
        int ndel = Math.max(1, this.newdelay + this.rand.nextInt() % this.VAR - this.VAR / 2);
        this.timer.setDelay(ndel);
    }
}

