/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.FullScreenExhibit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WaterfallIllusion
extends FullScreenExhibit {
    int phase = 0;
    int nsquares = 20;
    int speed = 10;
    JPanel mainpanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (!WaterfallIllusion.this.testing) {
                int maxr = Math.min(this.getHeight(), this.getWidth());
                int thick = maxr / WaterfallIllusion.this.nsquares;
                int a = 0;
                int i = -2;
                while (i < WaterfallIllusion.this.nsquares) {
                    boolean col = Math.abs(i + 100) % 2 > 0;
                    g.setColor(col ? this.getForeground() : this.getBackground());
                    a = i * thick + WaterfallIllusion.this.phase % (2 * thick);
                    if (maxr > 2 * a) {
                        g.fillRect(a, a, maxr - 2 * a, maxr - 2 * a);
                    }
                    ++i;
                }
            } else {
                g.setColor(Color.black);
                int z = 0;
                while (z < 800) {
                    g.fillRect((int)((double)this.getWidth() * Math.random()), (int)((double)this.getHeight() * Math.random()), 10, 10);
                    ++z;
                }
            }
        }
    };
    JPanel controls = new JPanel();
    JSlider slider = new JSlider();
    JToggleButton testbutton = new JToggleButton("Test");
    boolean reverse = false;
    Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            WaterfallIllusion.this.phase += WaterfallIllusion.this.speed;
            WaterfallIllusion.this.mainpanel.repaint();
        }
    });
    boolean testing = false;

    public String getExhibitName() {
        return "Waterfall illusion";
    }

    public void init() {
        super.init();
        this.parentExhibit = "com.neurolab.Adaptation";
        this.mainpanel.setForeground(Color.black);
        this.mainpanel.setBackground(Color.white);
        this.controls.add(this.testbutton);
        this.testbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WaterfallIllusion.this.testbutton.isSelected()) {
                    WaterfallIllusion.this.test();
                } else {
                    WaterfallIllusion.this.adapt();
                }
            }
        });
        this.controls.add(new JLabel("Speed"));
        this.controls.add(this.slider);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WaterfallIllusion.this.speed = WaterfallIllusion.this.slider.getValue() / 5;
            }
        });
        this.slider.setValue(10);
        ((Component)this.frame).setSize(400, 450);
        this.frame.getContentPane().add((Component)this.mainpanel, "Center");
        this.frame.getContentPane().add((Component)this.controls, "South");
        this.timer.start();
        this.frame.validate();
    }

    public void doClose() {
        super.doClose();
        this.timer.stop();
    }

    void test() {
        this.timer.stop();
        this.testing = true;
        this.mainpanel.repaint();
    }

    void adapt() {
        this.testing = false;
        this.timer.start();
    }

    public void close() {
        this.timer.stop();
    }
}

