/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.CustomSound16;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class Vowels
extends NeurolabExhibit {
    private String[] names = new String[]{"Larynx alone", "EE (beat) ", "I (bit)", "AY (bait)", "E (bet)", "A (bat)", "ER (Bert)", "U (but) ", "AH (Bart)", "O (bot)", "AW (bought)", "OH (boat)", "OO (boot)"};
    private String[] mnames = new String[]{"Larynx.GIF", "EE.GIF", "I.GIF", "AY.GIF", "E.GIF", "A.GIF", "ER.GIF", "U.GIF", "AH.GIF", "O.GIF", "AW.GIF", "OH.GIF", "OO.GIF"};
    public static float[][] formant = new float[][]{{0.0f, 0.0f}, {300.0f, 2600.0f}, {400.0f, 2400.0f}, {500.0f, 2200.0f}, {600.0f, 2000.0f}, {700.0f, 1800.0f}, {600.0f, 1600.0f}, {800.0f, 1400.0f}, {800.0f, 1200.0f}, {700.0f, 1100.0f}, {600.0f, 1000.0f}, {500.0f, 900.0f}, {400.0f, 800.0f}};
    public JPanel freqPanel;
    public JPanel typePanel;
    public JPanel buttonPanel;
    public GraphPanel graphArea;
    public PicturePanel mouthArea;
    public Spacer spacer1;
    public Spacer spacer2;
    public Spacer spacer3;
    public Spacer spacer4;
    public Spacer spacer5;
    public Spacer spacer6;
    public Spacer spacer7;
    TitledBorder titBord1;
    TitledBorder titBord2;
    private JRadioButton[] choices;
    private JRadioButton freq;
    private JRadioButton spect;
    private JRadioButton high;
    private JRadioButton med;
    private JRadioButton low;
    private ButtonGroup vowelgroup;
    private ButtonGroup typegroup;
    private ButtonGroup freqgroup;
    private GridBagLayout chkbxLayout;
    private GridBagLayout mainLayout;
    private GridBagConstraints chkbxGbConstraints;
    private GridBagConstraints mainGbConstraints;
    private int currentvowel = 0;
    private int currentfreq = 1;
    public Image[] throatimage;
    private double[] buffer;
    CustomSound16 sound;
    public JButton listen;
    private int oldvowel = 13;
    private int oldfreq = 0;

    public String getExhibitName() {
        return "Vowels";
    }

    public void init() {
        super.init();
        this.throatimage = new Image[13];
        int i = 0;
        while (i < 13) {
            this.throatimage[i] = this.getImage("resources/vowels/" + this.mnames[i]);
            ++i;
        }
        this.buffer = new double[44100];
        this.sound = new CustomSound16(this.buffer);
        this.createComponents();
    }

    public void createComponents() {
        this.graphArea = new GraphPanel();
        this.graphArea.setBackground(NeurolabExhibit.systemGray);
        this.graphArea.setBorder(NeurolabExhibit.loweredbevel);
        this.choices = new JRadioButton[this.names.length];
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(NeurolabExhibit.systemGray);
        this.buttonPanel.setBorder(NeurolabExhibit.etched);
        this.chkbxLayout = new GridBagLayout();
        this.buttonPanel.setLayout(this.chkbxLayout);
        this.chkbxGbConstraints = new GridBagConstraints();
        this.chkbxGbConstraints.fill = 2;
        ButtonHandler handler = new ButtonHandler();
        this.vowelgroup = new ButtonGroup();
        int i = 0;
        while (i < this.choices.length) {
            this.choices[i] = new JRadioButton(this.names[i], i == 0);
            this.choices[i].setBackground(NeurolabExhibit.systemGray);
            this.addchkboxComponent(this.choices[i], i < 7 ? i : i % 7 + 1, (i - 1) / 6, i == 0 ? 2 : 1, 1);
            this.choices[i].addItemListener(handler);
            this.vowelgroup.add(this.choices[i]);
            ++i;
        }
        this.freq = new JRadioButton("Waveform", false);
        this.spect = new JRadioButton("Spectrum", true);
        this.freq.setBackground(NeurolabExhibit.systemGray);
        this.spect.setBackground(NeurolabExhibit.systemGray);
        this.typegroup = new ButtonGroup();
        this.typegroup.add(this.freq);
        this.typegroup.add(this.spect);
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridLayout(2, 1));
        this.typePanel.add((Component)this.spect, "West");
        this.typePanel.add((Component)this.freq, "West");
        this.typePanel.setBackground(NeurolabExhibit.systemGray);
        this.titBord1 = BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Showing");
        this.typePanel.setBorder(this.titBord1);
        this.freq.addItemListener(handler);
        this.spect.addItemListener(handler);
        this.high = new JRadioButton("High", false);
        this.high.setBackground(NeurolabExhibit.systemGray);
        this.med = new JRadioButton("Medium", false);
        this.med.setBackground(NeurolabExhibit.systemGray);
        this.low = new JRadioButton("Low", true);
        this.low.setBackground(NeurolabExhibit.systemGray);
        this.freqgroup = new ButtonGroup();
        this.freqgroup.add(this.high);
        this.freqgroup.add(this.med);
        this.freqgroup.add(this.low);
        this.freqPanel = new JPanel();
        GridLayout glfreq = new GridLayout(3, 1);
        this.freqPanel.setLayout(glfreq);
        glfreq.setHgap(10);
        this.freqPanel.add((Component)this.high, "West");
        this.freqPanel.add((Component)this.med, "West");
        this.freqPanel.add((Component)this.low, "West");
        this.freqPanel.setBackground(NeurolabExhibit.systemGray);
        this.titBord2 = BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Frequency");
        this.freqPanel.setBorder(this.titBord2);
        this.high.addItemListener(handler);
        this.med.addItemListener(handler);
        this.low.addItemListener(handler);
        this.getMainContainer().setBackground(NeurolabExhibit.systemGray);
        this.mainLayout = new GridBagLayout();
        this.maincontainer.setLayout(this.mainLayout);
        this.mainGbConstraints = new GridBagConstraints();
        this.mainGbConstraints.insets = new Insets(10, 10, 10, 10);
        this.mainGbConstraints.fill = 1;
        this.mainGbConstraints.weightx = 40.0;
        this.mainGbConstraints.weighty = 40.0;
        this.addMainComponent(this.buttonPanel, 3, 7, 3, 3);
        this.mainGbConstraints.fill = 1;
        this.mouthArea = new PicturePanel();
        this.mouthArea.setBackground(NeurolabExhibit.systemGray);
        this.mainGbConstraints.weightx = 20.0;
        this.mainGbConstraints.weighty = 15.0;
        this.addMainComponent(this.mouthArea, 6, 7, 2, 2);
        this.mainGbConstraints.fill = 1;
        this.mainGbConstraints.weightx = 20.0;
        this.mainGbConstraints.weighty = 10.0;
        this.addMainComponent(this.typePanel, 5, 4, 2, 3);
        this.mainGbConstraints.fill = 1;
        this.mainGbConstraints.weightx = 20.0;
        this.mainGbConstraints.weighty = 10.0;
        this.addMainComponent(this.freqPanel, 5, 2, 2, 3);
        this.mainGbConstraints.fill = 1;
        this.mainGbConstraints.weightx = 40.0;
        this.mainGbConstraints.weighty = 40.0;
        this.addMainComponent(this.graphArea, 3, 1, 5, 1);
        this.mainGbConstraints.fill = 1;
        this.mainGbConstraints.weightx = 20.0;
        this.mainGbConstraints.weighty = 10.0;
        this.listen = new JButton("Listen");
        this.addMainComponent(this.listen, 6, 9, 1, 1);
        this.listen.setFont(this.listen.getFont().deriveFont(1, this.listen.getFont().getSize() + 2));
        this.listen.setBackground(NeurolabExhibit.systemGray);
        this.listen.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (Vowels.this.oldvowel != Vowels.this.getVowel() || Vowels.this.oldfreq != Vowels.this.getFreq()) {
                    Vowels.this.oldvowel = Vowels.this.getVowel();
                    Vowels.this.oldfreq = Vowels.this.getFreq();
                    Vowels.this.WaveMaker();
                    Vowels.this.sound.open(Vowels.this.buffer);
                }
                Vowels.this.sound.start();
            }

            public void mouseReleased(MouseEvent e) {
                Vowels.this.sound.stop();
            }
        });
        this.addMainComponent(new ReturnButton(), 7, 9, 1, 1);
    }

    private void addchkboxComponent(Component c, int row, int column, int width, int height) {
        this.chkbxGbConstraints.gridx = column;
        this.chkbxGbConstraints.gridy = row;
        this.chkbxGbConstraints.gridwidth = width;
        this.chkbxGbConstraints.gridheight = height;
        this.chkbxLayout.setConstraints(c, this.chkbxGbConstraints);
        this.buttonPanel.add(c);
    }

    private void addMainComponent(Component c, int row, int column, int width, int height) {
        this.mainGbConstraints.gridx = column;
        this.mainGbConstraints.gridy = row;
        this.mainGbConstraints.gridwidth = width;
        this.mainGbConstraints.gridheight = height;
        this.mainLayout.setConstraints(c, this.mainGbConstraints);
        this.getMainContainer().add(c);
    }

    public void WaveMaker() {
        float[] fbuffer = new float[this.buffer.length];
        int waven = 192 / this.getFreq();
        if (this.getVowel() == 0) {
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = i % (384 / this.getFreq()) >= 10 ? 1 : 0;
                ++i;
            }
        } else {
            double x = (double)formant[this.getVowel()][0] * Math.PI / 44100.0;
            double y = (double)formant[this.getVowel()][1] * Math.PI / 44100.0;
            int i = 0;
            while (i < this.buffer.length) {
                fbuffer[i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < 768) {
                double a = (Math.sin(x * (double)i) + Math.sin(y * (double)i)) * Math.exp((double)(-i) / 120.0);
                int j = i;
                while (j < this.buffer.length) {
                    int n = j;
                    fbuffer[n] = (float)((double)fbuffer[n] + a);
                    j += 384 / this.getFreq();
                }
                ++i;
            }
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            int i2 = 0;
            while (i2 < this.buffer.length) {
                if (this.buffer[i2] < min) {
                    min = this.buffer[i2];
                }
                if (this.buffer[i2] > max) {
                    max = this.buffer[i2];
                }
                ++i2;
            }
            System.out.println("min=" + min + ", max=" + max);
            max = Math.max(Math.abs(max), Math.abs(min));
            i2 = 0;
            while (i2 < this.buffer.length) {
                this.buffer[i2] = (double)fbuffer[i2] / max / 2.0;
                ++i2;
            }
        }
    }

    public int getVowel() {
        return this.currentvowel;
    }

    public int getFreq() {
        return this.currentfreq;
    }

    boolean larynx() {
        return this.getVowel() == 0;
    }

    public void close() {
        if (this.sound.isActive()) {
            this.sound.stop();
        }
    }

    class Button3D
    extends JButton {
        private final int bi = 2;

        public Button3D(String t) {
            super(t);
            this.setFont(new Font("Dialog", 0, 20));
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(NeurolabExhibit.systemGray);
            g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            NeurolabExhibit.paintText3D(g, this.getText(), (this.getWidth() - NeurolabExhibit.getTextWidth(g, this.getText())) / 2, this.getHeight() / 2);
        }
    }

    private class ButtonHandler
    implements ItemListener {
        private ButtonHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            int i = 0;
            while (i < Vowels.this.choices.length) {
                if (e.getSource() == Vowels.this.choices[i]) {
                    Vowels.this.currentvowel = i;
                    Vowels.this.mouthArea.vowel = i;
                    Vowels.this.mouthArea.repaint();
                    Vowels.this.graphArea.vowel = i;
                    break;
                }
                if (e.getSource() == Vowels.this.freq) {
                    Vowels.this.graphArea.typeswitch = 1;
                } else if (e.getSource() == Vowels.this.spect) {
                    Vowels.this.graphArea.typeswitch = 0;
                } else if (e.getSource() == Vowels.this.high) {
                    Vowels.this.currentfreq = 3;
                    Vowels.this.graphArea.step = 3;
                } else if (e.getSource() == Vowels.this.med) {
                    Vowels.this.currentfreq = 2;
                    Vowels.this.graphArea.step = 2;
                } else if (e.getSource() == Vowels.this.low) {
                    Vowels.this.currentfreq = 1;
                    Vowels.this.graphArea.step = 1;
                }
                ++i;
            }
            Vowels.this.graphArea.repaint();
        }
    }

    class GraphPanel
    extends JPanel {
        public int vowel;
        private Rectangle rect;
        public int step = 1;
        public int typeswitch;

        public void paint(Graphics g) {
            super.paint(g);
            int ax = 10;
            int ay = 125;
            int bx = 210;
            int incr = 5;
            boolean loop = true;
            float y = 0.0f;
            double[] expdec = new double[]{0.98, 0.97, 0.95, 0.94, 0.92, 0.9, 0.89, 0.88, 0.86, 0.85, 0.83, 0.82, 0.81, 0.79, 0.78, 0.77, 0.75, 0.74, 0.73, 0.72, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.63, 0.62, 0.61, 0.6, 0.59, 0.58, 0.57, 0.56, 0.55, 0.54, 0.53, 0.52, 0.51, 0.5, 0.5, 0.49, 0.48, 0.47, 0.46, 0.46, 0.45, 0.44, 0.43, 0.43, 0.42, 0.41, 0.41, 0.4, 0.39, 0.39, 0.38, 0.37, 0.37, 0.36, 0.36, 0.35, 0.34, 0.34, 0.33, 0.33, 0.32, 0.32, 0.31, 0.31, 0.3, 0.3, 0.29, 0.29, 0.28, 0.28, 0.27, 0.27, 0.26, 0.26, 0.25, 0.25, 0.25, 0.24, 0.24, 0.23, 0.23, 0.23, 0.22, 0.22, 0.22, 0.21, 0.21, 0.21, 0.2, 0.2, 0.2, 0.19, 0.19, 0.19, 0.18, 0.18, 0.18, 0.17, 0.17, 0.17, 0.17, 0.16, 0.16, 0.16, 0.15, 0.15, 0.15, 0.15, 0.14, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 0.13, 0.13, 0.12, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04};
            int shift = 10;
            float constbaseline = 120.0f;
            g.setColor(Color.black);
            this.rect = new Rectangle(shift, shift, this.getWidth() - 2 * shift, this.getHeight() - 2 * shift - 20);
            g.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            if (this.typeswitch == 0) {
                g.setFont(new Font("Ariel", 0, 20));
                NeurolabExhibit.paintText3D(g, "Spectrum", 100, this.getHeight() - 9);
                float i = 1.0f;
                while (i < 3000.0f) {
                    float x = (float)(2 * shift) + i / 3000.0f * (float)(this.getWidth() - 4 * shift);
                    float const1 = 200.0f;
                    float scalingfactor = constbaseline - 50.0f;
                    if (this.vowel == 0) {
                        y = constbaseline - 80.0f;
                    } else {
                        float z1 = (formant[this.vowel][0] - i) / const1;
                        float z2 = (formant[this.vowel][1] - i) / const1;
                        y = scalingfactor * (1.0f / (1.0f + z1 * z1) + 1.0f / (1.0f + z2 * z2));
                    }
                    g.setColor(Color.green);
                    g.drawLine((int)x, (int)constbaseline, (int)x, (int)(constbaseline - y));
                    i += (float)(75 * this.step);
                }
                g.setColor(Color.red);
                g.drawLine(shift, (int)constbaseline, this.getWidth() - shift, (int)constbaseline);
            } else {
                int j;
                NeurolabExhibit.antiAlias(g);
                g.setFont(new Font("Ariel", 0, 20));
                NeurolabExhibit.paintText3D(g, "Waveform", 100, this.getHeight() - 9);
                int waven = 200 / this.step;
                int[] w = new int[200];
                int baseline = 60;
                int i = 0;
                while (i < 200) {
                    w[i] = baseline;
                    ++i;
                }
                if (this.vowel == 0) {
                    w[2] = 30;
                    w[1] = 30;
                } else {
                    double X = (double)formant[this.vowel][0] * 4.487989505128276E-4;
                    double Y = (double)formant[this.vowel][1] * 4.487989505128276E-4;
                    i = 1;
                    while (i < 200) {
                        w[i] = (int)((double)baseline + expdec[i] * 30.0 * (Math.sin(X * (double)i) + Math.sin(Y * (double)i)));
                        ++i;
                    }
                }
                if (this.step != 1) {
                    i = 0;
                    j = waven;
                    do {
                        w[j] = w[j] + w[i] - baseline;
                        ++i;
                        ++j;
                    } while ((j %= 200) < 199);
                }
                int cx = 10;
                int hoffset = 0;
                int voffset = 10;
                j = 0;
                g.setColor(Color.yellow);
                int i2 = 0;
                while (i2 < 130) {
                    g.drawLine(hoffset + j + shift, voffset + w[i2] + shift, hoffset + 2 + j + shift, voffset + w[i2 + 1] + shift);
                    j += 2;
                    ++i2;
                }
            }
        }
    }

    class PicturePanel
    extends JPanel {
        public int vowel = 13;

        PicturePanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.vowel == 13) {
                int i = 0;
                while (i < 13) {
                    g.drawImage(Vowels.this.throatimage[i], 50, 30, 1, 1, this);
                    ++i;
                }
                this.vowel = 0;
            }
            g.drawImage(Vowels.this.throatimage[this.vowel], 0, 0, 73, 57, this);
        }
    }
}

