/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.circuit.CircuitCapacitor;
import com.neurolab.circuit.CircuitCell;
import com.neurolab.circuit.CircuitCurrent;
import com.neurolab.circuit.CircuitPanel;
import com.neurolab.circuit.CircuitResistor;
import com.neurolab.circuit.CircuitSwitch;
import com.neurolab.circuit.CircuitWire;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.RadioPanel;
import com.neurolab.common.ReturnButton;
import com.neurolab.fluid.FluidPanel;
import com.neurolab.fluid.FluidPipe;
import com.neurolab.fluid.FluidReservoir;
import com.neurolab.fluid.FluidValve;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeConstants
extends NeurolabExhibit
implements ActionListener,
ChangeListener {
    private Color[] oscColors = new Color[]{Color.green};
    private int[] base = new int[]{70};
    private String[] label = new String[]{"V"};
    Timer timer;
    boolean pressed = false;
    Oscilloscope osc;
    NeurolabExhibit.NamedSliderPanel R1;
    NeurolabExhibit.NamedSliderPanel R2;
    NeurolabExhibit.NamedSliderPanel C;
    FluidPanel fluidpanel;
    CircuitPanel circuitpanel;
    RadioPanel s_type;
    JPanel lpanel;
    JPanel rpanel;
    JPanel trpanel;
    JPanel brpanel;
    JPanel tlpanel;
    JPanel sliderpanel;
    JButton close_switch;
    String[] s_typenames = new String[]{"Voltage, V", "Current, I", "Resistance, R2"};
    Vector leftCell;
    Vector leftCurrent;
    Vector pressuretank;
    Vector currentpipe;
    CircuitSwitch leftSwitch;
    CircuitSwitch rightSwitch;
    FluidReservoir reservoir1;
    FluidReservoir reservoir2;
    FluidPipe outpipe;
    FluidValve exitvalve;
    FluidValve inputvalve;
    FluidValve currentvalve;
    FluidPipe currentFlow;
    double floor = 0.057;
    double x = 0.3;
    double y = 0.3;
    int c_type = 0;
    int cap = 0;
    ActionListener typeaction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int a = TimeConstants.this.s_type.getSelected();
            if (TimeConstants.this.c_type != a) {
                TimeConstants.this.c_type = a;
                switch (TimeConstants.this.c_type) {
                    case 0: {
                        TimeConstants.this.exitvalve.closed = false;
                        TimeConstants.this.leftSwitch.closed = false;
                        TimeConstants.this.inputvalve.closed = true;
                        TimeConstants.this.rightSwitch.closed = true;
                    }
                    case 2: {
                        TimeConstants.this.removeAll(TimeConstants.this.circuitpanel.componentlist, TimeConstants.this.leftCurrent);
                        TimeConstants.this.addAll(TimeConstants.this.circuitpanel.componentlist, TimeConstants.this.leftCell);
                        TimeConstants.this.removeAll(TimeConstants.this.fluidpanel.componentlist, TimeConstants.this.currentpipe);
                        TimeConstants.this.addAll(TimeConstants.this.fluidpanel.componentlist, TimeConstants.this.pressuretank);
                        if (TimeConstants.this.c_type == 0) break;
                        TimeConstants.this.exitvalve.closed = true;
                        TimeConstants.this.leftSwitch.closed = true;
                        TimeConstants.this.inputvalve.closed = false;
                        TimeConstants.this.rightSwitch.closed = false;
                        break;
                    }
                    case 1: {
                        TimeConstants.this.removeAll(TimeConstants.this.circuitpanel.componentlist, TimeConstants.this.leftCell);
                        TimeConstants.this.addAll(TimeConstants.this.circuitpanel.componentlist, TimeConstants.this.leftCurrent);
                        TimeConstants.this.removeAll(TimeConstants.this.fluidpanel.componentlist, TimeConstants.this.pressuretank);
                        TimeConstants.this.addAll(TimeConstants.this.fluidpanel.componentlist, TimeConstants.this.currentpipe);
                        TimeConstants.this.exitvalve.closed = false;
                        TimeConstants.this.leftSwitch.closed = false;
                        TimeConstants.this.rightSwitch.closed = true;
                    }
                }
            }
            TimeConstants.this.circuitpanel.repaint();
            TimeConstants.this.fluidpanel.repaint();
        }
    };

    public String getExhibitName() {
        return "Time Constants";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.createComponents();
        this.createCircuit();
        this.s_type.setSelected(0);
        this.R1.slider.setValue(5);
        this.R2.slider.setValue(6);
        this.C.slider.setValue(90);
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public void createComponents() {
        this.osc = new Oscilloscope(1, this){

            public void drawScreenElements(Graphics g) {
                int gut = this.getGutter();
                g.setFont(new Font("Ariel", 1, 12));
                g.setColor(this.getColors()[0]);
                g.drawString(TimeConstants.this.label[0], gut + 5, gut + 15);
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 120);
            }
        };
        this.osc.setColors(this.oscColors);
        this.osc.setBaseY(this.base);
        this.osc.timer.setDelay(200);
        this.osc.setGutter(5);
        this.lpanel = new JPanel();
        this.getMainContainer().add((Component)this.lpanel, "West");
        this.rpanel = new JPanel();
        this.getMainContainer().add((Component)this.rpanel, "East");
        NeurolabExhibit.setBG(this.lpanel);
        NeurolabExhibit.setBG(this.rpanel);
        this.rpanel.setLayout(new BorderLayout());
        this.trpanel = new JPanel();
        this.rpanel.add((Component)this.trpanel, "North");
        this.brpanel = new JPanel();
        this.rpanel.add((Component)this.brpanel, "South");
        NeurolabExhibit.setBG(this.trpanel);
        NeurolabExhibit.setBG(this.brpanel);
        this.brpanel.setLayout(new BorderLayout());
        JPanel a = new JPanel();
        a.setBackground(NeurolabExhibit.systemGray);
        this.brpanel.add((Component)a, "Center");
        this.close_switch = new JButton("Close switch");
        this.brpanel.add((Component)this.close_switch, "North");
        this.brpanel.add((Component)new ReturnButton(), "South");
        NeurolabExhibit.setBG(this.close_switch);
        this.close_switch.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                switch (TimeConstants.this.c_type) {
                    case 0: {
                        TimeConstants.this.inputvalve.toggle();
                        TimeConstants.this.leftSwitch.toggle();
                        break;
                    }
                    case 1: {
                        TimeConstants.this.currentvalve.toggle();
                        TimeConstants.this.leftSwitch.toggle();
                        if (TimeConstants.this.leftSwitch.closed) {
                            TimeConstants.this.fluidpanel.componentlist.addElement(TimeConstants.this.currentFlow);
                            break;
                        }
                        TimeConstants.this.fluidpanel.componentlist.removeElement(TimeConstants.this.currentFlow);
                        break;
                    }
                    case 2: {
                        TimeConstants.this.rightSwitch.toggle();
                        TimeConstants.this.exitvalve.toggle();
                    }
                }
                TimeConstants.this.pressed = true;
            }

            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
                TimeConstants.this.pressed = false;
            }
        });
        this.trpanel.setLayout(new BorderLayout());
        this.s_type = new RadioPanel(this.s_typenames, this.typeaction);
        this.trpanel.add((Component)this.s_type, "North");
        this.sliderpanel = new JPanel();
        this.trpanel.add((Component)this.sliderpanel, "South");
        NeurolabExhibit.setBG(this.sliderpanel);
        this.sliderpanel.setLayout(new GridLayout(3, 1));
        this.R1 = new NeurolabExhibit.NamedSliderPanel("R1", 20, NeurolabExhibit.LABEL_POS_LEFT);
        this.sliderpanel.add(this.R1);
        this.R2 = new NeurolabExhibit.NamedSliderPanel("R2", 20, NeurolabExhibit.LABEL_POS_LEFT);
        this.sliderpanel.add(this.R2);
        this.C = new NeurolabExhibit.NamedSliderPanel("C", 70, NeurolabExhibit.LABEL_POS_LEFT);
        this.sliderpanel.add(this.C);
        this.C.slider.addChangeListener(this);
        this.lpanel.setLayout(new BorderLayout());
        this.lpanel.add((Component)this.osc, "South");
        this.tlpanel = new JPanel();
        this.lpanel.add((Component)this.tlpanel, "North");
        NeurolabExhibit.setBG(this.tlpanel);
        this.tlpanel.setLayout(new BorderLayout());
        this.circuitpanel = new CircuitPanel();
        this.tlpanel.add((Component)this.circuitpanel, "West");
        this.circuitpanel.setPreferredSize(new Dimension(210, 190));
        this.fluidpanel = new FluidPanel();
        this.tlpanel.add((Component)this.fluidpanel, "East");
        NeurolabExhibit.setBG(this.circuitpanel);
        NeurolabExhibit.setBG(this.fluidpanel);
    }

    public void createCircuit() {
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[0] = 50;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 100;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 130;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 160;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[0] = 210;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[0] = 260;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 40;
        nArrayArray[7] = nArray7;
        nArrayArray[8] = new int[]{130, 75};
        nArrayArray[9] = new int[]{260, 60};
        int[] nArray8 = new int[2];
        nArray8[1] = 130;
        nArrayArray[10] = nArray8;
        nArrayArray[11] = new int[]{130, 135};
        nArrayArray[12] = new int[]{260, 150};
        int[] nArray9 = new int[2];
        nArray9[1] = 200;
        nArrayArray[13] = nArray9;
        nArrayArray[14] = new int[]{130, 200};
        nArrayArray[15] = new int[]{260, 200};
        int[][] ilist = nArrayArray;
        this.leftCell = new Vector();
        this.leftCurrent = new Vector();
        int i = 0;
        while (i < ilist.length) {
            this.circuitpanel.nodes.addElement(new Point((int)((double)ilist[i][0] * 0.6) + 30, (int)((double)ilist[i][1] * 0.75) + 25));
            ++i;
        }
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 0, 1));
        this.leftSwitch = new CircuitSwitch(this.circuitpanel, 1, 2);
        this.circuitpanel.componentlist.addElement(this.leftSwitch);
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 2, 4));
        this.rightSwitch = new CircuitSwitch(this.circuitpanel, 4, 5);
        this.circuitpanel.componentlist.addElement(this.rightSwitch);
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 5, 6));
        this.rightSwitch.closed = true;
        this.leftCell.addElement(new CircuitWire(this.circuitpanel, 0, 7));
        CircuitResistor r1 = new CircuitResistor(this.circuitpanel, 7, 10);
        this.leftCell.addElement(r1);
        CircuitCell v1 = new CircuitCell(this.circuitpanel, 13, 10);
        this.leftCell.addElement(v1);
        this.leftCurrent.addElement(new CircuitWire(this.circuitpanel, 0, 7));
        CircuitCurrent i1 = new CircuitCurrent(this.circuitpanel, 7, 10);
        this.leftCurrent.addElement(i1);
        this.leftCurrent.addElement(new CircuitWire(this.circuitpanel, 10, 13));
        this.addAll(this.circuitpanel.componentlist, this.leftCell);
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 3, 8));
        CircuitCapacitor c1 = new CircuitCapacitor(this.circuitpanel, 8, 11);
        this.circuitpanel.componentlist.addElement(c1);
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 11, 14));
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 6, 9));
        CircuitResistor r2 = new CircuitResistor(this.circuitpanel, 9, 12);
        this.circuitpanel.componentlist.addElement(r2);
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 12, 15));
        r1.name = "R1";
        r2.name = "R2 ";
        v1.name = "V ";
        i1.name = "I ";
        c1.name = "C ";
        this.circuitpanel.componentlist.addElement(new CircuitWire(this.circuitpanel, 13, 15));
        this.reservoir1 = new FluidReservoir(this.fluidpanel, new Point(60, 40), new Point(70 + this.C.slider.getValue(), 140));
        this.fluidpanel.componentlist.addElement(this.reservoir1);
        this.outpipe = new FluidPipe(this.fluidpanel, new Point(70 + this.C.slider.getValue(), 135), new Point(173, 135));
        this.fluidpanel.componentlist.addElement(this.outpipe);
        this.outpipe.drawend = true;
        this.exitvalve = new FluidValve(this.fluidpanel, new Point(170, 140), new Point(170, 150));
        this.fluidpanel.componentlist.addElement(this.exitvalve);
        this.outpipe.diameter = 10;
        this.exitvalve.diameter = 10;
        this.pressuretank = new Vector();
        this.reservoir2 = new FluidReservoir(this.fluidpanel, new Point(-10, 40), new Point(40, 140));
        this.pressuretank.addElement(this.reservoir2);
        this.inputvalve = new FluidValve(this.fluidpanel, new Point(40, 135), new Point(60, 135));
        this.pressuretank.addElement(this.inputvalve);
        this.inputvalve.diameter = 10;
        this.inputvalve.closed = true;
        this.reservoir2.level = 0.9;
        this.addAll(this.fluidpanel.componentlist, this.pressuretank);
        this.currentpipe = new Vector();
        this.currentvalve = new FluidValve(this.fluidpanel, new Point(70, 0), new Point(70, 30));
        this.currentpipe.addElement(this.currentvalve);
        this.currentvalve.diameter = 10;
        this.currentvalve.closed = true;
        this.currentFlow = new FluidPipe(this.fluidpanel, new Point(70, 30), new Point(70, 130));
        this.currentFlow.drawEdges = false;
        this.currentFlow.diameter = 12;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != "Sweep") {
            switch (this.s_type.getSelected()) {
                case 0: {
                    this.y -= (this.x - this.floor) / (double)(this.R2.slider.getValue() + 1);
                    if (!this.pressed) break;
                    this.y += (this.reservoir2.level - this.x) / (double)(this.R1.slider.getValue() + 1);
                    break;
                }
                case 1: {
                    this.y -= (this.x - this.floor) / (double)(this.R2.slider.getValue() + 1);
                    if (!this.pressed) break;
                    this.y += 0.1;
                    break;
                }
                case 2: {
                    this.y += (this.reservoir2.level - this.x) / (double)(this.R1.slider.getValue() + 1);
                    if (!this.pressed) break;
                    this.y -= (this.x - this.floor) / (double)(this.R2.slider.getValue() + 1);
                }
            }
            this.x = 10.0 * this.y / (double)(this.C.slider.getValue() + 10);
            int[] t = new int[]{100 - (int)(700.0 * this.x)};
            this.osc.setPosY(t);
            this.reservoir1.level = this.x;
            this.fluidpanel.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        int b = this.C.slider.getValue();
        if (this.cap != b) {
            this.cap = b;
            this.reservoir1.setPos(this.reservoir1.getP1(), new Point(70 + this.C.slider.getValue(), 140));
            this.outpipe.setPos(new Point(70 + this.C.slider.getValue(), 135), this.outpipe.getP2());
        }
        this.circuitpanel.repaint();
        this.fluidpanel.repaint();
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
        this.osc.timer.stop();
    }
}

