/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComboBoxUI;

public abstract class RobinExhibit
extends NeurolabExhibit {
    protected int questionumber;
    protected boolean testmode;
    protected int no_components = this.getNumComponents();
    protected int[] question = new int[this.no_components];
    protected String[] textStrings;
    protected String[] brainStrings;
    private Dimension dimension = this.getImageDimension();
    protected Image picture_base;
    public Image[] picture = new Image[this.no_components + 1];
    public boolean[] image_exists = new boolean[this.no_components + 1];
    public int correct;
    public boolean noarea = false;
    public boolean ignore = false;
    public boolean nocombo = false;
    public JPanel picturebox;
    public PicturePanel picgraphic;
    public TextPanel textbox;
    public JComboBox whichbit;
    private GridBagLayout mainLayout;
    private GridBagLayout chkbxLayout;
    public GridBagConstraints mainGbConstraints;
    public GridBagConstraints chkbxGbConstraints;
    public JRadioButton[] buttonchoice;
    private ButtonGroup buttonset;
    private JButton returnbutton;
    private JCheckBox testme;
    private Container maincontainer;
    JScrollPane textscrollbox = new JScrollPane();
    protected int index;

    public abstract int getNumComponents();

    protected abstract Dimension getImageDimension();

    public void init() {
        super.init();
        this.index = this.no_components;
        this.testmode = false;
        this.nocombo = false;
        this.noarea = false;
        this.createComponents();
    }

    public void createComponents() {
        EventHandler handler = new EventHandler();
        Border etched = BorderFactory.createEtchedBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        this.picturebox = new JPanel();
        this.picturebox.setBackground(NeurolabExhibit.systemGray);
        this.picturebox.setBorder(etched);
        this.chkbxLayout = new GridBagLayout();
        this.picturebox.setLayout(this.chkbxLayout);
        this.chkbxGbConstraints = new GridBagConstraints();
        this.chkbxGbConstraints.fill = 1;
        this.chkbxGbConstraints.weightx = 6.0;
        this.chkbxGbConstraints.weighty = 4.0;
        this.picgraphic = new PicturePanel();
        this.picgraphic.setBackground(NeurolabExhibit.systemGray);
        this.chkbxGbConstraints.fill = 1;
        this.chkbxGbConstraints.weightx = 80.0;
        this.chkbxGbConstraints.weighty = 100.0;
        this.addchkboxComponent(this.picgraphic, 0, 0, 1, 1);
        String[] htmlBrainStrings = new String[this.brainStrings.length];
        int i = 0;
        while (i < this.brainStrings.length) {
            htmlBrainStrings[i] = "<HTML>" + this.brainStrings[i];
            ++i;
        }
        this.whichbit = new JComboBox<String>(this.brainStrings);
        this.whichbit.setLightWeightPopupEnabled(false);
        this.whichbit.addItemListener(handler);
        this.whichbit.setPreferredSize(new Dimension(200, this.whichbit.getPreferredSize().height));
        this.textbox = new TextPanel();
        this.textbox.setBorder(new CompoundBorder(etched, new EmptyBorder(3, 3, 3, 3)));
        this.textbox.setBackground(NeurolabExhibit.systemGray);
        this.textbox.n = this.no_components;
        this.textscrollbox.getViewport().setView(this.textbox);
        this.testme = new JCheckBox("Test Me");
        this.testme.addItemListener(handler);
        this.testme.setBackground(NeurolabExhibit.systemGray);
        this.returnbutton = new JButton("Return");
        this.returnbutton.setBackground(NeurolabExhibit.systemGray);
        this.returnbutton.addActionListener(handler);
        this.returnbutton.setDoubleBuffered(true);
        this.maincontainer = this.getMainContainer();
        this.mainLayout = new GridBagLayout();
        this.maincontainer.setLayout(this.mainLayout);
        this.mainGbConstraints = new GridBagConstraints();
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.whichbit, 2, 3, 3, 1, 0, 20);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.textscrollbox, 4, 3, 3, 1, 0, 20);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.picturebox, 2, 0, 2, 4, 80, 80);
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.returnbutton, 6, 5, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.testme, 6, 3, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(10, 30), 0, 0, 1, 1, 1, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(30, 50), 4, 2, 1, 1, 0, 80);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(40, 30), 3, 4, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(10, 0), 6, 6, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(40, 50), 5, 4, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(40, 30), 7, 4, 1, 1, 0, 0);
    }

    public String getAppletInfo() {
        return "Spinal Tracts coded in Java by Robin Marlow \n based on an original program by Dr. Carpenter.";
    }

    public void addMainComponent(Component c, int row, int column, int width, int height, int weightx, int weighty) {
        this.mainGbConstraints.gridx = column;
        this.mainGbConstraints.gridy = row;
        this.mainGbConstraints.gridwidth = width;
        this.mainGbConstraints.gridheight = height;
        this.mainGbConstraints.weightx = weightx;
        this.mainGbConstraints.weighty = weighty;
        this.mainLayout.setConstraints(c, this.mainGbConstraints);
        this.maincontainer.add(c);
    }

    private void addchkboxComponent(Component c, int row, int column, int width, int height) {
        this.chkbxGbConstraints.gridx = column;
        this.chkbxGbConstraints.gridy = row;
        this.chkbxGbConstraints.gridwidth = width;
        this.chkbxGbConstraints.gridheight = height;
        this.chkbxLayout.setConstraints(c, this.chkbxGbConstraints);
        this.picturebox.add(c);
    }

    private void QuestionHandler() {
        this.questionumber = 0;
        this.correct = 0;
        int n = 0;
        while (n < this.no_components) {
            boolean unique;
            do {
                unique = true;
                double temp = (double)this.no_components * Math.random();
                this.question[n] = (int)temp;
                int m = 0;
                while (m < n) {
                    if (this.question[m] == this.question[n]) {
                        unique = false;
                    }
                    ++m;
                }
            } while (!unique);
            ++n;
        }
        int i = 0;
        while (i < this.question.length) {
            if (Math.random() < 0.5) {
                int n2 = i;
                this.question[n2] = this.question[n2] + this.no_components;
            }
            ++i;
        }
        this.setupQuestion();
    }

    private void nextQuestion(boolean answer) {
        if (answer) {
            JOptionPane.showMessageDialog(null, "Correct!", "You got it...", 1);
            ++this.correct;
        } else {
            JOptionPane.showMessageDialog(null, "Wrong! - The correct answer is shown", "You got it...", 1);
        }
        if (this.questionumber < this.no_components - 1) {
            ++this.questionumber;
            this.setupQuestion();
        } else {
            this.ignore = true;
            this.testme.doClick();
            this.testmode = false;
            this.ignore = false;
            JOptionPane.showMessageDialog(null, String.valueOf(this.correct) + " out of " + this.no_components, "You scored", 1);
        }
    }

    private void setupQuestion() {
        if (!this.testmode) {
            this.testmode = false;
            return;
        }
        if (this.question[this.questionumber] > this.no_components - 1) {
            this.ignore = true;
            this.noarea = false;
            this.nocombo = true;
            this.index = this.no_components;
            this.whichbit.setEnabled(false);
            this.whichbit.setBackground(Color.white);
            this.whichbit.setBackground(Color.white);
            if (this.question[this.questionumber] - this.no_components > this.no_components) {
                int n = this.questionumber;
                this.question[n] = this.question[n] - this.no_components;
            }
            this.whichbit.setSelectedIndex(this.question[this.questionumber] - this.no_components);
            this.picturebox.repaint();
            this.textbox.update();
            this.ignore = false;
        } else {
            this.ignore = true;
            this.noarea = true;
            this.nocombo = false;
            this.whichbit.setEnabled(true);
            this.whichbit.setSelectedIndex(0);
            if (this.whichbit.getItemAt(0) == this.brainStrings[1]) {
                this.whichbit.insertItemAt("Choose", 0);
                this.whichbit.setSelectedIndex(0);
            }
            this.index = this.question[this.questionumber];
            this.picturebox.repaint();
            this.textbox.update();
            this.ignore = false;
        }
    }

    protected int getPixelValueAt(Point e) throws InterruptedException {
        int[] pixels = new int[1];
        PixelGrabber pg = new PixelGrabber(this.picture_base, e.x, e.y, 1, 1, pixels, 0, 2);
        pg.grabPixels();
        return pixels[0];
    }

    public void close() {
    }

    public class ComboBoxUIDecorator
    extends ComboBoxUI {
        private ComboBoxUI m_parent;

        public ComboBoxUIDecorator(ComboBoxUI x) {
            this.m_parent = x;
        }

        public boolean isFocusTraversable(JComboBox c) {
            return this.m_parent.isFocusTraversable(c);
        }

        public void paint(Graphics g, JComponent c) {
            boolean ena = c.isEnabled();
            this.m_parent.paint(g, c);
        }

        public boolean isPopupVisible(JComboBox c) {
            return this.m_parent.isPopupVisible(c);
        }

        public void setPopupVisible(JComboBox c, boolean v) {
            this.m_parent.setPopupVisible(c, v);
        }
    }

    private class EventHandler
    implements ActionListener,
    ItemListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Return") {
                RobinExhibit.this.toExhibitChooser();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (RobinExhibit.this.whichbit.getItemAt(0) == "Choose" && !RobinExhibit.this.ignore) {
                RobinExhibit.this.ignore = true;
                RobinExhibit.this.whichbit.removeItemAt(0);
                RobinExhibit.this.ignore = false;
            }
            if (e.getSource() == RobinExhibit.this.testme) {
                if (e.getStateChange() == 1) {
                    RobinExhibit.this.testmode = true;
                    RobinExhibit.this.QuestionHandler();
                } else if (e.getStateChange() == 2) {
                    RobinExhibit.this.ignore = true;
                    RobinExhibit.this.testmode = false;
                    RobinExhibit.this.noarea = false;
                    RobinExhibit.this.nocombo = false;
                    RobinExhibit.this.whichbit.setSelectedIndex(0);
                    RobinExhibit.this.whichbit.setEnabled(true);
                    if (RobinExhibit.this.whichbit.getItemAt(0) == RobinExhibit.this.brainStrings[1]) {
                        RobinExhibit.this.whichbit.insertItemAt("Choose", 0);
                        RobinExhibit.this.whichbit.setSelectedIndex(0);
                    }
                    RobinExhibit.this.ignore = false;
                    RobinExhibit.this.textbox.n = RobinExhibit.this.no_components - 1;
                    RobinExhibit.this.index = RobinExhibit.this.no_components;
                    RobinExhibit.this.picturebox.repaint();
                    RobinExhibit.this.textbox.update();
                }
            }
            if (e.getSource() == RobinExhibit.this.whichbit && !RobinExhibit.this.ignore && !RobinExhibit.this.testmode && e.getStateChange() == 1) {
                RobinExhibit.this.textbox.n = RobinExhibit.this.whichbit.getSelectedIndex();
                RobinExhibit.this.index = RobinExhibit.this.whichbit.getSelectedIndex();
                RobinExhibit.this.textbox.update();
                RobinExhibit.this.picturebox.repaint();
            }
            if (e.getSource() == RobinExhibit.this.whichbit && !RobinExhibit.this.ignore && RobinExhibit.this.testmode && !RobinExhibit.this.nocombo && e.getStateChange() == 1) {
                if (RobinExhibit.this.whichbit.getSelectedIndex() == RobinExhibit.this.question[RobinExhibit.this.questionumber]) {
                    RobinExhibit.this.whichbit.hidePopup();
                    RobinExhibit.this.nextQuestion(true);
                } else {
                    RobinExhibit.this.ignore = true;
                    RobinExhibit.this.whichbit.hidePopup();
                    RobinExhibit.this.whichbit.setSelectedIndex(RobinExhibit.this.question[RobinExhibit.this.questionumber]);
                    RobinExhibit.this.ignore = false;
                    RobinExhibit.this.nextQuestion(false);
                }
                RobinExhibit.this.setupQuestion();
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        boolean mousedown = false;
        private boolean onceover = false;

        private MouseClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.mousedown = true;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.mousedown) {
                this.mouseClicked(e);
                this.mousedown = false;
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.doEvent(e);
        }

        private void doEvent(MouseEvent e) {
            if (!RobinExhibit.this.noarea) {
                int pixel;
                if (RobinExhibit.this.whichbit.getItemAt(0) == "Choose") {
                    RobinExhibit.this.ignore = true;
                    RobinExhibit.this.whichbit.removeItemAt(0);
                    RobinExhibit.this.ignore = false;
                    this.onceover = true;
                } else {
                    this.onceover = false;
                }
                try {
                    pixel = RobinExhibit.this.getPixelValueAt(e.getPoint());
                }
                catch (InterruptedException x) {
                    return;
                }
                int n = 0;
                while (n < RobinExhibit.this.no_components) {
                    if (pixel == -65536 - n * 65536) {
                        if (RobinExhibit.this.whichbit.getSelectedIndex() != n || this.onceover) {
                            if (RobinExhibit.this.testmode) {
                                RobinExhibit.this.index = RobinExhibit.this.question[RobinExhibit.this.questionumber] - RobinExhibit.this.no_components;
                                RobinExhibit.this.picturebox.repaint();
                                RobinExhibit.this.nextQuestion(false);
                                break;
                            }
                            RobinExhibit.this.whichbit.setSelectedIndex(n);
                            break;
                        }
                        if (RobinExhibit.this.whichbit.getSelectedIndex() != n || !RobinExhibit.this.testmode) break;
                        RobinExhibit.this.index = RobinExhibit.this.question[RobinExhibit.this.questionumber] - RobinExhibit.this.no_components;
                        RobinExhibit.this.picturebox.repaint();
                        RobinExhibit.this.nextQuestion(true);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        Cursor normal = Cursor.getDefaultCursor();
        Cursor hand = Cursor.getPredefinedCursor(12);

        MouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            try {
                int px = RobinExhibit.this.getPixelValueAt(e.getPoint());
                int msb = 255 - (px / 65536 & 0xFF);
                if (px != 0 && px != -1 && msb >= 0 && msb < RobinExhibit.this.no_components) {
                    RobinExhibit.this.setCursor(this.hand);
                } else {
                    RobinExhibit.this.setCursor(this.normal);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class PicturePanel
    extends JPanel {
        boolean painting = false;

        public PicturePanel() {
            this.addMouseListener(new MouseClickHandler());
            this.addMouseMotionListener(new MouseMotionHandler());
        }

        public void paint(Graphics g) {
            this.painting = true;
            super.paint(g);
            int i = RobinExhibit.this.index;
            if (!RobinExhibit.this.image_exists[i]) {
                RobinExhibit.this.picture[i] = this.createImage(new FilteredImageSource(RobinExhibit.this.picture_base.getSource(), new RedBlueSwapFilter(i)));
                RobinExhibit.this.image_exists[i] = true;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            g.drawImage(RobinExhibit.this.picture[i], 0, 0, this);
            this.painting = false;
        }
    }

    class RedBlueSwapFilter
    extends RGBImageFilter {
        int tindex;

        public RedBlueSwapFilter(int i) {
            this.tindex = i;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int n = 0;
            while (n < 18) {
                if (rgb == -65536 - n * 65536) {
                    if (n == this.tindex) {
                        return -14855425;
                    }
                    return 0x848484;
                }
                ++n;
            }
            return 0xFF000000 | (rgb & 0xFF0000) << 0 | (rgb & 0xFF00) << 0 | rgb & 0xFF;
        }
    }

    protected class TextPanel
    extends JTextPane {
        public int n;

        public TextPanel() {
            this.setEditable(false);
            this.setPreferredSize(this.getPreferredSize());
            this.setMargin(new Insets(3, 3, 3, 3));
            this.setFont(new Font("Dialog", 1, 12));
        }

        public void init() {
            this.n = 0;
        }

        public void update() {
            String as = null;
            as = RobinExhibit.this.testmode ? (RobinExhibit.this.question[RobinExhibit.this.questionumber] <= RobinExhibit.this.no_components - 1 ? "Select the name of the highlighted region" : (RobinExhibit.this.question[RobinExhibit.this.questionumber] >= RobinExhibit.this.no_components ? "Select the area of brain named" : "something wrong with the text matching!")) : RobinExhibit.this.textStrings[this.n];
            this.setText(as);
        }
    }
}

