/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.ActionPotentials;
import com.neurolab.common.AngleControl;
import com.neurolab.common.ExtraGraphics;
import com.neurolab.common.JPanel0;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.PercentageBar;
import com.neurolab.common.RadioPanel;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ReceptiveFields
extends NeurolabExhibit
implements ActionListener {
    ActionPotentials ap;
    Timer timer;
    int cx;
    int cy;
    int ntexdots = 7;
    int[] du;
    int[] dv;
    JPanel left;
    JPanel center;
    JPanel right;
    JPanel cbpanel;
    JPanel rtpanel;
    JPanel rmpanel;
    JPanel tlpanel;
    JPanel rightf;
    JPanel rbpanel;
    JPanel textpanel;
    JPanel rightt;
    JPanel anglepanel;
    PercentageBar blbar;
    RFScreen rfscreen;
    JCheckBox s_invert;
    JCheckBox r_invert;
    JCheckBox r_transient;
    JCheckBox r_reveal;
    NeurolabExhibit.NamedSliderPanel s_size;
    AngleControl s_angle;
    RadioPanel s_typepanel;
    RadioPanel r_typepanel;
    final String[] s_typelist = new String[]{"Extended", "Circle", "Annulus", "Edge", "Line", "Textured"};
    final String[] r_typelist = new String[]{"Simple large-field", "Simple centre-surround", "Complex dot-detector", "Directional large-field", "Simple linear", "Complex linear", "End-stopped linear"};
    ActionListener typeaction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ReceptiveFields.this.s_invert || e.getSource() == ReceptiveFields.this.r_invert) {
                ReceptiveFields.this.showActivity(ReceptiveFields.this.calculate());
            } else if (e.getSource() != ReceptiveFields.this.r_reveal) {
                int stim = ReceptiveFields.this.s_typepanel.getSelected();
                int field = ReceptiveFields.this.r_typepanel.getSelected();
                switch (field) {
                    case 3: 
                    case 5: 
                    case 6: {
                        ReceptiveFields.this.r_transient.setSelected(false);
                        ReceptiveFields.this.r_transient.setVisible(false);
                        break;
                    }
                    default: {
                        ReceptiveFields.this.r_transient.setVisible(true);
                    }
                }
                switch (stim) {
                    case 1: 
                    case 2: 
                    case 4: {
                        ReceptiveFields.this.s_size.setVisible(true);
                        break;
                    }
                    default: {
                        ReceptiveFields.this.s_size.setVisible(false);
                    }
                }
                switch (stim) {
                    case 3: 
                    case 4: {
                        ReceptiveFields.this.anglepanel.setVisible(true);
                        ReceptiveFields.this.validateTree();
                        break;
                    }
                    default: {
                        ReceptiveFields.this.anglepanel.setVisible(false);
                    }
                }
            }
            ReceptiveFields.this.rfscreen.repaint();
        }
    };
    double oldactivity;
    double activity;
    double smoothrate = 0.5;
    double l_act;
    double d_act;
    float annulusf = 0.6f;
    int outerrf = 120;
    int innerrf = 32;
    int u;
    int v;
    int ou;
    int ov;

    public String getExhibitName() {
        return "Receptive Fields";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.createComponents();
        this.ap = new ActionPotentials();
        this.timer = new Timer(100, this);
        this.ap.setRate(0.0);
        this.cx = 125;
        this.cy = 125;
        this.du = new int[this.ntexdots];
        this.dv = new int[this.ntexdots];
        this.timer.start();
    }

    public void createComponents() {
        this.left = new JPanel();
        this.getMainContainer().add((Component)this.left, "West");
        this.rightf = new JPanel();
        this.getMainContainer().add((Component)this.rightf, "Center");
        ((BorderLayout)this.getMainContainer().getLayout()).setHgap(10);
        NeurolabExhibit.setBG(this.left);
        NeurolabExhibit.setBG(this.rightf);
        this.rightf.setLayout(new BorderLayout());
        this.rightt = new JPanel();
        this.rightf.add((Component)this.rightt, "North");
        this.rbpanel = new JPanel();
        this.rightf.add((Component)this.rbpanel, "South");
        NeurolabExhibit.setBG(this.rightt);
        NeurolabExhibit.setBG(this.rbpanel);
        this.rightt.setLayout(new GridLayout(1, 2));
        this.center = new JPanel();
        this.rightt.add(this.center);
        this.right = new JPanel();
        this.rightt.add(this.right);
        NeurolabExhibit.setBG(this.right);
        NeurolabExhibit.setBG(this.center);
        this.rbpanel.setLayout(new BorderLayout());
        this.rbpanel.add((Component)new ReturnButton(), "East");
        this.textpanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                g.setFont(new Font("Arial", 1, 16));
                NeurolabExhibit.paintText3D(g, "Click/Drag in black area", 0, this.getHeight() - 8);
            }
        };
        this.rbpanel.add((Component)this.textpanel, "West");
        this.textpanel.setPreferredSize(new Dimension(200, 30));
        NeurolabExhibit.setBG(this.textpanel);
        BorderLayout b = new BorderLayout();
        b.setVgap(10);
        this.left.setLayout(b);
        this.tlpanel = new JPanel();
        this.left.add((Component)this.tlpanel, "Center");
        this.blbar = new PercentageBar();
        this.left.add((Component)this.blbar, "South");
        NeurolabExhibit.setBG(this.tlpanel);
        this.tlpanel.setBorder(NeurolabExhibit.loweredbevel);
        this.rfscreen = new RFScreen();
        this.tlpanel.add((Component)this.rfscreen, "North");
        this.rfscreen.setPreferredSize(new Dimension(250, 250));
        this.center.setBorder(BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Stimulus Type"));
        this.center.setLayout(new BorderLayout());
        this.s_typepanel = new RadioPanel(this.s_typelist, this.typeaction);
        this.center.add((Component)this.s_typepanel, "North");
        this.cbpanel = new JPanel();
        this.center.add((Component)this.cbpanel, "South");
        this.s_invert = new JCheckBox("Invert light and dark");
        this.center.add((Component)this.s_invert, "Center");
        this.s_invert.addActionListener(this.typeaction);
        NeurolabExhibit.setBG(this.cbpanel);
        NeurolabExhibit.setBG(this.s_invert);
        this.cbpanel.setLayout(new BorderLayout());
        this.s_size = new NeurolabExhibit.NamedSliderPanel("Size", 200, NeurolabExhibit.LABEL_POS_LEFT);
        this.cbpanel.add((Component)this.s_size, "North");
        this.anglepanel = new JPanel0();
        this.cbpanel.add((Component)this.anglepanel, "South");
        this.anglepanel.setPreferredSize(new Dimension(40, 60));
        this.s_angle = new AngleControl();
        this.anglepanel.add((Component)this.s_angle, "Center");
        this.s_angle.setPreferredSize(new Dimension(40, 60));
        this.s_angle.setPrefix("Angle       ");
        this.right.setBorder(BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Field type"));
        this.right.setLayout(new BorderLayout());
        this.r_typepanel = new RadioPanel(this.r_typelist, this.typeaction);
        this.right.add((Component)this.r_typepanel, "North");
        this.rmpanel = new JPanel();
        this.right.add((Component)this.rmpanel, "Center");
        this.r_reveal = new JCheckBox("Reveal");
        this.right.add((Component)this.r_reveal, "South");
        this.r_reveal.addActionListener(this.typeaction);
        NeurolabExhibit.setBG(this.rmpanel);
        NeurolabExhibit.setBG(this.r_reveal);
        this.rmpanel.setLayout(new BorderLayout());
        this.r_invert = new JCheckBox("Invert +/-");
        this.rmpanel.add((Component)this.r_invert, "North");
        this.r_transient = new JCheckBox("Transient");
        this.rmpanel.add((Component)this.r_transient, "South");
        NeurolabExhibit.setBG(this.r_invert);
        NeurolabExhibit.setBG(this.r_transient);
        this.r_typepanel.setSelected(0);
        this.s_typepanel.setSelected(1);
        this.r_reveal.setSelected(true);
        this.s_size.slider.setValue(50);
        this.s_angle.setValue(40);
    }

    public void showActivity(double activit) {
        if (this.activity < 0.0 || this.activity > 1.0) {
            System.out.println("Activity=" + String.valueOf(this.activity));
        }
        this.activity = this.smoothrate * this.activity + (1.0 - this.smoothrate) * activit;
        if (this.activity < 1.0E-4) {
            this.activity = 0.0;
        }
        if (this.s_invert.isSelected()) {
            this.activity = 1.0 - this.activity;
        }
        if (this.r_invert.isSelected()) {
            this.activity = 1.0 - this.activity;
        }
        double f = this.r_transient.isSelected() ? 4.0 * (this.activity - this.oldactivity) + (this.activity - 0.5) * 0.4 + 0.4 : this.activity;
        this.oldactivity = this.activity;
        this.blbar.p = (int)(100.0 * f);
        this.blbar.repaint();
        this.ap.setRate(f * 20.0);
    }

    public void actionPerformed(ActionEvent e) {
        this.showActivity(this.calculate());
    }

    public double calculate() {
        float act;
        block41: {
            act = 0.0f;
            this.ou = this.u;
            this.ov = this.v;
            this.u = this.rfscreen.ox - this.cx;
            this.v = this.rfscreen.oy - this.cy;
            int field = this.r_typepanel.getSelected();
            int size = this.s_size.slider.getValue();
            double angle = (double)this.s_angle.getValue() * Math.PI / 180.0;
            if (!this.rfscreen.pressing) break block41;
            block0 : switch (this.s_typepanel.getSelected()) {
                case 0: {
                    if (field != 0) break;
                    return 1.0;
                }
                case 1: {
                    return this.circleinfield(size, field, Math.sqrt(this.u * this.u + this.v * this.v));
                }
                case 2: {
                    if (field == 2) {
                        return 0.0;
                    }
                    double d = Math.sqrt(this.u * this.u + this.v * this.v);
                    return this.circleinfield(size, field, d) - this.circleinfield(this.annulusf * (float)size, field, d);
                }
                case 3: {
                    double proj = Math.abs((double)this.u * Math.cos(angle) + (double)this.v * Math.sin(angle));
                    switch (field) {
                        case 0: {
                            return 0.5 + this.limit((75.0 - proj) / (double)this.outerrf, -0.5, 0.5);
                        }
                        case 1: {
                            return this.limit((75.0 - proj) / (double)this.innerrf, -0.5, 0.5) - this.limit((75.0 - proj) / (double)this.outerrf, -0.5, 0.5);
                        }
                        case 4: {
                            if (!(angle > 1.3962634015954636) || !(angle < 1.7453292519943295)) break block0;
                            return -this.limit((Math.abs(this.v) - 75 + 25) / 50, 0.0, 1.0) + this.limit((Math.abs(this.v) - 75 + 8) / 16, 0.0, 1.0);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (field) {
                        case 0: {
                            return 0.003 * this.intrusion(this.outerrf / 2, size, angle);
                        }
                        case 1: {
                            return 0.01 * this.intrusion(this.innerrf / 2, size, angle) - 0.003 * this.intrusion(this.outerrf / 2, size, angle);
                        }
                        case 2: {
                            if (size >= 18) break block0;
                            return 0.01 * this.intrusion(50.0, size, angle);
                        }
                        case 4: {
                            return this.lintrusion(8.0, size, angle) - this.lintrusion(25.0, size, angle);
                        }
                        case 5: {
                            if (!(angle > 1.3962634015954636 && angle < 1.7453292519943295) && (!(angle > 4.537856055185257) || !(angle < 4.886921905584122)) || Math.abs(this.v) >= 70) break block0;
                            return 0.04 * (double)(this.v - this.ov) * this.limit((40 - Math.abs(this.u) + size) / 80, 0.0, 1.0);
                        }
                        case 6: {
                            if (!(angle > 1.3962634015954636 && angle < 1.7453292519943295) && (!(angle > 4.537856055185257) || !(angle < 4.886921905584122)) || Math.abs(this.v) >= 70 || this.u - size <= -80 || this.u + size >= 80) break block0;
                            return 0.001 * (double)size * (double)(this.v - this.ov);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (field) {
                        case 0: {
                            int i = 0;
                            while (i < this.ntexdots) {
                                if ((this.u + this.du[i]) * (this.u + this.du[i]) + (this.v + this.dv[i]) * (this.v + this.dv[i]) < this.outerrf / 2 * (this.outerrf / 2)) {
                                    act = (float)((double)act + 0.04);
                                }
                                ++i;
                            }
                            break block41;
                        }
                        case 1: {
                            int i = 0;
                            while (i < this.ntexdots) {
                                double dist = (this.u + this.du[i]) * (this.u + this.du[i]) + (this.v + this.dv[i]) * (this.v + this.dv[i]);
                                if (dist < (double)(this.innerrf / 2 * (this.innerrf / 2))) {
                                    act = (float)((double)act + 0.25);
                                } else if (dist < (double)(this.outerrf / 2 * (this.outerrf / 2))) {
                                    act = (float)((double)act - 0.08);
                                }
                                ++i;
                            }
                            break block41;
                        }
                        case 2: {
                            int i = 0;
                            while (i < this.ntexdots) {
                                if ((this.u + this.du[i]) * (this.u + this.du[i]) + (this.v + this.dv[i]) * (this.v + this.dv[i]) < 3025) {
                                    return 1.0;
                                }
                                ++i;
                            }
                            break block41;
                        }
                        case 3: {
                            return 0.05 * (double)(this.u - this.ou);
                        }
                        case 4: {
                            int i = 0;
                            while (i < this.ntexdots) {
                                if (this.v + this.dv[i] > -8 && this.v + this.dv[i] < 8) {
                                    act = (float)((double)act + 0.25);
                                } else if (this.v + this.dv[i] > -25 && this.v + this.dv[i] < 25) {
                                    act = (float)((double)act - 0.08);
                                }
                                ++i;
                            }
                            break block0;
                        }
                    }
                }
            }
        }
        return act;
    }

    public double limit(double v, double l, double h) {
        if (v < l) {
            return l;
        }
        if (v > h) {
            return h;
        }
        return v;
    }

    public double acos(double f) {
        return Math.acos(f);
    }

    public double limu(double a, double b) {
        return a < b ? a : b;
    }

    public double overlap(double d1, double d2, double dist) {
        return 0.01 * this.limu(d1, d2) * this.limit((d1 + d2 - 2.0 * dist) / (d1 + d2 - Math.abs(d1 - d2)), 0.0, 1.0);
    }

    public double segment(double zz, double r) {
        if (Math.abs(zz) > r) {
            if (zz < 0.0) {
                return 0.0;
            }
            return Math.PI * r * r;
        }
        double triangle = zz * Math.sqrt(r * r - zz * zz);
        if (zz < 0.0) {
            return r * r * this.acos(-zz / r) + triangle;
        }
        return r * r * (Math.PI - this.acos(zz / r)) + triangle;
    }

    public double intrusion(double rad, double size, double angle) {
        double y1;
        double x1;
        double dy = size * Math.cos(-angle);
        double dx = size * Math.sin(-angle);
        double dz = dx * (x1 = (double)this.u - dx / 2.0) + dy * (y1 = (double)this.v - dy / 2.0);
        double ww = dz * dz - size * size * (x1 * x1 + y1 * y1 - rad * rad);
        if (ww <= 0.0) {
            return 0.0;
        }
        double l1 = (-dz - Math.sqrt(ww)) / size;
        double l2 = (-dz + Math.sqrt(ww)) / size;
        return this.limit(l2, 0.0, size) - this.limit(l1, 0.0, size);
    }

    public double lintrusion(double a, double size, double angle) {
        double cos = Math.cos(angle);
        if (Math.abs(cos) > 0.05) {
            return this.limit((Math.abs(cos * size / 2.0) + 1.0 - (double)Math.abs(this.v)) / (2.0 * a), 0.0, 1.0);
        }
        if ((double)Math.abs(this.v) < a) {
            return 8.0 * size / (100.0 + a);
        }
        return 0.0;
    }

    public double circleinfield(double size, int f, double d) {
        switch (f) {
            case 0: {
                return this.overlap(120.0, size, d);
            }
            case 1: {
                return this.overlap(32.0, size, d) - 0.27 * this.overlap(120.0, size, d);
            }
            case 2: {
                if (!(size < 22.0) || !(d < 50.0)) break;
                return 1.0;
            }
            case 4: {
                return 0.003 * (this.segment(8 + this.v, size / 2.0) - this.segment(this.v - 8, size / 2.0)) - 0.001005 * (this.segment(this.v + 25, size / 2.0) - this.segment(this.v - 25, size / 2.0));
            }
        }
        return 0.0;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.ap != null && this.ap.timer != null) {
            this.ap.timer.stop();
        }
    }

    void doFillShape(Graphics g, Shape p) {
        ExtraGraphics.doFillShape(g, p);
    }

    void doFillShape(Graphics g, Rectangle r) {
        ExtraGraphics.doFillShape(g, r);
    }

    public class RFScreen
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        public int ox;
        public int oy;
        Shape stim_shape;
        boolean pressing = false;

        public RFScreen() {
            this.setBorder(NeurolabExhibit.loweredbevel);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.fillMe(g, this.getBackColor());
            NeurolabExhibit.antiAlias(g);
            g.setColor(Color.green);
            this.drawRF(g);
        }

        public void fillMe(Graphics g, Color c) {
            g.setColor(c);
            g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }

        public void drawRF(Graphics g) {
            if (ReceptiveFields.this.r_reveal.isSelected()) {
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g.setColor(Color.green);
                switch (ReceptiveFields.this.r_typepanel.getSelected()) {
                    case 1: {
                        g.drawOval(cx - 15, cy - 15, 32, 32);
                    }
                    case 0: 
                    case 2: {
                        g.drawOval(cx - 60, cy - 60, 120, 120);
                        break;
                    }
                    case 3: {
                        g.drawOval(cx - 60, cy - 60, 120, 120);
                        g.drawLine(cx - 40, cy, cx + 40, cy);
                        g.drawLine(cx + 40, cy, cx + 30, cy - 10);
                        g.drawLine(cx + 40, cy, cx + 30, cy + 10);
                        break;
                    }
                    case 4: {
                        int[] l_ht = new int[]{-25, -8, 8, 25};
                        int i = 0;
                        while (i < 4) {
                            g.drawLine(2, cy + l_ht[i], this.getWidth() - 2, cy + l_ht[i]);
                            ++i;
                        }
                        g.drawLine(2, cy + l_ht[0], 2, cy + l_ht[3]);
                        g.drawLine(this.getWidth() - 2, cy - l_ht[0], this.getWidth() - 2, cy + l_ht[3]);
                        break;
                    }
                    case 5: 
                    case 6: {
                        g.drawRect(cx - 40, cy - 60, 80, 120);
                        g.drawLine(cx, cy - 40, cx, cy + 40);
                        g.drawLine(cx, cy + 40, cx - 10, cy + 30);
                        g.drawLine(cx, cy + 40, cx + 10, cy + 30);
                    }
                }
            }
        }

        public Color getForeColor() {
            return ReceptiveFields.this.s_invert.isSelected() ? Color.black : Color.white;
        }

        public Color getBackColor() {
            return ReceptiveFields.this.s_invert.isSelected() ? Color.white : Color.black;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int size = ReceptiveFields.this.s_size.slider.getValue();
            switch (ReceptiveFields.this.s_typepanel.getSelected()) {
                case 0: {
                    this.stim_shape = new GeneralPath(new Rectangle(-this.getWidth(), -this.getHeight(), this.getWidth() * 3, this.getHeight() * 3));
                    break;
                }
                case 1: {
                    this.stim_shape = new GeneralPath(new Ellipse2D.Float(x - size / 2, y - size / 2, size, size));
                    break;
                }
                case 2: {
                    GeneralPath p = new GeneralPath(new Ellipse2D.Float(x - size / 2, y - size / 2, size, size));
                    this.stim_shape = p;
                    p.setWindingRule(0);
                    p.append(new Ellipse2D.Float((float)x - ReceptiveFields.this.annulusf * (float)size / 2.0f, (float)y - ReceptiveFields.this.annulusf * (float)size / 2.0f, ReceptiveFields.this.annulusf * (float)size, ReceptiveFields.this.annulusf * (float)size), true);
                    break;
                }
                case 3: {
                    this.stim_shape = AffineTransform.getRotateInstance((double)(ReceptiveFields.this.s_angle.getValue() + 90) * Math.PI / 180.0, x, y).createTransformedShape(new Rectangle(x - 350, y - 70, 700, 140));
                    break;
                }
                case 4: {
                    this.stim_shape = AffineTransform.getRotateInstance((double)(ReceptiveFields.this.s_angle.getValue() + 90) * Math.PI / 180.0, x, y).createTransformedShape(new Rectangle(x - size / 2, y - 2, size, 4));
                    break;
                }
                case 5: {
                    Rectangle square = new Rectangle(x, y, 4, 4);
                    GeneralPath gp = new GeneralPath(square);
                    Random r = new Random(0L);
                    int i = 0;
                    while (i < ReceptiveFields.this.ntexdots) {
                        ReceptiveFields.this.du[i] = r.nextInt() % 50;
                        ReceptiveFields.this.dv[i] = r.nextInt() % 50;
                        gp.append(AffineTransform.getTranslateInstance(ReceptiveFields.this.du[i], ReceptiveFields.this.dv[i]).createTransformedShape(square), true);
                        ++i;
                    }
                    this.stim_shape = gp;
                }
            }
            Graphics g = this.getGraphics();
            this.ox = x;
            this.oy = y;
            g.setColor(this.getForeColor());
            g.clipRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            NeurolabExhibit.antiAlias(g);
            ReceptiveFields.this.doFillShape(g, this.stim_shape);
            this.drawRF(g);
            this.pressing = true;
            ReceptiveFields.this.showActivity(ReceptiveFields.this.calculate());
        }

        public void mouseDragged(MouseEvent e) {
            Graphics g = this.getGraphics();
            g.clipRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            g.setColor(this.getBackColor());
            ReceptiveFields.this.doFillShape(g, this.stim_shape);
            ReceptiveFields.this.doFillShape(g, this.stim_shape.getBounds());
            int dx = e.getX() - this.ox;
            int dy = e.getY() - this.oy;
            NeurolabExhibit.antiAlias(g);
            this.stim_shape = AffineTransform.getTranslateInstance(dx, dy).createTransformedShape(this.stim_shape);
            g.setColor(this.getForeColor());
            ReceptiveFields.this.doFillShape(g, this.stim_shape);
            this.drawRF(g);
            this.ox = e.getX();
            this.oy = e.getY();
            ReceptiveFields.this.showActivity(ReceptiveFields.this.calculate());
        }

        public void mouseReleased(MouseEvent e) {
            this.pressing = false;
            Graphics g = this.getGraphics();
            g.setColor(this.getBackColor());
            g.clipRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            NeurolabExhibit.antiAlias(g);
            ReceptiveFields.this.doFillShape(g, this.stim_shape);
            ReceptiveFields.this.doFillShape(g, this.stim_shape.getBounds());
            this.drawRF(g);
            ReceptiveFields.this.showActivity(ReceptiveFields.this.calculate());
        }
    }
}

