/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.AngleControl;
import com.neurolab.common.JPanel0;
import com.neurolab.common.Label3D;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PosturalEquilibrium
extends NeurolabExhibit {
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel0();
    JCheckBox neck = new JCheckBox();
    JCheckBox vestibular = new JCheckBox();
    JCheckBox support = new JCheckBox();
    Border border1;
    TitledBorder titledBorder1;
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel4 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    JPanel jPanel5 = new JPanel0();
    Label3D label3D1 = new Label3D();
    Label3D label3D2 = new Label3D();
    Label3D label3D3 = new Label3D();
    AngleControl slope = new AngleControl();
    AngleControl head = new AngleControl();
    JPanel jPanel6 = new JPanel0();
    Border border2;
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel7 = new JPanel0();
    Border border3;
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel graph = new JPanel0(){

        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            try {
                g.setColor(Color.cyan);
                g.fillRect(-20, -100, 440, 400);
                int[] nArray = new int[4];
                nArray[1] = this.getWidth();
                nArray[2] = this.getWidth();
                Polygon grass = new Polygon(nArray, new int[]{PosturalEquilibrium.this.j * 120 / 100 + 5, PosturalEquilibrium.this.i * 120 / 100 + 5, 400, 400}, 4);
                g.setColor(Color.green);
                g.fillPolygon(grass);
                NeurolabExhibit.setStrokeThickness(g, 4.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            g.translate(65, 30);
            g.setColor(Color.black);
            g.drawPolyline(new int[]{PosturalEquilibrium.this.lx, PosturalEquilibrium.this.nx, PosturalEquilibrium.this.px, PosturalEquilibrium.this.qx}, new int[]{PosturalEquilibrium.this.ly, PosturalEquilibrium.this.ny, PosturalEquilibrium.this.py, PosturalEquilibrium.this.qy}, 4);
            g.drawPolyline(new int[]{PosturalEquilibrium.this.gx, PosturalEquilibrium.this.fx, PosturalEquilibrium.this.ex, PosturalEquilibrium.this.bx, PosturalEquilibrium.this.lx, PosturalEquilibrium.this.mx}, new int[]{PosturalEquilibrium.this.gy, PosturalEquilibrium.this.fy, PosturalEquilibrium.this.ey, PosturalEquilibrium.this.by, PosturalEquilibrium.this.ly, PosturalEquilibrium.this.my}, 6);
            g.drawPolyline(new int[]{PosturalEquilibrium.this.dx, PosturalEquilibrium.this.bx, PosturalEquilibrium.this.ax, PosturalEquilibrium.this.cx}, new int[]{PosturalEquilibrium.this.dy, PosturalEquilibrium.this.by, PosturalEquilibrium.this.ay, PosturalEquilibrium.this.cy}, 4);
            g.drawOval(PosturalEquilibrium.this.rx, PosturalEquilibrium.this.ry, 2, 2);
            g.setColor(Color.red);
            g.drawLine(PosturalEquilibrium.this.hx, PosturalEquilibrium.this.hy, PosturalEquilibrium.this.hx, PosturalEquilibrium.this.hy + 45);
            g.drawLine(PosturalEquilibrium.this.hx, PosturalEquilibrium.this.hy + 45, PosturalEquilibrium.this.hx + 7, PosturalEquilibrium.this.hy + 37);
            g.drawLine(PosturalEquilibrium.this.hx, PosturalEquilibrium.this.hy + 45, PosturalEquilibrium.this.hx - 7, PosturalEquilibrium.this.hy + 37);
            g.translate(0, -80);
        }
    };
    public Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PosturalEquilibrium.this.calculate();
            PosturalEquilibrium.this.graph.repaint();
        }
    });
    int body;
    int oldbody;
    int oldslope;
    int oldhead;
    double ctheta;
    double stheta;
    int x0;
    int y0;
    int ax;
    int ay;
    int bx;
    int by;
    int cx;
    int cy;
    int dx;
    int dy;
    int ex;
    int ey;
    int fx;
    int fy;
    int gx;
    int gy;
    int hx;
    int hy;
    int lx;
    int ly;
    int mx;
    int my;
    int nx;
    int ny;
    int px;
    int py;
    int qx;
    int qy;
    int rx;
    int ry;
    double k1;
    double k2;
    int xx;
    int beta1;
    int beta2;
    int nnx;
    int nny;
    int eex;
    int eey;
    final double scaler = 0.15;
    int i;
    int j;

    public String getExhibitName() {
        return "Posture";
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.oldbody = 5;
        this.oldslope = 0;
        this.i = 170;
        this.j = 170;
        this.oldhead = 5;
        this.slope_change();
        this.timer.start();
    }

    public int limu(int a, int b) {
        return a > b ? b : a;
    }

    public int liml(int a, int b) {
        return a > b ? a : b;
    }

    public void calculate() {
        int Head = this.head.getValue();
        int Slope = -this.slope.getValue();
        if (this.support.isSelected()) {
            this.body -= this.oldbody * 2 / 10;
        }
        if (this.neck.isSelected()) {
            this.body -= 2 * Head / 10;
        }
        if (this.vestibular.isSelected()) {
            this.body -= 2 * (this.oldbody - Head) / 10;
        }
        this.body = this.limu(this.body, Slope + 38);
        this.body = this.liml(this.body, Slope - 38);
        if (this.body == this.oldbody && Head == this.oldhead && Slope == this.oldslope) {
            return;
        }
        this.oldbody = this.body;
        this.oldhead = Head;
        this.oldslope = Slope;
        double cam = 0.15 * Math.cos(Math.PI / 180 * (double)(this.body - Head));
        double sam = 0.15 * Math.sin(Math.PI / 180 * (double)(this.body - Head));
        double cal = 0.15 * Math.cos(Math.PI / 180 * (double)this.body);
        double sal = 0.15 * Math.sin(Math.PI / 180 * (double)this.body);
        this.x0 = 140;
        this.y0 = 120;
        this.bx = this.x0 - (int)(300.0 * sal + 400.0 * cal);
        this.by = this.y0 - (int)(300.0 * cal - 400.0 * sal);
        this.ax = this.bx - (int)(300.0 * cam);
        this.ay = this.by + (int)(300.0 * sam);
        this.cx = this.bx - (int)(100.0 * sam);
        this.cy = this.by - (int)(100.0 * cam);
        this.dx = this.bx - (int)(200.0 * sam);
        this.dy = this.by - (int)(200.0 * cam);
        this.rx = this.bx - (int)(60.0 * cam + 60.0 * sam);
        this.ry = this.by + (int)(60.0 * sam - 60.0 * cam);
        this.lx = this.bx + (int)(800.0 * cal);
        this.ly = this.by - (int)(800.0 * sal);
        this.gx = this.x0 - (int)(600.0 * this.ctheta);
        this.gy = this.y0 + (int)(600.0 * this.stheta);
        this.fx = this.x0 - (int)(500.0 * this.ctheta);
        this.fy = this.y0 + (int)(500.0 * this.stheta);
        this.qx = this.x0 + (int)(400.0 * this.ctheta);
        this.qy = this.y0 - (int)(400.0 * this.stheta);
        this.px = this.x0 + (int)(500.0 * this.ctheta);
        this.py = this.y0 - (int)(500.0 * this.stheta);
        this.nnx = (this.lx + this.px) / 2;
        this.nny = (this.ly + this.py) / 2;
        this.xx = 2025 - ((this.lx - this.nnx) * (this.lx - this.nnx) + (this.ly - this.nny) * (this.ly - this.nny));
        this.xx = this.liml(this.xx, 0);
        this.k1 = Math.sqrt(this.xx);
        this.nx = this.nnx - (int)((double)(this.nnx - this.x0) * this.k1 / 75.0);
        this.ny = this.nny + (int)((double)(this.y0 - this.nny) * this.k1 / 75.0);
        this.eex = (this.bx + this.fx) / 2;
        this.eey = (this.by + this.fy) / 2;
        this.xx = 2025 - ((this.bx - this.eex) * (this.bx - this.eex) + (this.by - this.eey) * (this.by - this.eey));
        this.xx = this.liml(this.xx, 0);
        this.k2 = Math.sqrt(this.xx);
        this.ex = this.eex - (int)((double)(this.eex - this.x0) * this.k2 / 75.0);
        this.ey = this.eey + (int)((double)(this.y0 - this.eey) * this.k2 / 75.0);
        this.mx = this.lx + (int)(45.0 * Math.cos(Math.PI / 180 * (double)(this.body + 45)));
        this.my = this.ly - (int)(45.0 * Math.sin(Math.PI / 180 * (double)(this.body + 45)));
        this.hx = (this.bx + this.lx) / 2;
        this.hy = (this.by + this.ly) / 2;
    }

    private void jbInit() throws Exception {
        this.neck.setBackground(NeurolabExhibit.systemGray);
        this.vestibular.setBackground(NeurolabExhibit.systemGray);
        this.support.setBackground(NeurolabExhibit.systemGray);
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Reflexes");
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.neck.setText("Neck");
        this.jPanel2.setPreferredSize(new Dimension(150, 35));
        this.vestibular.setText("Vestibular");
        this.jPanel3.setBorder(this.titledBorder1);
        this.jPanel3.setPreferredSize(new Dimension(170, 120));
        this.jPanel3.setLayout(this.flowLayout1);
        this.support.setToolTipText("");
        this.support.setText("Positive supporting");
        this.flowLayout1.setAlignment(0);
        this.jPanel5.setLayout(null);
        this.label3D1.setFont(new Font("SansSerif", 1, 16));
        this.label3D1.setText("Slope");
        this.label3D1.setBounds(new Rectangle(12, 24, 56, 22));
        this.label3D2.setFont(new Font("SansSerif", 1, 16));
        this.label3D2.setText("Head");
        this.label3D2.setBounds(new Rectangle(16, 83, 49, 20));
        this.label3D3.setFont(new Font("SansSerif", 1, 16));
        this.label3D3.setText("tilt");
        this.label3D3.setBounds(new Rectangle(34, 100, 33, 21));
        this.slope.setForeground(SystemColor.menuText);
        this.slope.setFont(new Font("SansSerif", 1, 12));
        this.slope.setPrefix("");
        this.slope.setZero(90);
        this.slope.setMaximum(30);
        this.slope.setMinimum(-30);
        this.slope.setBounds(new Rectangle(77, 5, 40, 62));
        this.slope.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                PosturalEquilibrium.this.slope_mouseDragged(e);
            }
        });
        this.head.setForeground(SystemColor.menuText);
        this.head.setFont(new Font("Serif", 1, 12));
        this.head.setPrefix("");
        this.head.setZero(90);
        this.head.setMaximum(45);
        this.head.setMinimum(-45);
        this.head.setBounds(new Rectangle(77, 75, 40, 60));
        this.jPanel6.setBorder(this.border2);
        this.jPanel6.setLayout(this.borderLayout4);
        this.jPanel7.setBorder(this.border3);
        this.jPanel7.setLayout(this.borderLayout5);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.vestibular, null);
        this.jPanel3.add((Component)this.neck, null);
        this.jPanel3.add((Component)this.support, null);
        this.jPanel2.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.returnButton1, null);
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.label3D1, null);
        this.jPanel5.add((Component)this.head, null);
        this.jPanel5.add((Component)this.slope, null);
        this.jPanel5.add((Component)this.label3D2, null);
        this.jPanel5.add((Component)this.label3D3, null);
        this.jPanel1.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.jPanel7, "Center");
        this.jPanel7.add((Component)this.graph, "Center");
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    void slope_change() {
        int Slope = -this.slope.getValue();
        this.body = this.body + Slope - this.oldslope;
        this.stheta = 0.15 * Math.sin(Math.PI / 180 * (double)Slope);
        this.ctheta = 0.15 * Math.cos(Math.PI / 180 * (double)Slope);
        this.i = 120 - (int)(140.0 * this.stheta / this.ctheta);
        this.j = 120 + (int)(160.0 * this.stheta / this.ctheta);
    }

    void slope_mouseDragged(MouseEvent e) {
        this.slope_change();
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
    }
}

