/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.ActionPotentials;
import com.neurolab.common.JPanel0;
import com.neurolab.common.Label3D;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;

public class PhaseLocking
extends NeurolabExhibit
implements ActionListener {
    public static int numcells = 20;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    JLabel jLabel1 = new JLabel();
    JSlider frequency = new JSlider();
    JLabel jLabel2 = new JLabel();
    JSlider intensity = new JSlider();
    ReturnButton returnButton1 = new ReturnButton();
    JPanel jPanel2 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel jPanel3 = new JPanel0();
    JPanel jPanel4 = new JPanel0();
    Border border2;
    Label3D label3D1 = new Label3D();
    Label3D label3D2 = new Label3D();
    Label3D label3D3 = new Label3D();
    Label3D label3D4 = new Label3D();
    Label3D label3D5 = new Label3D();
    Border border3;
    Border border4;
    Oscilloscope osc = new Oscilloscope(numcells + 2, this);
    BorderLayout borderLayout3 = new BorderLayout();
    Timer timer = new Timer(50, this);
    int[] base = new int[numcells + 2];
    Color[] cols = new Color[numcells + 2];
    ActionPotentials ap;
    int[] y = new int[numcells + 2];
    int[] refractory = new int[numcells];
    int t = 0;
    Random r = new Random();

    public String getExhibitName() {
        return "Phase Locking";
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.base[0] = 30;
        this.cols[0] = Color.red;
        int i = 0;
        while (i < numcells) {
            this.base[i + 1] = 55 + i * 110 / numcells;
            this.cols[i + 1] = Color.cyan;
            ++i;
        }
        this.base[PhaseLocking.numcells + 1] = 200;
        this.cols[PhaseLocking.numcells + 1] = Color.yellow;
        this.osc.setBaseY(this.base);
        this.osc.setColors(this.cols);
        this.osc.timer.setDelay(50);
        this.osc.xSpeed = 2;
        this.timer.start();
        this.ap = new ActionPotentials();
        this.ap.setRate(0.0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Sweep") {
            if (this.osc != null) {
                this.osc.clear.doClick();
            }
        } else {
            int total = 0;
            double s = 0.7 * (double)this.intensity.getValue() * Math.sin((double)(++this.t * 2) * Math.PI * (double)this.frequency.getValue() / 2000.0);
            this.y[0] = -((int)s);
            int i = 0;
            while (i < numcells) {
                this.y[i + 1] = 0;
                if (this.refractory[i] > 0) {
                    int n = i;
                    this.refractory[n] = this.refractory[n] - 1;
                } else if (s > -1.0 + Math.random() * 100.0) {
                    this.refractory[i] = 20 + this.r.nextInt() % 40;
                    this.y[i + 1] = -20;
                }
                total += this.y[i + 1];
                ++i;
            }
            this.y[PhaseLocking.numcells + 1] = total;
            if (total < 0 & this.ap != null) {
                this.ap.doSingleAP();
            }
            this.osc.setPosY(this.y);
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border3 = BorderFactory.createLineBorder(Color.lightGray, 1);
        this.border4 = BorderFactory.createLineBorder(Color.lightGray, 1);
        this.jLabel1.setText("Frequency");
        this.frequency.setBackground(NeurolabExhibit.systemGray);
        this.jLabel2.setText("Intensity");
        this.frequency.setMaximum(200);
        this.frequency.setMinimum(20);
        this.frequency.setPreferredSize(new Dimension(100, 24));
        this.frequency.setBorder(this.border3);
        this.intensity.setPreferredSize(new Dimension(100, 24));
        this.intensity.setBorder(this.border4);
        this.intensity.setBackground(NeurolabExhibit.systemGray);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel2.setBorder(this.border1);
        this.jPanel4.setBorder(this.border2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jPanel3.setPreferredSize(new Dimension(110, 10));
        this.jPanel3.setLayout(null);
        this.label3D1.setFont(new Font("SansSerif", 1, 16));
        this.label3D1.setText("Stimulus");
        this.label3D1.setBounds(new Rectangle(19, 25, 83, 22));
        this.label3D2.setFont(new Font("SansSerif", 1, 16));
        this.label3D2.setText("Individual");
        this.label3D2.setBounds(new Rectangle(8, 96, 98, 27));
        this.label3D3.setFont(new Font("SansSerif", 1, 16));
        this.label3D3.setText("fibres");
        this.label3D3.setBounds(new Rectangle(47, 120, 56, 22));
        this.label3D4.setFont(new Font("SansSerif", 1, 16));
        this.label3D4.setText("Total");
        this.label3D4.setBounds(new Rectangle(50, 170, 51, 27));
        this.label3D5.setFont(new Font("SansSerif", 1, 16));
        this.label3D5.setText("activity");
        this.label3D5.setBounds(new Rectangle(30, 192, 71, 24));
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.frequency, null);
        this.jPanel1.add((Component)this.jLabel2, null);
        this.jPanel1.add((Component)this.intensity, null);
        this.jPanel1.add((Component)this.returnButton1, null);
        this.jPanel2.add((Component)this.jPanel3, "West");
        this.jPanel3.add((Component)this.label3D1, null);
        this.jPanel3.add((Component)this.label3D4, null);
        this.jPanel3.add((Component)this.label3D5, null);
        this.jPanel3.add((Component)this.label3D2, null);
        this.jPanel3.add((Component)this.label3D3, null);
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.osc, "Center");
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "South");
        this.getMainContainer().add((Component)this.jPanel2, "Center");
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
    }
}

