/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.ThickPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PassiveCurrents
extends NeurolabExhibit
implements ActionListener,
ChangeListener {
    private Timer timer;
    private float[] decay;
    private int ndecay = 100;
    JPanel lpanel;
    JPanel rpanel;
    JPanel blpanel;
    JPanel trpanel;
    JPanel mrpanel;
    NeurolabExhibit.NamedSliderPanel spacec;
    NeurolabExhibit.NamedSliderPanel timec;
    JButton start;
    JButton stop;
    JRadioButton charge;
    JRadioButton current;
    TitledBorder tborder1;
    ButtonGroup ch_or_cur;
    ThickPanel tlpanel;
    GraphPanel graph;
    boolean initialrun = false;
    float vscale;

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.createComponents();
        this.timer = new Timer(100, this);
        this.ndecay = 52;
        this.decay = new float[this.ndecay];
    }

    public void createComponents() {
        this.lpanel = new JPanel();
        this.getMainContainer().add((Component)this.lpanel, "West");
        this.rpanel = new JPanel();
        this.getMainContainer().add((Component)this.rpanel, "East");
        this.lpanel.setLayout(new BorderLayout());
        this.blpanel = new JPanel();
        this.lpanel.add((Component)this.blpanel, "South");
        this.tlpanel = new ThickPanel(10);
        this.lpanel.add((Component)this.tlpanel, "North");
        NeurolabExhibit.setBG(this.lpanel);
        NeurolabExhibit.setBG(this.rpanel);
        NeurolabExhibit.setBG(this.blpanel);
        this.graph = new GraphPanel();
        this.tlpanel.inner.add(this.graph);
        this.blpanel.setLayout(new GridLayout(1, 2));
        this.start = new JButton("Start");
        this.blpanel.add(this.start);
        this.stop = new JButton("Stop");
        this.blpanel.add(this.stop);
        this.start.addActionListener(this);
        this.stop.addActionListener(this);
        NeurolabExhibit.setBG(this.start);
        NeurolabExhibit.setBG(this.stop);
        this.rpanel.setLayout(new BorderLayout());
        this.rpanel.add((Component)new ReturnButton(), "South");
        this.trpanel = new JPanel();
        this.rpanel.add((Component)this.trpanel, "North");
        this.mrpanel = new JPanel();
        this.rpanel.add((Component)this.mrpanel, "Center");
        NeurolabExhibit.setBG(this.trpanel);
        NeurolabExhibit.setBG(this.mrpanel);
        this.tborder1 = BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Apply:");
        this.trpanel.setBorder(this.tborder1);
        this.trpanel.setLayout(new BorderLayout());
        this.charge = new JRadioButton("Charge");
        this.trpanel.add((Component)this.charge, "North");
        this.current = new JRadioButton("Current");
        this.trpanel.add((Component)this.current, "South");
        this.ch_or_cur = new ButtonGroup();
        this.ch_or_cur.add(this.charge);
        this.ch_or_cur.add(this.current);
        this.current.addChangeListener(this);
        Font arial14 = new Font("Arial", 0, 14);
        this.current.setFont(arial14);
        this.charge.setFont(arial14);
        NeurolabExhibit.setBG(this.charge);
        NeurolabExhibit.setBG(this.current);
        this.mrpanel.setLayout(new BorderLayout());
        this.spacec = new NeurolabExhibit.NamedSliderPanel("Space-constant", 100, NeurolabExhibit.LABEL_POS_BELOW);
        this.mrpanel.add((Component)this.spacec, "North");
        JPanel tmp = new JPanel();
        tmp.setLayout(new BorderLayout());
        this.mrpanel.add((Component)tmp, "Center");
        this.timec = new NeurolabExhibit.NamedSliderPanel("Time-constant", 100, NeurolabExhibit.LABEL_POS_BELOW);
        tmp.add((Component)this.timec, "North");
        NeurolabExhibit.setBG(tmp);
        this.charge.setSelected(true);
        this.spacec.slider.setValue(100);
        this.timec.slider.setValue(30);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Start") {
            this.graph.repaint();
            this.initDecay();
            this.timer.start();
        } else if (e.getActionCommand() == "Stop") {
            this.timer.stop();
        } else {
            this.tick();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.initDecay();
    }

    public void initDecay() {
        int i = 0;
        while (i < this.ndecay) {
            this.decay[i] = 0.0f;
            ++i;
        }
        this.decay[1] = 80.0f;
        this.initialrun = true;
    }

    public void tick() {
        float tau = this.timec.slider.getValue() / 4 + 5;
        float lambda = this.spacec.slider.getValue() * 2 / 25 + 2;
        float[] d = new float[this.ndecay];
        float X = 0.002f / tau;
        float Y = X * (lambda * lambda) * 5.0f;
        X = 1.0f - 2.0f * Y - X;
        int j = 0;
        while (j < 200) {
            int i = 1;
            while (i < this.ndecay - 1) {
                d[i] = X * this.decay[i] + Y * (this.decay[i - 1] + this.decay[i + 1]);
                ++i;
            }
            d[this.ndecay - 1] = 0.8f * d[this.ndecay - 2];
            d[0] = d[2];
            if (this.current.isSelected()) {
                d[1] = 80.0f;
            }
            this.decay = d;
            ++j;
        }
        if (this.initialrun) {
            this.vscale = 80.0f / this.decay[1];
            this.initialrun = false;
        }
        Graphics g = this.graph.getGraphics();
        int ct = this.graph.getWidth() / 2;
        g.setColor(Color.green);
        int Y0 = this.graph.getHeight() - 15;
        int ohp = 0;
        int oht = (int)((double)Y0 - 2.5 * (double)this.vscale * (double)this.decay[1]);
        int i = 1;
        while (i < this.ndecay) {
            int ht = (int)((double)Y0 - 2.5 * (double)this.vscale * (double)this.decay[i]);
            int hp = (i - 1) * (ct - 20) / this.ndecay;
            g.drawLine(ct - ohp, oht, ct - hp, ht);
            g.drawLine(ct + ohp, oht, ct + hp, ht);
            oht = ht;
            ohp = hp;
            ++i;
        }
    }

    public String getExhibitName() {
        return "Passive Currents";
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
    }

    class GraphPanel
    extends JPanel {
        public int base = 15;

        GraphPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.black);
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            g.setColor(Color.gray);
            g.drawLine(1, this.getHeight() - this.base, this.getWidth(), this.getHeight() - this.base);
            g.setColor(new Color(0, 128, 0));
            g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - this.base);
        }

        public Dimension getPreferredSize() {
            return new Dimension(420, 250);
        }
    }
}

