/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.LineOrArrowPanel;
import com.neurolab.common.JPanel0;
import com.neurolab.common.JRadioButton0;
import com.neurolab.common.Label3D;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.SignalGenerator;
import com.neurolab.common.SignalListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.border.Border;

public class ParametricFeedback
extends NeurolabExhibit
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    JPanel jPanel2 = new JPanel0();
    Border border1;
    GridLayout gridLayout1 = new GridLayout();
    JRadioButton jRadioButton1 = new JRadioButton0();
    JRadioButton jRadioButton2 = new JRadioButton0();
    JRadioButton jRadioButton3 = new JRadioButton0();
    JRadioButton jRadioButton4 = new JRadioButton0();
    JRadioButton jRadioButton5 = new JRadioButton0();
    JRadioButton jRadioButton6 = new JRadioButton0();
    JPanel jPanel3 = new JPanel0();
    Border border2;
    JScrollBar gain = new JScrollBar();
    Label3D label3D1 = new Label3D();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel4 = new JPanel0();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel gaintext = new JLabel();
    Oscilloscope ohead = new Oscilloscope();
    Oscilloscope obackground = new Oscilloscope();
    Oscilloscope oslip = new Oscilloscope();
    Oscilloscope oeye = new Oscilloscope();
    Border border3;
    Label3D label3D2 = new Label3D();
    Label3D label3D3 = new Label3D();
    BorderLayout borderLayout3 = new BorderLayout();
    Label3D lbackground = new Label3D();
    private LineOrArrowPanel inhib1;
    private LineOrArrowPanel arrow5;
    private LineOrArrowPanel line2;
    private LineOrArrowPanel arrow4;
    private LineOrArrowPanel arrow3;
    private LineOrArrowPanel line1;
    private LineOrArrowPanel arrow2;
    private LineOrArrowPanel arrow1;
    Label3D label3D5 = new Label3D();
    Label3D lslip = new Label3D();
    Label3D label3D7 = new Label3D();
    JCheckBox learn = new JCheckBox();
    JPanel gazepos = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.blue);
            g.fillRect((int)(ParametricFeedback.this.oX + ParametricFeedback.this.Y) + this.getWidth() / 2, 2, 5, this.getHeight() - 4);
        }
    };
    JPanel headpos = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.blue);
            g.fillRect((int)ParametricFeedback.this.oX + this.getWidth() / 2, 2, 5, this.getHeight() - 4);
        }
    };
    JPanel backpos = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.blue);
            g.fillRect((int)ParametricFeedback.this.background + this.getWidth() / 2, 2, 5, this.getHeight() - 4);
        }
    };
    JComponent[] hideInTheDark;
    JRadioButton[] mode = new JRadioButton[]{this.jRadioButton1, this.jRadioButton2, this.jRadioButton3, this.jRadioButton4, this.jRadioButton5, this.jRadioButton6};
    ButtonGroup bg = new ButtonGroup();
    ActionListener buttonlistener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ParametricFeedback.this.getModetype() == 0) {
                int i = 0;
                while (i < ParametricFeedback.this.hideInTheDark.length) {
                    ParametricFeedback.this.hideInTheDark[i].setVisible(false);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < ParametricFeedback.this.hideInTheDark.length) {
                    ParametricFeedback.this.hideInTheDark[i].setVisible(true);
                    ++i;
                }
            }
        }
    };
    SignalGenerator sig = new SignalGenerator();
    double gainval;
    double vgain;
    double Y;
    double rsv;
    double background;
    double oX;
    Label3D label3D4 = new Label3D();

    public String getExhibitName() {
        return "Parametric Feedback";
    }

    public ParametricFeedback() {
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ohead.remove(this.ohead.buttons);
        this.oeye.remove(this.oeye.buttons);
        this.obackground.remove(this.obackground.buttons);
        this.oslip.remove(this.oslip.buttons);
        int i = 0;
        while (i < this.mode.length) {
            this.bg.add(this.mode[i]);
            ++i;
        }
        this.myinit();
    }

    public int min(int a, int b) {
        return a > b ? b : a;
    }

    public void myinit() {
        this.sig.setSignalListener(new SignalListener(){

            public void signalEvent(double X) {
                ParametricFeedback.this.oX = X;
                ParametricFeedback.this.Y = X * ParametricFeedback.this.vgain;
                String gt = "0.00";
                if (Math.abs(ParametricFeedback.this.gainval) > 0.2) {
                    gt = String.valueOf(ParametricFeedback.this.gainval / 50.0);
                }
                ParametricFeedback.this.gaintext.setText(gt.substring(0, ParametricFeedback.this.min(gt.length(), 5)));
                switch (ParametricFeedback.this.getModetype()) {
                    case 0: {
                        ParametricFeedback.this.rsv = 0.0;
                        break;
                    }
                    case 1: {
                        ParametricFeedback.this.background = 0.0;
                        ParametricFeedback.this.rsv = X + ParametricFeedback.this.Y;
                        ParametricFeedback.this.vgain = 0.99 * ParametricFeedback.this.vgain - 0.01;
                        break;
                    }
                    case 2: {
                        ParametricFeedback.this.background = X;
                        ParametricFeedback.this.rsv = X + ParametricFeedback.this.Y - ParametricFeedback.this.background;
                        ParametricFeedback.this.Y += 0.9 * ParametricFeedback.this.rsv;
                        if (!(Math.abs(ParametricFeedback.this.vgain) > 1.0E-5)) break;
                        ParametricFeedback.this.vgain *= 0.99;
                        break;
                    }
                    case 3: {
                        ParametricFeedback.this.background = 0.0;
                        ParametricFeedback.this.rsv = X - ParametricFeedback.this.Y;
                        ParametricFeedback.this.vgain = 0.99 * ParametricFeedback.this.vgain + 0.01;
                        break;
                    }
                    case 4: {
                        ParametricFeedback.this.background = 0.0;
                        ParametricFeedback.this.rsv = X + 0.75 * ParametricFeedback.this.Y;
                        ParametricFeedback.this.vgain = 0.99 * ParametricFeedback.this.vgain - 0.0133;
                        break;
                    }
                    case 5: {
                        ParametricFeedback.this.background = 0.0;
                        ParametricFeedback.this.rsv = X + 1.33 * ParametricFeedback.this.Y;
                        ParametricFeedback.this.vgain = 0.99 * ParametricFeedback.this.vgain - 0.0075;
                    }
                }
                ParametricFeedback.this.Y -= 0.9 * ParametricFeedback.this.rsv;
                if (ParametricFeedback.this.learn.isSelected()) {
                    ParametricFeedback.this.gainval = 50.0 * ParametricFeedback.this.vgain;
                    ParametricFeedback.this.gain.setValue((int)(45.0 + ParametricFeedback.this.gainval / 2.0));
                }
                ParametricFeedback.this.ohead.setPosY(new int[]{(int)X * 10});
                ParametricFeedback.this.obackground.setPosY(new int[]{(int)(ParametricFeedback.this.background * 10.0)});
                ParametricFeedback.this.oslip.setPosY(new int[]{(int)(ParametricFeedback.this.rsv * 20.0)});
                ParametricFeedback.this.oeye.setPosY(new int[]{(int)(ParametricFeedback.this.Y * 10.0)});
                ParametricFeedback.this.headpos.repaint();
                ParametricFeedback.this.gazepos.repaint();
                ParametricFeedback.this.backpos.repaint();
                if (ParametricFeedback.this.ohead.getPosX() >= ParametricFeedback.this.ohead.graph.getDataWidth()) {
                    ParametricFeedback.this.sweepall();
                }
            }
        });
        int i = 0;
        while (i < this.mode.length) {
            this.mode[i].addActionListener(this.buttonlistener);
            ++i;
        }
        this.sig.frequency.setValue(15);
        this.sig.amplitude.setValue(20);
        this.sig.sinusoidal.setSelected(true);
        this.gain.setValue(30);
        this.learn.setSelected(true);
        this.mode[0].doClick();
        this.sig.timer.start();
        int[] base = new int[]{30};
        this.ohead.setBaseY(base);
        this.obackground.setBaseY(base);
        this.oslip.setBaseY(base);
        this.oeye.setBaseY(base);
        this.sweepall();
    }

    public void sweepall() {
        this.ohead.clear.doClick();
        this.obackground.clear.doClick();
        this.oslip.clear.doClick();
        this.oeye.clear.doClick();
        this.ohead.sweep.doClick();
        this.obackground.sweep.doClick();
        this.oslip.sweep.doClick();
        this.oeye.sweep.doClick();
    }

    public int getModetype() {
        int j = 0;
        int i = 0;
        while (i < this.mode.length) {
            if (this.mode[i].isSelected()) {
                j = i;
            }
            ++i;
        }
        return j;
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void jbInit() throws Exception {
        this.learn.setBackground(NeurolabExhibit.systemGray);
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border3 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.getMainContainer().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(null);
        this.returnButton1.setBounds(488, 274, 81, 30);
        this.jPanel2.setBorder(this.border1);
        this.jPanel2.setBounds(48, 243, 314, 70);
        this.jPanel2.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(3);
        this.gridLayout1.setColumns(2);
        this.jRadioButton1.setText("Dark");
        this.jRadioButton1.setFont(new Font("SansSerif", 1, 12));
        this.jRadioButton2.setText("Visual assistance");
        this.jRadioButton2.setFont(new Font("SansSerif", 1, 12));
        this.jRadioButton3.setText("Visual suppression");
        this.jRadioButton3.setFont(new Font("SansSerif", 1, 12));
        this.jRadioButton4.setText("Reversing prisms");
        this.jRadioButton4.setFont(new Font("SansSerif", 1, 12));
        this.jRadioButton5.setText("Magnifying lenses");
        this.jRadioButton5.setFont(new Font("SansSerif", 1, 12));
        this.jRadioButton6.setText("Minifying lenses");
        this.jRadioButton6.setFont(new Font("SansSerif", 1, 12));
        this.jPanel3.setBorder(this.border2);
        this.jPanel3.setBounds(230, 134, 173, 98);
        this.jPanel3.setLayout(this.borderLayout2);
        this.gain.setValue(45);
        this.gain.setOrientation(0);
        this.gain.setBounds(new Rectangle(21, 25, 123, 16));
        this.gain.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ParametricFeedback.this.gain_adjustmentValueChanged(e);
            }
        });
        this.label3D1.setFont(new Font("SansSerif", 1, 16));
        this.label3D1.setText("VOR");
        this.label3D1.setBounds(new Rectangle(62, 7, 50, 18));
        this.jPanel4.setLayout(null);
        this.jPanel4.setBackground(Color.darkGray);
        this.jLabel1.setForeground(Color.green);
        this.jLabel1.setText("Gain");
        this.jLabel1.setBounds(new Rectangle(72, 47, 30, 11));
        this.jLabel2.setForeground(Color.lightGray);
        this.jLabel2.setText("+");
        this.jLabel2.setBounds(new Rectangle(120, 44, 11, 11));
        this.jLabel3.setForeground(Color.lightGray);
        this.jLabel3.setText("-");
        this.jLabel3.setBounds(new Rectangle(48, 42, 10, 11));
        this.gaintext.setFont(new Font("SansSerif", 1, 20));
        this.gaintext.setForeground(Color.green);
        this.gaintext.setHorizontalAlignment(0);
        this.gaintext.setText("0");
        this.gaintext.setBounds(new Rectangle(58, 63, 56, 19));
        this.ohead.setBounds(38, 160, 123, 68);
        this.ohead.setGutter(2);
        this.obackground.setBounds(35, 38, 121, 68);
        this.obackground.setGutter(2);
        this.oslip.setBounds(252, 39, 120, 67);
        this.oslip.setGutter(2);
        this.oeye.setBounds(449, 164, 120, 67);
        this.oeye.setGutter(2);
        this.gazepos.setBorder(this.border3);
        this.gazepos.setBounds(439, 38, 140, 21);
        this.gazepos.setLayout(null);
        this.headpos.setBorder(this.border3);
        this.headpos.setBounds(439, 65, 140, 21);
        this.headpos.setLayout(null);
        this.label3D2.setFont(new Font("Dialog", 1, 14));
        this.label3D2.setText("Head");
        this.label3D2.setBounds(new Rectangle(2, 4, 51, 16));
        this.label3D3.setFont(new Font("SansSerif", 1, 14));
        this.label3D3.setText("Gaze");
        this.label3D3.setBounds(new Rectangle(2, 5, 40, 16));
        this.lbackground.setFont(new Font("SansSerif", 1, 13));
        this.lbackground.setText("Target");
        this.lbackground.setBounds(35, 20, 96, 18);
        this.label3D5.setBounds(38, 144, 53, 16);
        this.label3D5.setText("Head");
        this.label3D5.setFont(new Font("SansSerif", 1, 13));
        this.lslip.setBounds(252, 19, 120, 20);
        this.lslip.setText("Retinal slip");
        this.lslip.setFont(new Font("SansSerif", 1, 13));
        this.label3D7.setFont(new Font("SansSerif", 1, 13));
        this.label3D7.setText("Eye-in-head");
        this.label3D7.setBounds(450, 143, 99, 19);
        this.learn.setText("Learn");
        this.learn.setBounds(418, 276, 64, 27);
        this.label3D4.setBounds(new Rectangle(3, 5, 106, 16));
        this.label3D4.setText("Background");
        this.label3D4.setToolTipText("");
        this.label3D4.setFont(new Font("Dialog", 1, 14));
        this.backpos.setLayout(null);
        this.backpos.setBorder(this.border3);
        this.backpos.setBounds(439, 11, 140, 21);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.setPreferredSize(new Dimension(374, 323));
        this.jPanel1.add((Component)this.returnButton1, null);
        this.jPanel1.add((Component)this.lbackground, null);
        this.jPanel1.add((Component)this.oslip, null);
        this.jPanel1.add((Component)this.oeye, null);
        this.jPanel1.add((Component)this.learn, null);
        this.jPanel1.add((Component)this.ohead, null);
        this.jPanel1.add((Component)this.label3D5, null);
        this.jPanel1.add((Component)this.lslip, null);
        this.jPanel1.add((Component)this.label3D7, null);
        this.jPanel1.add((Component)this.obackground, null);
        this.jPanel1.add((Component)this.headpos, null);
        this.headpos.add((Component)this.label3D2, null);
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jRadioButton1, null);
        this.jPanel2.add((Component)this.jRadioButton4, null);
        this.jPanel2.add((Component)this.jRadioButton2, null);
        this.jPanel2.add((Component)this.jRadioButton5, null);
        this.jPanel2.add((Component)this.jRadioButton3, null);
        this.jPanel2.add((Component)this.jRadioButton6, null);
        this.jPanel1.add((Component)this.backpos, null);
        this.backpos.add((Component)this.label3D4, null);
        this.jPanel1.add((Component)this.gazepos, null);
        this.gazepos.add((Component)this.label3D3, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.arrow1 = new LineOrArrowPanel();
        this.jPanel1.add(this.arrow1);
        this.arrow1.setBounds(157, 59, 95, 16);
        this.arrow1.setArrowEnd(true);
        this.arrow2 = new LineOrArrowPanel();
        this.jPanel1.add(this.arrow2);
        this.arrow2.setBounds(161, 189, 69, 14);
        this.arrow2.setArrowEnd(true);
        this.line1 = new LineOrArrowPanel();
        this.jPanel1.add(this.line1);
        this.line1.setBounds(199, 87, 10, 109);
        this.line1.setLocations(128);
        this.arrow3 = new LineOrArrowPanel();
        this.jPanel1.add(this.arrow3);
        this.arrow3.setBounds(203, 81, 49, 16);
        this.arrow3.setArrowEnd(true);
        this.arrow4 = new LineOrArrowPanel();
        this.jPanel1.add(this.arrow4);
        this.arrow4.setBounds(403, 182, 46, 14);
        this.arrow4.setArrowEnd(true);
        this.line2 = new LineOrArrowPanel();
        this.jPanel1.add(this.line2);
        this.line2.setBounds(451, 97, 10, 40);
        this.line2.setLocations(128);
        this.arrow5 = new LineOrArrowPanel();
        this.jPanel1.add(this.arrow5);
        this.arrow5.setBounds(374, 92, 84, 15);
        this.arrow5.setArrowStart(true);
        this.inhib1 = new LineOrArrowPanel();
        this.jPanel1.add(this.inhib1);
        this.inhib1.setBounds(304, 106, 10, 22);
        this.inhib1.setInhibEnd(true);
        this.inhib1.setLocations(128);
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jLabel3, null);
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.gain, null);
        this.jPanel4.add((Component)this.label3D1, null);
        this.jPanel4.add((Component)this.gaintext, null);
        this.jPanel4.add((Component)this.jLabel1, null);
        this.hideInTheDark = new JComponent[]{this.arrow1, this.arrow3, this.arrow5, this.line1, this.line2, this.inhib1, this.obackground, this.oslip, this.lbackground, this.lslip};
    }

    void gain_adjustmentValueChanged(AdjustmentEvent e) {
        if (this.gain.getValue() != (int)(45.0 + this.gainval / 2.0)) {
            this.gainval = (double)this.gain.getValue() * 2.0 - 100.0;
            this.vgain = this.gainval / 50.0;
        }
    }

    public void close() {
        this.sig.timer.stop();
    }

    public static Object getGUIBuilderInstance() {
        return new ParametricFeedback(Boolean.FALSE);
    }

    public ParametricFeedback(Boolean initGUI) {
    }
}

