/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.JPanel0;
import com.neurolab.common.NeurolabExhibit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;

public class NetworkLearning
extends NeurolabExhibit {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel0();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JToggleButton randombutton = new JToggleButton();
    JPanel rightpanel = new JPanel0();
    JPanel leftpanel = new JPanel0();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel graphic = new JPanel0(){

        public void paint(Graphics g) {
            int j;
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            int w = this.getWidth() / 3;
            int h0 = this.getHeight() / NetworkLearning.this.input.length;
            int h1 = this.getHeight() / NetworkLearning.this.hidden.length;
            int h2 = this.getHeight() / NetworkLearning.this.output.length;
            int i = 0;
            while (i < NetworkLearning.this.input.length) {
                NetworkLearning.this.drawcell(g, w * 0 + w / 2, h0 * i + h0 / 2, 26.0 * NetworkLearning.this.input[i]);
                j = 0;
                while (j < NetworkLearning.this.hidden.length) {
                    NetworkLearning.this.drawconnec(g, w * 0 + w / 2, h0 * i + h0 / 2, w * 1 + w / 2, h1 * j + h1 / 2, NetworkLearning.this.wih[i][j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < NetworkLearning.this.hidden.length) {
                NetworkLearning.this.drawcell(g, w * 1 + w / 2, h1 * i + h1 / 2, NetworkLearning.this.hidden[i]);
                j = 0;
                while (j < NetworkLearning.this.output.length) {
                    NetworkLearning.this.drawconnec(g, w * 1 + w / 2, h1 * i + h1 / 2, w * 2 + w / 2, h2 * j + h2 / 2, NetworkLearning.this.who[i][j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < NetworkLearning.this.output.length) {
                NetworkLearning.this.drawcell(g, w * 2 + w / 2, h2 * i + h2 / 2, 10.0 * NetworkLearning.this.output[i]);
                ++i;
            }
        }
    };
    int rad = 10;
    int diam = this.rad * 2;
    double[] input = new double[3];
    double[] hidden = new double[20];
    double[] output = new double[2];
    double[][] wih = new double[this.input.length][this.hidden.length];
    double[][] who = new double[this.hidden.length][this.output.length];
    JCheckBox[] cb = new JCheckBox[this.input.length];
    JTextField[] tp = new JTextField[this.output.length];
    JPanel[] opanel = new JPanel[this.output.length];
    JLabel[] olabel = new JLabel[this.output.length];
    boolean randomising = false;
    boolean repeating = false;
    Timer timer = new Timer(250, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            NetworkLearning.this.randomising = true;
            int i = 0;
            while (i < 3) {
                NetworkLearning.this.cb[i].setSelected(Math.random() > 0.5);
                ++i;
            }
            NetworkLearning.this.randomising = false;
            NetworkLearning.this.wasCorrect = false;
            NetworkLearning.this.repeating = false;
            while (!NetworkLearning.this.wasCorrect) {
                NetworkLearning.this.newinput();
                NetworkLearning.this.repeating = true;
            }
        }
    });
    double rate1 = 0.005;
    double rate2 = 5.0E-4;
    int examples = 0;
    int nCorrect;
    int nWrong;
    boolean wasCorrect;
    Vector scores = new Vector();
    JButton jButton3 = new JButton();
    JTextField examplestxt = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField accutxt = new JTextField();

    void drawcell(Graphics g, int x, int y, double colour) {
        g.setColor(new Color(this.lim(colour), 0, this.lim(-colour) / 2));
        g.fillOval(x - this.rad, y - this.rad, this.diam, this.diam);
        g.setColor(Color.black);
        g.drawOval(x - this.rad, y - this.rad, this.diam, this.diam);
    }

    void drawconnec(Graphics g, int x1, int y1, int x2, int y2, double colour) {
        g.setColor(new Color(this.lim(800.0 * colour), 0, this.lim(-800.0 * colour) / 2));
        g.drawLine(x1 + this.rad, y1, x2 - this.rad, y2);
    }

    int lim(double x) {
        return (int)Math.min(Math.max(x, 0.0), 255.0);
    }

    double lim(double x, double min, double max) {
        return x > min ? (x < max ? x : max) : min;
    }

    public void newinput() {
        int i = 0;
        while (i < this.input.length) {
            this.input[i] = this.cb[i].isSelected() ? 10 : -10;
            ++i;
        }
        this.calculate();
        this.learn();
        this.graphic.repaint();
        this.settexts();
    }

    void settexts() {
        int i = 0;
        while (i < this.output.length) {
            int v = (int)(this.output[i] * 1.0) / 1;
            this.tp[i].setText(String.valueOf(v));
            ++i;
        }
        this.examplestxt.setText(String.valueOf(this.examples));
        this.accutxt.setText(String.valueOf(this.getCorrectPercent()));
    }

    void forget() {
        int j;
        int i = 0;
        while (i < this.input.length) {
            j = 0;
            while (j < this.hidden.length) {
                this.wih[i][j] = Math.random() * 0.2 - 0.1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.hidden.length) {
            j = 0;
            while (j < this.output.length) {
                this.who[i][j] = Math.random() * 0.2 - 0.1;
                ++j;
            }
            ++i;
        }
        this.examples = 0;
        this.nCorrect = 0;
        this.newinput();
    }

    double sigm(double x) {
        return 2.0 * (1.0 / (1.0 + Math.exp(x)) - 0.5);
    }

    double sgn(double x) {
        return x / Math.abs(x);
    }

    void calculate() {
        int j = 0;
        while (j < this.hidden.length) {
            double sum = 0.0;
            int i = 0;
            while (i < this.input.length) {
                sum += this.wih[i][j] * this.input[i];
                ++i;
            }
            this.hidden[j] = 255.0 * this.sigm(sum);
            ++j;
        }
        this.output[1] = 0.0;
        this.output[0] = 0.0;
        int i = 0;
        while (i < this.hidden.length) {
            this.output[0] = this.output[0] + 0.1 * this.who[i][0] * this.hidden[i];
            this.output[1] = this.output[1] + 0.1 * this.who[i][1] * this.hidden[i];
            ++i;
        }
    }

    void learn() {
        boolean e = this.isEven();
        int even = e ? 1 : -1;
        int odd = e ? -1 : 1;
        double[] discrep = new double[this.hidden.length];
        int i = 0;
        while (i < this.hidden.length) {
            this.who[i][0] = this.lim(this.who[i][0] + 0.5 * this.hidden[i] * this.rate2 * (double)odd, -5.0, 5.0);
            this.who[i][1] = this.lim(this.who[i][1] + 0.5 * this.hidden[i] * this.rate2 * (double)even, -5.0, 5.0);
            discrep[i] = (double)even * this.sgn(this.output[0]) * this.who[i][0] + (double)odd * this.sgn(this.output[1]) * this.who[i][1];
            ++i;
        }
        i = 0;
        while (i < this.input.length) {
            int j = 0;
            while (j < this.hidden.length) {
                this.wih[i][j] = this.lim(this.wih[i][j] + this.input[i] * discrep[j] * this.rate1, -5.0, 5.0);
                ++j;
            }
            ++i;
        }
        ++this.examples;
        boolean bl2 = this.wasCorrect = (double)even * (this.output[1] - this.output[0]) > 0.0;
        if (!this.repeating) {
            if (this.wasCorrect) {
                ++this.nCorrect;
            } else {
                ++this.nWrong;
            }
            if (this.scores.size() > 200) {
                this.scores.removeElementAt(0);
            }
            this.scores.addElement(new Boolean(this.wasCorrect));
        }
    }

    boolean isEven() {
        int t = 0;
        int i = 0;
        while (i < this.input.length) {
            if (this.cb[i].isSelected()) {
                ++t;
            }
            ++i;
        }
        return t % 2 == 0;
    }

    int getCorrectPercent() {
        int c = 0;
        int i = 0;
        while (i < this.scores.size()) {
            if (((Boolean)this.scores.elementAt(i)).booleanValue()) {
                ++c;
            }
            ++i;
        }
        return 100 * c / this.scores.size();
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int i = 0;
                while (i < NetworkLearning.this.input.length) {
                    if (e.getItem() == NetworkLearning.this.cb[i] && !NetworkLearning.this.randomising) {
                        NetworkLearning.this.newinput();
                    }
                    ++i;
                }
            }
        };
        int i = 0;
        while (i < this.input.length) {
            this.cb[i] = new JCheckBox();
            this.cb[i].setBackground(NeurolabExhibit.systemGray);
            this.cb[i].addItemListener(il);
            this.leftpanel.add(this.cb[i]);
            ++i;
        }
        Border b = BorderFactory.createBevelBorder(1);
        int i2 = 0;
        while (i2 < this.output.length) {
            this.tp[i2] = new JTextField("0.0", 7);
            this.tp[i2].setBorder(b);
            this.tp[i2].setEditable(false);
            this.olabel[i2] = new JLabel(i2 == 0 ? "Odd" : "Even");
            this.olabel[i2].setFont(new Font("Dialog", 1, 14));
            this.opanel[i2] = new JPanel0();
            this.opanel[i2].setLayout(null);
            this.opanel[i2].add(this.olabel[i2]);
            this.opanel[i2].add(this.tp[i2]);
            this.rightpanel.add(this.opanel[i2]);
            this.rightpanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    NetworkLearning.this.layoutRightPanel();
                }
            });
            ++i2;
        }
        this.forget();
    }

    void layoutRightPanel() {
        int y = this.rightpanel.getHeight() / this.output.length / 2;
        int i = 0;
        while (i < this.output.length) {
            Rectangle s = new Rectangle(new Point(0, y), this.olabel[i].getPreferredSize());
            this.olabel[i].setBounds(s);
            s = new Rectangle(new Point(40, y), this.tp[i].getPreferredSize());
            this.tp[i].setBounds(s);
            ++i;
        }
    }

    private void jbInit() throws Exception {
        this.leftpanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(this.input.length);
        this.rightpanel.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(this.output.length);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkLearning.this.jButton2_actionPerformed(e);
            }
        });
        this.randombutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkLearning.this.randombutton_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.jButton1.setBackground(Color.lightGray);
        this.jButton1.setText("Return");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkLearning.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setBackground(Color.lightGray);
        this.jButton2.setText("Forget");
        this.randombutton.setBackground(Color.lightGray);
        this.randombutton.setMnemonic('0');
        this.randombutton.setText("Random stimuli");
        this.jPanel3.setLayout(this.flowLayout1);
        this.jButton3.setBackground(Color.lightGray);
        this.jButton3.setText("Repeat stimulus");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NetworkLearning.this.jButton3_actionPerformed(e);
            }
        });
        this.examplestxt.setText("0");
        this.examplestxt.setColumns(3);
        this.examplestxt.setHorizontalAlignment(4);
        this.jLabel1.setText("Seen");
        this.jLabel2.setText("Accu%");
        this.accutxt.setText("0");
        this.accutxt.setColumns(3);
        this.rightpanel.setPreferredSize(new Dimension(100, 0));
        this.jPanel1.add((Component)this.graphic, "Center");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.accutxt, null);
        this.jPanel3.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.examplestxt, null);
        this.jPanel3.add((Component)this.jButton3, null);
        this.jPanel3.add((Component)this.randombutton, null);
        this.jPanel3.add((Component)this.jButton2, null);
        this.jPanel3.add((Component)this.jButton1, null);
        this.jPanel1.add((Component)this.rightpanel, "East");
        this.jPanel1.add((Component)this.leftpanel, "West");
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.forget();
    }

    void randombutton_actionPerformed(ActionEvent e) {
        if (this.randombutton.isSelected()) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.getHolder().setExhibit("com.neurolab.NeuralNetwork");
    }

    void jButton3_actionPerformed(ActionEvent e) {
        this.newinput();
    }

    public void close() {
        this.timer.stop();
    }
}

