/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class LineOrArrowPanel
extends JPanel {
    public int lineThickness = 3;
    private int locations = 64;
    private boolean arrowStart = false;
    private boolean arrowEnd = false;
    private boolean inhibEnd = false;
    private boolean inhibStart = false;
    private int arrowSize = 6;
    public static final int LOC_L = 1;
    public static final int LOC_R = 2;
    public static final int LOC_T = 4;
    public static final int LOC_B = 8;
    public static final int LOC_D1 = 16;
    public static final int LOC_D2 = 32;
    public static final int LOC_H = 64;
    public static final int LOC_V = 128;

    LineOrArrowPanel() {
        this.setOpaque(false);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(this.lineThickness));
        int w = this.getWidth();
        int h = this.getHeight();
        int a = this.getArrowSize();
        int m = 2;
        if ((this.getLocations() & 1) > 0) {
            g2.drawLine(m, m, m, h - m);
        }
        if ((this.getLocations() & 2) > 0) {
            g2.drawLine(w - m, m, w - m, h - m);
        }
        if ((this.getLocations() & 4) > 0) {
            g2.drawLine(m, m, w - m, m);
        }
        if ((this.getLocations() & 8) > 0) {
            g2.drawLine(m, h - m, w - m, h - m);
        }
        if ((this.getLocations() & 0x10) > 0) {
            g2.drawLine(m, m, w - m, h - m);
        }
        if ((this.getLocations() & 0x20) > 0) {
            g2.drawLine(w - m, m, m, h - m);
        }
        if ((this.getLocations() & 0x40) > 0) {
            g2.drawLine(m, h / 2, w - m, h / 2);
            if (this.isArrowEnd()) {
                g2.drawLine(w - m, h / 2, w - a, h / 2 - a);
                g2.drawLine(w - m, h / 2, w - a, h / 2 + a);
            }
            if (this.isArrowStart()) {
                g2.drawLine(m, h / 2, a, h / 2 - a);
                g2.drawLine(m, h / 2, a, h / 2 + a);
            }
            if (this.isInhibEnd()) {
                g2.fillOval(w - a, h / 2 - a / 2, a, a);
            }
            if (this.isInhibStart()) {
                g2.fillOval(0, h / 2 - a / 2, a, a);
            }
        }
        if ((this.getLocations() & 0x80) > 0) {
            g2.drawLine(w / 2, m, w / 2, h - m);
            if (this.isArrowEnd()) {
                g2.drawLine(w / 2, h - m, w / 2 - a, h - a);
                g2.drawLine(w / 2, h - m, w / 2 + a, h - a);
            }
            if (this.isArrowStart()) {
                g2.drawLine(w / 2, m, w / 2 - a, a);
                g2.drawLine(w / 2, m, w / 2 + a, a);
            }
            if (this.isInhibEnd()) {
                g2.fillOval(w / 2 - a / 2, h - a, a, a);
            }
            if (this.isInhibStart()) {
                g2.fillOval(w / 2 - a / 2, 0, a, a);
            }
        }
    }

    public void setArrowStart(boolean arrowStart) {
        this.arrowStart = arrowStart;
    }

    public boolean isArrowStart() {
        return this.arrowStart;
    }

    public void setArrowEnd(boolean arrowEnd) {
        this.arrowEnd = arrowEnd;
    }

    public boolean isArrowEnd() {
        return this.arrowEnd;
    }

    public void setLocations(int locations) {
        this.locations = locations;
    }

    public int getLocations() {
        return this.locations;
    }

    public void setArrowSize(int arrowSize) {
        this.arrowSize = arrowSize;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public void setInhibEnd(boolean inhibEnd) {
        this.inhibEnd = inhibEnd;
    }

    public boolean isInhibEnd() {
        return this.inhibEnd;
    }

    public void setInhibStart(boolean inhibStart) {
        this.inhibStart = inhibStart;
    }

    public boolean isInhibStart() {
        return this.inhibStart;
    }
}

