/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.AngleControl;
import com.neurolab.common.JPanel0;
import com.neurolab.common.JRadioButton0;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.PercentageBar;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;

public class LineLearning
extends NeurolabExhibit {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    JButton forget = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel mainpanel = new JPanel0();
    FlowLayout flowLayout2 = new FlowLayout();
    JPanel jPanel4 = new JPanel0();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel6 = new JPanel0();
    JPanel jPanel7 = new JPanel0();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel8 = new JPanel0();
    Border border1;
    BorderLayout borderLayout8 = new BorderLayout();
    AngleControl orientation = new AngleControl();
    BorderLayout borderLayout10 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel9 = new JPanel0();
    FlowLayout flowLayout3 = new FlowLayout();
    JPanel orientgraph = new JPanel0(){

        public void paint(Graphics g_) {
            super.paint(g_);
            LineLearning.this.drawStim(this, g_);
        }
    };
    JToggleButton stimulusbutton = new JToggleButton();
    int nunits = 5;
    UnitPanel[] unit = new UnitPanel[this.nunits];
    Random rand = new Random();
    Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int fired = -1;
            int i = 0;
            while (i < LineLearning.this.nunits) {
                if (LineLearning.this.unit[i].calc()) {
                    fired = i;
                }
                ++i;
            }
            if (fired >= 0) {
                LineLearning.this.timer.stop();
                LineLearning.this.timer2.start();
                LineLearning.this.stimulusbutton.setSelected(false);
            }
        }
    });
    Timer timer2 = new Timer(1200, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < LineLearning.this.nunits) {
                LineLearning.this.unit[i].lineVisible = false;
                LineLearning.this.unit[i].response.setSelected(false);
                LineLearning.this.unit[i].graph.repaint();
                ++i;
            }
            LineLearning.this.stimulusbutton.setEnabled(true);
            if (LineLearning.this.continuous) {
                LineLearning.this.orientation.setValue(LineLearning.this.rand.nextInt() % 180);
                LineLearning.this.orientation.repaint();
                LineLearning.this.orientgraph.repaint();
                LineLearning.this.autotrainbegin();
            }
        }
    });
    JButton contin = new JButton();
    boolean continuous = false;

    public String getExhibitName() {
        return "Learning lines";
    }

    void drawStim(Component c, Graphics g) {
        NeurolabExhibit.antiAlias(g);
        g.setColor(Color.white);
        NeurolabExhibit.setStrokeThickness(g, 4.0f);
        double s = -Math.sin((double)this.orientation.getValue() * Math.PI / 180.0);
        double cs = Math.cos((double)this.orientation.getValue() * Math.PI / 180.0);
        Dimension cd = c.getSize();
        g.drawLine(cd.width / 2 + (int)((double)cd.width * s), cd.height / 2 + (int)((double)cd.height * cs), cd.width / 2 - (int)((double)cd.width * s), cd.height / 2 - (int)((double)cd.height * cs));
    }

    public void init() {
        super.init();
        try {
            this.myinit();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.stimulusbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!LineLearning.this.stimulusbutton.isSelected()) {
                    LineLearning.this.endstimulus();
                } else {
                    LineLearning.this.beginstimulus();
                    LineLearning.this.stimulusbutton.setEnabled(false);
                }
            }
        });
    }

    public void myinit() {
        int i = 0;
        while (i < this.nunits) {
            this.unit[i] = new UnitPanel();
            this.mainpanel.add(this.unit[i]);
            ++i;
        }
        this.orientation.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                LineLearning.this.orientgraph.repaint();
            }
        });
        this.timer2.setRepeats(false);
        this.forget_actionPerformed(new ActionEvent(this, 1001, "Forget"));
    }

    private void jbInit() throws Exception {
        this.forget.setBackground(NeurolabExhibit.systemGray);
        this.stimulusbutton.setBackground(NeurolabExhibit.systemGray);
        this.contin.setBackground(NeurolabExhibit.systemGray);
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.flowLayout1);
        this.forget.setText("Forget");
        this.forget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineLearning.this.forget_actionPerformed(e);
            }
        });
        this.mainpanel.setLayout(this.flowLayout2);
        this.jPanel4.setLayout(this.borderLayout5);
        this.jPanel6.setBorder(this.border1);
        this.jPanel6.setLayout(this.borderLayout8);
        this.jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.jPanel7.setPreferredSize(new Dimension(170, 101));
        this.jPanel7.setLayout(this.borderLayout6);
        this.orientation.setPreferredSize(new Dimension(55, 55));
        this.orientation.setPrefix("                       ");
        this.jPanel8.setLayout(this.borderLayout10);
        this.orientgraph.setLayout(this.borderLayout7);
        this.orientgraph.setBackground(Color.black);
        this.orientgraph.setPreferredSize(new Dimension(90, 85));
        this.stimulusbutton.setPreferredSize(new Dimension(100, 27));
        this.stimulusbutton.setText("Stimulus");
        this.jPanel8.setPreferredSize(new Dimension(85, 57));
        this.jPanel9.setLayout(this.flowLayout3);
        this.contin.setText("Auto-train");
        this.contin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineLearning.this.contin_actionPerformed(e);
            }
        });
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.contin, null);
        this.jPanel2.add((Component)this.forget, null);
        this.jPanel2.add((Component)this.returnButton1, null);
        this.jPanel1.add((Component)this.mainpanel, "Center");
        this.mainpanel.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jPanel7, "Center");
        this.jPanel7.add((Component)this.jPanel6, "West");
        this.jPanel6.add((Component)this.orientgraph, "North");
        this.jPanel7.add((Component)this.jPanel8, "East");
        this.jPanel8.add((Component)this.stimulusbutton, "South");
        this.jPanel8.add((Component)this.jPanel9, "Center");
        this.jPanel9.add((Component)this.orientation, null);
        this.jPanel4.setPreferredSize(new Dimension(195, 100));
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    public void beginstimulus() {
        int i = 0;
        while (i < this.nunits) {
            this.unit[i].lineVisible = true;
            this.unit[i].graph.repaint();
            this.unit[i].initCalc();
            ++i;
        }
        this.stimulusbutton.setSelected(true);
        this.stimulusbutton.setEnabled(false);
        this.timer.start();
    }

    public void endstimulus() {
        int i = 0;
        while (i < this.nunits) {
            this.unit[i].lineVisible = false;
            this.unit[i].graph.repaint();
            ++i;
        }
        this.timer.stop();
    }

    public void autotrainbegin() {
        this.beginstimulus();
    }

    void forget_actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.nunits) {
            this.unit[i].forget();
            ++i;
        }
    }

    void contin_actionPerformed(ActionEvent e) {
        boolean bl2 = this.continuous = !this.continuous;
        if (this.continuous) {
            this.contin.setText("Stop");
            this.autotrainbegin();
        } else {
            this.contin.setText("Auto-train");
        }
    }

    public void close() {
        this.timer.stop();
        this.timer2.stop();
    }

    class UnitPanel
    extends JPanel0 {
        JRadioButton response = new JRadioButton0();
        PercentageBar percentage = new PercentageBar();
        JPanel jP5 = new JPanel0();
        JPanel jPanel111 = new JPanel0();
        JPanel graph = new JPanel0(this){
            final /* synthetic */ UnitPanel this$1;
            {
                this.this$1 = unitPanel;
            }

            public void paint(Graphics g) {
                super.paint(g);
                if (this.this$1.dots[0] == null) {
                    this.this$1.initDots();
                }
                int i = 0;
                while (i < this.this$1.ndots) {
                    g.setColor(new Color((int)(255.0 * this.this$1.strength[i]), 0, (int)(255.0 * (1.0 - this.this$1.strength[i]))));
                    g.fillOval(this.this$1.dots[i].x - this.this$1.dr, this.this$1.dots[i].y - this.this$1.dr, 2 * this.this$1.dr, 2 * this.this$1.dr);
                    ++i;
                }
                if (this.this$1.lineVisible) {
                    UnitPanel.access$0(this.this$1).drawStim(this.this$1.graph, g);
                }
            }
        };
        int ndots = 40;
        int dr = 3;
        Point[] dots = new Point[this.ndots];
        double[] strength = new double[this.ndots];
        double[] z = new double[this.ndots];
        double activity;
        double increment;
        boolean lineVisible;

        public UnitPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.percentage, "Center");
            this.add((Component)this.response, "South");
            this.add((Component)this.jP5, "North");
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, new Color(255, 255, 235), new Color(94, 93, 80), new Color(135, 133, 115)), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.jP5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.jP5.setPreferredSize(new Dimension(90, 90));
            this.jP5.setLayout(new BorderLayout());
            this.percentage.setPreferredSize(new Dimension(70, 10));
            this.response.setEnabled(false);
            this.response.setText("Response");
            this.response.setFont(new Font("Dialog", 1, 14));
            this.jP5.add((Component)this.jPanel111, "Center");
            this.jPanel111.setBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)));
            this.jPanel111.setLayout(new BorderLayout());
            this.jPanel111.add((Component)this.graph, "Center");
            this.graph.setBackground(Color.black);
        }

        public void initDots() {
            int i = 0;
            while (i < this.ndots) {
                this.dots[i] = new Point(this.dr + LineLearning.this.rand.nextInt() % (this.graph.getWidth() - 2 * this.dr), this.dr + LineLearning.this.rand.nextInt() % this.graph.getHeight());
                ++i;
            }
        }

        public void initCalc() {
            this.activity = 0.0;
            this.increment = 0.0;
            this.response.setSelected(false);
            double s = Math.sin(Math.PI * (double)LineLearning.this.orientation.getValue() / 180.0);
            double cs = Math.cos((double)LineLearning.this.orientation.getValue() * Math.PI / 180.0);
            int i = 0;
            while (i < this.ndots) {
                this.z[i] = (double)(this.dots[i].y - this.graph.getHeight() / 2) * s + (double)(this.dots[i].x - this.graph.getWidth() / 2) * cs;
                if (Math.abs(this.z[i]) < 8.0) {
                    this.increment += this.strength[i];
                }
                ++i;
            }
        }

        public void forget() {
            int i = 0;
            while (i < this.ndots) {
                this.z[i] = 0.0;
                this.strength[i] = 0.5;
                ++i;
            }
            this.dots[0] = null;
            this.graph.repaint();
        }

        public boolean calc() {
            this.activity += this.increment;
            this.percentage.setValue(this.activity > 100.0 ? 100 : (int)this.activity);
            if (this.activity >= 100.0) {
                this.response.setSelected(true);
                int i = 0;
                while (i < this.ndots) {
                    if (Math.abs(this.z[i]) < 8.0) {
                        int n = i;
                        this.strength[n] = this.strength[n] + 0.5 * (1.0 - this.strength[i]);
                    } else {
                        int n = i;
                        this.strength[n] = this.strength[n] * 0.5;
                    }
                    ++i;
                }
                this.graph.repaint();
                return true;
            }
            return false;
        }

        static /* synthetic */ LineLearning access$0(UnitPanel unitPanel) {
            return unitPanel.LineLearning.this;
        }
    }
}

