/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LateralInhibition
extends NeurolabExhibit
implements ImageObserver {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton strip = new JButton();
    JButton cornsweet = new JButton();
    ReturnButton returnButton1 = new ReturnButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel4 = new JPanel();
    JLabel jLabel1 = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    JSlider completeness = new JSlider();
    Box box1;
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    JPanel jPanel9 = new JPanel();
    JPanel jPanel10 = new JPanel();
    Border border1;
    Border border2;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton jButton3 = new JButton();
    JButton jButton4 = new JButton();
    JButton jButton5 = new JButton();
    JButton jButton6 = new JButton();
    JButton jButton7 = new JButton();
    JButton jButton8 = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanel11 = new JPanel();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel12 = new JPanel();
    Border border3;
    TitledBorder titledBorder1;
    JRadioButton singleline = new JRadioButton();
    JRadioButton edge = new JRadioButton();
    JRadioButton pairoflines = new JRadioButton();
    GridLayout gridLayout1 = new GridLayout();
    ButtonGroup bg = new ButtonGroup();
    Border border4;
    JPanel jPanel13 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    Border border5;
    JPanel jPanel14 = new JPanel();
    BorderLayout borderLayout8 = new BorderLayout();
    Border border6;
    BorderLayout borderLayout9 = new BorderLayout();
    BorderLayout borderLayout10 = new BorderLayout();
    int baseh = 40;
    JPanel linegraphic = new JPanel(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            int base = this.getHeight() - LateralInhibition.this.baseh;
            g.setColor(Color.gray);
            g.drawLine(0, base, this.getWidth(), base);
            g.setColor(Color.blue);
            int mid = this.getWidth() / 2;
            if (LateralInhibition.this.singleline.isSelected() || LateralInhibition.this.edge.isSelected()) {
                g.drawLine(mid, base, mid, 0);
            }
            if (LateralInhibition.this.edge.isSelected()) {
                g.drawLine(0, base, mid, base);
                g.drawLine(mid, 0, this.getWidth(), 0);
            } else if (LateralInhibition.this.pairoflines.isSelected()) {
                g.drawLine(mid - LateralInhibition.this.linespacing * 4, base, mid - LateralInhibition.this.linespacing * 4, 0);
                g.drawLine(mid + LateralInhibition.this.linespacing * 4, base, mid + LateralInhibition.this.linespacing * 4, 0);
            }
            if (LateralInhibition.this.linedata == null) {
                return;
            }
            g.setColor(Color.green);
            double[] dArray = LateralInhibition.this.linedata;
            synchronized (LateralInhibition.this.linedata) {
                int i = 1;
                while (i < LateralInhibition.this.linedata.length) {
                    g.drawLine((i - 1) * 4, base - (int)((double)base * LateralInhibition.this.linedata[i - 1]), i * 4, base - (int)((double)base * LateralInhibition.this.linedata[i]));
                    ++i;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    };
    final int NPIXEL = 4;
    int linespacing = 4;
    JPanel imagegraphic = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (LateralInhibition.this.image != null) {
                g.drawImage(LateralInhibition.this.image, 0, 0, this);
            }
        }
    };
    double[] linedata;
    String[] imagename = new String[]{"resources/lat_inh.jpg", "resources/testimage1.jpg"};
    BufferedImage image;
    Image defaultimage;
    Point oldmouse;
    int imageindex = 0;
    double[] kernelB = new double[]{1.0, 2.0, 4.0, 6.0, 7.0, 6.0, 4.0, 2.0, 1.0};
    double[] kernelL = new double[]{-1.0, -2.0, -4.0, -6.0, -7.0, 41.0, -7.0, -6.0, -4.0, -2.0, -1.0};
    int RK = 4;
    double PV = 7.0;
    float[] kdataL = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    float[] kdataB = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
    float[] kdataI = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    Kernel ikL = new Kernel(3, 3, this.kdataL);
    Kernel ikB = new Kernel(3, 3, this.kdataB);
    ConvolveOp opB = new ConvolveOp(this.ikB);
    ConvolveOp opL = new ConvolveOp(this.ikL);
    static final int BLUR = 0;
    static final int LATIN = 1;
    static final int RESTORE = 2;

    public String getExhibitName() {
        return "Lateral Inhibition";
    }

    double sgn(double a) {
        return a / Math.abs(a);
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.linegraphic.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                LateralInhibition.this.linedata = new double[LateralInhibition.this.linegraphic.getWidth() / 4];
                LateralInhibition.this.setupLinedata();
            }
        });
        this.imagegraphic.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                LateralInhibition.this.createimage();
            }
        });
        this.linegraphic.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                LateralInhibition.this.oldmouse = e.getPoint();
            }
        });
        this.linegraphic.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (LateralInhibition.this.linedata != null) {
                    double m = (e.getY() - LateralInhibition.this.oldmouse.y) / (e.getX() - LateralInhibition.this.oldmouse.x);
                    int dir = (int)LateralInhibition.this.sgn(e.getX() - LateralInhibition.this.oldmouse.x);
                    int i = 0;
                    while (i != e.getX() - LateralInhibition.this.oldmouse.x) {
                        if (LateralInhibition.this.oldmouse.x + i < 0 || LateralInhibition.this.oldmouse.x + i > LateralInhibition.this.linedata.length - 1) break;
                        double h = (double)LateralInhibition.this.oldmouse.y + m * (double)i;
                        LateralInhibition.this.linedata[LateralInhibition.this.oldmouse.x + i] = 1.0 - h / (double)(LateralInhibition.this.linegraphic.getHeight() - LateralInhibition.this.baseh);
                        i += dir;
                    }
                }
                LateralInhibition.this.linegraphic.repaint();
                LateralInhibition.this.oldmouse = e.getPoint();
            }
        });
        this.imagegraphic.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ++LateralInhibition.this.imageindex;
                    LateralInhibition.this.imageindex %= LateralInhibition.this.imagename.length;
                    LateralInhibition.this.loadimage();
                }
            }
        });
        this.loadimage();
        this.initkernel();
    }

    void loadimage() {
        this.defaultimage = this.getImage(this.imagename[this.imageindex]);
        int x = this.defaultimage.getWidth(this);
        int y = this.defaultimage.getHeight(this);
        if (x > 0 && y > 0) {
            this.createimage();
        }
    }

    public boolean imageUpdate(Image i, int f, int x, int y, int w, int h) {
        if ((f & 0x20) == 0) {
            return true;
        }
        this.createimage();
        return false;
    }

    void createimage() {
        if (this.imagegraphic.getWidth() > 0 && this.imagegraphic.getHeight() > 0) {
            this.image = new BufferedImage(this.imagegraphic.getWidth(), this.imagegraphic.getHeight(), 1);
            this.image.getGraphics().drawImage(this.defaultimage, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            this.imagegraphic.repaint();
        }
    }

    public void setupLinedata() {
        boolean isedge = this.edge.isSelected();
        boolean is1 = this.singleline.isSelected();
        boolean is2 = this.pairoflines.isSelected();
        int w = this.linedata.length;
        double p = 0.0;
        int i = 0;
        while (i < w) {
            p = isedge && i > w / 2 ? 0.8 : (is1 && i == w / 2 ? 1.0 : (is2 && (i == w / 2 - this.linespacing || i == w / 2 + this.linespacing) ? 1.0 : 0.0));
            this.linedata[i] = p;
            ++i;
        }
    }

    private void jbInit() throws Exception {
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.linecommand(e);
            }
        });
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.linecommand(e);
            }
        });
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.linecommand(e);
            }
        });
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.imagecommand(e);
            }
        });
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.imagecommand(e);
            }
        });
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.imagecommand(e);
            }
        });
        this.strip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.strip_actionPerformed(e);
            }
        });
        this.cornsweet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.cornsweet_actionPerformed(e);
            }
        });
        this.singleline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.stimchange(e);
            }
        });
        this.edge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.stimchange(e);
            }
        });
        this.pairoflines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LateralInhibition.this.stimchange(e);
            }
        });
        this.linegraphic.setBackground(Color.black);
        this.linegraphic.setForeground(Color.green);
        this.jPanel4.setBackground(Color.lightGray);
        this.completeness.setBackground(Color.lightGray);
        this.strip.setBackground(Color.lightGray);
        this.cornsweet.setBackground(Color.lightGray);
        this.jPanel3.setBackground(Color.lightGray);
        this.jPanel8.setBackground(Color.lightGray);
        this.jButton5.setBackground(Color.lightGray);
        this.jButton4.setBackground(Color.lightGray);
        this.jButton3.setBackground(Color.lightGray);
        this.jButton6.setBackground(Color.lightGray);
        this.jButton7.setBackground(Color.lightGray);
        this.jButton8.setBackground(Color.lightGray);
        this.jPanel11.setBackground(Color.lightGray);
        this.jPanel12.setBackground(Color.lightGray);
        this.jPanel9.setBackground(Color.lightGray);
        this.singleline.setBackground(Color.lightGray);
        this.edge.setBackground(Color.lightGray);
        this.pairoflines.setBackground(Color.lightGray);
        this.jPanel5.setBackground(Color.lightGray);
        this.jPanel6.setBackground(Color.lightGray);
        this.jPanel10.setBackground(Color.lightGray);
        this.jPanel13.setBackground(Color.lightGray);
        this.imagegraphic.setBackground(Color.lightGray);
        this.bg.add(this.singleline);
        this.bg.add(this.edge);
        this.bg.add(this.pairoflines);
        this.box1 = Box.createHorizontalBox();
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border3, "Stimulus");
        this.border4 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border6 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.strip.setText("Strip illusion");
        this.cornsweet.setText("Cornsweet illusion");
        this.jPanel3.setPreferredSize(new Dimension(150, 103));
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.flowLayout1);
        this.jLabel1.setText("Completeness");
        this.jPanel4.setPreferredSize(new Dimension(100, 34));
        this.completeness.setValue(80);
        this.completeness.setPreferredSize(new Dimension(120, 24));
        this.jPanel5.setBorder(this.border1);
        this.jPanel5.setLayout(this.borderLayout4);
        this.jPanel6.setBorder(this.border2);
        this.jPanel6.setLayout(this.borderLayout5);
        this.jPanel8.setLayout(this.gridBagLayout2);
        this.jButton3.setText("Restore");
        this.jButton4.setText("Lateral inhibition");
        this.jButton5.setText("Blur");
        this.jButton6.setText("Blur");
        this.jButton7.setText("Lateral inhibition");
        this.jButton8.setText("Restore");
        this.jPanel11.setLayout(this.gridBagLayout3);
        this.jPanel7.setLayout(this.borderLayout6);
        this.jPanel12.setBorder(this.titledBorder1);
        this.jPanel12.setPreferredSize(new Dimension(40, 63));
        this.jPanel12.setLayout(this.gridLayout1);
        this.singleline.setSelected(true);
        this.singleline.setText("Single line");
        this.edge.setText("Edge");
        this.pairoflines.setText("Pair of lines");
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.jPanel10.setBorder(this.border4);
        this.jPanel10.setLayout(this.borderLayout7);
        this.jPanel13.setBorder(this.border5);
        this.jPanel13.setLayout(this.borderLayout10);
        this.jPanel14.setBorder(this.border5);
        this.jPanel14.setLayout(this.borderLayout9);
        this.jPanel9.setLayout(this.borderLayout8);
        this.jPanel9.setBorder(this.border6);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.cornsweet, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.jPanel3.add((Component)this.returnButton1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.jPanel3.add((Component)this.strip, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 0, 4, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jLabel1, null);
        this.jPanel4.add((Component)this.completeness, null);
        this.jPanel1.add((Component)this.box1, "Center");
        this.box1.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jPanel9, "Center");
        this.jPanel9.add((Component)this.jPanel14, "Center");
        this.jPanel14.add((Component)this.linegraphic, "Center");
        this.jPanel5.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.jPanel11, "East");
        this.jPanel11.add((Component)this.jButton7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel11.add((Component)this.jButton6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel11.add((Component)this.jButton8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel7.add((Component)this.jPanel12, "Center");
        ((BorderLayout)this.jPanel7.getLayout()).setHgap(10);
        NeurolabExhibit.setBG(this.jPanel7);
        this.jPanel12.add((Component)this.singleline, null);
        this.jPanel12.add((Component)this.edge, null);
        this.jPanel12.add((Component)this.pairoflines, null);
        this.box1.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jPanel8, "South");
        this.jPanel8.add((Component)this.jButton4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel8.add((Component)this.jButton5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel8.add((Component)this.jButton3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.jPanel6.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.jPanel13, "Center");
        this.jPanel13.add((Component)this.imagegraphic, "Center");
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    double gauss(double a) {
        return Math.exp(-a * a);
    }

    void createopL() {
        float[] d = new float[9];
        double c = (double)this.completeness.getValue() / 100.0;
        int i = 0;
        while (i < 9) {
            d[i] = this.kdataL[i] * (float)c + (1.0f - (float)c) * this.kdataI[i];
            ++i;
        }
        this.ikL = new Kernel(3, 3, d);
        this.opL = new ConvolveOp(this.ikL);
    }

    void initkernel() {
        this.kernelB = new double[1 + this.RK * 2];
        this.kernelL = new double[1 + this.RK * 2];
        double sum = 0.0;
        int i = 1;
        while (i <= this.RK) {
            double d = (double)(i * 2) / (double)this.RK;
            this.kernelB[this.RK + i] = this.PV * this.gauss(d);
            this.kernelB[this.RK - i] = this.PV * this.gauss(d);
            this.kernelL[this.RK + i] = -this.PV * this.gauss(d);
            this.kernelL[this.RK - i] = -this.PV * this.gauss(d);
            sum += 2.0 * this.PV * this.gauss(d);
            ++i;
        }
        this.kernelB[this.RK] = this.PV;
        this.kernelL[this.RK] = sum;
    }

    public double[] convolve(double[] source, double[] kernel, double scale, double completeness) {
        double[] ndata = new double[this.linedata.length];
        int kcentre = kernel.length / 2;
        double t = 0.0;
        int i = 0;
        while (i < kernel.length) {
            t += kernel[i];
            ++i;
        }
        t += scale;
        i = 0;
        while (i < this.linedata.length) {
            ndata[i] = 0.0;
            int j = 0;
            while (j < kernel.length) {
                int r = Math.min(Math.max(i + j - kcentre, 0), this.linedata.length - 1);
                int n = i;
                ndata[n] = ndata[n] + kernel[j] * this.linedata[r];
                ++j;
            }
            if (completeness < 1.0) {
                ndata[i] = ndata[i] * completeness + t * this.linedata[i] * (1.0 - completeness);
            }
            int n = i++;
            ndata[n] = ndata[n] / t;
        }
        return ndata;
    }

    void linecommand(ActionEvent e) {
        String s = e.getActionCommand();
        switch (this.commandInt(s)) {
            case 0: {
                this.linedata = this.convolve(this.linedata, this.kernelB, 0.0, 0.8 * (double)this.completeness.getValue() / 100.0);
                break;
            }
            case 1: {
                this.linedata = this.convolve(this.linedata, this.kernelL, 20.0, (double)this.completeness.getValue() / 100.0);
                break;
            }
            case 2: {
                this.setupLinedata();
            }
        }
        this.linegraphic.repaint();
    }

    public int commandInt(String s) {
        if (s.equals("Blur")) {
            return 0;
        }
        if (s.equals("Lateral inhibition")) {
            return 1;
        }
        if (s.equals("Restore")) {
            return 2;
        }
        return -1;
    }

    void imagecommand(ActionEvent e) {
        switch (this.commandInt(e.getActionCommand())) {
            case 0: {
                this.image = this.opB.filter(this.image, this.opB.createCompatibleDestImage(this.image, this.image.getColorModel()));
                this.imagegraphic.repaint();
                break;
            }
            case 1: {
                this.createopL();
                this.image = this.opL.filter(this.image, this.opB.createCompatibleDestImage(this.image, this.image.getColorModel()));
                this.imagegraphic.repaint();
                break;
            }
            case 2: {
                this.image.getGraphics().drawImage(this.defaultimage, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
            }
        }
        this.imagegraphic.repaint();
    }

    void strip_actionPerformed(ActionEvent e) {
        this.getHolder().setExhibit("com.neurolab.StripIllusion");
    }

    void cornsweet_actionPerformed(ActionEvent e) {
        this.getHolder().setExhibit("com.neurolab.CornsweetIllusion");
    }

    void stimchange(ActionEvent e) {
        this.setupLinedata();
        this.linegraphic.repaint();
    }

    public void close() {
    }
}

