/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.JPanel0;
import com.neurolab.common.JRadioButton0;
import com.neurolab.common.Label3D;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import javax.swing.border.Border;

public class EyeMovements
extends NeurolabExhibit {
    private static final String[][] strings = new String[][]{{"Head", "velocity", "Eye", "position", "20", "5"}, {"Target", "velocity", "Eye", "position", "20", "2"}, {"Target", "position", "Eye", "position", "20", "2"}, {"Target", "distance", "Vergence", "", "2", "1"}, {"Target", "position", "Eye", "position", "20", "1"}, {"Target", "position", "Eye", "position", "0.2", "2"}};
    private JRadioButton[] radios = new JRadioButton[6];
    private Label3D[] labels = new Label3D[4];
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel0();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    JButton fixationdemo = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel4 = new JPanel0();
    GridLayout gridLayout2 = new GridLayout();
    JRadioButton jRadioButton1 = new JRadioButton0();
    JRadioButton jRadioButton2 = new JRadioButton0();
    JRadioButton jRadioButton3 = new JRadioButton0();
    JRadioButton jRadioButton4 = new JRadioButton0();
    JRadioButton jRadioButton5 = new JRadioButton0();
    JRadioButton jRadioButton6 = new JRadioButton0();
    JPanel jPanel5 = new JPanel0();
    Border border1;
    JPanel jPanel6 = new JPanel0();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border2;
    Border border3;
    Border border4;
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel7 = new JPanel0();
    Border border5;
    Label3D label3D1 = new Label3D();
    Label3D label3D2 = new Label3D();
    Label3D label3D3 = new Label3D();
    Label3D label3D4 = new Label3D();
    int t = 0;
    Oscilloscope osc = new Oscilloscope(2, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (EyeMovements.this.osc != null) {
                EyeMovements.this.osc.clear.doClick();
                EyeMovements.this.osc.setPosY(new int[2]);
            }
            EyeMovements.this.X = 0.0;
            EyeMovements.this.Y = 0.0;
            EyeMovements.this.dy = 0.0;
            EyeMovements.this.cn = 0;
            EyeMovements.this.ct = 0;
            EyeMovements.this.t = 0;
        }
    }){

        public void drawScreenElements(Graphics g) {
            int w = this.getGutter();
            int r = EyeMovements.this.getSelectedRadio();
            g.setColor(Color.black);
            g.fillRect(this.getWidth() - 50 - w, w + 5, 50 - w, 40);
            g.fillRect(this.getWidth() - 40 - w, this.getHeight() - 60 - 2 * w, 45 - 2 * w, 40 - 2 * w);
            g.setFont(this.getFont());
            g.setColor(Color.lightGray);
            g.drawLine(this.getWidth() - 10 - w, 10 + w, this.getWidth() - 10 - w, 40 + w);
            g.drawString(String.valueOf(strings[r][4]) + " deg", this.getWidth() - 50 - w, 30 + w);
            g.drawLine(this.getWidth() - 60 - w, this.getHeight() - 45 - 2 * w, this.getWidth() - 10 - w, this.getHeight() - 45 - 2 * w);
            g.drawString(String.valueOf(strings[r][5]) + " sec", this.getWidth() - 40 - w, this.getHeight() - 30 - 2 * w);
            g.setColor(Color.gray);
            int i = 0;
            while (i < 2) {
                g.drawLine(w, this.baseY[i] + w, this.getWidth() - w, this.baseY[i] + w);
                g.drawString("0", 5 + w, this.baseY[i] + w + 2);
                ++i;
            }
        }
    };
    Random rand = new Random();
    int[] y = new int[2];
    double Y = 0.0;
    double dy = 0.0;
    double X = 0.0;
    int ct = 0;
    Timer timer = new Timer(50, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int r = EyeMovements.this.getSelectedRadio();
            ++EyeMovements.this.t;
            if (EyeMovements.this.t == 1) {
                EyeMovements.this.X = 0.0;
                EyeMovements.this.Y = 0.0;
                EyeMovements.this.dy = 0.0;
            }
            switch (r) {
                case 0: {
                    EyeMovements.this.X = EyeMovements.this.t > 20 && EyeMovements.this.t < 150 ? 20 : 0;
                    if (EyeMovements.this.t == 20) {
                        EyeMovements.this.dy = 10.0;
                    } else if (EyeMovements.this.t == 150) {
                        EyeMovements.this.dy = -10.0;
                    }
                    EyeMovements.this.Y = EyeMovements.this.nystag(EyeMovements.this.dy *= 0.97, 8 + EyeMovements.this.rand.nextInt() % 15);
                    break;
                }
                case 1: {
                    EyeMovements.this.X = EyeMovements.this.t > 20 && EyeMovements.this.t < 170 ? 10 : 0;
                    EyeMovements.this.dy = (12.0 * EyeMovements.this.dy + EyeMovements.this.X) / 15.0;
                    EyeMovements.this.Y = EyeMovements.this.nystag(EyeMovements.this.dy, 8 + EyeMovements.this.rand.nextInt() % 15);
                    break;
                }
                case 2: {
                    double ox = EyeMovements.this.X;
                    EyeMovements.this.X = 10.0 * Math.sin(Math.PI * 4 * (double)EyeMovements.this.t / 100.0);
                    double k = 20 - EyeMovements.this.t / 8;
                    if (k < 0.0) {
                        k = 0.0;
                    }
                    EyeMovements.this.dy = (k * EyeMovements.this.dy + (EyeMovements.this.X - ox + 0.5 - EyeMovements.this.rand.nextDouble())) / (k + 1.0);
                    if (Math.abs(EyeMovements.this.X - EyeMovements.this.Y) > 5.0 && EyeMovements.this.rand.nextInt() % 4 < 2) {
                        EyeMovements.this.Y = EyeMovements.this.X;
                    }
                    EyeMovements.this.Y += EyeMovements.this.dy;
                    break;
                }
                case 3: {
                    EyeMovements.this.X = EyeMovements.this.t % 100 > 50 ? -20 : 20;
                    EyeMovements.this.Y = (7.0 * EyeMovements.this.Y + EyeMovements.this.X) / 8.0;
                    break;
                }
                case 4: {
                    if (EyeMovements.this.rand.nextDouble() > 0.9) {
                        EyeMovements.this.X = -10 + 5 * (EyeMovements.this.rand.nextInt() % 5);
                        EyeMovements.this.ct = 5 + EyeMovements.this.rand.nextInt() % 5;
                    }
                    if (EyeMovements.this.ct == 0) {
                        if (EyeMovements.this.Y > EyeMovements.this.X + 4.0) {
                            EyeMovements.this.dy = -5.0;
                        }
                        if (EyeMovements.this.X - 4.0 > EyeMovements.this.Y) {
                            EyeMovements.this.dy = 5.0;
                        }
                        if (EyeMovements.this.Y < EyeMovements.this.X + 5.0 && EyeMovements.this.Y > EyeMovements.this.X - 5.0) {
                            EyeMovements.this.dy = EyeMovements.this.X - EyeMovements.this.Y;
                            EyeMovements.this.ct = 8;
                        }
                        EyeMovements.this.Y += EyeMovements.this.dy;
                        break;
                    }
                    --EyeMovements.this.ct;
                    break;
                }
                case 5: {
                    EyeMovements.this.X = 0.0;
                    EyeMovements.this.dy = (EyeMovements.this.dy - 2.0 + 4.0 * EyeMovements.this.rand.nextDouble()) / 2.0;
                    EyeMovements.this.Y += EyeMovements.this.dy;
                    if (EyeMovements.this.Y > 5.0 && (double)(EyeMovements.this.rand.nextInt() % 15) < EyeMovements.this.Y) {
                        EyeMovements.this.Y = -1.0;
                    }
                    if (!(EyeMovements.this.Y < -5.0) || !((double)(EyeMovements.this.rand.nextInt() % 15) < -EyeMovements.this.Y)) break;
                    EyeMovements.this.Y = 1.0;
                }
            }
            EyeMovements.this.y[0] = (int)(6.0 * EyeMovements.this.X);
            EyeMovements.this.y[1] = (int)(6.0 * EyeMovements.this.Y);
            EyeMovements.this.osc.setPosY(EyeMovements.this.y);
        }
    });
    int cn;
    ButtonGroup bg = new ButtonGroup();
    int[] basey = new int[]{60, 110};

    public String getExhibitName() {
        return "Eye Movements";
    }

    public double nystag(double dy, double k) {
        this.Y += dy;
        if (this.cn == 0) {
            if (this.Y > k) {
                this.Y = -k + 1.0 - 2.0 * this.rand.nextDouble();
                this.cn = 3;
            }
            if (this.Y < -k) {
                this.Y = k - 1.0 + 2.0 * this.rand.nextDouble();
                this.cn = 3;
            }
        } else {
            --this.cn;
        }
        return this.Y;
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myinit();
    }

    public void myinit() {
        this.radios[0] = this.jRadioButton1;
        this.radios[1] = this.jRadioButton2;
        this.radios[2] = this.jRadioButton3;
        this.radios[3] = this.jRadioButton4;
        this.radios[4] = this.jRadioButton5;
        this.radios[5] = this.jRadioButton6;
        this.labels[0] = this.label3D1;
        this.labels[1] = this.label3D2;
        this.labels[2] = this.label3D3;
        this.labels[3] = this.label3D4;
        int i = 0;
        while (i < 6) {
            this.bg.add(this.radios[i]);
            ++i;
        }
        this.radios[0].setSelected(true);
        this.osc.setBaseY(this.basey);
        this.osc.timer.setDelay(50);
        this.osc.xSpeed = 2;
        this.setLabels();
        this.timer.start();
    }

    public int getSelectedRadio() {
        int i = 0;
        while (i < 6) {
            if (this.radios[i].isSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setLabels() {
        int r = this.getSelectedRadio();
        int i = 0;
        while (i < 4) {
            this.labels[i].setText(strings[r][i]);
            this.labels[i].repaint();
            ++i;
        }
    }

    private void jbInit() throws Exception {
        this.fixationdemo.setBackground(NeurolabExhibit.systemGray);
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border4 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.fixationdemo.setText("Demo of fixation movements");
        this.fixationdemo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.fixationdemo_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.jPanel4.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(3);
        this.gridLayout2.setColumns(2);
        this.jRadioButton1.setText("Vestibular");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jRadioButton2.setText("Optokinesis");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jRadioButton3.setText("Pursuit");
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jRadioButton4.setText("Vergence");
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jRadioButton5.setText("Saccades");
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jRadioButton6.setText("Fixation");
        this.jRadioButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EyeMovements.this.radiochange(e);
            }
        });
        this.jPanel5.setBorder(this.border1);
        this.jPanel5.setLayout(this.borderLayout4);
        this.jPanel6.setBorder(this.border2);
        this.jPanel6.setLayout(this.borderLayout5);
        this.jPanel4.setBorder(this.border3);
        this.jPanel3.setBorder(this.border4);
        this.jPanel7.setPreferredSize(new Dimension(130, 10));
        this.jPanel7.setLayout(null);
        this.label3D1.setFont(new Font("SansSerif", 1, 16));
        this.label3D1.setText("label3D1");
        this.label3D1.setBounds(new Rectangle(18, 24, 112, 27));
        this.label3D2.setBounds(new Rectangle(17, 51, 112, 27));
        this.label3D2.setText("label3D1");
        this.label3D2.setFont(new Font("SansSerif", 1, 16));
        this.label3D3.setBounds(new Rectangle(18, 117, 112, 27));
        this.label3D3.setText("label3D1");
        this.label3D3.setFont(new Font("SansSerif", 1, 16));
        this.label3D4.setBounds(new Rectangle(17, 143, 112, 27));
        this.label3D4.setText("label3D1");
        this.label3D4.setFont(new Font("SansSerif", 1, 16));
        this.osc.setGutter(5);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.fixationdemo, null);
        this.jPanel3.add((Component)this.returnButton1, null);
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jRadioButton1, null);
        this.jPanel4.add((Component)this.jRadioButton4, null);
        this.jPanel4.add((Component)this.jRadioButton2, null);
        this.jPanel4.add((Component)this.jRadioButton5, null);
        this.jPanel4.add((Component)this.jRadioButton3, null);
        this.jPanel4.add((Component)this.jRadioButton6, null);
        this.jPanel5.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.jPanel7, "West");
        this.jPanel7.add((Component)this.label3D4, null);
        this.jPanel7.add((Component)this.label3D1, null);
        this.jPanel7.add((Component)this.label3D2, null);
        this.jPanel7.add((Component)this.label3D3, null);
        this.jPanel6.add((Component)this.osc, "Center");
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "South");
        this.getMainContainer().add((Component)this.jPanel5, "Center");
    }

    void radiochange(ActionEvent e) {
        this.setLabels();
        this.osc.drawScreenElements(this.osc.graph.getGraphics());
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
        this.osc.timer.stop();
    }

    void fixationdemo_actionPerformed(ActionEvent e) {
        this.getHolder().setExhibit("com.neurolab.FixationMovements");
    }
}

