/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class ExhibitChooser
extends NeurolabExhibit
implements ActionListener {
    private String[][] exhibits = new String[][]{{"Cell ionic", "equilibria", "MembranePotentials"}, {"Action", "potentials", "ActPots"}, {"Compound", "A.P.", "CompoundAP"}, {"Passive", "currents", "PassiveCurrents"}, {"Time", "constants", "TimeConstants"}, {"Conduction", "velocity", "ConductionVelocity"}, {"Sensory", "adaptation", "Adaptation"}, {"Lateral", "inhibition", "LateralInhibition"}, {"Synaptic", "interaction", "SynapticInteraction"}, {"Pacinian", "corpuscle", "PacinianCorpuscle"}, {"Sound &", "hearing", "SoundAndHearing"}, {"Basilar", "membrane", "BasilarMembrane"}, {"Phase", "locking", "PhaseLocking"}, {"Vowels", "", "Vowels"}, {"Interaural", "delay", "BinauralCoincidence"}, {"Olfactory", "recognition", "OlfactoryCoding"}, {"Visual", "optics", "VisualOptics"}, {"Line", "Spread", "LineSpread"}, {"Retinal", "receptors", "RetinalReceptors"}, {"Blind", "spot", "BlindSpot"}, {"Horizontal", "cells", "HorizontalCells"}, {"Receptive", "fields", "ReceptiveFields"}, {"Colour", "mixing", "ColourMixing"}, {"Line", "learning", "LineLearning"}, {"Postural", "equilibrium", "PosturalEquilibrium"}, {"Stretch", "reflex", "StretchReflex"}, {"Control", "systems", "ControlSystems"}, {"Parametric", "feedback", "ParametricFeedback"}, {"Cerebellar", "dysmetria", "CerebellarDysmetria"}, {"Cerebellar", "learning", "CerebellarLearning"}, {"Neural", "network", "NeuralNetwork"}, {"Eye", "movements", "EyeMovements"}, {"Brain", "anatomy", "BrainAnatomy"}, {"Spinal", "tracts", "SpinalTracts"}, {"Cortical", "regions", "CorticalAreas"}, {"Anatomical", "pathways", "AnatomicalPathways"}, {"Hypo-", "thalamus", "Hypothalamus"}, {"Pavlovian", "conditioning", "PavlovianConditioning"}, {"Motivation", "model", "MotivationalMaps"}};
    private String iconpath = "resources/icons/";
    private String classprefix = "com.neurolab.";
    private Image[] bitmap;
    private Dimension gridsize;
    PictureButton[] button;
    boolean DRAW_BEVEL = false;

    public void init() {
        super.init();
        this.bitmap = new Image[this.exhibits.length];
        int i = 0;
        while (i < this.exhibits.length) {
            if (this.exhibits[i][0] != "") {
                this.bitmap[i] = this.getImage(String.valueOf(this.iconpath) + this.exhibits[i][2] + ".GIF");
            }
            ++i;
        }
        this.gridsize = new Dimension(7, 6);
        GridLayout gl = new GridLayout(this.gridsize.width, this.gridsize.height);
        gl.setHgap(2);
        gl.setVgap(2);
        this.getMainContainer().setLayout(gl);
        this.createComponents();
        this.getMainContainer().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NeurolabExhibit.plafset = false;
                }
            }
        });
    }

    public void createComponents() {
        this.button = new PictureButton[this.exhibits.length];
        int i = 0;
        while (i < this.exhibits.length) {
            this.button[i] = this.exhibits[i][0] != "" ? new PictureButton(this.bitmap[i], this.exhibits[i][0], this.exhibits[i][1]) : new PictureButton(null, this.exhibits[i][0], this.exhibits[i][1]);
            this.getMainContainer().add(this.button[i]);
            this.button[i].addActionListener(this);
            this.button[i].setActionCommand(this.exhibits[i][2]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != "") {
            this.getHolder().setExhibit(String.valueOf(this.classprefix) + e.getActionCommand());
        }
    }

    public String getExhibitName() {
        return "";
    }

    public void close() {
    }

    public class PictureButton
    extends JButton {
        Image image;
        String text1;
        String text2;
        Font font;
        public final int inset = 7;
        public final int bt = 2;

        public PictureButton(Image im, String t1, String t2) {
            this.image = im;
            this.text1 = t1;
            this.text2 = t2;
            this.setBackground(NeurolabExhibit.systemGray);
            this.setMargin(new Insets(2, 2, 2, 2));
            this.font = this.getFont();
            this.font = new Font(this.font.getName(), 0, this.font.getSize() - 1);
            this.setFont(this.font);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ExhibitChooser.this.DRAW_BEVEL) {
                g.setColor(Color.white);
                g.drawLine(2, 2, this.getWidth() - 4, 2);
                g.drawLine(2, 2, 2, this.getHeight() - 4);
                g.setColor(Color.gray);
                g.drawLine(2, this.getHeight() - 4, this.getWidth() - 4, this.getHeight() - 4);
                g.drawLine(this.getWidth() - 4, 2, this.getWidth() - 4, this.getHeight() - 4);
            }
            if (this.image != null) {
                g.drawImage(this.image, 7, 7, this.getHeight() - 14, this.getHeight() - 14, this);
            }
            g.setColor(Color.black);
            g.setFont(this.font);
            g.drawString(this.text1, this.getWidth() / 2 - 7, 15);
            g.drawString(this.text2, this.getWidth() / 2 - 7, 30);
        }

        public boolean imageUpdate(Image i, int f, int x, int y, int w, int h) {
            if ((f & 0x20) > 0) {
                this.repaint();
                return false;
            }
            return true;
        }
    }
}

