/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.FullScreenExhibit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CornsweetIllusion
extends FullScreenExhibit {
    double centre = 0.21;
    int bands = 80;
    JPanel mainpanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(CornsweetIllusion.this.mix(this.getForeground(), this.getBackground(), 0.5));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int mid = this.getWidth() / 2;
            double mw = (double)this.getWidth() * CornsweetIllusion.this.centre;
            double bw = mw / (double)CornsweetIllusion.this.bands;
            int x = 0;
            while (x < CornsweetIllusion.this.bands) {
                g.setColor(CornsweetIllusion.this.mix(this.getForeground(), this.getBackground(), (double)(CornsweetIllusion.this.reverse ? x : CornsweetIllusion.this.bands - 1 - x) / (double)CornsweetIllusion.this.bands));
                if (x < CornsweetIllusion.this.bands / 2) {
                    g.fillRect((int)((double)mid + (double)x * bw), 0, 1 + (int)bw, this.getHeight());
                } else {
                    g.fillRect((int)((double)mid - mw / 2.0 + (double)(x - CornsweetIllusion.this.bands / 2) * bw), 0, 1 + (int)bw, this.getHeight());
                }
                ++x;
            }
        }
    };
    boolean reverse = false;
    Timer timer = new Timer(2000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            CornsweetIllusion.this.reverse = !CornsweetIllusion.this.reverse;
            CornsweetIllusion.this.mainpanel.repaint();
        }
    });

    public String getExhibitName() {
        return "Cornsweet illusion";
    }

    Color mix(Color a, Color b, double f) {
        return new Color((int)(f * (double)a.getRed() + (1.0 - f) * (double)b.getRed()), (int)(f * (double)a.getGreen() + (1.0 - f) * (double)b.getGreen()), (int)(f * (double)a.getBlue() + (1.0 - f) * (double)b.getBlue()));
    }

    public void init() {
        this.parentExhibit = "com.neurolab.LateralInhibition";
        super.init();
        this.mainpanel.setForeground(new Color(128, 128, 128));
        this.mainpanel.setBackground(new Color(192, 192, 192));
        this.frame.getContentPane().add((Component)this.mainpanel, "Center");
        this.timer.start();
        this.frame.validate();
    }

    public void doClose() {
        super.doClose();
        this.timer.stop();
    }

    public void close() {
        this.timer.stop();
    }
}

