/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.GraphicComponent;
import com.neurolab.common.JPanel0;
import com.neurolab.common.JRadioButton0;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ControlSystems
extends NeurolabExhibit {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel0();
    BorderLayout borderLayout3 = new BorderLayout();
    Oscilloscope oscilloscope1 = new Oscilloscope(2, null);
    JPanel jPanel4 = new JPanel0();
    JPanel jPanel5 = new JPanel0();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel3 = new JPanel0();
    JPanel jPanel6 = new JPanel0();
    Border border1;
    TitledBorder titledBorder1;
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel7 = new JPanel0();
    JPanel jPanel8 = new JPanel0();
    JRadioButton controlprop = new JRadioButton0();
    JRadioButton controlrate = new JRadioButton0();
    JRadioButton controlintegral = new JRadioButton0();
    GridLayout gridLayout3 = new GridLayout();
    JSlider gainslider = new JSlider();
    JSlider biasslider = new JSlider();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    Border border2;
    Border border3;
    JPanel jPanel9 = new JPanel0();
    BorderLayout borderLayout4 = new BorderLayout();
    ReturnButton returnButton1 = new ReturnButton();
    JSlider externalslider = new JSlider();
    JLabel jLabel3 = new JLabel();
    JSlider plantgainslider = new JSlider();
    JLabel jLabel4 = new JLabel();
    JPanel jPanel10 = new JPanel0();
    Border border4;
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel11 = new JPanel0();
    Border border5;
    JPanel jPanel12 = new JPanel0();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    Border border6;
    ButtonGroup bg = new ButtonGroup();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel13 = new JPanel0();
    GridLayout gridLayout4 = new GridLayout();
    JPanel jPanel14 = new JPanel0();
    JPanel jPanel15 = new JPanel0();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    JRadioButton ballistic = new JRadioButton0();
    JRadioButton directfb = new JRadioButton0();
    JRadioButton internalfb = new JRadioButton0();
    JCheckBox parametricfb = new JCheckBox();
    JCheckBox feedforward = new JCheckBox();
    JCheckBox plantdelay = new JCheckBox();
    JPanel graphicpanel = new JPanel0();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    GraphicComponent graphicComponent2 = new GraphicComponent();
    GraphicComponent graphicComponent3 = new GraphicComponent();
    GraphicComponent graphicComponent4 = new GraphicComponent();
    GraphicComponent graphicComponent1 = new GraphicComponent();
    JPanel gfeedforward = new JPanel0();
    GraphicComponent feedforw1 = new GraphicComponent();
    GraphicComponent feedforw2 = new GraphicComponent();
    JPanel directfbpanel = new JPanel();
    GraphicComponent graphicComponent8 = new GraphicComponent();
    GraphicComponent dfbarrow1 = new GraphicComponent();
    GraphicComponent graphicComponent10 = new GraphicComponent();
    GraphicComponent dfbarrow2 = new GraphicComponent();
    JLabel jLabel12 = new JLabel();
    JPanel modelpanel = new JPanel();
    GraphicComponent graphicComponent7 = new GraphicComponent();
    GraphicComponent graphicComponent12 = new GraphicComponent();
    JPanel directfbpanelr = new JPanel();
    GraphicComponent graphicComponent9 = new GraphicComponent();
    GraphicComponent graphicComponent11 = new GraphicComponent();
    JPanel paramballpanel = new JPanel();
    GraphicComponent graphicComponent13 = new GraphicComponent();
    GraphicComponent graphicComponent14 = new GraphicComponent();
    GraphicComponent graphicComponent15 = new GraphicComponent();
    GraphicComponent graphicComponent16 = new GraphicComponent();
    GraphicComponent graphicComponent17 = new GraphicComponent();
    GraphicComponent graphicComponent18 = new GraphicComponent();
    GraphicComponent dot01 = new GraphicComponent();
    JPanel internalfbpanel = new JPanel();
    GraphicComponent graphicComponent5 = new GraphicComponent();
    GraphicComponent graphicComponent6 = new GraphicComponent();
    GraphicComponent graphicComponent20 = new GraphicComponent();
    GraphicComponent graphicComponent19 = new GraphicComponent();
    GraphicComponent graphicComponent21 = new GraphicComponent();
    GraphicComponent graphicComponent22 = new GraphicComponent();
    GraphicComponent graphicComponent23 = new GraphicComponent();
    ButtonGroup bg2 = new ButtonGroup();
    Timer timer = new Timer(80, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ControlSystems.this.calc();
            ControlSystems.this.oscilloscope1.setPosY(new int[]{(int)(512.0 + ControlSystems.this.Y * 450.0 / 30.0), (int)(512.0 + ControlSystems.this.X * 450.0 / 30.0)});
        }
    });
    double oldv;
    double v;
    double sumv;
    double X;
    double Y;
    double m;
    double j;
    double cgain;
    double u;
    double w;
    double rate;
    int model;
    int controller;
    double gain;
    double bias;
    int t = 0;
    double[] del = new double[6];

    public String getExhibitName() {
        return "Control Systems";
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.myinit();
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.t = 0;
            }
        };
        this.oscilloscope1.sweep.addActionListener(al);
        this.oscilloscope1.clear.addActionListener(al);
        this.oscilloscope1.timer.setDelay(80);
        this.oscilloscope1.xSpeed = 2;
        this.setupDiagram();
        this.timer.start();
    }

    public void myinit() {
        this.bg.add(this.controlprop);
        this.bg.add(this.controlrate);
        this.bg.add(this.controlintegral);
        this.bg2.add(this.ballistic);
        this.bg2.add(this.directfb);
        this.bg2.add(this.internalfb);
        this.controlprop.doClick();
        this.ballistic.doClick();
    }

    public void calc() {
        this.gain = this.gainslider.getValue();
        this.bias = this.biasslider.getValue();
        this.model = this.modeltype();
        this.controller = this.contype();
        ++this.t;
        this.j = this.t++ % 120;
        if (this.j > 60.0) {
            this.j = 120.0 - this.j;
        }
        this.X = this.limit(2.0 * this.j - 60.0, -30.0, 30.0);
        this.oldv = this.v;
        this.sumv = this.sumv * 0.98 + 0.02 * this.v;
        switch (this.model) {
            case 0: {
                this.v = this.X;
                break;
            }
            case 1: {
                this.m = 0.9 * this.m + 0.1 * (this.gain * this.w / 500.0 + this.bias / 100.0);
                this.v = this.X - this.m;
                break;
            }
            case 2: {
                this.v = this.X - this.Y;
            }
        }
        if (this.feedforward.isSelected()) {
            this.v -= (double)this.externalslider.getValue();
        }
        switch (this.controller) {
            case 0: {
                this.w = this.cgain * this.v;
                break;
            }
            case 1: {
                this.rate = 0.9 * this.rate + 0.1 * (this.v - this.oldv);
                if (this.model == 0) {
                    this.w = this.cgain * (this.v + 10.0 * this.rate);
                    break;
                }
                if (this.plantdelay.isSelected() && this.model == 2) {
                    this.w = this.cgain * (this.v - 5.0 * this.rate);
                    break;
                }
                this.w = this.cgain * (this.v + 10.0 * this.rate);
                break;
            }
            case 2: {
                this.w = this.cgain * (this.v + 5.0 * this.sumv);
            }
        }
        if (this.model != 0) {
            this.w *= 3.0;
        }
        if (this.model != 1) {
            this.w += (double)(this.biasslider.getValue() / 10);
        }
        this.u = this.u * 0.9 + 0.1 * this.w * (double)this.plantgainslider.getValue() / 50.0;
        this.Y = this.plantdelay.isSelected() ? (double)this.externalslider.getValue() + this.delayer(this.u) : (double)this.externalslider.getValue() + this.u;
        this.cgain = this.gain / 500.0;
        if (this.model == 1) {
            this.cgain = 1.0;
        }
        if (this.parametricfb.isSelected()) {
            this.adjust();
        }
    }

    double delayer(double z) {
        double d = this.del[0];
        int i = 0;
        while (i < 5) {
            this.del[i] = this.del[i + 1];
            ++i;
        }
        this.del[5] = z;
        return d;
    }

    void adjust() {
        switch (this.model) {
            case 0: {
                this.biasslider.setValue((int)this.limit(this.bias - (this.Y - this.X) / 20.0, -300.0, 300.0));
                this.gainslider.setValue((int)this.limit(this.gain - (Math.abs(this.Y) - Math.abs(this.X)) / 20.0, 200.0, 700.0));
                break;
            }
            case 1: {
                this.biasslider.setValue((int)this.limit((this.bias + (this.Y - this.m)) / 10.0, -300.0, 300.0));
                this.gainslider.setValue((int)this.limit(this.gain + (Math.abs(this.Y) - Math.abs(this.m)) / 10.0, 200.0, 700.0));
            }
        }
    }

    public double limit(double x, double min, double max) {
        return x > max ? max : (x < min ? min : x);
    }

    private void jbInit() throws Exception {
        this.gainslider.setMaximum(700);
        this.gainslider.setMinimum(200);
        this.gainslider.setBackground(NeurolabExhibit.systemGray);
        this.biasslider.setMaximum(300);
        this.biasslider.setMinimum(-300);
        this.biasslider.setValue(0);
        this.biasslider.setBackground(NeurolabExhibit.systemGray);
        this.externalslider.setValue(0);
        this.externalslider.setMaximum(20);
        this.externalslider.setMinimum(-20);
        this.externalslider.setBackground(NeurolabExhibit.systemGray);
        this.plantgainslider.setMaximum(60);
        this.plantgainslider.setMinimum(30);
        this.plantgainslider.setBackground(NeurolabExhibit.systemGray);
        this.parametricfb.setBackground(NeurolabExhibit.systemGray);
        this.feedforward.setBackground(NeurolabExhibit.systemGray);
        this.plantdelay.setBackground(NeurolabExhibit.systemGray);
        this.border1 = BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115));
        this.titledBorder1 = new TitledBorder(this.border1, "Controller");
        this.border2 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.border3 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.border4 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border5 = BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115));
        this.border6 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.oscilloscope1.setPreferredSize(new Dimension(250, 130));
        this.oscilloscope1.setGutter(3);
        this.jPanel1.setPreferredSize(new Dimension(150, 125));
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jPanel3.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115)), "Controller"));
        this.jPanel3.setLayout(this.gridLayout2);
        this.jPanel6.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115)), "Noise"));
        this.jPanel6.setLayout(null);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setColumns(1);
        this.controlprop.setText("Proportional");
        this.controlrate.setText("Prop + rate");
        this.controlintegral.setText("Prop + integral");
        this.jPanel7.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(3);
        this.gridLayout3.setColumns(1);
        this.jPanel8.setLayout(null);
        this.gainslider.setBounds(new Rectangle(0, 0, 118, 24));
        this.biasslider.setBounds(new Rectangle(0, 41, 118, 24));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setText("Gain");
        this.jLabel1.setBounds(new Rectangle(46, 21, 31, 17));
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setText("Bias");
        this.jLabel2.setBounds(new Rectangle(45, 61, 27, 16));
        this.jPanel9.setLayout(this.borderLayout4);
        this.externalslider.setBounds(new Rectangle(10, 33, 110, 26));
        this.jLabel3.setText("External");
        this.jLabel3.setBounds(new Rectangle(44, 58, 51, 17));
        this.plantgainslider.setBounds(new Rectangle(9, 82, 111, 24));
        this.jLabel4.setText("Plant gain");
        this.jLabel4.setBounds(new Rectangle(38, 106, 61, 17));
        this.jPanel10.setBorder(this.border4);
        this.jPanel10.setLayout(this.borderLayout5);
        this.jPanel11.setBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)));
        this.jPanel11.setLayout(this.borderLayout6);
        this.jPanel12.setLayout(null);
        this.jPanel12.setPreferredSize(new Dimension(13, 1));
        this.jLabel5.setFont(new Font("SansSerif", 1, 16));
        this.jLabel5.setForeground(Color.green);
        this.jLabel5.setText("x");
        this.jLabel5.setBounds(new Rectangle(3, 24, 14, 17));
        this.jLabel6.setFont(new Font("Dialog", 1, 16));
        this.jLabel6.setForeground(Color.red);
        this.jLabel6.setText("y");
        this.jLabel6.setBounds(new Rectangle(3, 58, 13, 17));
        this.jPanel13.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(2);
        this.jPanel14.setLayout(this.gridLayout5);
        this.gridLayout5.setRows(3);
        this.gridLayout5.setColumns(1);
        this.jPanel15.setLayout(this.gridLayout6);
        this.gridLayout6.setRows(3);
        this.gridLayout6.setColumns(1);
        this.ballistic.setToolTipText("");
        this.ballistic.setSelected(true);
        this.ballistic.setText("Ballistic");
        this.ballistic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.directfb.setText("Direct FB");
        this.directfb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.internalfb.setText("Internal FB");
        this.internalfb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.parametricfb.setText("Parametric FB");
        this.parametricfb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.feedforward.setText("Feedforward");
        this.feedforward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.plantdelay.setText("Plant Delay");
        this.plantdelay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlSystems.this.changetype(e);
            }
        });
        this.graphicpanel.setLayout(null);
        this.jLabel7.setBackground(Color.red);
        this.jLabel7.setFont(new Font("SansSerif", 1, 18));
        this.jLabel7.setOpaque(true);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("x");
        this.jLabel7.setBounds(new Rectangle(10, 114, 20, 31));
        this.jLabel8.setBounds(new Rectangle(272, 113, 23, 31));
        this.jLabel8.setText("y");
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setOpaque(true);
        this.jLabel8.setFont(new Font("SansSerif", 1, 18));
        this.jLabel8.setBackground(Color.green);
        this.jLabel9.setBounds(new Rectangle(90, 117, 62, 31));
        this.jLabel9.setText("Controller");
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setOpaque(true);
        this.jLabel9.setFont(new Font("SansSerif", 1, 12));
        this.jLabel9.setForeground(Color.white);
        this.jLabel9.setBackground(Color.darkGray);
        this.jLabel10.setBackground(Color.darkGray);
        this.jLabel10.setForeground(Color.white);
        this.jLabel10.setFont(new Font("SansSerif", 1, 12));
        this.jLabel10.setOpaque(true);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("Plant");
        this.jLabel10.setBounds(new Rectangle(180, 116, 62, 31));
        this.jLabel11.setFont(new Font("Dialog", 1, 12));
        this.jLabel11.setText("Noise");
        this.jLabel11.setBounds(new Rectangle(268, 61, 37, 20));
        this.graphicComponent2.setType(2);
        this.graphicComponent2.setThickness(2);
        this.graphicComponent2.setArrow(1);
        this.graphicComponent2.setBounds(new Rectangle(29, 121, 61, 19));
        this.graphicComponent3.setBounds(new Rectangle(151, 122, 29, 19));
        this.graphicComponent3.setArrow(1);
        this.graphicComponent3.setThickness(2);
        this.graphicComponent3.setType(2);
        this.graphicComponent4.setBounds(new Rectangle(241, 120, 30, 19));
        this.graphicComponent4.setArrow(1);
        this.graphicComponent4.setThickness(2);
        this.graphicComponent4.setType(2);
        this.graphicComponent1.setToolTipText("");
        this.graphicComponent1.setType(3);
        this.graphicComponent1.setThickness(2);
        this.graphicComponent1.setArrow(1);
        this.graphicComponent1.setBounds(new Rectangle(274, 80, 20, 32));
        this.gfeedforward.setBounds(new Rectangle(76, 60, 190, 57));
        this.gfeedforward.setLayout(null);
        this.feedforw1.setType(2);
        this.feedforw1.setThickness(2);
        this.feedforw1.setBounds(new Rectangle(50, 6, 136, 13));
        this.feedforw2.setType(3);
        this.feedforw2.setThickness(2);
        this.feedforw2.setArrow(1);
        this.feedforw2.setBounds(new Rectangle(44, 13, 14, 44));
        this.directfbpanel.setOpaque(false);
        this.directfbpanel.setBounds(new Rectangle(41, 117, 61, 99));
        this.directfbpanel.setLayout(null);
        this.graphicComponent8.setType(2);
        this.graphicComponent8.setThickness(2);
        this.graphicComponent8.setBounds(new Rectangle(24, 60, 39, 18));
        this.dfbarrow1.setType(3);
        this.dfbarrow1.setThickness(2);
        this.dfbarrow1.setArrow(2);
        this.dfbarrow1.setBounds(new Rectangle(13, 20, 20, 51));
        this.graphicComponent10.setType(4);
        this.graphicComponent10.setBounds(new Rectangle(18, 8, 11, 12));
        this.dfbarrow2.setType(2);
        this.dfbarrow2.setThickness(2);
        this.dfbarrow2.setArrow(1);
        this.dfbarrow2.setBounds(new Rectangle(4, 4, 14, 19));
        this.jLabel12.setBackground(Color.darkGray);
        this.jLabel12.setFont(new Font("Dialog", 1, 12));
        this.jLabel12.setForeground(Color.white);
        this.jLabel12.setOpaque(true);
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setHorizontalTextPosition(0);
        this.jLabel12.setText("Model");
        this.jLabel12.setBounds(new Rectangle(-1, 39, 62, 31));
        this.modelpanel.setOpaque(false);
        this.modelpanel.setBounds(new Rectangle(90, 132, 86, 73));
        this.modelpanel.setLayout(null);
        this.graphicComponent7.setType(3);
        this.graphicComponent7.setThickness(2);
        this.graphicComponent7.setBounds(new Rectangle(66, 0, 15, 55));
        this.graphicComponent12.setType(2);
        this.graphicComponent12.setThickness(2);
        this.graphicComponent12.setArrow(2);
        this.graphicComponent12.setBounds(new Rectangle(61, 43, 13, 20));
        this.directfbpanelr.setOpaque(false);
        this.directfbpanelr.setBounds(new Rectangle(96, 144, 195, 72));
        this.directfbpanelr.setLayout(null);
        this.graphicComponent9.setToolTipText("");
        this.graphicComponent9.setType(2);
        this.graphicComponent9.setThickness(2);
        this.graphicComponent9.setBounds(new Rectangle(-1, 31, 189, 22));
        this.graphicComponent11.setType(3);
        this.graphicComponent11.setThickness(2);
        this.graphicComponent11.setBounds(new Rectangle(178, 0, 19, 44));
        this.paramballpanel.setOpaque(false);
        this.paramballpanel.setBounds(new Rectangle(48, 129, 239, 82));
        this.paramballpanel.setLayout(null);
        this.graphicComponent13.setToolTipText("");
        this.graphicComponent13.setType(3);
        this.graphicComponent13.setThickness(2);
        this.graphicComponent13.setBounds(new Rectangle(3, 1, 14, 57));
        this.graphicComponent14.setType(2);
        this.graphicComponent14.setThickness(2);
        this.graphicComponent14.setArrow(2);
        this.graphicComponent14.setBounds(new Rectangle(81, 50, 153, 15));
        this.graphicComponent15.setType(3);
        this.graphicComponent15.setThickness(2);
        this.graphicComponent15.setBounds(new Rectangle(227, 15, 12, 43));
        this.graphicComponent16.setBounds(new Rectangle(9, 50, 60, 15));
        this.graphicComponent16.setThickness(2);
        this.graphicComponent16.setArrow(1);
        this.graphicComponent16.setType(2);
        this.graphicComponent17.setType(4);
        this.graphicComponent17.setBounds(new Rectangle(69, 51, 12, 12));
        this.graphicComponent18.setType(3);
        this.graphicComponent18.setThickness(2);
        this.graphicComponent18.setBounds(new Rectangle(64, 22, 23, 31));
        this.dot01.setType(4);
        this.dot01.setBounds(new Rectangle(73, 19, 5, 5));
        this.internalfbpanel.setOpaque(false);
        this.internalfbpanel.setBounds(new Rectangle(56, 143, 234, 83));
        this.internalfbpanel.setLayout(null);
        this.graphicComponent5.setType(3);
        this.graphicComponent5.setThickness(2);
        this.graphicComponent5.setBounds(new Rectangle(222, 0, 10, 77));
        this.graphicComponent6.setType(2);
        this.graphicComponent6.setThickness(2);
        this.graphicComponent6.setArrow(2);
        this.graphicComponent6.setBounds(new Rectangle(74, 71, 154, 10));
        this.graphicComponent20.setBounds(new Rectangle(7, 71, 56, 10));
        this.graphicComponent20.setThickness(2);
        this.graphicComponent20.setArrow(1);
        this.graphicComponent20.setType(2);
        this.graphicComponent19.setType(3);
        this.graphicComponent19.setThickness(2);
        this.graphicComponent19.setBounds(new Rectangle(3, 43, 11, 33));
        this.graphicComponent21.setType(4);
        this.graphicComponent21.setBounds(new Rectangle(62, 69, 12, 13));
        this.graphicComponent22.setType(3);
        this.graphicComponent22.setThickness(2);
        this.graphicComponent22.setBounds(new Rectangle(61, 59, 13, 11));
        this.graphicComponent23.setType(4);
        this.graphicComponent23.setBounds(new Rectangle(65, 59, 5, 5));
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jPanel5.add((Component)this.oscilloscope1, null);
        this.oscilloscope1.add((Component)this.jPanel12, "West");
        this.jPanel12.add((Component)this.jLabel6, null);
        this.jPanel12.add((Component)this.jLabel5, null);
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jPanel7, null);
        this.jPanel7.add((Component)this.controlprop, null);
        this.jPanel7.add((Component)this.controlrate, null);
        this.jPanel7.add((Component)this.controlintegral, null);
        this.jPanel3.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.gainslider, null);
        this.jPanel8.add((Component)this.jLabel1, null);
        this.jPanel8.add((Component)this.biasslider, null);
        this.jPanel8.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.returnButton1, "South");
        this.jPanel9.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.plantgainslider, null);
        this.jPanel6.add((Component)this.jLabel4, null);
        this.jPanel6.add((Component)this.externalslider, null);
        this.jPanel6.add((Component)this.jLabel3, null);
        this.jPanel1.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.jPanel11, "Center");
        this.jPanel11.add((Component)this.jPanel13, "South");
        this.jPanel13.add((Component)this.jPanel14, null);
        this.jPanel14.add((Component)this.ballistic, null);
        this.jPanel14.add((Component)this.directfb, null);
        this.jPanel14.add((Component)this.internalfb, null);
        this.jPanel13.add((Component)this.jPanel15, null);
        this.jPanel15.add((Component)this.parametricfb, null);
        this.jPanel15.add((Component)this.feedforward, null);
        this.jPanel15.add((Component)this.plantdelay, null);
        this.jPanel11.add((Component)this.graphicpanel, "Center");
        this.modelpanel.add((Component)this.jLabel12, null);
        this.modelpanel.add((Component)this.graphicComponent7, null);
        this.modelpanel.add((Component)this.graphicComponent12, null);
        this.internalfbpanel.add((Component)this.graphicComponent5, null);
        this.internalfbpanel.add((Component)this.graphicComponent6, null);
        this.internalfbpanel.add((Component)this.graphicComponent20, null);
        this.internalfbpanel.add((Component)this.graphicComponent21, null);
        this.internalfbpanel.add((Component)this.graphicComponent19, null);
        this.internalfbpanel.add((Component)this.graphicComponent22, null);
        this.internalfbpanel.add((Component)this.graphicComponent23, null);
        this.directfbpanelr.add((Component)this.graphicComponent9, null);
        this.directfbpanelr.add((Component)this.graphicComponent11, null);
        this.graphicpanel.add((Component)this.graphicComponent2, null);
        this.graphicpanel.add((Component)this.jLabel11, null);
        this.graphicpanel.add((Component)this.jLabel8, null);
        this.graphicpanel.add((Component)this.jLabel7, null);
        this.graphicpanel.add((Component)this.graphicComponent4, null);
        this.graphicpanel.add((Component)this.graphicComponent1, null);
        this.gfeedforward.add((Component)this.feedforw1, null);
        this.gfeedforward.add((Component)this.feedforw2, null);
        this.graphicpanel.add((Component)this.jLabel10, null);
        this.graphicpanel.add((Component)this.graphicComponent3, null);
        this.graphicpanel.add((Component)this.jLabel9, null);
        this.paramballpanel.add((Component)this.graphicComponent13, null);
        this.paramballpanel.add((Component)this.graphicComponent14, null);
        this.paramballpanel.add((Component)this.graphicComponent15, null);
        this.paramballpanel.add((Component)this.graphicComponent16, null);
        this.paramballpanel.add((Component)this.graphicComponent17, null);
        this.paramballpanel.add((Component)this.graphicComponent18, null);
        this.paramballpanel.add((Component)this.dot01, null);
        this.directfbpanel.add((Component)this.graphicComponent8, null);
        this.directfbpanel.add((Component)this.dfbarrow1, null);
        this.directfbpanel.add((Component)this.graphicComponent10, null);
        this.directfbpanel.add((Component)this.dfbarrow2, null);
        this.graphicpanel.add((Component)this.modelpanel, null);
        this.graphicpanel.add((Component)this.directfbpanelr, null);
        this.graphicpanel.add((Component)this.paramballpanel, null);
        this.graphicpanel.add((Component)this.directfbpanel, null);
        this.graphicpanel.add((Component)this.internalfbpanel, null);
        this.graphicpanel.add((Component)this.gfeedforward, null);
        this.gainslider.setValue(500);
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    void setupDiagram() {
        if (this.directfb.isSelected() && this.parametricfb.isSelected()) {
            this.parametricfb.setSelected(false);
        }
        this.directfbpanel.setVisible(false);
        this.paramballpanel.setVisible(false);
        this.directfbpanelr.setVisible(false);
        this.internalfbpanel.setVisible(false);
        this.modelpanel.setVisible(false);
        this.gfeedforward.setVisible(false);
        if (this.feedforward.isSelected()) {
            this.gfeedforward.setVisible(true);
        }
        if (this.directfb.isSelected()) {
            this.directfbpanel.setVisible(true);
            this.directfbpanelr.setVisible(true);
        }
        if (this.ballistic.isSelected() && this.parametricfb.isSelected()) {
            this.paramballpanel.setVisible(true);
        }
        if (this.internalfb.isSelected()) {
            this.modelpanel.setVisible(true);
            this.directfbpanel.setVisible(true);
            if (this.parametricfb.isSelected()) {
                this.internalfbpanel.setVisible(true);
            }
        }
        this.graphicpanel.repaint();
    }

    int modeltype() {
        if (this.ballistic.isSelected()) {
            return 0;
        }
        if (this.directfb.isSelected()) {
            return 2;
        }
        if (this.internalfb.isSelected()) {
            return 1;
        }
        return -1;
    }

    int contype() {
        if (this.controlprop.isSelected()) {
            return 0;
        }
        if (this.controlrate.isSelected()) {
            return 1;
        }
        if (this.controlintegral.isSelected()) {
            return 2;
        }
        return -1;
    }

    void changetype(ActionEvent e) {
        this.setupDiagram();
    }

    public void close() {
        this.timer.stop();
    }
}

