/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.JPanel0;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ConductionVelocity
extends NeurolabExhibit {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel0();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel3 = new JPanel0();
    JPanel jPanel4 = new JPanel0();
    JPanel jPanel5 = new JPanel0();
    JLabel jLabel1 = new JLabel();
    Border border1;
    JPanel jPanel6 = new JPanel0();
    BorderLayout borderLayout4 = new BorderLayout();
    Border border2;
    TitledBorder titledBorder1;
    JPanel jPanel7 = new JPanel0();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel8 = new JPanel0();
    JPanel jPanel9 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanel10 = new JPanel0();
    JPanel jPanel11 = new JPanel0();
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    JCheckBox myelinated = new JCheckBox();
    BorderLayout borderLayout5 = new BorderLayout();
    Border border5;
    Border border6;
    JTextPane veltext = new JTextPane();
    Border border7;
    JLabel jLabel2 = new JLabel();
    JPanel jPanel13 = new JPanel0();
    JTextPane diamtext = new JTextPane();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JPanel jPanel14 = new JPanel0();
    JTextPane myeltext = new JTextPane();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel15 = new JPanel0();
    JTextPane rltext = new JTextPane();
    JLabel jLabel4 = new JLabel();
    JPanel jPanel16 = new JPanel0();
    JTextPane cmtext = new JTextPane();
    JLabel jLabel5 = new JLabel();
    GridLayout gridLayout3 = new GridLayout();
    JTextPane rmtext = new JTextPane();
    JLabel jLabel6 = new JLabel();
    JPanel jPanel17 = new JPanel0();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    JPanel jPanel18 = new JPanel0();
    FlowLayout flowLayout4 = new FlowLayout();
    JTextPane ttext = new JTextPane();
    JLabel jLabel7 = new JLabel();
    JPanel jPanel19 = new JPanel0();
    FlowLayout flowLayout5 = new FlowLayout();
    JTextPane ltext = new JTextPane();
    JLabel jLabel8 = new JLabel();
    GridLayout gridLayout4 = new GridLayout();
    Border border8;
    JPanel jPanel20 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JButton diamInc = new JButton();
    JButton diamDec = new JButton();
    JButton myelDec = new JButton();
    JButton myelInc = new JButton();
    GridLayout gridLayout6 = new GridLayout();
    JPanel jPanel21 = new JPanel();
    JPanel picture = new JPanel0(){

        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            Point centre = new Point(this.getWidth() / 2, this.getHeight() / 2);
            int outerR = (int)(ConductionVelocity.this.diam * 10.0 / 2.0);
            int innerR = (int)(ConductionVelocity.this.innr * 10.0 / 2.0);
            g.setColor(Color.black);
            g.fillOval(centre.x - outerR, centre.y - outerR, 2 * outerR, 2 * outerR);
            g.setColor(Color.yellow);
            g.fillOval(centre.x - innerR, centre.y - innerR, 2 * innerR, 2 * innerR);
        }
    };
    double p;
    double q;
    double sa;
    double csa;
    double middle;
    double innr;
    double cm;
    double rm;
    double rl;
    double tau;
    double lambda;
    double v;
    double th;
    double diam;
    double oth = 0.5;

    public String getExhibitName() {
        return "Conduction velocity";
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ImageIcon iinc = new ImageIcon(this.getImage("resources/bitmaps/UpTriangle.GIF"));
        ImageIcon idec = new ImageIcon(this.getImage("resources/bitmaps/DownTriangle.GIF"));
        this.diamInc.setIcon(iinc);
        this.diamDec.setIcon(idec);
        this.myelInc.setIcon(iinc);
        this.myelDec.setIcon(idec);
        this.reset();
    }

    private void jbInit() throws Exception {
        this.veltext.setContentType("text/html");
        this.diamtext.setContentType("text/html");
        this.myeltext.setContentType("text/html");
        this.rltext.setContentType("text/html");
        this.cmtext.setContentType("text/html");
        this.rmtext.setContentType("text/html");
        this.ttext.setContentType("text/html");
        this.ltext.setContentType("text/html");
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.border2 = BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115));
        this.titledBorder1 = new TitledBorder(this.border2, "Design parameters");
        this.border3 = BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115));
        this.titledBorder2 = new TitledBorder(this.border3, "Myelin");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border5 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.border6 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.border7 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, Color.gray, Color.darkGray), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border8 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, new Color(255, 255, 235), Color.white, new Color(135, 133, 115), new Color(94, 93, 80)), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jLabel1.setFont(new Font("Dialog", 1, 16));
        this.jLabel1.setLabelFor(this.veltext);
        this.jLabel1.setText("Velocity");
        this.jPanel3.setBorder(this.border1);
        this.jPanel3.setLayout(this.borderLayout5);
        this.jPanel4.setLayout(this.borderLayout4);
        this.jPanel6.setBorder(this.titledBorder1);
        this.jPanel6.setLayout(this.gridLayout2);
        this.jPanel7.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setColumns(1);
        this.jPanel10.setBorder(this.border4);
        this.jPanel10.setPreferredSize(new Dimension(130, 90));
        this.myelinated.setBackground(NeurolabExhibit.systemGray);
        this.myelinated.setText("Myelinated");
        this.myelinated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConductionVelocity.this.changeMyel(e);
            }
        });
        this.picture.setBackground(new Color(128, 255, 255));
        this.picture.setBorder(this.border5);
        this.veltext.setBackground(Color.black);
        this.veltext.setFont(new Font("SansSerif", 1, 20));
        this.veltext.setForeground(Color.yellow);
        this.veltext.setBorder(this.border7);
        this.veltext.setPreferredSize(new Dimension(120, 35));
        this.veltext.setCaretColor(Color.yellow);
        this.veltext.setEditable(false);
        this.veltext.setText("10.8 m/sec");
        this.jLabel2.setLabelFor(this.jPanel13);
        this.jLabel2.setText("External diameter");
        this.diamtext.setCaretColor(Color.yellow);
        this.diamtext.setBorder(this.border7);
        this.diamtext.setPreferredSize(new Dimension(80, 30));
        this.diamtext.setForeground(Color.green);
        this.diamtext.setFont(new Font("SansSerif", 1, 16));
        this.diamtext.setBackground(Color.black);
        this.jPanel13.setLayout(this.borderLayout6);
        this.jPanel11.setPreferredSize(new Dimension(130, 58));
        this.jLabel3.setLabelFor(this.jPanel14);
        this.jLabel3.setText("Thickness");
        this.jPanel14.setLayout(this.borderLayout7);
        this.myeltext.setCaretColor(Color.yellow);
        this.myeltext.setBorder(this.border7);
        this.myeltext.setPreferredSize(new Dimension(80, 30));
        this.myeltext.setForeground(Color.green);
        this.myeltext.setFont(new Font("SansSerif", 1, 16));
        this.myeltext.setBackground(Color.black);
        this.rltext.setBackground(Color.black);
        this.rltext.setFont(new Font("SansSerif", 1, 12));
        this.rltext.setForeground(Color.cyan);
        this.rltext.setBorder(this.border7);
        this.rltext.setCaretColor(Color.yellow);
        this.rltext.setEditable(false);
        this.rltext.setPreferredSize(new Dimension(110, 30));
        this.jLabel4.setFont(new Font("Dialog", 1, 16));
        this.jLabel4.setText("<HTML>R<sub>L");
        this.cmtext.setBackground(Color.black);
        this.cmtext.setFont(new Font("SansSerif", 1, 12));
        this.cmtext.setForeground(Color.cyan);
        this.cmtext.setBorder(this.border7);
        this.cmtext.setCaretColor(Color.yellow);
        this.cmtext.setEditable(false);
        this.cmtext.setPreferredSize(new Dimension(110, 30));
        this.jLabel5.setFont(new Font("Dialog", 1, 16));
        this.jLabel5.setText("<HTML>C<sub>M");
        this.jPanel8.setPreferredSize(new Dimension(150, 60));
        this.jPanel8.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(3);
        this.gridLayout3.setColumns(1);
        this.rmtext.setBackground(Color.black);
        this.rmtext.setFont(new Font("SansSerif", 1, 12));
        this.rmtext.setForeground(Color.cyan);
        this.rmtext.setBorder(this.border7);
        this.rmtext.setCaretColor(Color.yellow);
        this.rmtext.setEditable(false);
        this.rmtext.setPreferredSize(new Dimension(110, 30));
        this.jLabel6.setFont(new Font("Dialog", 1, 16));
        this.jLabel6.setText("<HTML>R<sub>M</sub>");
        this.jPanel16.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.jPanel17.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(2);
        this.jPanel15.setLayout(this.flowLayout3);
        this.flowLayout3.setAlignment(2);
        this.jPanel18.setLayout(this.flowLayout4);
        this.flowLayout4.setAlignment(2);
        this.ttext.setBackground(Color.black);
        this.ttext.setFont(new Font("SansSerif", 1, 16));
        this.ttext.setForeground(Color.cyan);
        this.ttext.setBorder(this.border7);
        this.ttext.setCaretColor(Color.yellow);
        this.ttext.setEditable(false);
        this.ttext.setPreferredSize(new Dimension(110, 30));
        this.jLabel7.setFont(new Font("Dialog", 1, 16));
        this.jLabel7.setText("<HTML><font face='Times New Roman'><I>&#964;");
        this.jPanel19.setLayout(this.flowLayout5);
        this.flowLayout5.setAlignment(2);
        this.ltext.setBackground(Color.black);
        this.ltext.setFont(new Font("SansSerif", 1, 16));
        this.ltext.setForeground(Color.cyan);
        this.ltext.setBorder(this.border7);
        this.ltext.setCaretColor(Color.yellow);
        this.ltext.setEditable(false);
        this.ltext.setPreferredSize(new Dimension(110, 30));
        this.jLabel8.setFont(new Font("Dialog", 1, 16));
        this.jLabel8.setText("<HTML><font face='Times New Roman'><I>&#955;");
        this.jPanel9.setPreferredSize(new Dimension(111, 50));
        this.jPanel9.setLayout(this.gridLayout4);
        this.gridLayout4.setRows(3);
        this.jPanel5.setBorder(this.border8);
        this.borderLayout5.setHgap(5);
        this.borderLayout5.setVgap(5);
        this.borderLayout3.setHgap(5);
        this.borderLayout3.setVgap(5);
        this.borderLayout4.setHgap(5);
        this.borderLayout4.setVgap(5);
        this.borderLayout2.setHgap(5);
        this.borderLayout2.setVgap(5);
        this.jPanel20.setLayout(this.gridLayout5);
        this.diamInc.setMargin(new Insets(0, 0, 0, 0));
        this.diamInc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConductionVelocity.this.diamInc_actionPerformed(e);
            }
        });
        this.diamDec.setMargin(new Insets(0, 0, 0, 0));
        this.diamDec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConductionVelocity.this.diamDec_actionPerformed(e);
            }
        });
        this.gridLayout5.setRows(2);
        this.myelDec.setMargin(new Insets(0, 0, 0, 0));
        this.myelDec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConductionVelocity.this.myelDec_actionPerformed(e);
            }
        });
        this.myelInc.setMargin(new Insets(0, 0, 0, 0));
        this.myelInc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConductionVelocity.this.myelInc_actionPerformed(e);
            }
        });
        this.gridLayout6.setRows(2);
        this.jPanel21.setLayout(this.gridLayout6);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.picture, "Center");
        this.jPanel2.add((Component)this.jPanel5, "South");
        this.jPanel5.add((Component)this.jLabel1, null);
        this.jPanel5.add((Component)this.veltext, null);
        this.jPanel1.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.jPanel11, null);
        this.jPanel11.add((Component)this.jLabel2, null);
        this.jPanel11.add((Component)this.jPanel13, null);
        this.jPanel13.add((Component)this.diamtext, "Center");
        this.jPanel13.add((Component)this.jPanel20, "East");
        this.jPanel20.add((Component)this.diamInc, null);
        this.jPanel20.add((Component)this.diamDec, null);
        this.jPanel6.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.myelinated, null);
        this.jPanel10.add((Component)this.jLabel3, null);
        this.jPanel10.add((Component)this.jPanel14, null);
        this.jPanel14.add((Component)this.myeltext, "Center");
        this.jPanel14.add((Component)this.jPanel21, "East");
        this.jPanel21.add((Component)this.myelInc, null);
        this.jPanel21.add((Component)this.myelDec, null);
        this.jPanel4.add((Component)this.jPanel7, "East");
        this.jPanel7.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.jPanel16, null);
        this.jPanel16.add((Component)this.jLabel5, null);
        this.jPanel16.add((Component)this.cmtext, null);
        this.jPanel8.add((Component)this.jPanel17, null);
        this.jPanel17.add((Component)this.jLabel6, null);
        this.jPanel17.add((Component)this.rmtext, null);
        this.jPanel8.add((Component)this.jPanel15, null);
        this.jPanel15.add((Component)this.jLabel4, null);
        this.jPanel15.add((Component)this.rltext, null);
        this.jPanel7.add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.jPanel19, null);
        this.jPanel19.add((Component)this.jLabel8, null);
        this.jPanel19.add((Component)this.ltext, null);
        this.jPanel9.add((Component)this.jPanel18, null);
        this.jPanel18.add((Component)this.jLabel7, null);
        this.jPanel18.add((Component)this.ttext, null);
        this.jPanel9.add((Component)this.returnButton1, null);
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    void calc() {
        if (this.myelinated.isSelected()) {
            this.innr = this.diam - 2.0 * this.th;
            this.middle = (this.innr + this.diam) / 2.0;
            this.p = 0.625 * this.th;
            this.q = 0.25 * this.th;
        } else {
            this.innr = this.middle = this.diam;
            this.th = 0.0;
            this.p = 0.05;
            this.q = 0.02;
        }
        this.sa = Math.PI * this.middle * 1.0E-4;
        this.csa = this.innr * this.innr * Math.PI * 1.0E-8 / 4.0;
        this.cm = 0.006 * this.sa / this.p;
        this.rm = this.q * 200000.0 / (2.0 * this.sa);
        this.rl = 110.0 / this.csa;
        this.tau = this.cm * this.rm / 1000.0;
        this.lambda = 10.0 * Math.sqrt(this.rm / this.rl);
        this.v = 10.0 * this.lambda / (this.tau + 0.2);
        String yellow = "#ffff00";
        String green = "#00ff00";
        this.cmtext.setText(this.cap(1000000.0 * this.cm, " pF/cm", yellow));
        this.rmtext.setText(this.cap(this.rm / 1000000.0, " Mohm.cm", yellow));
        this.rltext.setText(this.cap(this.rl / 1000000.0, " Mohm/cm", yellow));
        this.ltext.setText(this.cap(this.lambda, " mm", yellow));
        this.ttext.setText(this.cap(this.tau, " msec", yellow));
        this.veltext.setText(this.cap(this.v, " m/sec", yellow));
        this.diamtext.setText(this.cap(this.diam, " &#956;", green));
        this.myeltext.setText(this.cap(this.th, " &#956;", green));
        this.picture.repaint();
    }

    String cap(double val, String unit, String colour) {
        String d = String.valueOf(val);
        int p = d.indexOf(46);
        if (p >= 0) {
            if (p > 3) {
                d = d.substring(0, p);
            } else {
                int last = d.length() > 4 ? 4 : d.length();
                d = d.substring(0, last);
                while (d.endsWith("0")) {
                    d = d.substring(0, d.length() - 1);
                }
                if (d.endsWith(".")) {
                    d = d.substring(0, d.length() - 1);
                }
            }
        }
        if (d.length() == 0) {
            d = "0";
        }
        return "<HTML><body bgcolor='black'><FONT FACE='arial' COLOR=\"" + colour + "\"><B>" + d + unit + "</body></HTML>";
    }

    void change(ActionEvent e) {
        this.calc();
    }

    void diamInc_actionPerformed(ActionEvent e) {
        this.diam = this.diam < 1.0 ? (this.diam += 0.2) : (double)((int)(this.diam + 1.0));
        if (this.diam > 20.0) {
            this.diam = 20.0;
        }
        this.calc();
    }

    void diamDec_actionPerformed(ActionEvent e) {
        this.diam = this.diam < 2.0 ? (this.diam -= 0.2) : (double)((int)(this.diam - 1.0));
        if (this.diam < 0.1) {
            this.diam = 0.1;
        }
        if (this.diam < 2.0 * this.th + 0.1) {
            this.th -= 0.1;
        }
        if (this.th < 0.1) {
            this.th = 0.1;
        }
        if (this.diam < 2.0 * this.th + 0.1) {
            this.diam = 2.0 * this.th + 0.1;
        }
        this.calc();
    }

    void myelInc_actionPerformed(ActionEvent e) {
        if (2.0 * this.th < this.diam - 0.2) {
            this.th += 0.1;
        }
        this.calc();
    }

    void myelDec_actionPerformed(ActionEvent e) {
        if (this.th >= 0.2) {
            this.th -= 0.1;
        }
        this.calc();
    }

    void reset() {
        this.diam = 5.0;
        this.th = 0.5;
        this.calc();
    }

    void changeMyel(ActionEvent e) {
        if (this.myelinated.isSelected()) {
            this.th = this.oth;
        } else {
            this.oth = this.th;
            this.th = 0.0;
        }
        this.change(e);
    }

    public void close() {
    }
}

