/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CompoundAP
extends NeurolabExhibit
implements ActionListener {
    ButtonGroup cbg1 = new ButtonGroup();
    ReturnButton returnButton1 = new ReturnButton();
    JButton Stimulate = new JButton();
    JPanel jPanel1 = new JPanel();
    JCheckBox damage = new JCheckBox();
    JSlider dispersion = new JSlider();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JRadioButton monophasic = new JRadioButton();
    JRadioButton diphasic = new JRadioButton();
    JPanel jPanel3 = new JPanel();
    JSlider electrode1 = new JSlider();
    JLabel jLabel2 = new JLabel();
    JSlider electrode2 = new JSlider();
    JLabel jLabel3 = new JLabel();
    Oscilloscope osc = new Oscilloscope(1, this);
    JPanel jPanel4 = new JPanel();
    GridBagConstraints gbc = new GridBagConstraints();
    int numaps = 18;
    double[] appos;
    double[] apvel;
    int[] apdam;
    int block;
    Timer timer;
    Color[] electrodecols = new Color[]{Color.red, Color.blue};
    JSlider[] electrode;
    JPanel appane = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.setStrokeThickness(g, 3.0f);
            g.setColor(Color.black);
            int i = 0;
            while (i < CompoundAP.this.numaps) {
                g.drawLine(5, CompoundAP.this.apy(i), this.getWidth() - 5, CompoundAP.this.apy(i));
                ++i;
            }
            g.drawLine(15, this.getHeight(), 15, 15);
            i = 0;
            while (i < 2) {
                g.setColor(CompoundAP.this.electrodecols[i]);
                g.drawLine(CompoundAP.this.electrodex(CompoundAP.this.electrode[i].getValue()), this.getHeight(), CompoundAP.this.electrodex(CompoundAP.this.electrode[i].getValue()), 15);
                ++i;
            }
            if (CompoundAP.this.damage.isSelected()) {
                i = 0;
                while (i < CompoundAP.this.numaps) {
                    g.drawLine(CompoundAP.this.electrodex(CompoundAP.this.apdam[i]), CompoundAP.this.apy(i), CompoundAP.this.electrodex(CompoundAP.this.apdam[i]) + 15, CompoundAP.this.apy(i));
                    ++i;
                }
            }
            if (CompoundAP.this.monophasic.isSelected()) {
                CompoundAP.this.block = (CompoundAP.this.electrode1.getValue() + CompoundAP.this.electrode2.getValue()) / 2 - 1;
                g.setColor(Color.darkGray);
                g.fillRect(CompoundAP.this.electrodex(CompoundAP.this.block), 10, 10, this.getHeight() - 30);
            }
        }
    };
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    Border border2;
    Border border3;
    int dead = 0;
    double voltage = 0.0;

    public int electrodex(int a) {
        return 20 + (this.appane.getWidth() - 15) * a / 100;
    }

    public int apy(int a) {
        return 20 + a * (this.appane.getHeight() - 40) / this.numaps;
    }

    public String getExhibitName() {
        return "Compound AP  ";
    }

    public void init() {
        super.init();
        this.createComponents();
        this.electrode1.setValue(10);
        this.electrode1.setValue(20);
        this.dispersion.setValue(30);
        this.timer = new Timer(100, this);
        this.stimulate();
    }

    public void createComponents() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.osc.remove(this.osc.buttons);
        this.osc.timer.setDelay(100);
        this.osc.xSpeed = 5;
        int[] base = new int[]{50};
        this.osc.setBaseY(base);
        Color[] cols = new Color[]{Color.green};
        this.osc.setColors(cols);
        this.diphasic.setSelected(true);
        this.electrode1.setValue(10);
        this.electrode2.setValue(30);
        this.dispersion.setValue(30);
        this.electrode = new JSlider[2];
        this.electrode[0] = this.electrode1;
        this.electrode[1] = this.electrode2;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != "Sweep") {
            if (e.getActionCommand() == "Damage") {
                this.apdam = new int[this.numaps];
                Random r = new Random();
                int i = 0;
                while (i < this.numaps) {
                    this.apdam[i] = 5 + r.nextInt() % 80;
                    ++i;
                }
                this.appane.repaint();
            } else if (e.getActionCommand() == "Monophasic") {
                this.appane.repaint();
            } else if (e.getActionCommand() == "Diphasic") {
                this.appane.repaint();
            } else {
                Graphics g = this.appane.getGraphics();
                NeurolabExhibit.setStrokeThickness(g, 3.0f);
                int i = 0;
                while (i < this.numaps) {
                    g.setColor(Color.black);
                    this.drawAP(g, 15 + (int)this.appos[i], this.apy(i));
                    g.setColor(Color.orange);
                    int n = i;
                    this.appos[n] = this.appos[n] + this.apvel[i];
                    if (this.appos[i] != 0.0) {
                        if (this.damage.isSelected() && this.appos[i] > (double)(this.electrodex(this.apdam[i]) - 30) && this.appos[i] < (double)this.electrodex(this.apdam[i]) || this.monophasic.isSelected() && this.appos[i] > (double)(this.electrodex(this.block) - 30) || this.appos[i] > (double)this.appane.getWidth()) {
                            this.appos[i] = 0.0;
                            this.apvel[i] = 0.0;
                            ++this.dead;
                        } else {
                            this.drawAP(g, 15 + (int)this.appos[i], this.apy(i));
                            if (this.appos[i] > (double)(this.electrodex(this.electrode1.getValue()) - 30) && this.appos[i] < (double)this.electrodex(this.electrode1.getValue())) {
                                this.voltage += 20.0;
                            }
                            if (this.appos[i] > (double)(this.electrodex(this.electrode2.getValue()) - 30) && this.appos[i] < (double)this.electrodex(this.electrode2.getValue())) {
                                this.voltage -= 20.0;
                            }
                        }
                    }
                    this.voltage *= 0.8;
                    ++i;
                }
                if (this.dead >= this.numaps && this.osc.timer.isRunning()) {
                    this.timer.stop();
                }
                int[] a = new int[]{-((int)this.voltage) * 6};
                this.osc.setPosY(a);
            }
        }
    }

    public void drawAP(Graphics g, int x, int y) {
        g.drawLine(x, y, x + 15, y);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(Color.lightGray, 2);
        this.border2 = BorderFactory.createLineBorder(Color.lightGray, 2);
        this.border3 = BorderFactory.createLineBorder(Color.lightGray, 2);
        this.getMainContainer().setLayout(null);
        this.returnButton1.setBounds(new Rectangle(461, 268, 113, 45));
        this.Stimulate.setText("Stimulate");
        this.Stimulate.setBackground(NeurolabExhibit.systemGray);
        this.Stimulate.setBounds(new Rectangle(1, 211, 90, 54));
        this.Stimulate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompoundAP.this.Stimulate_actionPerformed(e);
            }
        });
        this.jPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Nerve"));
        this.jPanel1.setBounds(new Rectangle(458, 162, 119, 103));
        this.jPanel1.setLayout(null);
        this.jPanel1.setBackground(NeurolabExhibit.systemGray);
        this.damage.setText("Damage");
        this.damage.setBackground(NeurolabExhibit.systemGray);
        this.damage.setActionCommand("Damage");
        this.damage.setBounds(new Rectangle(13, 18, 90, 25));
        this.damage.addActionListener(this);
        this.dispersion.setBorder(this.border3);
        this.dispersion.setBackground(NeurolabExhibit.systemGray);
        this.dispersion.setBounds(new Rectangle(7, 69, 98, 26));
        this.jLabel1.setText("Dispersion:");
        this.jLabel1.setBounds(new Rectangle(12, 47, 82, 20));
        this.jPanel2.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Recording"));
        this.jPanel2.setBounds(new Rectangle(459, 0, 119, 79));
        this.jPanel2.setLayout(this.gridLayout1);
        this.jPanel2.setBackground(NeurolabExhibit.systemGray);
        this.monophasic.setText("Monophasic");
        this.monophasic.setBackground(NeurolabExhibit.systemGray);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.diphasic.setText("Diphasic");
        this.diphasic.setBackground(NeurolabExhibit.systemGray);
        this.jPanel3.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Electrode position"));
        this.jPanel3.setBounds(new Rectangle(459, 79, 119, 83));
        this.jPanel3.setLayout(null);
        this.jPanel3.setBackground(NeurolabExhibit.systemGray);
        this.electrode1.setBorder(this.border1);
        this.electrode1.setBackground(NeurolabExhibit.systemGray);
        this.electrode1.setBounds(new Rectangle(20, 26, 92, 26));
        this.electrode1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CompoundAP.this.electrode_stateChanged(e);
            }
        });
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setForeground(Color.red);
        this.jLabel2.setText("+");
        this.jLabel2.setBounds(new Rectangle(9, 27, 13, 23));
        this.jLabel2.setBackground(NeurolabExhibit.systemGray);
        this.electrode2.setBorder(this.border2);
        this.electrode2.setBackground(NeurolabExhibit.systemGray);
        this.electrode2.setBounds(new Rectangle(19, 51, 93, 26));
        this.electrode2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CompoundAP.this.electrode_stateChanged(e);
            }
        });
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setText("-");
        this.jLabel3.setBackground(NeurolabExhibit.systemGray);
        this.jLabel3.setBounds(new Rectangle(10, 51, 13, 20));
        this.jPanel4.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanel4.setBounds(new Rectangle(2, 2, 455, 203));
        this.jPanel4.setBackground(NeurolabExhibit.systemGray);
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.appane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel5.setBounds(new Rectangle(98, 210, 357, 105));
        this.jPanel5.setLayout(this.borderLayout1);
        this.jPanel5.setBackground(NeurolabExhibit.systemGray);
        this.getMainContainer().add((Component)this.jPanel4, null);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.anchor = 10;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbc.ipadx = 336;
        this.gbc.ipady = 185;
        this.jPanel4.add((Component)this.appane, this.gbc);
        this.getMainContainer().add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.osc, "Center");
        this.getMainContainer().add((Component)this.Stimulate, null);
        this.getMainContainer().add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.monophasic, null);
        this.jPanel2.add((Component)this.diphasic, null);
        this.getMainContainer().add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.electrode1, null);
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.electrode2, null);
        this.jPanel3.add((Component)this.jLabel3, null);
        this.getMainContainer().add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.damage, null);
        this.jPanel1.add((Component)this.dispersion, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.getMainContainer().add((Component)this.returnButton1, null);
        this.cbg1.add(this.monophasic);
        this.cbg1.add(this.diphasic);
        this.monophasic.addActionListener(this);
        this.diphasic.addActionListener(this);
    }

    public void stimulate() {
        if (this.osc != null) {
            this.osc.clear.doClick();
            this.osc.sweep.doClick();
        }
        this.appos = new double[this.numaps];
        this.apvel = new double[this.numaps];
        Random r = new Random();
        int i = 0;
        while (i < this.numaps) {
            this.apvel[i] = 10.0 + (double)(this.dispersion.getValue() * (r.nextInt() % 100 - 50)) / 1000.0;
            ++i;
        }
        this.dead = 0;
        this.appane.repaint();
        this.timer.start();
    }

    void Stimulate_actionPerformed(ActionEvent e) {
        this.stimulate();
    }

    void electrode_stateChanged(ChangeEvent e) {
        this.appane.repaint();
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
        this.osc.timer.stop();
    }
}

