/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.MemoryImageSource;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColourMixing
extends NeurolabExhibit {
    private JPanel buttonbox;
    private JPanel randombox;
    private JPanel squares;
    private JPanel innersquare;
    private JPanel fillsquare;
    private JPanel fillsquare2;
    private JPanel fillsquare3;
    private JPanel sliderbarpanel;
    private JPanel colourdisplaypanel;
    private JButton button;
    private JButton blackout;
    private JButton whiteout;
    private JCheckBox randomButton;
    private Triangle triangle;
    private Section section;
    public buttonPanel buttonpanel;
    private Complementary complement;
    private SliderControls fore;
    private SliderControls back;
    private GridBagLayout mainLayout;
    private GridBagLayout squaresLayout;
    private GridBagLayout cdpLayout;
    private GridBagConstraints mainGbConstraints;
    private GridBagConstraints squaresGbConstraints;
    private GridBagConstraints cdpGbConstraints;
    private Container maincontainer;
    private Timer timer;
    Color systemGray;
    public int gap;
    public boolean equiluminant = false;
    public double length = 200.0;
    public double angle = 1.0471975511965976;
    public int height = (int)(this.length * Math.sin(this.angle));
    public int radius = (int)(0.2f * (float)this.height);
    public Point circ_cent = new Point((int)(this.length - Math.cos(this.angle / 2.0) * (double)this.height * (double)0.4f), (int)(0.8f * (float)this.height));
    public Point west;
    public Point east;
    public Point north;
    public Point left;
    public Point right;
    public InputHandler handler = new InputHandler();
    Image colourtriangle;

    public String getExhibitName() {
        return "Colours";
    }

    public void init() {
        super.init();
        this.systemGray = new Color(191, 191, 191);
        Border etched = BorderFactory.createEtchedBorder();
        this.createComponents();
    }

    public void createComponents() {
        this.squares = new JPanel();
        this.squares.setBorder(NeurolabExhibit.loweredbevel);
        this.triangle = new Triangle();
        this.triangle.setBorder(NeurolabExhibit.loweredbevel);
        this.triangle.addMouseListener(this.handler);
        this.addMouseListener(this.handler);
        this.section = new Section();
        this.complement = new Complementary();
        this.buttonpanel = new buttonPanel();
        this.colourdisplaypanel = new JPanel();
        this.sliderbarpanel = new JPanel();
        this.fore = new SliderControls(this, 255, 24, 255, true);
        this.back = new SliderControls(this, 255, 255, 255, false);
        this.timer = new Timer(2000, new ActionListener(){
            int counter = 0;

            public void actionPerformed(ActionEvent evt) {
                ++this.counter;
                if (this.counter > 9) {
                    this.counter = 0;
                    ColourMixing.this.fore.randomizeSliders();
                } else {
                    ColourMixing.this.back.randomizeSliders();
                }
            }
        });
        this.maincontainer = this.getMainContainer();
        this.getMainContainer().setBackground(this.systemGray);
        this.mainLayout = new GridBagLayout();
        this.maincontainer.setLayout(this.mainLayout);
        this.mainGbConstraints = new GridBagConstraints();
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.triangle, 0, 0, 1, 4, 70, 100);
        this.triangle.setBackground(Color.black);
        this.calculate();
        this.mainGbConstraints.fill = 3;
        this.addMainComponent(this.sliderbarpanel, 0, 1, 1, 4, 10, 0);
        GridLayout sliderlayout = new GridLayout();
        this.sliderbarpanel.setLayout(sliderlayout);
        this.sliderbarpanel.setBackground(this.systemGray);
        sliderlayout.setColumns(1);
        sliderlayout.setHgap(5);
        sliderlayout.setRows(2);
        sliderlayout.setVgap(5);
        this.sliderbarpanel.add(this.fore);
        this.sliderbarpanel.add(this.back);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.colourdisplaypanel, 0, 2, 1, 3, 5, 10);
        this.cdpLayout = new GridBagLayout();
        this.colourdisplaypanel.setLayout(this.cdpLayout);
        this.cdpGbConstraints = new GridBagConstraints();
        this.cdpGbConstraints.fill = 1;
        this.cdpGbConstraints.weightx = 100.0;
        this.cdpGbConstraints.weighty = 20.0;
        this.cdpGbConstraints.gridwidth = 1;
        this.cdpGbConstraints.gridheight = 1;
        this.cdpGbConstraints.gridx = 0;
        this.cdpGbConstraints.gridy = 1;
        this.cdpLayout.setConstraints(this.section, this.cdpGbConstraints);
        this.colourdisplaypanel.add(this.section);
        this.cdpGbConstraints.gridy = 2;
        this.cdpLayout.setConstraints(this.complement, this.cdpGbConstraints);
        this.colourdisplaypanel.add(this.complement);
        this.squares = new JPanel();
        this.cdpGbConstraints.gridy = 0;
        this.cdpGbConstraints.weighty = 60.0;
        this.cdpLayout.setConstraints(this.squares, this.cdpGbConstraints);
        this.colourdisplaypanel.add(this.squares);
        this.squaresLayout = new GridBagLayout();
        this.squares.setLayout(this.squaresLayout);
        this.squaresGbConstraints = new GridBagConstraints();
        this.innersquare = new JPanel();
        this.squaresGbConstraints.fill = 1;
        this.squaresGbConstraints.weightx = 33.0;
        this.squaresGbConstraints.weighty = 33.0;
        this.squaresGbConstraints.gridx = 1;
        this.squaresGbConstraints.gridy = 1;
        this.squaresGbConstraints.gridwidth = 1;
        this.squaresGbConstraints.gridheight = 1;
        this.squaresLayout.setConstraints(this.innersquare, this.squaresGbConstraints);
        this.squares.add(this.innersquare);
        this.fillsquare = new JPanel();
        this.squaresGbConstraints.gridx = 1;
        this.squaresGbConstraints.gridy = 2;
        this.fillsquare.setOpaque(false);
        this.squaresGbConstraints.fill = 1;
        this.squaresGbConstraints.weightx = 33.0;
        this.squaresGbConstraints.weighty = 33.0;
        this.squaresGbConstraints.gridx = 0;
        this.squaresGbConstraints.gridy = 1;
        this.squaresGbConstraints.gridwidth = 1;
        this.squaresGbConstraints.gridheight = 1;
        this.squaresLayout.setConstraints(this.fillsquare, this.squaresGbConstraints);
        this.squares.add(this.fillsquare);
        this.fillsquare2 = new JPanel();
        this.squaresGbConstraints.gridx = 2;
        this.squaresGbConstraints.gridy = 0;
        this.fillsquare2.setOpaque(false);
        this.squaresLayout.setConstraints(this.fillsquare2, this.squaresGbConstraints);
        this.squares.add(this.fillsquare2);
        this.fillsquare3 = new JPanel();
        this.squaresGbConstraints.gridx = 0;
        this.squaresGbConstraints.gridy = 2;
        this.fillsquare3.setOpaque(false);
        this.squaresLayout.setConstraints(this.fillsquare3, this.squaresGbConstraints);
        this.squares.add(this.fillsquare3);
        int[] forecolours = new int[3];
        int[] backcolours = new int[3];
        this.fore.getValues(forecolours);
        this.back.getValues(backcolours);
        this.innersquare.setBackground(new Color(forecolours[0], forecolours[1], forecolours[2]));
        this.squares.setBackground(new Color(backcolours[0], backcolours[1], backcolours[2]));
        this.mainGbConstraints.fill = 3;
        this.mainGbConstraints.fill = 13;
        this.addMainComponent(this.buttonpanel, 3, 2, 1, 1, 5, 0);
    }

    public void start() {
    }

    public void paint(Graphics g) {
        this.fore.repaint();
        this.back.repaint();
        this.buttonpanel.repaint();
        this.triangle.repaint();
        this.section.repaint();
        this.complement.repaint();
        int[] forecolours = new int[3];
        int[] backcolours = new int[3];
        this.fore.getValues(forecolours);
        this.back.getValues(backcolours);
        this.innersquare.setBackground(new Color(forecolours[0], forecolours[1], forecolours[2]));
        this.squares.setBackground(new Color(backcolours[0], backcolours[1], backcolours[2]));
    }

    private void addMainComponent(Component c, int row, int column, int width, int height, int weightx, int weighty) {
        this.mainGbConstraints.gridx = column;
        this.mainGbConstraints.gridy = row;
        this.mainGbConstraints.gridwidth = width;
        this.mainGbConstraints.gridheight = height;
        this.mainGbConstraints.weightx = weightx;
        this.mainGbConstraints.weighty = weighty;
        this.mainLayout.setConstraints(c, this.mainGbConstraints);
        this.maincontainer.add(c);
    }

    public void calculate() {
        double length = 200.0;
        double angle = 1.0471975511965976;
        int height = (int)(length * Math.sin(angle));
        int index = 0;
        int[] pix = new int[(int)(length * (double)height)];
        double ratio = 255.0 / length;
        int y = 0;
        while (y < height) {
            int xinc = (int)(length / 2.0 / (double)height * (double)y);
            int x = 0;
            while ((double)x < length) {
                if ((double)x >= length / 2.0 - (double)xinc && (double)x <= length / 2.0 + (double)xinc) {
                    int redcomp = (int)(ratio * NeurolabExhibit.ptLineDist(length / 2.0, 0.0, length, height, x, y));
                    int greencomp = (int)(ratio * NeurolabExhibit.ptLineDist(length / 2.0, 0.0, 0.0, height, x, y));
                    int bluecomp = (int)(ratio * NeurolabExhibit.ptLineDist(0.0, height, length, height, x, y));
                    double scaling = !this.equiluminant ? (double)(255.0f / (float)Math.max(redcomp, Math.max(greencomp, bluecomp))) : 1.0;
                    redcomp = (int)((double)redcomp * scaling);
                    greencomp = (int)((double)greencomp * scaling);
                    bluecomp = (int)((double)bluecomp * scaling);
                    if (NeurolabExhibit.distance(this.circ_cent, x, y) > (double)this.radius && x > this.circ_cent.x && y > this.circ_cent.y - 10) {
                        redcomp = 191;
                        greencomp = 191;
                        bluecomp = 191;
                    }
                    pix[index++] = 0xFF000000 | redcomp << 16 | greencomp << 8 | bluecomp;
                } else {
                    pix[index++] = 0;
                }
                ++x;
            }
            ++y;
        }
        this.colourtriangle = this.createImage(new MemoryImageSource((int)length, height, pix, 0, (int)length));
    }

    public void close() {
        this.timer.stop();
    }

    class Complementary
    extends JPanel {
        Complementary() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics g2 = g;
            this.setBackground(ColourMixing.this.systemGray);
            int[] forecolours = new int[3];
            ColourMixing.this.fore.getValues(forecolours);
            g2.setColor(new Color(255 - forecolours[0], 255 - forecolours[1], 255 - forecolours[2]));
            g2.fillRoundRect(30, 0, 30, 30, 5, 5);
            g2.setFont(new Font("Ariel", 0, 12));
            g2.setColor(Color.black);
            g2.drawString("Complementary", 70, 12);
            g2.drawString("colour", 75, 28);
        }
    }

    private class InputHandler
    implements ItemListener,
    ChangeListener,
    ActionListener,
    MouseListener {
        private InputHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == ColourMixing.this.buttonpanel.randomButton) {
                ColourMixing.this.timer.start();
            }
            if (e.getStateChange() == 2 && source == ColourMixing.this.buttonpanel.randomButton) {
                ColourMixing.this.timer.stop();
            }
            if (e.getStateChange() == 1 && source == ColourMixing.this.buttonpanel.constantButton) {
                ColourMixing.this.equiluminant = true;
                ColourMixing.this.calculate();
                ColourMixing.this.repaint();
            }
            if (e.getStateChange() == 2 && source == ColourMixing.this.buttonpanel.constantButton) {
                ColourMixing.this.equiluminant = false;
                ColourMixing.this.calculate();
                ColourMixing.this.repaint();
            }
        }

        public void stateChanged(ChangeEvent e) {
            ColourMixing.this.repaint();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Return") {
                ColourMixing.this.toExhibitChooser();
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == ColourMixing.this.triangle && e.getY() > ((ColourMixing)ColourMixing.this).triangle.northcorner.y && e.getY() < ((ColourMixing)ColourMixing.this).triangle.westcorner.y && (double)e.getX() < (double)((ColourMixing)ColourMixing.this).triangle.eastcorner.x - (double)(((ColourMixing)ColourMixing.this).triangle.westcorner.y - e.getY()) * 0.58 && (double)e.getY() > (double)((ColourMixing)ColourMixing.this).triangle.westcorner.x + (double)(e.getY() - ((ColourMixing)ColourMixing.this).triangle.northcorner.y) * 0.58) {
                Point red_corner = ((ColourMixing)ColourMixing.this).triangle.westcorner;
                Point green_corner = ((ColourMixing)ColourMixing.this).triangle.eastcorner;
                Point blue_corner = ((ColourMixing)ColourMixing.this).triangle.northcorner;
                int red_dist = (int)NeurolabExhibit.ptLineDist(green_corner, blue_corner, e.getPoint());
                int green_dist = (int)NeurolabExhibit.ptLineDist(red_corner, blue_corner, e.getPoint());
                int blue_dist = (int)NeurolabExhibit.ptLineDist(red_corner, green_corner, e.getPoint());
                double scaling = 255.0f / (float)Math.max(red_dist, Math.max(green_dist, blue_dist));
                red_dist = (int)((double)red_dist * scaling);
                green_dist = (int)((double)green_dist * scaling);
                blue_dist = (int)((double)blue_dist * scaling);
                if (e.isMetaDown() || e.isControlDown() || e.isAltDown()) {
                    ColourMixing.this.back.setValues(red_dist, green_dist, blue_dist);
                } else {
                    ColourMixing.this.fore.setValues(red_dist, green_dist, blue_dist);
                }
                ColourMixing.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ColourMixing.this.buttonpanel.blackout) {
                ColourMixing.this.innersquare.setBackground(new Color(0, 0, 0));
                ColourMixing.this.squares.setBackground(new Color(0, 0, 0));
            } else if (e.getSource() == ColourMixing.this.buttonpanel.whiteout) {
                ColourMixing.this.innersquare.setBackground(new Color(255, 255, 255));
                ColourMixing.this.squares.setBackground(new Color(255, 255, 255));
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseClicked(e);
            int[] forecolours = new int[3];
            int[] backcolours = new int[3];
            ColourMixing.this.fore.getValues(forecolours);
            ColourMixing.this.back.getValues(backcolours);
            ColourMixing.this.innersquare.setBackground(new Color(forecolours[0], forecolours[1], forecolours[2]));
            ColourMixing.this.squares.setBackground(new Color(backcolours[0], backcolours[1], backcolours[2]));
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class Section
    extends JPanel {
        Section() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics g2 = g;
            this.setBackground(ColourMixing.this.systemGray);
            int[] forecolours = new int[3];
            int[] backcolours = new int[3];
            ColourMixing.this.fore.getValues(forecolours);
            ColourMixing.this.back.getValues(backcolours);
            float r_step = (float)(backcolours[0] - forecolours[0]) / 100.0f;
            float g_step = (float)(backcolours[1] - forecolours[1]) / 100.0f;
            float b_step = (float)(backcolours[2] - forecolours[2]) / 100.0f;
            int xstart = (this.getWidth() - 100) / 2;
            int ystart = (this.getHeight() - 20) / 2;
            int x = 0;
            while (x < 100) {
                int newred = (int)((float)forecolours[0] + (float)x * r_step);
                int newgreen = (int)((float)forecolours[1] + (float)x * g_step);
                int newblue = (int)((float)forecolours[2] + (float)x * b_step);
                double scaling = !ColourMixing.this.equiluminant ? (double)(255.0f / (float)Math.max(newred, Math.max(newgreen, newblue))) : 1.0;
                newred = (int)((double)newred * scaling);
                newgreen = (int)((double)newgreen * scaling);
                newblue = (int)((double)newblue * scaling);
                g2.setColor(new Color(newred, newgreen, newblue));
                g2.drawLine(xstart + x, ystart, xstart + x, ystart + 20);
                ++x;
            }
            g2.setFont(new Font("Ariel", 0, 12));
            g2.setColor(Color.black);
            g2.drawString("Fore", 20, this.getHeight() / 2 + 5);
            g2.drawString("Back", this.getWidth() - 40, this.getHeight() / 2 + 5);
        }
    }

    class SliderControls
    extends JPanel {
        InputHandler handler;
        ColourMixing applet;
        JSlider red;
        JSlider green;
        JSlider blue;
        JPanel rlabel;
        JPanel glabel;
        JPanel blabel;
        GridBagLayout sliderLayout;
        GridBagConstraints sliderGbConstraints;

        public SliderControls(ColourMixing app, int redstart, int greenstart, int bluestart, boolean foreground) {
            this.handler = new InputHandler();
            this.applet = app;
            this.red = new JSlider(1, 0, 255, redstart);
            this.red.setMajorTickSpacing(50);
            this.red.setPaintTicks(true);
            this.red.addChangeListener(this.handler);
            this.red.setBackground(ColourMixing.this.systemGray);
            this.green = new JSlider(1, 0, 255, greenstart);
            this.green.setMajorTickSpacing(50);
            this.green.setPaintTicks(true);
            this.green.addChangeListener(this.handler);
            this.green.setBackground(ColourMixing.this.systemGray);
            this.blue = new JSlider(1, 0, 255, bluestart);
            this.blue.setMajorTickSpacing(50);
            this.blue.setPaintTicks(true);
            this.blue.addChangeListener(this.handler);
            this.blue.setBackground(ColourMixing.this.systemGray);
            this.sliderLayout = new GridBagLayout();
            this.setLayout(this.sliderLayout);
            this.sliderGbConstraints = new GridBagConstraints();
            this.sliderGbConstraints.fill = 1;
            this.sliderGbConstraints.weightx = 33.0;
            this.sliderGbConstraints.weighty = 90.0;
            this.sliderGbConstraints.gridx = 0;
            this.sliderGbConstraints.gridy = 0;
            this.sliderGbConstraints.gridwidth = 1;
            this.sliderGbConstraints.gridheight = 1;
            this.sliderLayout.setConstraints(this.red, this.sliderGbConstraints);
            this.add(this.red);
            this.sliderGbConstraints.gridx = 1;
            this.sliderLayout.setConstraints(this.green, this.sliderGbConstraints);
            this.add(this.green);
            this.sliderGbConstraints.gridx = 2;
            this.sliderLayout.setConstraints(this.blue, this.sliderGbConstraints);
            this.add(this.blue);
            ballColour rlabel = new ballColour();
            rlabel.setForeground(Color.red);
            rlabel.setBackground(ColourMixing.this.systemGray);
            ballColour glabel = new ballColour();
            glabel.setForeground(Color.green);
            glabel.setBackground(ColourMixing.this.systemGray);
            ballColour blabel = new ballColour();
            blabel.setForeground(Color.blue);
            blabel.setBackground(ColourMixing.this.systemGray);
            this.sliderGbConstraints.weightx = 33.0;
            this.sliderGbConstraints.weighty = 10.0;
            this.sliderGbConstraints.gridx = 0;
            this.sliderGbConstraints.gridy = 1;
            this.sliderGbConstraints.gridwidth = 1;
            this.sliderGbConstraints.gridheight = 1;
            this.sliderLayout.setConstraints(rlabel, this.sliderGbConstraints);
            this.add(rlabel);
            this.sliderGbConstraints.gridx = 1;
            this.sliderLayout.setConstraints(glabel, this.sliderGbConstraints);
            this.add(glabel);
            this.sliderGbConstraints.gridx = 2;
            this.sliderLayout.setConstraints(blabel, this.sliderGbConstraints);
            this.add(blabel);
            TitledBorder title1 = foreground ? BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Foreground") : BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Background");
            title1.setTitleJustification(2);
            this.setBackground(ColourMixing.this.systemGray);
            this.setBorder(title1);
        }

        public int getValues(int[] vals) {
            vals[0] = this.red.getValue();
            vals[1] = this.green.getValue();
            vals[2] = this.blue.getValue();
            return 0;
        }

        public int setValues(int r, int g, int b) {
            this.red.setValue(r);
            this.green.setValue(g);
            this.blue.setValue(b);
            return 0;
        }

        public int getRed() {
            return this.red.getValue();
        }

        public int getGreen() {
            return this.green.getValue();
        }

        public int getBlue() {
            return this.blue.getValue();
        }

        public void randomizeSliders() {
            this.red.setValue((int)(255.0 * Math.random()));
            this.blue.setValue((int)(255.0 * Math.random()));
            this.green.setValue((int)(255.0 * Math.random()));
        }

        public class ballColour
        extends JPanel {
            int diameter;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                this.diameter = Math.min(this.getWidth(), this.getHeight());
                g.fillOval(0, 0, this.diameter, this.diameter);
            }
        }
    }

    class Triangle
    extends JPanel {
        double f_r;
        double f_g;
        double f_b;
        double f_max;
        double b_r;
        double b_g;
        double b_b;
        double b_max;
        int[] forecolours = new int[3];
        int[] backcolours = new int[3];
        Point westcorner;
        Point eastcorner;
        Point northcorner;

        public Triangle() {
            this.setPreferredSize(new Dimension(220, 220));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics g2 = g;
            int gap = (int)((double)this.getWidth() - ColourMixing.this.length) / 2;
            this.westcorner = new Point(gap, 4 * gap + ColourMixing.this.colourtriangle.getHeight(this));
            this.eastcorner = new Point(gap + ColourMixing.this.colourtriangle.getWidth(this), 4 * gap + ColourMixing.this.colourtriangle.getHeight(this));
            this.northcorner = new Point(gap + (int)ColourMixing.this.length / 2, 4 * gap);
            g.drawImage(ColourMixing.this.colourtriangle, gap, 4 * gap, this);
            g2.setColor(Color.black);
            g2.drawLine(this.northcorner.x, this.northcorner.y, this.eastcorner.x, this.eastcorner.y);
            g2.drawLine(this.eastcorner.x, this.eastcorner.y, this.westcorner.x, this.westcorner.y);
            g2.drawLine(this.westcorner.x, this.westcorner.y, this.northcorner.x, this.northcorner.y);
            ColourMixing.this.fore.getValues(this.forecolours);
            ColourMixing.this.back.getValues(this.backcolours);
            this.f_r = (float)this.forecolours[0] / 255.0f;
            this.f_g = (float)this.forecolours[1] / 255.0f;
            this.f_b = (float)this.forecolours[2] / 255.0f;
            this.f_max = this.f_r + this.f_g + this.f_b;
            this.f_r /= this.f_max;
            this.f_g /= this.f_max;
            this.f_b /= this.f_max;
            Point centre = new Point(this.westcorner.x + ColourMixing.this.colourtriangle.getWidth(this) / 2, this.westcorner.y - ColourMixing.this.colourtriangle.getHeight(this) / 2);
            Point foreg = new Point((int)((double)centre.x + (1.0 - this.f_r) * (double)(ColourMixing.this.colourtriangle.getWidth(this) / 2) - (1.0 - this.f_g) * (double)(ColourMixing.this.colourtriangle.getWidth(this) / 2)), (int)((double)centre.y - this.f_b * (double)(ColourMixing.this.colourtriangle.getHeight(this) / 2) + (1.0 - this.f_b) * (double)(ColourMixing.this.colourtriangle.getHeight(this) / 2)));
            this.b_r = (float)this.backcolours[0] / 255.0f;
            this.b_g = (float)this.backcolours[1] / 255.0f;
            this.b_b = (float)this.backcolours[2] / 255.0f;
            this.b_max = this.b_r + this.b_g + this.b_b;
            this.b_r /= this.b_max;
            this.b_g /= this.b_max;
            this.b_b /= this.b_max;
            Point backg = new Point((int)((double)centre.x + (1.0 - this.b_r) * (double)(ColourMixing.this.colourtriangle.getWidth(this) / 2) - (1.0 - this.b_g) * (double)(ColourMixing.this.colourtriangle.getWidth(this) / 2)), (int)((double)centre.y - this.b_b * (double)(ColourMixing.this.colourtriangle.getHeight(this) / 2) + (1.0 - this.b_b) * (double)(ColourMixing.this.colourtriangle.getHeight(this) / 2)));
            Point new_circ_cent = new Point(ColourMixing.this.circ_cent.x + gap, ColourMixing.this.circ_cent.x + 4 * gap);
            if (foreg.x > 0 && backg.x > 0) {
                Point right = new Point(foreg.x, foreg.y);
                Point left = new Point(backg.x, backg.y);
                if (foreg.x < backg.x) {
                    left.setLocation(foreg);
                    right.setLocation(backg);
                } else {
                    right.setLocation(foreg);
                    left.setLocation(backg);
                }
                double p = right.x - left.x;
                if (p == 0.0) {
                    p = 0.001;
                }
                double grad = (double)(right.y - left.y) / p;
                if (right.x > new_circ_cent.x && NeurolabExhibit.distance(new_circ_cent, right) > (double)ColourMixing.this.radius) {
                    do {
                        int tempx = right.x - 1;
                        int tempy = right.y - (int)grad;
                        right.setLocation(tempx, tempy);
                    } while (right.x > new_circ_cent.x && NeurolabExhibit.distance(new_circ_cent, right) > (double)ColourMixing.this.radius);
                }
                if (left.y >= 75 && left.y <= 270 && (float)left.x >= 120.0f - (float)(left.y - 75) * 0.58f && (float)left.x <= 120.0f + (float)(left.y - 75) * 0.58f && right.y >= 75 && right.y <= 270 && (float)right.x >= 120.0f - (float)(right.y - 75) * 0.58f && (float)right.x <= 120.0f + (float)(right.y - 75) * 0.58f) {
                    g2.drawLine(left.x, left.y, right.x, right.y);
                }
            }
            g2.setFont(new Font("Ariel", 1, 30));
            g2.setColor(Color.blue);
            g2.drawString("B", this.northcorner.x - 10, this.northcorner.y - 5);
            g2.setColor(Color.green);
            g2.drawString("G", this.eastcorner.x - 10, this.eastcorner.y + 30);
            g2.setColor(Color.red);
            g2.drawString("R", this.westcorner.x - 10, this.eastcorner.y + 30);
        }
    }

    class buttonPanel
    extends JPanel {
        JButton button;
        JButton blackout;
        JButton whiteout;
        JCheckBox randomButton;
        JCheckBox constantButton;
        GridBagLayout buttonsLayout;
        GridBagConstraints buttonsGbConstraints;
        Spacer spacer1;
        Spacer spacer2;
        Spacer spacer3;

        public buttonPanel() {
            this.setBackground(ColourMixing.this.systemGray);
            InputHandler handler = new InputHandler();
            this.button = new JButton();
            this.button.setBackground(ColourMixing.this.systemGray);
            this.button.setText("Return");
            this.button.addActionListener(handler);
            this.randomButton = new JCheckBox("Auto change");
            this.randomButton.setSelected(false);
            this.randomButton.addItemListener(handler);
            this.randomButton.setBackground(ColourMixing.this.systemGray);
            this.constantButton = new JCheckBox("Equiluminant");
            this.constantButton.setSelected(false);
            this.constantButton.addItemListener(handler);
            this.constantButton.setBackground(ColourMixing.this.systemGray);
            this.blackout = new JButton();
            this.blackout.setText("Blackout");
            this.blackout.setBackground(ColourMixing.this.systemGray);
            this.whiteout = new JButton();
            this.whiteout.setText("Whiteout");
            this.whiteout.setBackground(ColourMixing.this.systemGray);
            this.blackout.addMouseListener(handler);
            this.whiteout.addMouseListener(handler);
            this.setBorder(NeurolabExhibit.etched);
            this.buttonsLayout = new GridBagLayout();
            this.setLayout(this.buttonsLayout);
            this.buttonsGbConstraints = new GridBagConstraints();
            this.buttonsGbConstraints.fill = 1;
            this.buttonsGbConstraints.weightx = 0.0;
            this.buttonsGbConstraints.weighty = 24.0;
            this.buttonsGbConstraints.gridwidth = 1;
            this.buttonsGbConstraints.gridheight = 1;
            this.buttonsGbConstraints.gridx = 1;
            this.buttonsGbConstraints.gridy = 1;
            this.buttonsLayout.setConstraints(this.randomButton, this.buttonsGbConstraints);
            this.add(this.randomButton);
            this.buttonsGbConstraints.gridx = 2;
            this.buttonsGbConstraints.gridy = 1;
            this.buttonsLayout.setConstraints(this.blackout, this.buttonsGbConstraints);
            this.add(this.blackout);
            this.buttonsGbConstraints.gridx = 1;
            this.buttonsGbConstraints.gridy = 3;
            this.buttonsLayout.setConstraints(this.constantButton, this.buttonsGbConstraints);
            this.buttonsGbConstraints.gridx = 2;
            this.buttonsGbConstraints.gridy = 3;
            this.buttonsLayout.setConstraints(this.whiteout, this.buttonsGbConstraints);
            this.add(this.whiteout);
            this.buttonsGbConstraints.gridx = 1;
            this.buttonsGbConstraints.gridy = 5;
            this.buttonsGbConstraints.gridwidth = 2;
            this.buttonsLayout.setConstraints(this.button, this.buttonsGbConstraints);
            this.add(this.button);
            this.buttonsGbConstraints.gridwidth = 1;
            this.spacer1 = new Spacer(5, 5);
            this.spacer1.setBackground(Color.red);
            this.buttonsGbConstraints.weightx = 2.0;
            this.buttonsGbConstraints.weighty = 2.0;
            this.buttonsGbConstraints.gridx = 0;
            this.buttonsGbConstraints.gridy = 0;
            this.buttonsLayout.setConstraints(this.spacer1, this.buttonsGbConstraints);
            this.add(this.spacer1);
            this.spacer2 = new Spacer(5, 5);
            this.spacer2.setBackground(Color.red);
            this.buttonsGbConstraints.weightx = 2.0;
            this.buttonsGbConstraints.weighty = 2.0;
            this.buttonsGbConstraints.gridx = 3;
            this.buttonsGbConstraints.gridy = 3;
            this.buttonsLayout.setConstraints(this.spacer2, this.buttonsGbConstraints);
            this.add(this.spacer2);
            this.setBackground(ColourMixing.this.systemGray);
        }
    }
}

