/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.GraphicComponent;
import com.neurolab.common.JPanel0;
import com.neurolab.common.JRadioButton0;
import com.neurolab.common.MidiGenerator;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class CerebellarLearning
extends NeurolabExhibit {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel0();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel0();
    ReturnButton returnButton1 = new ReturnButton();
    JButton forget = new JButton();
    JRadioButton execute = new JRadioButton0();
    JRadioButton learn = new JRadioButton0();
    ButtonGroup bg1 = new ButtonGroup();
    JPanel mainpanel = new JPanel0();
    JPanel purarray = new JPanel0();
    JPanel jPanel5 = new JPanel0();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    GridLayout gridLayout1 = new GridLayout();
    GraphicComponent graphicComponent1 = new GraphicComponent();
    GraphicComponent graphicComponent2 = new GraphicComponent();
    GraphicComponent parascend = new GraphicComponent();
    static final int[] midiNotes = new int[]{70, 72, 74, 75, 77};
    MidiGenerator midi = new MidiGenerator();
    int npurk = 5;
    int npar = 9;
    PurkinjeCell[] purk = new PurkinjeCell[this.npurk];
    ParallelFibre[] parf = new ParallelFibre[this.npar];
    double[][] strength = new double[this.npurk][this.npar];
    boolean[][] patterns = new boolean[this.npurk][this.npar];
    static final Color colInactive = new Color(0, 0, 128);
    static final Color colActive = Color.red;

    public String getExhibitName() {
        return "Cerebellar sequencer";
    }

    public void init() {
        super.init();
        try {
            this.jbInit();
            this.bg1.add(this.learn);
            this.bg1.add(this.execute);
            this.myinit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void myinit() {
        this.mainpanel.add((Component)this.purarray, null);
        this.purarray.setOpaque(false);
        this.mainpanel.add((Component)this.graphicComponent1, null);
        this.mainpanel.add((Component)this.graphicComponent2, null);
        this.mainpanel.add((Component)this.parascend, null);
        int dy = 8;
        int i = 0;
        while (i < this.npar) {
            this.parf[i] = new ParallelFibre(i);
            this.mainpanel.add((Component)this.parf[i].parax, null);
            this.mainpanel.add((Component)this.parf[i].parbend, null);
            ++i;
        }
        i = 0;
        while (i < this.npurk) {
            this.purk[i] = new PurkinjeCell(i);
            this.purarray.add(this.purk[i]);
            ++i;
        }
        this.purk[this.npurk - 1].remove(this.purk[this.npurk - 1].outputAxon);
        this.forget.doClick();
        this.learn.setSelected(true);
        i = 0;
        while (i < this.npurk) {
            this.purk[i].setCellColor(colInactive);
            ++i;
        }
        this.patterns[0][6] = true;
        this.patterns[0][3] = true;
        this.patterns[0][0] = true;
        this.patterns[1][8] = true;
        this.patterns[1][4] = true;
        this.patterns[1][1] = true;
        this.patterns[4][3] = true;
        this.patterns[4][2] = true;
        this.patterns[4][1] = true;
        this.patterns[3][6] = true;
        this.patterns[3][7] = true;
        this.patterns[3][0] = true;
        this.patterns[2][7] = true;
        this.patterns[2][5] = true;
        this.patterns[2][2] = true;
    }

    private void jbInit() throws Exception {
        this.forget.setBackground(NeurolabExhibit.systemGray);
        this.jPanel1.setLayout(this.borderLayout2);
        this.forget.setText("Forget");
        this.forget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CerebellarLearning.this.forget_actionPerformed(e);
            }
        });
        this.execute.setText("Execute");
        this.learn.setText("Learn");
        this.mainpanel.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 235), new Color(135, 133, 115)));
        this.mainpanel.setLayout(null);
        this.purarray.setBounds(new Rectangle(93, 12, 472, 255));
        this.purarray.setLayout(this.gridLayout1);
        this.jPanel5.setBounds(new Rectangle(6, 113, 83, 49));
        this.jPanel5.setLayout(this.flowLayout1);
        this.jLabel1.setFont(new Font("SansSerif", 1, 16));
        this.jLabel1.setText("Response");
        this.jLabel2.setFont(new Font("SansSerif", 1, 16));
        this.jLabel2.setText("Feedback");
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.gridLayout1.setColumns(this.npurk);
        this.graphicComponent1.setType(2);
        this.graphicComponent1.setBounds(new Rectangle(39, 242, 55, 13));
        this.graphicComponent2.setType(3);
        this.graphicComponent2.setThickness(3);
        this.graphicComponent2.setArrow(2);
        this.graphicComponent2.setBounds(new Rectangle(34, 172, 12, 76));
        this.parascend.setType(3);
        this.parascend.setThickness(3);
        this.parascend.setBounds(new Rectangle(32, 40, 16, 72));
        this.getMainContainer().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                CerebellarLearning.this.this_keyTyped(e);
            }
        });
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.learn, null);
        this.jPanel2.add((Component)this.execute, null);
        this.jPanel2.add((Component)this.forget, null);
        this.jPanel2.add((Component)this.returnButton1, null);
        this.jPanel1.add((Component)this.mainpanel, "Center");
        this.mainpanel.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jLabel1, null);
        this.jPanel5.add((Component)this.jLabel2, null);
        this.getMainContainer().setLayout(this.borderLayout1);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
    }

    public void activateParallels(PurkinjeCell src) {
        int i = this.getPurkinjeIndex(src);
        int k = 0;
        while (k < this.npurk) {
            this.purk[k].activity = -0.5;
            ++k;
        }
        int j = 0;
        while (j < this.npar) {
            if (this.patterns[i][j]) {
                this.parf[j].activate();
                if (!this.learn.isSelected()) {
                    int k2 = 0;
                    while (k2 < this.npurk) {
                        System.out.print("purk " + k2 + " activated " + this.purk[k2].activity);
                        this.purk[k2].activate(this.strength[k2][j]);
                        System.out.println("->" + this.purk[k2].activity);
                        ++k2;
                    }
                }
            }
            ++j;
        }
    }

    public int getPurkinjeIndex(PurkinjeCell src) {
        int j = 0;
        int i = 0;
        while (i < this.npurk) {
            if (src == this.purk[i]) {
                j = i;
            }
            ++i;
        }
        return j;
    }

    void forget_actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.npurk) {
            int j = 0;
            while (j < this.npar) {
                this.strength[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    void this_keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (c >= 'a' && c <= 'e') {
            this.purk[c - 97].actionPerformed(new ActionEvent(this, 1001, String.valueOf(c)));
        }
    }

    public void close() {
        this.midi.close();
        int i = 0;
        while (i < this.purk.length) {
            this.purk[i].timer.stop();
            this.purk[i].timer2.stop();
            ++i;
        }
        i = 0;
        while (i < this.parf.length) {
            this.parf[i].timer.stop();
            ++i;
        }
    }

    class ParallelFibre
    implements ActionListener {
        int activity = 0;
        Color colInactive = new Color(192, 0, 192);
        Color colActive = Color.red;
        Timer timer = new Timer(750, this);
        GraphicComponent parax = new GraphicComponent();
        GraphicComponent parbend = new GraphicComponent();

        public ParallelFibre(int i) {
            int dy = 8;
            this.parax.setType(2);
            this.parax.setThickness(3);
            this.parax.setBounds(new Rectangle(50, 21 + i * dy, 507, 18));
            this.parbend.setThickness(3);
            this.parbend.setBounds(new Rectangle(39, 29 + i * dy, 12, 13));
            this.parax.setOpaque(false);
            this.parbend.setOpaque(false);
            this.setCol(this.colInactive);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.activity > 0) {
                --this.activity;
                if (this.activity == 0) {
                    this.setCol(this.colInactive);
                    this.timer.stop();
                }
            }
        }

        public void setCol(Color c) {
            this.parax.setForeground(c);
            this.parbend.setForeground(c);
            CerebellarLearning.this.parascend.setForeground(c);
        }

        public void activate() {
            ++this.activity;
            this.setCol(this.colActive);
            this.timer.start();
        }
    }

    class PurkinjeCell
    extends JPanel
    implements ActionListener {
        GraphicComponent graphicComponent1 = new GraphicComponent();
        GraphicComponent graphicComponent2 = new GraphicComponent();
        GraphicComponent outputAxon = new GraphicComponent();
        GraphicComponent graphicComponent3 = new GraphicComponent();
        GraphicComponent graphicComponent4 = new GraphicComponent();
        GraphicComponent graphicComponent5 = new GraphicComponent();
        GraphicComponent graphicComponent6 = new GraphicComponent();
        GraphicComponent graphicComponent7 = new GraphicComponent();
        GraphicComponent graphicComponent8 = new GraphicComponent();
        GraphicComponent stim1 = new GraphicComponent();
        GraphicComponent stim2 = new GraphicComponent();
        GraphicComponent stim3 = new GraphicComponent();
        JButton stimB = new JButton();
        public boolean isActive = false;
        public double activity;
        Timer timer = new Timer(500, this);
        Timer timer2 = new Timer(500, new ActionListener(this){
            final /* synthetic */ PurkinjeCell this$1;
            {
                this.this$1 = purkinjeCell;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$1.setCellColor(colInactive);
                PurkinjeCell.access$0(this.this$1).activateParallels(this.this$1);
                this.this$1.isActive = false;
            }
        });

        public PurkinjeCell(int i) {
            this.setLayout(null);
            this.graphicComponent1.setType(4);
            this.graphicComponent1.setBounds(new Rectangle(25, 135, 43, 44));
            this.graphicComponent2.setForeground(Color.blue);
            this.graphicComponent2.setBounds(new Rectangle(0, 171, 37, 66));
            this.outputAxon.setForeground(Color.red);
            this.outputAxon.setType(2);
            this.outputAxon.setBounds(new Rectangle(0, 228, 95, 18));
            this.graphicComponent3.setType(3);
            this.graphicComponent3.setThickness(3);
            this.graphicComponent3.setBounds(new Rectangle(37, 7, 10, 133));
            this.graphicComponent4.setDirection(true);
            this.graphicComponent4.setThickness(3);
            this.graphicComponent4.setBounds(new Rectangle(31, 111, 12, 14));
            this.graphicComponent5.setType(3);
            this.graphicComponent5.setThickness(3);
            this.graphicComponent5.setBounds(new Rectangle(46, 7, 10, 133));
            this.graphicComponent6.setThickness(3);
            this.graphicComponent6.setBounds(new Rectangle(50, 110, 12, 14));
            this.graphicComponent7.setType(3);
            this.graphicComponent7.setThickness(3);
            this.graphicComponent7.setBounds(new Rectangle(54, 7, 12, 106));
            this.graphicComponent8.setType(3);
            this.graphicComponent8.setThickness(3);
            this.graphicComponent8.setBounds(new Rectangle(26, 7, 13, 107));
            this.stim1.setBounds(new Rectangle(70, 180, 15, 30));
            this.stim1.setThickness(3);
            this.stim1.setDirection(true);
            this.stim2.setBounds(new Rectangle(60, 175, 10, 10));
            this.stim2.setType(2);
            this.stim2.setThickness(3);
            this.stim3.setBounds(new Rectangle(65, 170, 10, 10));
            this.stim3.setType(3);
            this.stim3.setThickness(3);
            this.stimB.setBounds(new Rectangle(48, 200, 45, 20));
            this.stimB.setText(String.valueOf((char)(67 + i)));
            this.stimB.setBackground(NeurolabExhibit.systemGray);
            this.add(this.stimB);
            this.add(this.graphicComponent1);
            this.add(this.graphicComponent2);
            this.add(this.graphicComponent3);
            this.add(this.graphicComponent4);
            this.add(this.graphicComponent5);
            this.add(this.graphicComponent6);
            this.add(this.graphicComponent7);
            this.add(this.graphicComponent8);
            this.add(this.outputAxon);
            this.add(this.stim1);
            this.add(this.stim2);
            this.add(this.stim3);
            this.setStimColor(colInactive);
            this.setOpaque(false);
            this.stimB.addActionListener(new ActionListener(this){
                final /* synthetic */ PurkinjeCell this$1;
                {
                    this.this$1 = purkinjeCell;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setStimColor(colActive);
                    this.this$1.timer.start();
                }
            });
            this.timer.setRepeats(false);
            this.timer2.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.setStimColor(colInactive);
            this.setCellColor(colActive);
            this.isActive = true;
            int me = CerebellarLearning.this.getPurkinjeIndex(this);
            CerebellarLearning.this.midi.playNote(midiNotes[me]);
            if (CerebellarLearning.this.learn.isSelected()) {
                int i = 0;
                while (i < CerebellarLearning.this.npar) {
                    double[] dArray = CerebellarLearning.this.strength[me];
                    int n = i;
                    dArray[n] = dArray[n] + (CerebellarLearning.this.parf[i].activity > 0 ? (1.0 - CerebellarLearning.this.strength[me][i]) * 0.5 : -(CerebellarLearning.this.strength[me][i] + 1.0) * 0.2);
                    ++i;
                }
            }
            this.timer2.start();
        }

        public void setCellColor(Color c) {
            this.graphicComponent1.setForeground(c);
            this.graphicComponent2.setForeground(c);
            this.graphicComponent3.setForeground(c);
            this.graphicComponent4.setForeground(c);
            this.graphicComponent5.setForeground(c);
            this.graphicComponent6.setForeground(c);
            this.graphicComponent7.setForeground(c);
            this.graphicComponent8.setForeground(c);
            int i = CerebellarLearning.this.getPurkinjeIndex(this) - 1;
            while (i >= 0) {
                CerebellarLearning.this.purk[i].outputAxon.setForeground(c);
                --i;
            }
            CerebellarLearning.this.graphicComponent1.setForeground(c);
            CerebellarLearning.this.graphicComponent2.setForeground(c);
        }

        public void setStimColor(Color c) {
            this.stim1.setForeground(c);
            this.stim2.setForeground(c);
            this.stim3.setForeground(c);
        }

        public void activate(double stim) {
            this.activity += stim;
            if (this.activity > 0.5) {
                this.activity = -0.5;
                this.timer.start();
            }
        }

        static /* synthetic */ CerebellarLearning access$0(PurkinjeCell purkinjeCell) {
            return purkinjeCell.CerebellarLearning.this;
        }
    }
}

