/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CerebellarDysmetria
extends NeurolabExhibit
implements ActionListener {
    JButton clearbutton;
    JPanel rightpanel;
    JPanel leftpanel;
    JPanel buttonpanel;
    JPanel canvas;
    TextArea textarea;
    Point lastpoint;
    private static String instructions = "Click on the centre spot, then - keeping the mouse button down - move as quickly as possible to each of the other spots in turn. You will exhibit various aspects of dysmetria, particularly overshoot, intention tremor and decomposition of movement. The demonstration is even more dramatic if you turn the mouse round so that the buttons are towards you.";

    public String getExhibitName() {
        return "Cerebellar Dysmetria";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.getMainContainer().setBackground(NeurolabExhibit.systemGray);
        this.createComponents();
    }

    public void createComponents() {
        this.rightpanel = new JPanel();
        this.getMainContainer().add((Component)this.rightpanel, "East");
        this.leftpanel = new JPanel();
        this.getMainContainer().add((Component)this.leftpanel, "West");
        this.leftpanel.setBorder(NeurolabExhibit.raisedbevel);
        this.leftpanel.setBackground(NeurolabExhibit.systemGray);
        this.canvas = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                NeurolabExhibit.antiAlias(g);
                g.setColor(new Color(0, 0, 64));
                g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                int cx = this.getWidth() / 2;
                int cy = this.getHeight() / 2;
                g.setColor(Color.red);
                g.fillOval(cx - 10, cy - 10, 20, 20);
                int i = 0;
                while (i < 3) {
                    double theta = (double)i * 2.0 * Math.PI / 3.0 + 0.5235987755982988;
                    g.fillOval(cx + (int)((double)cy * 0.8 * Math.sin(theta)), cy + (int)((double)cy * 0.8 * Math.cos(theta)), 8, 8);
                    ++i;
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 305);
            }
        };
        this.leftpanel.add(this.canvas);
        this.canvas.setBackground(NeurolabExhibit.systemGray);
        this.canvas.setBorder(NeurolabExhibit.loweredbevel);
        this.canvas.setCursor(new Cursor(1));
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CerebellarDysmetria.this.lastpoint = e.getPoint();
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Graphics g = CerebellarDysmetria.this.canvas.getGraphics();
                NeurolabExhibit.antiAlias(g);
                g.setColor(Color.white);
                CerebellarDysmetria.this.lastpoint = e.getPoint();
                g.drawLine(CerebellarDysmetria.this.lastpoint.x, CerebellarDysmetria.this.lastpoint.y, CerebellarDysmetria.this.lastpoint.x, CerebellarDysmetria.this.lastpoint.y);
            }
        });
        this.rightpanel.setLayout(new BorderLayout());
        this.buttonpanel = new JPanel();
        this.rightpanel.add((Component)this.buttonpanel, "South");
        this.textarea = new TextArea(instructions, 17, 20, 3);
        this.rightpanel.add((Component)this.textarea, "North");
        this.rightpanel.setBackground(NeurolabExhibit.systemGray);
        this.textarea.setEditable(false);
        this.textarea.setBackground(NeurolabExhibit.systemGray);
        this.buttonpanel.setLayout(new BorderLayout());
        this.buttonpanel.setBackground(NeurolabExhibit.systemGray);
        this.clearbutton = new JButton("Clear");
        this.buttonpanel.add((Component)this.clearbutton, "West");
        this.clearbutton.addActionListener(this);
        this.clearbutton.setBackground(NeurolabExhibit.systemGray);
        this.buttonpanel.add((Component)new ReturnButton(), "East");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Return") {
            this.toExhibitChooser();
        }
        if (e.getActionCommand() == "Clear") {
            this.canvas.repaint();
        }
    }

    public void close() {
    }
}

