/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;

public class BrainAnatomyOld
extends NeurolabExhibit {
    public int transverse = 0;
    public int[] no_components = new int[]{14, 13};
    public int[] no_whiteparts = new int[]{10, 11};
    public double[] float_number = new double[]{28.0, 26.0};
    public JPanel picturebox;
    public PicturePanel picgraphic;
    public TextPanel textbox;
    public JComboBox whichbit;
    public Spacer spacer1;
    public Spacer spacer2;
    public Spacer spacer3;
    public Spacer spacer4;
    private GridBagLayout mainLayout;
    private GridBagLayout chkbxLayout;
    private GridBagConstraints mainGbConstraints;
    private GridBagConstraints chkbxGbConstraints;
    private JButton returnbutton;
    private JButton swapsection;
    private JCheckBox testme;
    private Container maincontainer;
    Image[] picture_base = new Image[2];
    Image[][] picture = new Image[2][];
    boolean[][] image_exists = new boolean[2][];
    public int[][] question = new int[2][];
    public int index;
    public int questionumber;
    public int correct;
    public boolean noarea = false;
    public boolean ignore = false;
    public boolean testmode;
    public boolean nocombo = false;
    Color systemGray;
    String[][] brainStrings = new String[][]{{"Choose", "Medulla", "Pons", "Pituitary", "Hypothalamus", "Cerebellum", "Colliculi", "Corpus callosum", "Cerebral cortex", "Thalamus", "Pineal", "Fornix", "Aqueduct", "Fourth ventricle", "Anterior commissure"}, {"Choose", "Association Fibres", "Lateral Ventricle", "Corpus Striatum", "Optic Tract", "Infundibulum", "Hypothalamus", "Third Ventricle", "Thalamus", "Fornix", "Caudate Nucleus", "Amygdala", "Corpus Callosum", "Internal Capsule"}};
    String[][] textStrings = new String[][]{{"The medulla is the lowest part of the brainstem", "The pons is the middle part of the brain stem, where the cerebellum attaches", "The anterior pituitary secretes the hormones prolactin, TSH, FSH, LH, ACTH and GH. Posterior pituitary secretes ADH and oxcytocin.", "The hypothalamus is the control centre for hormones, visceral function and motivation", "The cerebellum coordinates movements", "The superior colliculi are responsible for visual orienting; The inferior colliculi form part of the auditory pathway.", "The corpus callosum is the main white matter tract connecting the left and right cerebral hemispheres.", "the cerebral cortex is a convoluted sheet of grey matter that forms the two hemispheres of the cerebrum.", "The thalamus is the primary input nucleus serving the cerebral cortex.", "The pineal gland secretes melatonin.", "The fornix is a limbic pathway between the hippocampus and forebrain nuclei.", "The aqueduct of Sylvius (cerebral aqueduct) carries CSF down out of lateral and third ventricles.", "The fourth ventricle is in the lower pons, just anterior to the cerebellum.", "The anterior commisure is a white matter tract that connects the left and right temporal lobes and olfactory tracts.", "Click on an area to find out about it! ", "shouldn't see this!!"}, {"Association fibres in the subcortical white matter connect different regions of the cerebral cortex.", "The lateral ventricles are the main location where cerebrospinal fluid is synthesised.", "The corpus striatum is a region of the basal ganglia involved in control of behaviour.", "The optic tract conveys information from the eyes to the visual regions of the thalamus.", "The infundibulum is the stalk of the pituitary gland.", "The hypothalamus is the control centre for hormones, visceral function and motivation.", "The third ventricle is a narrow CSF space between the two halves of the thalamus.", "The thalamus is the major input nucleus of the cerebral cortex", "The fornix is a limbic pathway between the hippocampus and forebrain nuclei.", "The caudate nucleus is the superior segment of the basal ganglia, running in the wall of the lateral ventricle.", "The amygdala is a nucleus deep in the anterior temporal lobe that is responsive to fearful stimuli.", "The corpus callosum is the main white matter tract connecting the left and right cerebral hemispheres.", "The internal capsule is the white matter pathway descending from the cerebral cortex to the brainstem and spinal cord.", "Click on an area to find out about it! ", "shouldn't see this!!"}};

    public String getExhibitName() {
        return "Brain anatomy";
    }

    public void init() {
        int i = 0;
        while (i < this.picture.length) {
            this.picture[i] = new Image[this.no_components[i] + 1];
            this.image_exists[i] = new boolean[this.no_components[i] + 1];
            this.question[i] = new int[this.no_components[i] * 2];
            ++i;
        }
        super.init();
        this.picture_base[0] = this.getImage("resources/imagemaps/SAGITTAL.GIF");
        this.picture_base[1] = this.getImage("resources/imagemaps/TRANSVERSE.GIF");
        this.index = this.no_components[this.transverse];
        this.testmode = false;
        this.nocombo = false;
        this.noarea = false;
        this.createComponents();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void createComponents() {
        EventHandler handler = new EventHandler();
        Border etched = BorderFactory.createEtchedBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        this.picturebox = new JPanel();
        this.picturebox.setBackground(this.systemGray);
        this.picturebox.setBorder(etched);
        this.chkbxLayout = new GridBagLayout();
        this.picturebox.setLayout(this.chkbxLayout);
        this.chkbxGbConstraints = new GridBagConstraints();
        this.chkbxGbConstraints.fill = 1;
        this.chkbxGbConstraints.weightx = 6.0;
        this.chkbxGbConstraints.weighty = 4.0;
        this.picgraphic = new PicturePanel();
        this.picgraphic.setBackground(this.systemGray);
        this.chkbxGbConstraints.fill = 1;
        this.chkbxGbConstraints.weightx = 80.0;
        this.chkbxGbConstraints.weighty = 100.0;
        this.addchkboxComponent(this.picgraphic, 0, 0, 1, 1);
        this.whichbit = new JComboBox<String>(this.brainStrings[0]);
        this.whichbit.setMaximumRowCount(5);
        this.whichbit.setLightWeightPopupEnabled(false);
        this.whichbit.addItemListener(handler);
        this.textbox = new TextPanel();
        this.textbox.setBorder(etched);
        this.textbox.setBackground(this.systemGray);
        this.textbox.setPreferredSize(new Dimension(150, 150));
        this.textbox.n = this.no_components[this.transverse];
        this.testme = new JCheckBox("Test Me");
        this.testme.addItemListener(handler);
        this.testme.setBackground(this.systemGray);
        this.returnbutton = new JButton("Return");
        this.returnbutton.setBackground(this.systemGray);
        this.returnbutton.addActionListener(handler);
        this.swapsection = new JButton("Change View");
        this.swapsection.setBackground(this.systemGray);
        this.swapsection.addActionListener(handler);
        this.maincontainer = this.getMainContainer();
        this.mainLayout = new GridBagLayout();
        this.maincontainer.setLayout(this.mainLayout);
        this.mainGbConstraints = new GridBagConstraints();
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.whichbit, 2, 2, 5, 1, 0, 20);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.textbox, 4, 3, 3, 1, 0, 20);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(this.picturebox, 2, 0, 2, 4, 80, 80);
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.returnbutton, 7, 5, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.testme, 6, 3, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 0;
        this.addMainComponent(this.swapsection, 7, 3, 2, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(10, 30), 0, 0, 1, 1, 1, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(30, 50), 4, 2, 1, 1, 0, 80);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(40, 30), 3, 4, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(10, 0), 6, 6, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
        this.addMainComponent(new Spacer(40, 50), 5, 4, 1, 1, 0, 0);
        this.mainGbConstraints.fill = 1;
    }

    public String getAppletInfo() {
        return "Brain Anatomy coded in Java by Robin Marlow \n based on an original program by Dr. Carpenter";
    }

    private void addMainComponent(Component c, int row, int column, int width, int height, int weightx, int weighty) {
        this.mainGbConstraints.gridx = column;
        this.mainGbConstraints.gridy = row;
        this.mainGbConstraints.gridwidth = width;
        this.mainGbConstraints.gridheight = height;
        this.mainGbConstraints.weightx = weightx;
        this.mainGbConstraints.weighty = weighty;
        this.mainLayout.setConstraints(c, this.mainGbConstraints);
        this.maincontainer.add(c);
    }

    private void addchkboxComponent(Component c, int row, int column, int width, int height) {
        this.chkbxGbConstraints.gridx = column;
        this.chkbxGbConstraints.gridy = row;
        this.chkbxGbConstraints.gridwidth = width;
        this.chkbxGbConstraints.gridheight = height;
        this.chkbxLayout.setConstraints(c, this.chkbxGbConstraints);
        this.picturebox.add(c);
    }

    private void QuestionHandler() {
        this.questionumber = 0;
        this.correct = 0;
        int n = 0;
        while (n < this.no_components[this.transverse] * 2) {
            boolean unique;
            do {
                unique = true;
                double temp = this.float_number[this.transverse] * Math.random();
                this.question[this.transverse][n] = (int)temp;
                int m = 0;
                while (m < n) {
                    if (this.question[this.transverse][m] == this.question[this.transverse][n]) {
                        unique = false;
                    }
                    ++m;
                }
                m = n + 1;
                while (m < this.no_components[this.transverse] * 2) {
                    if (this.question[this.transverse][m] == this.question[this.transverse][n]) {
                        unique = false;
                    }
                    ++m;
                }
            } while (!unique);
            ++n;
        }
        this.setupQuestion();
    }

    private void nextQuestion(boolean answer) {
        if (answer) {
            JOptionPane.showMessageDialog(null, "Correct!", "You got it...", 1);
            ++this.correct;
        } else {
            JOptionPane.showMessageDialog(null, "Wrong! - The correct answer is shown", "You got it...", 1);
        }
        if (this.questionumber < this.no_components[this.transverse] * 2 - 1) {
            ++this.questionumber;
            System.out.println("question number = " + this.questionumber + " " + this.question[this.transverse][this.questionumber]);
            this.setupQuestion();
        } else {
            this.ignore = true;
            this.testme.doClick();
            this.testmode = false;
            this.ignore = false;
            JOptionPane.showMessageDialog(null, String.valueOf(this.correct) + " out of " + this.no_components[this.transverse] * 2, "You scored", 1);
        }
    }

    private void setupQuestion() {
        if (!this.testmode) {
            this.testmode = false;
        } else if (this.question[this.transverse][this.questionumber] > this.no_components[this.transverse] - 1) {
            this.ignore = true;
            this.noarea = false;
            this.nocombo = true;
            this.index = this.no_components[this.transverse];
            this.whichbit.setEnabled(false);
            this.whichbit.setSelectedIndex(this.question[this.transverse][this.questionumber] - this.no_components[this.transverse]);
            this.picturebox.repaint();
            this.textbox.update();
            this.ignore = false;
        } else {
            this.ignore = true;
            this.noarea = true;
            this.nocombo = false;
            this.whichbit.setEnabled(true);
            this.whichbit.setSelectedIndex(0);
            if (this.whichbit.getItemAt(0) == this.brainStrings[this.transverse][1]) {
                this.whichbit.insertItemAt("Choose", 0);
                this.whichbit.setSelectedIndex(0);
            }
            this.index = this.question[this.transverse][this.questionumber];
            this.picturebox.repaint();
            this.textbox.update();
            this.ignore = false;
        }
    }

    public void close() {
    }

    protected int getPixelValueAt(Point e) throws InterruptedException {
        int[] pixels = new int[1];
        PixelGrabber pg = new PixelGrabber(this.picture_base[this.transverse], e.x, e.y, 1, 1, pixels, 0, 2);
        pg.grabPixels();
        return pixels[0];
    }

    private class EventHandler
    implements ActionListener,
    ItemListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Return") {
                BrainAnatomyOld.this.toExhibitChooser();
            }
            if (e.getActionCommand() == "Change View" && !BrainAnatomyOld.this.testmode) {
                BrainAnatomyOld.this.ignore = true;
                BrainAnatomyOld.this.transverse = BrainAnatomyOld.this.transverse == 0 ? 1 : 0;
                BrainAnatomyOld.this.whichbit.removeAllItems();
                int i = 0;
                while (i < BrainAnatomyOld.this.brainStrings[BrainAnatomyOld.this.transverse].length) {
                    BrainAnatomyOld.this.whichbit.addItem(BrainAnatomyOld.this.brainStrings[BrainAnatomyOld.this.transverse][i]);
                    ++i;
                }
                BrainAnatomyOld.this.textbox.n = BrainAnatomyOld.this.index = BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse];
                if (BrainAnatomyOld.this.whichbit.getItemAt(0) == BrainAnatomyOld.this.brainStrings[BrainAnatomyOld.this.transverse][1]) {
                    BrainAnatomyOld.this.whichbit.insertItemAt("Choose", 0);
                    BrainAnatomyOld.this.whichbit.setSelectedIndex(0);
                }
                BrainAnatomyOld.this.ignore = false;
                BrainAnatomyOld.this.picturebox.repaint();
                BrainAnatomyOld.this.textbox.update();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (BrainAnatomyOld.this.whichbit.getItemAt(0) == "Choose" && !BrainAnatomyOld.this.ignore) {
                BrainAnatomyOld.this.ignore = true;
                BrainAnatomyOld.this.whichbit.removeItemAt(0);
                BrainAnatomyOld.this.ignore = false;
            }
            if (e.getSource() == BrainAnatomyOld.this.testme) {
                if (e.getStateChange() == 1) {
                    BrainAnatomyOld.this.testmode = true;
                    BrainAnatomyOld.this.QuestionHandler();
                }
                if (e.getStateChange() == 2) {
                    BrainAnatomyOld.this.ignore = true;
                    BrainAnatomyOld.this.testmode = false;
                    BrainAnatomyOld.this.noarea = false;
                    BrainAnatomyOld.this.nocombo = false;
                    BrainAnatomyOld.this.whichbit.setSelectedIndex(0);
                    BrainAnatomyOld.this.whichbit.setEnabled(true);
                    if (BrainAnatomyOld.this.whichbit.getItemAt(0) == BrainAnatomyOld.this.brainStrings[BrainAnatomyOld.this.transverse][1]) {
                        BrainAnatomyOld.this.whichbit.insertItemAt("Choose", 0);
                        BrainAnatomyOld.this.whichbit.setSelectedIndex(0);
                    }
                    BrainAnatomyOld.this.ignore = false;
                    BrainAnatomyOld.this.textbox.n = BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse];
                    BrainAnatomyOld.this.index = BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse];
                    BrainAnatomyOld.this.picturebox.repaint();
                    BrainAnatomyOld.this.textbox.update();
                }
            }
            if (e.getSource() == BrainAnatomyOld.this.whichbit && !BrainAnatomyOld.this.ignore && !BrainAnatomyOld.this.testmode && e.getStateChange() == 1) {
                BrainAnatomyOld.this.textbox.n = BrainAnatomyOld.this.whichbit.getSelectedIndex();
                BrainAnatomyOld.this.index = BrainAnatomyOld.this.whichbit.getSelectedIndex();
                BrainAnatomyOld.this.picturebox.repaint();
                BrainAnatomyOld.this.textbox.update();
            }
            if (e.getSource() == BrainAnatomyOld.this.whichbit && !BrainAnatomyOld.this.ignore && BrainAnatomyOld.this.testmode && !BrainAnatomyOld.this.nocombo && e.getStateChange() == 1) {
                if (BrainAnatomyOld.this.whichbit.getSelectedIndex() == BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber]) {
                    BrainAnatomyOld.this.whichbit.hidePopup();
                    BrainAnatomyOld.this.nextQuestion(true);
                } else {
                    BrainAnatomyOld.this.ignore = true;
                    BrainAnatomyOld.this.whichbit.hidePopup();
                    BrainAnatomyOld.this.whichbit.setSelectedIndex(BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber]);
                    BrainAnatomyOld.this.ignore = false;
                    BrainAnatomyOld.this.nextQuestion(false);
                }
                BrainAnatomyOld.this.setupQuestion();
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private boolean onceover = false;
        boolean mousedown = false;

        private MouseClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.mousedown = true;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.mousedown) {
                this.mouseClicked(e);
                this.mousedown = false;
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (!BrainAnatomyOld.this.noarea) {
                int pixel;
                if (BrainAnatomyOld.this.whichbit.getItemAt(0) == "Choose") {
                    BrainAnatomyOld.this.ignore = true;
                    BrainAnatomyOld.this.whichbit.removeItemAt(0);
                    BrainAnatomyOld.this.ignore = false;
                    this.onceover = true;
                } else {
                    this.onceover = false;
                }
                try {
                    pixel = BrainAnatomyOld.this.getPixelValueAt(e.getPoint());
                }
                catch (InterruptedException x) {
                    return;
                }
                int n = 0;
                while (n < BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse]) {
                    if (pixel == -65536 - n * 65536) {
                        if (BrainAnatomyOld.this.whichbit.getSelectedIndex() != n || this.onceover) {
                            if (BrainAnatomyOld.this.testmode) {
                                BrainAnatomyOld.this.index = BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber] - BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse];
                                BrainAnatomyOld.this.picturebox.repaint();
                                BrainAnatomyOld.this.nextQuestion(false);
                                break;
                            }
                            if (BrainAnatomyOld.this.testmode) break;
                            if (BrainAnatomyOld.this.textbox.n == BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse]) {
                                BrainAnatomyOld.this.textbox.n = 0;
                                BrainAnatomyOld.this.textbox.repaint();
                            }
                            BrainAnatomyOld.this.index = n;
                            BrainAnatomyOld.this.whichbit.setSelectedIndex(n);
                            BrainAnatomyOld.this.picturebox.repaint();
                            break;
                        }
                        if (BrainAnatomyOld.this.whichbit.getSelectedIndex() != n || !BrainAnatomyOld.this.testmode) break;
                        System.out.println("clicking on somewhere already highlighted!");
                        BrainAnatomyOld.this.index = BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber] - BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse];
                        BrainAnatomyOld.this.picturebox.repaint();
                        BrainAnatomyOld.this.nextQuestion(true);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        Cursor normal = Cursor.getDefaultCursor();
        Cursor hand = Cursor.getPredefinedCursor(12);

        MouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            try {
                int px = BrainAnatomyOld.this.getPixelValueAt(e.getPoint());
                if (px != 0 && px != -1) {
                    BrainAnatomyOld.this.setCursor(this.hand);
                } else {
                    BrainAnatomyOld.this.setCursor(this.normal);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class PicturePanel
    extends JPanel {
        public PicturePanel() {
            this.addMouseListener(new MouseClickHandler());
            this.addMouseMotionListener(new MouseMotionHandler());
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (BrainAnatomyOld.this.image_exists[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.index]) {
                g.drawImage(BrainAnatomyOld.this.picture[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.index], 0, 0, 321, 226, this);
            } else {
                BrainAnatomyOld.this.picture[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.index] = this.createImage(new FilteredImageSource(BrainAnatomyOld.this.picture_base[BrainAnatomyOld.this.transverse].getSource(), new RedBlueSwapFilter()));
                BrainAnatomyOld.this.image_exists[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.index] = true;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                g.drawImage(BrainAnatomyOld.this.picture[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.index], 0, 0, 321, 226, this);
            }
        }
    }

    class RedBlueSwapFilter
    extends RGBImageFilter {
        public RedBlueSwapFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int n = 0;
            while (n < BrainAnatomyOld.this.no_whiteparts[BrainAnatomyOld.this.transverse]) {
                if (rgb == -65536 - n * 65536) {
                    if (n == BrainAnatomyOld.this.index) {
                        return -14855425;
                    }
                    return -1;
                }
                ++n;
            }
            n = BrainAnatomyOld.this.no_whiteparts[BrainAnatomyOld.this.transverse];
            while (n < BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse]) {
                if (rgb == -65536 - n * 65536) {
                    if (n == BrainAnatomyOld.this.index) {
                        return -14855425;
                    }
                    return -16777216;
                }
                ++n;
            }
            return 0xFF000000 | (rgb & 0xFF0000) << 0 | (rgb & 0xFF00) << 0 | rgb & 0xFF;
        }
    }

    class TextPanel
    extends JTextPane {
        public int n;

        TextPanel() {
        }

        public void init() {
            this.n = 0;
        }

        public void update() {
            this.setForeground(Color.black);
            String as = BrainAnatomyOld.this.testmode ? (BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber] <= BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse] - 1 ? "Select the name of the highlighted region" : (BrainAnatomyOld.this.question[BrainAnatomyOld.this.transverse][BrainAnatomyOld.this.questionumber] >= BrainAnatomyOld.this.no_components[BrainAnatomyOld.this.transverse] ? "Select the area of brain named" : "something wrong with the text matching!")) : BrainAnatomyOld.this.textStrings[BrainAnatomyOld.this.transverse][this.n];
            this.setText(as);
        }
    }
}

